/* Xymon Client V1.2 for VSE/ESA and z/VSE
    Copyright (C) 2003-2010 Richard Smrcina
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
 
    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html            */
/*  This program will call an assembler subroutine to get the CPU
    Utilization and report the results back to Hobbit.
 
    Rich Smrcina: CPU Utilization added for V1.1  05/03/2006
   V1.2 - Added cfgmode parameter to designate the configuration mode
          Changed client architecture to use Hobbit server based
          configuration for most VSE tests (getvis is the exception).
          Server mode writes the test results to librarian members which
          are sent to Hobbit via the client data channel.
          Server based configuration will require the Hobbit back-end
          code which should be available with Hobbit 4.3. 02/01/2007
    Rich Smrcina: Changed project name to Xymon           02/10/2009
                                                                      */
parse arg lib cfgmode .
init='0'             /*  Init flag  */
cr='0a'x             /*  Carriage return   */
/*  Retrieve options member from PRD2.CONFIG                     */
'execio * diskr 'lib'.hobvars.z (stem hobvars. finis'
/*  Init local variables first  */
bbdisplay=''
bbport=''
domainname=''
hostname=''
/*  Go through options table to fill values to run the client    */
do i=1 to hobvars.0
  if left(hobvars.i,1)='#' then iterate   /* Ignore comment */
  parse var hobvars.i kw value
  value=strip(value,'B')
  select
    when kw='bbdisplay' then
      bbdisplay=value
    when kw='bbport' then
      bbport=value
    when kw='domainname' then
      domainname=value
    when kw='hostname' then
      hostname=value
    when kw='CPU' then
      parse var value yellow red
    otherwise
      nop
    end
  end
call get_uptime
call do_cputest
call write_constant_client_data
/*  How the data is sent to the server depends upon the client
    configuration mode.
    If the client is configured at the client, the data is sent
    as status messages to Xymon.
    If the client is configured at the server, the data is put into
    librarian members and collected at the end of all of the tests
    and send to Xymon as a client data message.                   */
if cfgmode='CLIENT' then
  call send_data_client
else
  call send_data_server
return
 
get_uptime:
/*  Retrieve IPL Time data and compute uptime                    */
'execio * diskr 'lib'.hobvsitm.z (stem hobvsitm. finis'
parse var hobvsitm.1 ipldate ipltime numdays numsecs timezone .
daysup=date('B')-numdays
cdsecs=time('S')
if cdsecs >= numsecs then
  secsup=cdsecs-numsecs
if cdsecs < numsecs then do
  secsup=(86400-numsecs)+cdsecs
  daysup=daysup-1
  end
hrsup=format(secsup%3600,2,0)
minup=format((secsup-(hrsup*3600))/60,2,0)
return
 
do_cputest:
color='green'
numeric digits 18
/*  Call assembler routine to call TDSERV macro  */
rtn=hobvscpu()
/*  Parse the returned values                    */
parse var rtn 3 numcpu 4 numact 5 21 numsvc 25 26 tdver 27 quicpu 28 ,
      29 cpu.1 69 cpu.2 109 cpu.3 149 cpu.4 189 cpu.5 229 ,
      cpu.6 269 cpu.7 309 cpu.8 349 cpu.9 389 cpu.10 429
/*
say 'rtn='c2x(rtn)
say c2x(numcpu) c2x(numact) c2x(numsvc) c2x(tdver) c2x(quicpu)
do i=1 to 10
  say 'cpu.'i'='c2x(cpu.i)
  end */
/*  Convert them to decimal                      */
numcpu=x2d(c2x(numcpu))
numact=x2d(c2x(numact))
numsvc=x2d(c2x(numsvc))
tdver=x2d(c2x(tdver))
quicpu=x2d(c2x(quicpu))
/*  Get old values  */
'execio * diskr 'lib'.hobvsecp.z (stem hobvsecp. finis'
if rc <> 0 then do     /* If member not found, set the values to zero */
  do i=1 to numcpu     /* to fool the calculations the first time.    */
    hobvsecp.i='0 0 0 0 0'
    end
  end
tot_cpu=0   /* Reset total values */
tot_np=0
reset=0
do i=1 to numcpu
/*  Parse the values for each CPU  */
  parse var cpu.i cpuid 3 cpuflg 4 5 cputim 13 cpunp 21
/*  Parse the values from the last interval  */
  parse var hobvsecp.i-1 . oc ocputim ocpunp .
  cpuid.i=x2d(c2x(cpuid))
  cpuflg=c2x(cpuflg)
  cputim=x2d(c2x(cputim))
  cputim_ms=cputim/62.5   /* Convert CPU Time to ms */
  cpunp=x2d(c2x(cpunp))
  cpunp_ms=cpunp/62.5     /* Convert NP  Time to ms */
  if cputim_ms<ocputim then do /* This must be the result of a reset. */
    reset=1                    /* Set the flag and leave this loop.   */
    leave
    end
  select
    when cpuflg='40' then
      status.i='Active'
    when cpuflg='02' then
      status.i='Quiesced'
    otherwise
      status.i='Not Active'
    end
  c=time('S')           /*  Seconds since midnight  */
  if c < 300 then       /*  For the first interval after midnight */
    c=86400+c           /*    add a day's worth of seconds        */
  e=c-oc                /*  Get the time difference */
  curr_cpums=cputim_ms-ocputim                  /* Calc CPU Time diff */
  curr_cpumsd.i=format(curr_cpums,8,2)
  curr_npms=cpunp_ms-ocpunp                     /* Calc NP  Time diff */
  curr_npmsd.i=format(curr_npms,8,2)
  cpu_util=((curr_cpums/1000) / e) * 100        /* CPU Utilization    */
  cpu_utild.i=format(cpu_util,3,2)
  tot_cpu=tot_cpu+cpu_util                      /* Tot CPU Util       */
  np_util=((curr_npms/1000) / e) * 100          /* NP  Utilization    */
  np_utild.i=format(np_util,3,2)
  tot_np=tot_np+np_util                         /* Tot NP Util       */
  if curr_cpums=0 then
    currnp.i=format(0,1,3)
  else
    currnp.i=format((curr_npms/curr_cpums),1,3) /* Curr NPS           */
/*  Write the current values out for the next interval  */
  push i-1 c cputim_ms cpunp_ms
  'execio 1 diskw 'lib'.hobvsecp.z'
  end
tot_cpud=format(tot_cpu,3,2)
tot_cpu_statmsg=format(tot_cpu,3,0)
tot_npd=format(tot_np,3,2)
if reset=1 then do         /*  Handle a reset  */
  tot_cpud=0
  do i=1 to numcpu
    push i-1 '0 0 0'
    'execio 1 diskw 'lib'.hobvsecp.z'
    end
  end
'execio 0 diskw 'lib'.hobvsecp.z (finis'
return
 
send_data_client:
'execio * diskr 'lib'.hobvseos.data (stem oslevel. finis'
do i=1 to oslevel.0
  parse var oslevel.i kw '=' first second .
  if kw='SYSTEM' then do
    os=first
    level=second
    leave
    end
  end
call init_open_socket         /* Initialize and Open the socket  */
out=os level cr
out=out||'IPLed on: 'ipldate' at 'ipltime cr
out=out||'Uptime: ' daysup 'Days, 'hrsup' Hours, 'minup 'Minutes' cr
out=out||'Number of CPUs: 'numcpu||cr
out=out||'Number of Active CPUs: 'numact||cr
out=out||'Number of Quiesced CPUs: 'quicpu||cr
out=out||'Number of SVCs: 'numsvc||cr
out=out||'Turbo Dispatcher Version: 'tdver||cr
out=out||' '||cr
out=out||'For the current interval:'||cr
out=out||'CPU Status        CPU Time  CPU Util       NP Time' ,
         'NP Util   NPS'||cr
do i=1 to numcpu
  out=out||'  'i-1   left(status.i,10) curr_cpumsd.i'  ' ,
      cpu_utild.i'%  ' curr_npmsd.i np_utild.i'%' currnp.i cr
  end
out=out||'Total' copies(' ',22) tot_cpud'%' copies(' ',13) tot_npd'%'
if reset=1 then do         /*  Handle a reset  */
  out=cr||'CPU timers were reset during the last interval.'
  color='yellow'
  end
status='status' fqdn'.cpu' color date() time() 'CPU Utilization' ,
       tot_cpu_statmsg'%' cr||out
call send_to_bb
call close_term_socket
return
 
send_data_server:
queue '[uptime]'
queue 'Uptime: 'daysup 'Days, 'hrsup' Hours, 'minup' Minutes'
queue ''
'execio * diskw 'lib'.hobvseup.data (finis'
queue '[cpu]'
if reset=1 then
  queue 'Timers reset during last interval'
else do
  queue 'Avg CPU='tot_cpu_statmsg'%, Avg NP CPU='tot_npd
  queue 'CPU Status        CPU Time  CPU Util       NP Time' ,
        'NP Util   NPS'
  do i=1 to numcpu
    queue right(i-1,3,'0') left(status.i,10) curr_cpumsd.i'   ' ,
          cpu_utild.i'% ' curr_npmsd.i np_utild.i'%' currnp.i
    end
  end
queue ''
'execio * diskw 'lib'.hobvsecp.data (finis'
return
 
write_constant_client_data:
queue '[date]'
daten=date('N')
parse var daten dd mm yy .
dow=date('W')
queue left(dow,3) mm dd time() timezone yy
queue ''
'execio * diskw 'lib'.hobvsedt.data (finis'
return
 
send_to_bb:
status=toascii(status)
ret=Socket('Send',sid,status)
parse var ret rc .
if rc<>0 then
  say 'Send:' ret
return
 
toascii:
parse arg buffer
buffer=translate(buffer,asc,ebc)
return buffer
 
init_open_socket:
ret=socket('Initialize','hobvse')
parse var ret rc .
if rc<>0 then
  say 'Initialize:' ret
ret=socket('Socket','AF_INET','Sock_Stream',0)
parse var ret rc .
if rc<>0 then
  say 'Socket:' ret
parse var ret rc sid .
if init='0' then do
  init='1'
  call init_values
  end
name='AF_INET' bbport bbdisplay
ret=socket('Connect',sid,name)
parse var ret rc .
if rc<>0 then
  say 'Connect:' ret
return
 
close_term_socket:
ret=Socket('Close',sid)
parse var ret rc .
if rc<>0 then
  say 'Close:' ret
ret=Socket('Terminate')
parse var ret rc .
if rc<>0 then
  say 'Terminate:' ret
return
 
init_values:
ebc=' !"#$%&'||'7D'X||'()*+,-./012' ,
    '3456789:;<=>?@ABCDE' ,
    'FGHIJKLMNOPQRSTUVWX' ,
    'YZ
\Y_`abcdefghijk' ,
    'lmnopqrstuvwxyz{|}~'
asc='202122232425262728292A2B2C2D2E2F303132'x ,
    '333435363738393A3B3C3D3E3F404142434445'x ,
    '464748494A4B4C4D4E4F505152535455565758'x ,
    '595A5B5C5D5E5F606162636465666768696A6B'x ,
    '6C6D6E6F707172737475767778797A7B7C7D7E'x
if hostname='' then do
  ret=socket('Gethostname')
  parse var ret rc hostname .
  if rc<>0 then
    say 'Gethostname:' ret
  hostname=lower(hostname)
  end
if domainname='' then
  fqdn=hostname
else
  fqdn=hostname||'.'||domainname
/*  Change periods to commas  */
fqdn=translate(fqdn,',','.')
return
 
/*  Convert parameter to lower case.  */
lower:
arg string
lc_chars='abcdefghijklmnopqrstuvwxyz'
uc_chars='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
string=translate(string,lc_chars,uc_chars)
return string
