/* Xymon Client V1.2 for VSE/ESA and z/VSE
    Copyright (C) 2003-2010 Richard Smrcina
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
 
    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html            */
/*  This program will call an assembler subroutine to get the page
    rate and report the results back to Xymon.
 
   Rich Smrcina: Original V1.0 release 04/11/2006
   V1.2 - Added cfgmode parameter to designate the configuration mode
          Changed client architecture to use Hobbit server based
          configuration for most VSE tests (getvis is the exception).
          Server mode writes the test results to librarian members which
          are sent to Hobbit via the client data channel.
          Server based configuration will require the Hobbit back-end
          code which should be available with Hobbit 4.3. 02/01/2007
 
          Changed project name to Xymon                   02/09/2009
                                                                      */
parse arg lib cfgmode .
if cfgmode='CLIENT' then
  call init_local_vars
call do_pagetest
if cfgmode='SERVER' then
  call write_client_data
else
  call send_client_data
return
 
do_pagetest:
color='green'
/*  Get old values  */
rm=rexxmsg('OFF')
'execio * diskr 'lib'.hobvsepg.z (stem hobvsepg. finis'
if rc <> 0 then       /* If member not found, set the values to zero */
  hobvsepg.1='0 0 0'  /* to fool the calculations the first time.    */
j=rexxmsg(rm)
/*  Parse the values from the last interval  */
parse var hobvsepg.1 oc opagein opageout .
/*  Call assembler routine to call GETFLD macro  */
rtn=hobvspag()
parse var rtn pagein 5 pageout 9
pagein=x2d(c2x(pagein))
pageout=x2d(c2x(pageout))
c=time('S')           /*  Seconds since midnight  */
if c < 300 then       /*  For the first interval after midnight */
  c=86400+c           /*    add a day's worth of seconds        */
e=c-oc                /*  Get the time difference */
diff_pi=pagein-opagein  /*  Calculate the diffs */
diff_po=pageout-opageout
paging=((diff_pi + diff_po) / e)   /* Calculate the paging rate  */
pagingd=strip(format(paging,5,2),'L')
/*  Write the current values out for the next interval  */
push c pagein pageout
'execio 1 diskw 'lib'.hobvsepg.z (finis'
return
 
write_client_data:
queue '[paging]'
queue 'Page Rate='pagingd '/sec'
queue 'Total Page Ins='pagein
queue 'Total Page Outs='pageout
queue ''
'execio * diskw' lib'.hobvsepg.data (finis'
return
 
send_client_data:
call init_open_socket         /* Initialize and Open the socket  */
/* out=cr||'Total Page Ins='pagein||cr
out=out||'Total Page Outs='pageout||cr
out=out||'Diff Page Ins='diff_pi||cr
out=out||'Diff Page Outs='diff_po||cr
out=out||'Elapsed time='e||cr  */
out='paging : 'pagingd
status='status' fqdn'.paging' color date() time() 'Paging' pagingd ,
       '/sec' cr out cr
call send_to_bb
call close_term_socket
return
 
send_to_bb:
status=toascii(status)
ret=Socket('Send',sid,status)
parse var ret rc .
if rc<>0 then
  say 'Send:' ret
return
 
toascii:
parse arg buffer
buffer=translate(buffer,asc,ebc)
return buffer
 
init_open_socket:
call init_local_vars
ret=socket('Initialize','hobvse')
parse var ret rc .
if rc<>0 then
  say 'Initialize:' ret
ret=socket('Socket','AF_INET','Sock_Stream',0)
parse var ret rc .
if rc<>0 then
  say 'Socket:' ret
parse var ret rc sid .
call init_values
name='AF_INET' bbport bbdisplay
ret=socket('Connect',sid,name)
parse var ret rc .
if rc<>0 then
  say 'Connect:' ret
return
 
close_term_socket:
ret=Socket('Close',sid)
parse var ret rc .
if rc<>0 then
  say 'Close:' ret
ret=Socket('Terminate')
parse var ret rc .
if rc<>0 then
  say 'Terminate:' ret
return
 
init_local_vars:
cr='0a'x             /*  Carriage return   */
/*  Init local variables first  */
bbdisplay=''
bbport=''
domainname=''
hostname=''
/*  Go through options table to fill values to run the client    */
/*  Retrieve options member from PRD2.CONFIG                     */
'execio * diskr 'lib'.hobvars.z (stem hobvars. finis'
do i=1 to hobvars.0
  if left(hobvars.i,1)='#' then iterate   /* Ignore comment */
  parse var hobvars.i kw value
  value=strip(value,'B')
  select
    when kw='bbdisplay' then
      bbdisplay=value
    when kw='bbport' then
      bbport=value
    when kw='domainname' then
      domainname=value
    when kw='hostname' then
      hostname=value
    when kw='PAGE' then
      parse var value yellow red
    otherwise
      nop
    end
  end
return
 
init_values:
ebc=' !"#$%&'||'7D'X||'()*+,-./012' ,
    '3456789:;<=>?@ABCDE' ,
    'FGHIJKLMNOPQRSTUVWX' ,
    'YZ
\Y_`abcdefghijk' ,
    'lmnopqrstuvwxyz{|}~'
asc='202122232425262728292A2B2C2D2E2F303132'x ,
    '333435363738393A3B3C3D3E3F404142434445'x ,
    '464748494A4B4C4D4E4F505152535455565758'x ,
    '595A5B5C5D5E5F606162636465666768696A6B'x ,
    '6C6D6E6F707172737475767778797A7B7C7D7E'x
if hostname='' then do
  ret=socket('Gethostname')
  parse var ret rc hostname .
  if rc<>0 then
    say 'Gethostname:' ret
  hostname=lower(hostname)
  end
if domainname='' then
  fqdn=hostname
else
  fqdn=hostname||'.'||domainname
/*  Change periods to commas  */
fqdn=translate(fqdn,',','.')
return
 
/*  Convert parameter to lower case.  */
lower:
arg string
lc_chars='abcdefghijklmnopqrstuvwxyz'
uc_chars='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
string=translate(string,lc_chars,uc_chars)
return string
