export type ControllerSet = {
    stick?: ControllerStick[];
    trigger?: ControllerTrigger[];
    dpad?: ControllerDpad;
    button?: Button[];
};
export type ControllerStick = {
    stickbutton: Button[];
    name: string;
    uq_index: number;
};
type ControllerDpad = {
    dpadbutton: Button[];
    uq_index: number;
};
export type ControllerTrigger = {
    triggerbutton: Button;
    name: string;
    uq_index: number;
};
type Button = {
    slots: Slots;
    name: string;
    actionName?: string;
    uq_index: number;
};
type Slots = {
    slot: Slot;
};
export type Slot = {
    code: number;
    mode: string;
};
type MappedName = {
    output: string;
    name?: string;
};
export declare function getFormattedMappedName({ code, mode }: Slot, name?: string): string;
export declare function getMappedName({ code, mode }: Slot, name?: string): MappedName;
export declare const readableInputs: any;
export {};
