/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.DataHelper;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.JobQueueRunner;
import net.i2p.router.JobStats;
import net.i2p.router.JobTiming;
import net.i2p.router.MessageHistory;
import net.i2p.router.RouterClock;
import net.i2p.router.RouterContext;
import net.i2p.router.message.HandleGarlicMessageJob;
import net.i2p.router.networkdb.kademlia.HandleFloodfillDatabaseLookupMessageJob;
import net.i2p.router.networkdb.kademlia.IterativeSearchJob;
import net.i2p.router.tunnel.pool.TestJob;
import net.i2p.util.Clock;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class JobQueue {
    private final Log _log;
    private final RouterContext _context;
    private final Map<Integer, JobQueueRunner> _queueRunners;
    private static final AtomicInteger _runnerId = new AtomicInteger(0);
    private final BlockingQueue<Job> _readyJobs;
    private final Set<Job> _timedJobs;
    private final ConcurrentHashMap<String, JobStats> _jobStats;
    private final QueuePumper _pumper;
    private volatile boolean _allowParallelOperation;
    private volatile boolean _alive;
    private final Object _jobLock;
    private volatile long _nextPumperRun;
    private static final int RUNNERS;
    private static int DEFAULT_MAX_RUNNERS;
    private static final String PROP_MAX_RUNNERS = "router.maxJobRunners";
    private static final long MAX_LIMIT_UPDATE_DELAY = 300000L;
    private long _lagWarning = 5000L;
    private static final long DEFAULT_LAG_WARNING = 5000L;
    @Deprecated
    private static final String PROP_LAG_WARNING = "router.jobLagWarning";
    private long _lagFatal = 30000L;
    private static final long DEFAULT_LAG_FATAL = 30000L;
    @Deprecated
    private static final String PROP_LAG_FATAL = "router.jobLagFatal";
    private long _runWarning = 5000L;
    private static final long DEFAULT_RUN_WARNING = 5000L;
    @Deprecated
    private static final String PROP_RUN_WARNING = "router.jobRunWarning";
    private long _runFatal = 30000L;
    private static final long DEFAULT_RUN_FATAL = 30000L;
    @Deprecated
    private static final String PROP_RUN_FATAL = "router.jobRunFatal";
    private long _warmupTime = 900000L;
    private static final long DEFAULT_WARMUP_TIME = 900000L;
    @Deprecated
    private static final String PROP_WARMUP_TIME = "router.jobWarmupTime";
    private int _maxWaitingJobs = DEFAULT_MAX_WAITING_JOBS;
    private static final int DEFAULT_MAX_WAITING_JOBS;
    private static final long MIN_LAG_TO_DROP;
    private static final String PROP_MAX_WAITING_JOBS = "router.maxWaitingJobs";
    private final Object _runnerLock = new Object();
    private static final int POISON_ID = -99999;

    public JobQueue(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(JobQueue.class);
        this._context.statManager().createRateStat("jobQueue.readyJobs", "Ready and waiting scheduled jobs", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.droppedJobs", "Scheduled jobs dropped due to insane overload", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.queuedJobs", "Scheduled jobs in queue", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.jobRun", "Duration of scheduled jobs", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.jobRunSlow", "Duration of jobs that take over a second (ms)", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("jobQueue.jobLag", "Delay before waiting jobs are run (ms)", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.jobWait", "Time a scheduled job stays queued before running (ms)", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._readyJobs = new LinkedBlockingQueue<Job>();
        this._timedJobs = new TreeSet<Job>(new JobComparator());
        this._jobLock = new Object();
        this._queueRunners = new ConcurrentHashMap<Integer, JobQueueRunner>(RUNNERS);
        this._jobStats = new ConcurrentHashMap();
        this._pumper = new QueuePumper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Job job) {
        long numReady;
        if (job == null || !this._alive) {
            return;
        }
        boolean alreadyExists = false;
        boolean dropped = false;
        long now = this._context.clock().now();
        long start = job.getTiming().getStartAfter();
        if (start > now + 259200000L && this._log.shouldWarn()) {
            this._log.warn(job + " scheduled far in the future: " + new Date(start));
        }
        Object object = this._jobLock;
        synchronized (object) {
            boolean removed;
            if (this._readyJobs.contains(job)) {
                alreadyExists = true;
            }
            numReady = this._readyJobs.size();
            if (!alreadyExists && (removed = this._timedJobs.remove(job)) && this._log.shouldWarn()) {
                this._log.warn(job + " rescheduled");
            }
            if (!alreadyExists && this.shouldDrop(job, numReady)) {
                job.dropped();
                dropped = true;
            } else if (!alreadyExists) {
                if (start <= now) {
                    job.getTiming().setStartAfter(now);
                    if (job instanceof JobImpl) {
                        ((JobImpl)job).madeReady(now);
                    }
                    this._readyJobs.offer(job);
                } else {
                    this._timedJobs.add(job);
                    if (start < this._nextPumperRun) {
                        this._jobLock.notifyAll();
                    }
                }
            }
        }
        this._context.statManager().addRateData("jobQueue.readyJobs", numReady);
        this._context.statManager().addRateData("jobQueue.queuedJobs", this._timedJobs.size());
        if (dropped) {
            JobStats old;
            String key;
            JobStats stats;
            this._context.statManager().addRateData("jobQueue.droppedJobs", 1L);
            if (this._log.shouldWarn()) {
                this._log.warn(job + " dropped due to backlog: " + numReady + " jobs already queued");
            }
            if ((stats = this._jobStats.get(key = job.getName())) == null && (old = this._jobStats.putIfAbsent(key, stats = new JobStats(key))) != null) {
                stats = old;
            }
            stats.jobDropped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(Job job) {
        Object object = this._jobLock;
        synchronized (object) {
            boolean removed = this._timedJobs.remove(job);
            if (!removed) {
                this._readyJobs.remove(job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isJobActive(Job job) {
        Iterator<JobQueueRunner> iterator = this._jobLock;
        synchronized (iterator) {
            if (this._readyJobs.contains(job) || this._timedJobs.contains(job)) {
                return true;
            }
        }
        for (JobQueueRunner runner : this._queueRunners.values()) {
            if (runner.getCurrentJob() != job) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void timingUpdated() {
        Object object = this._jobLock;
        synchronized (object) {
            this._jobLock.notifyAll();
        }
    }

    public int getReadyCount() {
        return this._readyJobs.size();
    }

    public long getMaxLag() {
        Job j = (Job)this._readyJobs.peek();
        if (j == null) {
            return 0L;
        }
        JobTiming jt = j.getTiming();
        if (jt == null) {
            return 0L;
        }
        long startAfter = jt.getStartAfter();
        return this._context.clock().now() - startAfter;
    }

    private boolean shouldDrop(Job job, long numReady) {
        if (this._maxWaitingJobs <= 0) {
            return false;
        }
        if (!this._allowParallelOperation) {
            return false;
        }
        if (numReady > (long)this._context.getProperty(PROP_MAX_WAITING_JOBS, DEFAULT_MAX_WAITING_JOBS)) {
            Class<?> cls = job.getClass();
            if (!this._context.getBooleanProperty("router.disableTunnelTesting") ? (cls == HandleFloodfillDatabaseLookupMessageJob.class || cls == HandleGarlicMessageJob.class || cls == IterativeSearchJob.class || cls == TestJob.class) && this.getMaxLag() >= MIN_LAG_TO_DROP : (cls == HandleFloodfillDatabaseLookupMessageJob.class || cls == HandleGarlicMessageJob.class || cls == IterativeSearchJob.class) && this.getMaxLag() >= MIN_LAG_TO_DROP) {
                return true;
            }
        }
        return false;
    }

    public void allowParallelOperation() {
        this._allowParallelOperation = true;
        this.runQueue(this._context.getProperty(PROP_MAX_RUNNERS, RUNNERS));
    }

    public void startup() {
        this._alive = true;
        I2PThread pumperThread = new I2PThread(this._pumper, "JobQueuePumper", true);
        pumperThread.setPriority(10);
        pumperThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void restart() {
        Object object = this._jobLock;
        synchronized (object) {
            this._timedJobs.clear();
            this._readyJobs.clear();
            this._jobLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this._alive = false;
        Object object = this._jobLock;
        synchronized (object) {
            this._timedJobs.clear();
            this._readyJobs.clear();
            this._jobLock.notifyAll();
        }
        PoisonJob poison = new PoisonJob();
        for (JobQueueRunner runner : this._queueRunners.values()) {
            runner.stopRunning();
            this._readyJobs.offer(poison);
        }
        this._queueRunners.clear();
        this._jobStats.clear();
        _runnerId.set(0);
    }

    boolean isAlive() {
        return this._alive;
    }

    public long getLastJobBegin() {
        long when = -1L;
        for (JobQueueRunner runner : this._queueRunners.values()) {
            long cur = runner.getLastBegin();
            if (cur <= when) continue;
            when = cur;
        }
        return when;
    }

    public long getLastJobEnd() {
        long when = -1L;
        for (JobQueueRunner runner : this._queueRunners.values()) {
            long cur = runner.getLastEnd();
            if (cur <= when) continue;
            when = cur;
        }
        return when;
    }

    public Job getLastJob() {
        Job j = null;
        long when = -1L;
        for (JobQueueRunner cur : this._queueRunners.values()) {
            if (cur.getLastBegin() <= when) continue;
            j = cur.getCurrentJob();
            when = cur.getLastBegin();
        }
        return j;
    }

    Job getNext() {
        while (this._alive) {
            try {
                Job j = this._readyJobs.take();
                if (j.getJobId() != -99999L) {
                    return j;
                }
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Job no longer alive; returning null");
        }
        return null;
    }

    public synchronized void runQueue(int numThreads) {
        if (!this._queueRunners.isEmpty() && !this._allowParallelOperation) {
            return;
        }
        if (this._queueRunners.size() < numThreads) {
            if (this._log.shouldInfo()) {
                this._log.info("Increasing the number of queue runners from " + this._queueRunners.size() + " to " + numThreads);
            }
            for (int i = this._queueRunners.size(); i < numThreads; ++i) {
                JobQueueRunner runner = new JobQueueRunner(this._context, i);
                this._queueRunners.put(i, runner);
                runner.setName("JobQueue " + _runnerId.incrementAndGet() + '/' + numThreads);
                runner.start();
            }
        } else if (this._queueRunners.size() == numThreads) {
            if (this._log.shouldWarn()) {
                this._log.warn("Already have " + numThreads + " threads");
            }
        } else if (this._log.shouldWarn()) {
            this._log.warn("Already have " + this._queueRunners.size() + " threads, not decreasing");
        }
    }

    void removeRunner(int id) {
        this._queueRunners.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJobTimings(long delta) {
        Object object = this._jobLock;
        synchronized (object) {
            for (Job j : this._timedJobs) {
                j.getTiming().offsetChanged(delta);
            }
            for (Job j : this._readyJobs) {
                j.getTiming().offsetChanged(delta);
            }
        }
        object = this._runnerLock;
        synchronized (object) {
            for (JobQueueRunner runner : this._queueRunners.values()) {
                Job job = runner.getCurrentJob();
                if (job == null) continue;
                job.getTiming().offsetChanged(delta);
            }
        }
    }

    void updateStats(Job job, long doStart, long origStartAfter, long duration) {
        JobStats old;
        JobStats stats;
        if (this._context.router() == null) {
            return;
        }
        String key = job.getName();
        long lag = doStart - origStartAfter;
        MessageHistory hist = this._context.messageHistory();
        long uptime = this._context.router().getUptime();
        if (lag < 0L) {
            lag = 0L;
        }
        if (duration < 0L) {
            duration = 0L;
        }
        if ((stats = this._jobStats.get(key)) == null && (old = this._jobStats.putIfAbsent(key, stats = new JobStats(key))) != null) {
            stats = old;
        }
        stats.jobRan(duration, lag);
        String dieMsg = null;
        if (lag > this._lagWarning) {
            dieMsg = "Too much lag for " + job.getName() + " Job: " + lag + "ms with run time of " + duration + "ms";
        } else if (duration > this._runWarning) {
            dieMsg = "Run too long for " + job.getName() + " Job: " + lag + "ms lag with run time of " + duration + "ms";
        }
        if (dieMsg != null) {
            if (this._log.shouldWarn()) {
                this._log.warn(dieMsg);
            }
            if (hist != null) {
                hist.messageProcessingError(-1L, JobQueue.class.getName(), dieMsg);
            }
        }
        if (lag > this._lagFatal && uptime > this._warmupTime) {
            if (this._log.shouldWarn()) {
                this._log.log(30, "Router is incredibly overloaded or there's an error.");
            }
            return;
        }
        if (uptime > this._warmupTime && duration > this._runFatal) {
            if (this._log.shouldWarn()) {
                this._log.log(30, "Router is incredibly overloaded (slow cpu?) or there's an error.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJobs(Collection<Job> readyJobs, Collection<Job> timedJobs, Collection<Job> activeJobs, Collection<Job> justFinishedJobs) {
        for (JobQueueRunner runner : this._queueRunners.values()) {
            Job job = runner.getCurrentJob();
            if (job != null) {
                activeJobs.add(job);
                continue;
            }
            job = runner.getLastJob();
            if (job == null) continue;
            justFinishedJobs.add(job);
        }
        Object object = this._jobLock;
        synchronized (object) {
            readyJobs.addAll(this._readyJobs);
            timedJobs.addAll(this._timedJobs);
        }
        return this._queueRunners.size();
    }

    public Collection<JobStats> getJobStats() {
        return Collections.unmodifiableCollection(this._jobStats.values());
    }

    @Deprecated
    public void renderStatusHTML(Writer out) throws IOException {
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        int cores = SystemVersion.getCores();
        RUNNERS = cores == 1 || SystemVersion.isSlow() || maxMemory < 0x10000000L ? 4 : (cores <= 4 ? cores + 2 : (maxMemory >= 0x40000000L ? Math.min(cores, 8) : (maxMemory >= 0x20000000L ? Math.min(cores - 2, 6) : Math.min(cores, 5))));
        DEFAULT_MAX_RUNNERS = Math.min(SystemVersion.getCores() + 2, 8);
        int n = DEFAULT_MAX_WAITING_JOBS = SystemVersion.isSlow() || SystemVersion.getCores() < 4 ? 20 : 30;
        MIN_LAG_TO_DROP = SystemVersion.isSlow() || SystemVersion.getCores() < 4 ? 200L : (SystemVersion.getCPULoadAvg() > 90 ? 10L : 100L);
    }

    private static class JobComparator
    implements Comparator<Job>,
    Serializable {
        private JobComparator() {
        }

        @Override
        public int compare(Job l, Job r) {
            if (l.equals(r)) {
                return 0;
            }
            long ld = l.getTiming().getStartAfter() - r.getTiming().getStartAfter();
            if (ld < 0L) {
                return -1;
            }
            if (ld > 0L) {
                return 1;
            }
            ld = l.getJobId() - r.getJobId();
            if (ld < 0L) {
                return -1;
            }
            if (ld > 0L) {
                return 1;
            }
            return l.hashCode() - r.hashCode();
        }
    }

    private static class PoisonJob
    implements Job {
        private PoisonJob() {
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public long getJobId() {
            return -99999L;
        }

        @Override
        public JobTiming getTiming() {
            return null;
        }

        @Override
        public void runJob() {
        }

        @Override
        public Exception getAddedBy() {
            return null;
        }

        @Override
        public void dropped() {
        }
    }

    private final class QueuePumper
    implements Runnable,
    Clock.ClockUpdateListener,
    RouterClock.ClockShiftListener {
        public QueuePumper() {
            JobQueue.this._context.clock().addUpdateListener(this);
            ((RouterClock)JobQueue.this._context.clock()).addShiftListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block28: {
                block10: while (true) {
                    try {
                        while (JobQueue.this._alive) {
                            long now = JobQueue.this._context.clock().now();
                            long timeToWait = -1L;
                            try {
                                Object object = JobQueue.this._jobLock;
                                synchronized (object) {
                                    boolean isHexaCore;
                                    Job lastJob = null;
                                    long lastTime = Long.MIN_VALUE;
                                    Iterator iter = JobQueue.this._timedJobs.iterator();
                                    while (iter.hasNext()) {
                                        Job j = (Job)iter.next();
                                        long timeLeft = j.getTiming().getStartAfter() - now;
                                        if (lastJob != null && lastTime > j.getTiming().getStartAfter() && JobQueue.this._log.shouldInfo()) {
                                            JobQueue.this._log.info(lastJob + " out of order with " + j + "\n* Difference: " + DataHelper.formatDuration(lastTime - j.getTiming().getStartAfter()));
                                        }
                                        lastJob = j;
                                        lastTime = lastJob.getTiming().getStartAfter();
                                        if (timeLeft <= 0L) {
                                            if (j instanceof JobImpl) {
                                                ((JobImpl)j).madeReady(now);
                                            }
                                            JobQueue.this._readyJobs.offer(j);
                                            iter.remove();
                                            continue;
                                        }
                                        timeToWait = timeLeft;
                                        if (timeToWait <= 10000L || !iter.hasNext()) break;
                                        if (JobQueue.this._log.shouldInfo()) {
                                            JobQueue.this._log.info(j + " deferred for " + DataHelper.formatDuration(timeToWait));
                                        }
                                        iter.remove();
                                        Job nextJob = (Job)iter.next();
                                        JobQueue.this._timedJobs.add(j);
                                        long nextTimeLeft = nextJob.getTiming().getStartAfter() - now;
                                        if (timeToWait <= nextTimeLeft) break;
                                        if (JobQueue.this._log.shouldInfo()) {
                                            JobQueue.this._log.info(j + " out of order with " + nextJob + "\n* Difference: " + DataHelper.formatDuration(timeToWait - nextTimeLeft));
                                        }
                                        timeToWait = Math.max(10L, nextTimeLeft);
                                        break;
                                    }
                                    boolean highLoad = SystemVersion.getCPULoadAvg() > 90 || SystemVersion.getCPULoad() > 95;
                                    boolean isSlow = SystemVersion.isSlow();
                                    boolean isQuadCore = SystemVersion.getCores() >= 4;
                                    boolean bl = isHexaCore = SystemVersion.getCores() >= 6;
                                    if (timeToWait < 0L) {
                                        timeToWait = highLoad ? 250L : 100L;
                                    } else if (timeToWait < 10L) {
                                        timeToWait = highLoad ? 100L : 50L;
                                    } else if (!isSlow && isHexaCore && timeToWait > 2500L) {
                                        timeToWait = highLoad ? 3500L : 2500L;
                                    } else if (!isSlow && isQuadCore && timeToWait > 4000L) {
                                        timeToWait = highLoad ? 5000L : 4000L;
                                    } else if (timeToWait > 10000L) {
                                        timeToWait = highLoad ? 12000L : 10000L;
                                    }
                                    JobQueue.this._nextPumperRun = JobQueue.this._context.clock().now() + timeToWait;
                                    JobQueue.this._jobLock.wait(timeToWait);
                                    continue block10;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                        break block28;
                    }
                    catch (Throwable t) {
                        if (JobQueue.this._log.shouldError()) {
                            JobQueue.this._log.error("Pumper killed?!", t);
                        }
                        break block28;
                    }
                }
                finally {
                    JobQueue.this._context.clock().removeUpdateListener(this);
                    ((RouterClock)JobQueue.this._context.clock()).removeShiftListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void offsetChanged(long delta) {
            JobQueue.this.updateJobTimings(delta);
            Object object = JobQueue.this._jobLock;
            synchronized (object) {
                JobQueue.this._jobLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clockShift(long delta) {
            if (delta < 0L) {
                this.offsetChanged(delta);
            } else {
                Object object = JobQueue.this._jobLock;
                synchronized (object) {
                    JobQueue.this._jobLock.notifyAll();
                }
            }
        }
    }
}

