/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class OutNetMessagePool {
    private final Log _log;
    private final RouterContext _context;

    public OutNetMessagePool(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(OutNetMessagePool.class);
    }

    public void add(OutNetMessage msg) {
        if (msg == null) {
            return;
        }
        MessageSelector selector = msg.getReplySelector();
        boolean valid = this.validate(msg);
        if (!valid) {
            if (selector != null) {
                this._context.messageRegistry().unregisterPending(msg);
            }
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Adding message to OutNetMessagePool" + msg);
        }
        if (selector != null) {
            this._context.messageRegistry().registerPending(msg);
        }
        this._context.commSystem().processMessage(msg);
    }

    private boolean validate(OutNetMessage msg) {
        if (msg.getMessage() == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Null message in the OutNetMessage - expired too soon");
            }
            return false;
        }
        if (msg.getTarget() == null) {
            this._log.error("No target in the OutNetMessage: " + msg, new Exception());
            return false;
        }
        if (msg.getPriority() < 0) {
            this._log.error("Message cannot have a priority of < 0, dropping..." + msg, new Exception());
            return false;
        }
        if (msg.getExpiration() <= this._context.clock().now()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping expired Outbound message" + msg, new Exception());
            }
            return false;
        }
        return true;
    }
}

