/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class ExpireLeasesJob
extends JobImpl {
    private final Log _log;
    private final KademliaNetworkDatabaseFacade _facade;
    private static final long RERUN_DELAY_MS = 30000L;

    public ExpireLeasesJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(ExpireLeasesJob.class);
        this._facade = facade;
    }

    @Override
    public String getName() {
        return "Expire Leases";
    }

    @Override
    public void runJob() {
        List<Hash> toExpire = this.selectKeysToExpire();
        if (!toExpire.isEmpty()) {
            StringBuilder buf = new StringBuilder(16);
            buf.append("Leases to expire: ");
            for (Hash h : toExpire) {
                buf.append("[").append(h.toBase64().substring(0, 6)).append("]");
                buf.append(" ");
            }
            this._log.info(buf.toString());
            for (Hash key : toExpire) {
                this._facade.fail(key);
            }
            if (this._log.shouldLog(20)) {
                this._log.info("[DbId: " + this._facade + "] Known LeaseSets: " + this._facade.getKnownLeaseSets() + "; Leases to expire: " + toExpire);
            }
        }
        this.requeue(30000L);
    }

    private List<Hash> selectKeysToExpire() {
        ArrayList<Hash> toExpire = new ArrayList<Hash>(128);
        for (Map.Entry<Hash, DatabaseEntry> entry : this._facade.getDataStore().getMapEntries()) {
            DatabaseEntry obj = entry.getValue();
            if (!obj.isLeaseSet()) continue;
            LeaseSet ls = (LeaseSet)obj;
            if (!ls.isCurrent(60000L)) {
                toExpire.add(entry.getKey());
                continue;
            }
            if (!this._log.shouldDebug()) continue;
            if (ls.getDestination() != null) {
                this._log.debug("Lease [" + ls.getDestination().calculateHash().toBase64().substring(0, 6) + "] is current - not expiring");
                continue;
            }
            this._log.debug("Not expiring current but unidentified Lease (no destination)");
        }
        return toExpire;
    }
}

