/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.crypto.EncType;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.kademlia.KBucketSet;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.IterativeSearchJob;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.util.SystemVersion;

class ExploreJob
extends SearchJob {
    private final FloodfillPeerSelector _peerSelector;
    private final boolean _isRealExplore;
    private static final long MAX_EXPLORE_TIME = SystemVersion.isSlow() ? 20000L : 15000L;
    static final String PROP_EXPLORE_BREDTH = "router.exploreBredth";
    private static final int EXPLORE_BREDTH = SystemVersion.isSlow() ? 1 : 2;
    static final int MAX_CLOSEST = 32;
    static final int PER_FLOODFILL_PEER_TIMEOUT = 5000;

    public ExploreJob(RouterContext context, KademliaNetworkDatabaseFacade facade, Hash key, boolean isRealExplore, long msgIDBloomXor) {
        super(context, facade, key, null, null, MAX_EXPLORE_TIME, false, false, msgIDBloomXor);
        this._peerSelector = (FloodfillPeerSelector)this._facade.getPeerSelector();
        this._isRealExplore = isRealExplore;
    }

    @Override
    protected I2NPMessage buildMessage(TunnelId replyTunnelId, Hash replyGateway, long expiration, RouterInfo peer) {
        FastI2NPMessageImpl outMsg;
        RouterContext ctx = this.getContext();
        DatabaseLookupMessage msg = new DatabaseLookupMessage(ctx, true);
        msg.setSearchKey(this.getState().getTarget());
        msg.setFrom(replyGateway);
        Set<Hash> dontIncludePeers = this.getState().getClosestAttempted(32);
        msg.setMessageExpiration(expiration);
        if (replyTunnelId != null) {
            msg.setReplyTunnel(replyTunnelId);
        }
        int available = 32 - dontIncludePeers.size();
        if (this._isRealExplore) {
            msg.setSearchType(DatabaseLookupMessage.Type.EXPL);
        } else {
            msg.setSearchType(DatabaseLookupMessage.Type.RI);
        }
        KBucketSet<Hash> ks = this._facade.getKBuckets();
        Hash rkey = ctx.routingKeyGenerator().getRoutingKey(this.getState().getTarget());
        if (available > 0) {
            HashSet<Hash> dontInclude = new HashSet<Hash>(dontIncludePeers);
            List<Hash> peers = this._peerSelector.selectNearestExplicit(rkey, available, dontInclude, ks);
            dontIncludePeers.addAll(peers);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Excluding " + (dontIncludePeers.size() - 1) + " closest peers from exploration\n* Excluded: ");
        for (Hash h : dontIncludePeers) {
            buf.append("[").append(h.toBase64().substring(0, 6)).append("]");
            buf.append(" ");
        }
        if (this._log.shouldDebug()) {
            this._log.debug(buf.toString());
        }
        msg.setDontIncludePeers(dontIncludePeers);
        RouterIdentity ident = peer.getIdentity();
        EncType type = ident.getPublicKey().getType();
        boolean encryptElG = ctx.getProperty("router.encryptRouterLookups", IterativeSearchJob.DEFAULT_ENCRYPT_RI);
        if (replyTunnelId != null && (encryptElG && type == EncType.ELGAMAL_2048 || type == EncType.ECIES_X25519)) {
            EncType ourType = ctx.keyManager().getPublicKey().getType();
            boolean ratchet1 = ourType.equals((Object)EncType.ECIES_X25519);
            boolean ratchet2 = DatabaseLookupMessage.supportsRatchetReplies(peer);
            if (DatabaseLookupMessage.supportsEncryptedReplies(peer) && (ratchet2 || !ratchet1)) {
                boolean supportsRatchet = ratchet1 && ratchet2;
                MessageWrapper.OneTimeSession sess = MessageWrapper.generateSession(ctx, ctx.sessionKeyManager(), MAX_EXPLORE_TIME, !supportsRatchet);
                if (sess != null) {
                    if (sess.tag != null) {
                        if (this._log.shouldInfo()) {
                            this._log.info("[Job " + this.getJobId() + "] Requesting AES reply from [" + ident.calculateHash().toBase64().substring(0, 6) + "] \n* Session Key: " + sess.key + "\n* Tag: " + sess.tag);
                        }
                        msg.setReplySession(sess.key, sess.tag);
                    } else {
                        if (this._log.shouldInfo()) {
                            this._log.info("[Job " + this.getJobId() + "] Requesting AEAD reply from [" + ident.calculateHash().toBase64().substring(0, 6) + "] \n* Session Key: " + sess.key + "\n* Tag: " + sess.rtag);
                        }
                        msg.setReplySession(sess.key, sess.rtag);
                    }
                } else if (this._log.shouldWarn()) {
                    this._log.warn("Failed encrypt to " + peer);
                }
            }
            outMsg = MessageWrapper.wrap(ctx, (I2NPMessage)msg, peer);
            if (this._log.shouldDebug()) {
                this._log.debug("[Job " + this.getJobId() + "] Encrypted Exploratory DbLookupMessage for [" + this.getState().getTarget().toBase64().substring(0, 6) + "] sent to [" + ident.calculateHash().toBase64().substring(0, 6) + "]");
            }
        } else {
            outMsg = msg;
        }
        return outMsg;
    }

    @Override
    protected int getBredth() {
        String exploreBredth = this.getContext().getProperty(PROP_EXPLORE_BREDTH);
        boolean isSingleCore = SystemVersion.getCores() < 2;
        boolean isSlow = SystemVersion.isSlow();
        int cpuLoad = SystemVersion.getCPULoad();
        int cpuLoadAvg = SystemVersion.getCPULoadAvg();
        if (exploreBredth == null && this.getContext().netDb().getKnownRouters() < 1500 && !isSlow && !isSingleCore && cpuLoad < 95 && cpuLoadAvg < 95) {
            if (this._log.shouldInfo()) {
                this._log.info("[Job " + this.getJobId() + "] Initiating Exploratory Search -> Max " + EXPLORE_BREDTH * 3 + " concurrent (less than 1000 known peers)");
            }
            return EXPLORE_BREDTH * 3;
        }
        if (exploreBredth == null && this.getContext().netDb().getKnownRouters() > 3500 || cpuLoad > 90 && cpuLoadAvg > 90 || isSlow || isSingleCore) {
            if (this._log.shouldInfo()) {
                if (cpuLoad > 80 || cpuLoadAvg > 80 || isSlow || isSingleCore) {
                    this._log.info("[Job " + this.getJobId() + "] Initiating Exploratory Search -> Max 1 concurrent (High CPU load or device is low spec)");
                } else {
                    this._log.info("[Job " + this.getJobId() + "] Initiating Exploratory Search -> Max 1 concurrent (over 3000 known peers)");
                }
            }
            return 1;
        }
        if (exploreBredth == null && !isSlow && !isSingleCore && cpuLoad < 95 && cpuLoadAvg < 95) {
            if (this._log.shouldInfo()) {
                this._log.info("[Job " + this.getJobId() + "] Initiating Exploratory Search -> Max " + EXPLORE_BREDTH * 2 + " concurrent (less than 3000 known peers)");
            }
            return EXPLORE_BREDTH * 2;
        }
        if (this.getContext().netDb().getKnownRouters() < 1500) {
            if (this._log.shouldInfo()) {
                this._log.info("[Job " + this.getJobId() + "] Initiating Exploratory Search -> Max " + Math.min(EXPLORE_BREDTH + 1, 2) + " concurrent (less than 1000 known peers)");
            }
            return Math.min(EXPLORE_BREDTH + 1, 2);
        }
        if (exploreBredth != null) {
            if (this._log.shouldInfo()) {
                this._log.info("[Job " + this.getJobId() + "] Initiating Exploratory Search -> Max " + exploreBredth + " concurrent (custom configuration)");
            }
            return Integer.valueOf(exploreBredth);
        }
        if (this._log.shouldInfo()) {
            this._log.info("[Job " + this.getJobId() + "] Initiating Exploratory Search -> Max " + EXPLORE_BREDTH + " concurrent");
        }
        return EXPLORE_BREDTH;
    }

    @Override
    protected void newPeersFound(int numNewPeers) {
        if (this._log.shouldInfo()) {
            if (numNewPeers == 1) {
                this._log.info("[Job " + this.getJobId() + "] Found " + numNewPeers + " new peer via Exploratory Search");
            } else if (numNewPeers > 1) {
                this._log.info("[Job " + this.getJobId() + "] Found " + numNewPeers + " new peers via Exploratory Search");
            } else {
                this._log.info("[Job " + this.getJobId() + "] Found no new peers via Exploratory Search");
            }
        }
        this._facade.setLastExploreNewDate(this.getContext().clock().now());
    }

    @Override
    public String getName() {
        return "Explore Kademlia NetDb";
    }
}

