/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.DatabaseEntry;
import net.i2p.data.LeaseSet;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;
import net.i2p.util.Log;

class FloodOnlyLookupMatchJob
extends JobImpl
implements ReplyJob {
    protected final Log _log;
    protected final FloodSearchJob _search;
    protected volatile boolean _success;

    public FloodOnlyLookupMatchJob(RouterContext ctx, FloodSearchJob job) {
        super(ctx);
        this._log = ctx.logManager().getLog(this.getClass());
        this._search = job;
    }

    @Override
    public void runJob() {
        if (this._success) {
            if (this._log.shouldInfo()) {
                this._log.info("[Job " + this._search.getJobId() + "] Search for [" + this._search.getKey().toBase64().substring(0, 6) + "] found locally");
            }
            this._search.success();
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info("[Job " + this._search.getJobId() + "] Search failed for [" + this._search.getKey().toBase64().substring(0, 6) + "]");
            }
            this._search.failed();
        }
    }

    @Override
    public String getName() {
        return "Match NetDb FloodSearch";
    }

    @Override
    public void setMessage(I2NPMessage message) {
        DatabaseEntry entry;
        int type;
        int mtype = message.getType();
        if (mtype == 3) {
            this._search.failed();
            return;
        }
        if (mtype != 1) {
            return;
        }
        DatabaseStoreMessage dsm = (DatabaseStoreMessage)message;
        if (this._log.shouldDebug()) {
            this._log.debug("[Job " + this._search.getJobId() + "] Received a DbStoreMsg for [" + dsm.getKey().toBase64().substring(0, 6) + "]");
        }
        if (dsm.getKey().equals(this._search.getKey())) {
            this._success = true;
        }
        if (DatabaseEntry.isLeaseSet(type = (entry = dsm.getEntry()).getType())) {
            LeaseSet ls = (LeaseSet)dsm.getEntry();
            ls.setReceivedAsReply();
        }
    }
}

