/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Set;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillVerifyStoreJob;
import net.i2p.router.networkdb.kademlia.StoreJob;

class FloodfillStoreJob
extends StoreJob {
    private final FloodfillNetworkDatabaseFacade _facade;
    private static final String PROP_RI_VERIFY = "router.verifyRouterInfoStore";
    private static final long RI_VERIFY_STARTUP_TIME = 10800000L;

    public FloodfillStoreJob(RouterContext context, FloodfillNetworkDatabaseFacade facade, Hash key, DatabaseEntry data, Job onSuccess, Job onFailure, long timeoutMs) {
        this(context, facade, key, data, onSuccess, onFailure, timeoutMs, null);
    }

    public FloodfillStoreJob(RouterContext context, FloodfillNetworkDatabaseFacade facade, Hash key, DatabaseEntry data, Job onSuccess, Job onFailure, long timeoutMs, Set<Hash> toSkip) {
        super(context, facade, key, data, onSuccess, onFailure, timeoutMs, toSkip);
        this._facade = facade;
    }

    @Override
    protected int getParallelization() {
        return 1;
    }

    @Override
    protected int getRedundancy() {
        return 1;
    }

    @Override
    protected void succeed() {
        long published;
        boolean isls2;
        boolean isRouterInfo;
        super.succeed();
        boolean shouldLog = this._log.shouldInfo();
        Hash key = this._state.getTarget();
        if (this._facade.isVerifyInProgress(key)) {
            if (shouldLog) {
                this._log.info("Skipping verify, one already in progress for: [" + key.toBase64().substring(0, 6) + "]");
            }
            return;
        }
        RouterContext ctx = this.getContext();
        if (ctx.router().gracefulShutdownInProgress()) {
            if (shouldLog) {
                this._log.info("Skipping verify of [" + key.toBase64().substring(0, 6) + "] - shutdown in progress...");
            }
            return;
        }
        DatabaseEntry data = this._state.getData();
        int type = data.getType();
        boolean bl = isRouterInfo = type == 0;
        if (isRouterInfo && !ctx.getBooleanProperty(PROP_RI_VERIFY) && ctx.router().getUptime() > 10800000L) {
            this._facade.routerInfoPublishSuccessful();
            return;
        }
        boolean bl2 = isls2 = data.isLeaseSet() && type != 1;
        if (isls2) {
            LeaseSet2 ls2 = (LeaseSet2)data;
            published = ls2.getPublished();
        } else {
            published = data.getDate();
        }
        Hash sentTo = this._state.getSuccessful();
        Hash client = type == 5 ? ((LeaseSet)data).getDestination().calculateHash() : key;
        FloodfillVerifyStoreJob fvsj = new FloodfillVerifyStoreJob(ctx, key, client, published, type, sentTo, this._state.getAttempted(), this._facade);
        if (shouldLog) {
            this._log.info("[Job " + this.getJobId() + "] Succeeded sending key [" + key.toBase64().substring(0, 6) + "] - queueing VerifyFloodfillStore Job [" + fvsj.getJobId() + "]");
        }
        ctx.jobQueue().addJob(fvsj);
    }

    @Override
    public String getName() {
        return "Verify Floodfill Store";
    }
}

