/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.IterativeFollowupJob;
import net.i2p.router.networkdb.kademlia.IterativeSearchJob;
import net.i2p.router.networkdb.kademlia.SingleLookupJob;
import net.i2p.router.networkdb.kademlia.SingleSearchJob;
import net.i2p.util.Log;

class IterativeLookupJob
extends JobImpl {
    private final Log _log;
    private final DatabaseSearchReplyMessage _dsrm;
    private final IterativeSearchJob _search;

    public IterativeLookupJob(RouterContext ctx, DatabaseSearchReplyMessage dsrm, IterativeSearchJob search) {
        super(ctx);
        this._log = ctx.logManager().getLog(IterativeLookupJob.class);
        this._dsrm = dsrm;
        this._search = search;
    }

    @Override
    public void runJob() {
        long timeSent;
        Hash from = this._dsrm.getFromHash();
        long now = this.getContext().clock().now();
        boolean isBanlisted = this.getContext().banlist().isBanlisted(from);
        if (!this._search.wasQueried(from)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Received unsolicited DbSearchReply message from [" + from.toBase64().substring(0, 6) + "]" + (isBanlisted ? " (Router is banlisted)" : ""));
                if (!isBanlisted) {
                    this._log.warn("Banning Router [" + from.toBase64().substring(0, 6) + "] for 15m -> Sending unsolicited DbSearchReply messages");
                }
            }
            this.getContext().banlist().banlistRouter(from, " <b>\u279c</b> Unsolicited DbSearchReply messages", null, null, now + 900000L);
            return;
        }
        int limit = Math.min(this._dsrm.getNumReplies(), SingleLookupJob.MAX_TO_FOLLOW);
        int newPeers = 0;
        int oldPeers = 0;
        int invalidPeers = 0;
        for (int i = 0; i < limit; ++i) {
            Hash peer = this._dsrm.getReply(i);
            if (peer.equals(this.getContext().routerHash())) {
                ++oldPeers;
                continue;
            }
            if (peer.equals(from)) {
                ++invalidPeers;
                continue;
            }
            if (this.getContext().banlist().isBanlistedForever(peer) || this.getContext().banlist().isBanlisted(peer)) {
                ++oldPeers;
                continue;
            }
            RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(peer);
            if (ri == null) {
                this._search.newPeerToTry(peer);
                if (this._search.getFromHash() == null) {
                    this.getContext().jobQueue().addJob(new SingleSearchJob(this.getContext(), peer, from));
                }
                ++newPeers;
                continue;
            }
            if (ri.getPublished() < this.getContext().clock().now() - 3600000L || !FloodfillNetworkDatabaseFacade.isFloodfill(ri)) {
                if (this._search.getFromHash() == null) {
                    this.getContext().jobQueue().addJob(new IterativeFollowupJob(this.getContext(), peer, peer, this._search));
                }
                ++oldPeers;
                continue;
            }
            this._search.newPeerToTry(peer);
            ++oldPeers;
        }
        if (this._log.shouldInfo()) {
            this._log.info("[Job " + this._search.getJobId() + "] IterativeLookup -> DbSearchReplyMsg\n* Processed: " + newPeers + " new, " + oldPeers + " old, and " + invalidPeers + " invalid hashes");
        }
        if ((timeSent = this._search.timeSent(from)) > 0L) {
            this.getContext().profileManager().dbLookupReply(from, newPeers, oldPeers, invalidPeers, 0, this.getContext().clock().now() - timeSent);
        }
        this._search.failed(this._dsrm.getFromHash(), false);
    }

    @Override
    public String getName() {
        return "Process DbStoreReplyMsg";
    }
}

