/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

class RefreshRoutersJob
extends JobImpl {
    private final Log _log;
    private final FloodfillNetworkDatabaseFacade _facade;
    private List<Hash> _routers;
    private boolean _wasRun;
    private static final long RERUN_DELAY_MS = 2000L;
    static final String PROP_RERUN_DELAY_MS = "router.refreshRouterDelay";
    static final String PROP_ROUTER_FRESHNESS = "router.refreshSkipIfYounger";
    static final String PROP_ROUTER_REFRESH_TIMEOUT = "router.refreshTimeout";
    static final String PROP_ROUTER_REFRESH_UNINTERESTING = "router.refreshUninteresting";
    private static final long EXPIRE = 604800000L;
    private static final long OLDER = 0x6DDD00L;
    private static long RESTART_DELAY_MS = 300000L;
    private static final boolean DEFAULT_SHOULD_DISCONNECT = false;
    private static final String PROP_SHOULD_DISCONNECT = "router.enableImmediateDisconnect";

    public RefreshRoutersJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(RefreshRoutersJob.class);
        this._facade = facade;
    }

    @Override
    public String getName() {
        return "Refresh NetDb Routers";
    }

    @Override
    public void runJob() {
        Random rand = new Random();
        long lag = this.getContext().jobQueue().getMaxLag();
        int netDbCount = this.getContext().netDb().getKnownRouters();
        long uptime = this.getContext().router().getUptime();
        boolean isCpuHighLoad = SystemVersion.getCPULoad() > 80;
        boolean shouldDisconnect = this.getContext().getProperty(PROP_SHOULD_DISCONNECT, false);
        if (this._facade.isInitialized() && lag < 500L && this.getContext().commSystem().getStatus() != CommSystemFacade.Status.DISCONNECTED && netDbCount < 5000 && uptime > 60000L) {
            if (this._routers == null || this._routers.isEmpty()) {
                this._routers = this._facade.getFloodfillPeers();
                int ff = this._routers.size();
                Set<Hash> all = this._facade.getAllRouters();
                all.removeAll(this._routers);
                int non = all.size();
                this._routers.addAll(all);
                if (this._log.shouldInfo()) {
                    this._log.info("To check: " + ff + " Floodfills and " + non + " non-Floodfills");
                }
            }
            if (this._routers.isEmpty()) {
                this._routers = null;
                if (this.getContext().router().getUptime() < 3600000L) {
                    RESTART_DELAY_MS = 60000L;
                } else if (netDbCount > 5000 && this.getContext().router().getUptime() > 3600000L) {
                    RESTART_DELAY_MS *= 12L;
                } else if (netDbCount > 3000) {
                    RESTART_DELAY_MS *= (long)(rand.nextInt(12) + 1);
                } else if (netDbCount > 1000 || isCpuHighLoad) {
                    this.requeue(RESTART_DELAY_MS *= (long)(rand.nextInt(3) + 1));
                } else {
                    this.requeue(RESTART_DELAY_MS);
                }
                if (netDbCount > 5000) {
                    this._log.info("Finished refreshing NetDb; over 5000 known routers, job will rerun in " + RESTART_DELAY_MS / 1000L / 60L + "m");
                } else {
                    this._log.info("Finished refreshing NetDb routers; job will rerun in " + RESTART_DELAY_MS / 1000L + "s");
                }
                return;
            }
            long expire = this.getContext().clock().now() - 604800000L;
            Iterator<Hash> iter = this._routers.iterator();
            while (iter.hasNext()) {
                RouterInfo ri;
                Hash h = iter.next();
                iter.remove();
                if (h.equals(this.getContext().routerHash())) continue;
                if (this._log.shouldDebug()) {
                    this._log.debug("Checking RouterInfo [" + h.toBase64().substring(0, 6) + "]");
                }
                if ((ri = this.getContext().netDb().lookupRouterInfoLocally(h)) == null) continue;
                long older = this.getContext().clock().now() - ri.getPublished();
                String freshness = this.getContext().getProperty(PROP_ROUTER_FRESHNESS);
                String refreshTimeout = this.getContext().getProperty(PROP_ROUTER_REFRESH_TIMEOUT);
                int routerAge = 900000;
                String v = ri.getVersion();
                String MIN_VERSION = "0.9.58";
                Hash us = this.getContext().routerHash();
                boolean isUs = us.equals(ri.getIdentity().getHash());
                boolean isHidden = this.getContext().router().isHidden();
                boolean uninteresting = (ri.getCapabilities().indexOf(85) >= 0 || ri.getCapabilities().indexOf(75) >= 0 || ri.getCapabilities().indexOf(76) >= 0 || VersionComparator.comp(v, MIN_VERSION) < 0) && this.getContext().netDb().getKnownRouters() > 3000 && uptime > 900000L && !isHidden && !isUs;
                boolean refreshUninteresting = this.getContext().getBooleanProperty(PROP_ROUTER_REFRESH_UNINTERESTING);
                String caps = "unknown";
                boolean noSSU = true;
                boolean isFF = false;
                String country = "unknown";
                boolean noCountry = true;
                if (ri != null) {
                    caps = ri.getCapabilities().toUpperCase();
                    if (caps.contains("F")) {
                        isFF = true;
                    }
                    if ((country = this.getContext().commSystem().getCountry(h)) != null && country != "unknown") {
                        noCountry = false;
                    }
                }
                if (ri != null) {
                    for (RouterAddress ra : ri.getAddresses()) {
                        if (!ra.getTransportStyle().equals("SSU") && !ra.getTransportStyle().equals("SSU2")) continue;
                        noSSU = false;
                        break;
                    }
                }
                int rapidScan = 600000;
                if (uninteresting || isFF && noSSU) {
                    routerAge = rapidScan;
                } else if (freshness == null) {
                    if (netDbCount > 4000) {
                        routerAge = 21600000;
                    }
                    if (netDbCount > 6000) {
                        routerAge = 28800000;
                    }
                } else {
                    routerAge = Integer.valueOf(freshness) * 60 * 60 * 1000;
                }
                if (older > (long)routerAge) {
                    if (this._log.shouldInfo()) {
                        if (refreshTimeout == null) {
                            this._log.info("Refreshing Router [" + h.toBase64().substring(0, 6) + "]\n* Published: " + new Date(ri.getPublished()));
                        } else {
                            this._log.info("Refreshing Router [" + h.toBase64().substring(0, 6) + "] - " + Integer.valueOf(refreshTimeout) + "s timeout\n* Published: " + new Date(ri.getPublished()));
                        }
                    }
                    if (refreshTimeout == null && uptime < 3600000L) {
                        this._facade.search(h, null, null, 20000L, false);
                    } else if (refreshTimeout == null && uptime < 28800000L) {
                        this._facade.search(h, null, null, 15000L, false);
                    } else if (refreshTimeout == null && uptime > 28800000L) {
                        this._facade.search(h, null, null, 10000L, false);
                    } else {
                        this._facade.search(h, null, null, Integer.valueOf(refreshTimeout) * 1000, false);
                    }
                } else if (this._log.shouldDebug()) {
                    if (routerAge / 60 / 60 / 1000 <= 1 && freshness == null && !uninteresting && !refreshUninteresting) {
                        this._log.debug("Skipping refresh of Router [" + h.toBase64().substring(0, 6) + "] -> Less than 1h old\n* Published: " + new Date(ri.getPublished()));
                    } else if (uninteresting && refreshUninteresting && routerAge / 60 / 60 / 1000 <= 1) {
                        this._log.debug("Skipping refresh of uninteresting Router [" + h.toBase64().substring(0, 6) + "] -> Less than " + rapidScan / 60 / 1000 + "m old \n* Published: " + new Date(ri.getPublished()));
                    } else if (uninteresting && !refreshUninteresting && !isHidden) {
                        this._log.debug("Skipping refresh of Router [" + h.toBase64().substring(0, 6) + "] -> Uninteresting");
                    } else if (noSSU && isFF) {
                        this._log.debug("Skipping refresh of Router [" + h.toBase64().substring(0, 6) + "] -> Floodfill with SSU disabled");
                    } else {
                        this._log.debug("Skipping refresh of Router [" + h.toBase64().substring(0, 6) + "] -> less than " + routerAge / 60 / 60 / 1000 + "h old \n* Published: " + new Date(ri.getPublished()));
                    }
                }
                break;
            }
        } else if (netDbCount > 5000) {
            this._log.info("Over 5000 known routers, suspending Refresh Routers job...");
        } else if (lag > 500L) {
            this._log.info("Job lag over 500ms, suspending Refresh Routers job...");
        } else if (this.getContext().commSystem().getStatus() == CommSystemFacade.Status.DISCONNECTED) {
            this._log.info("Network disconnected, suspending Refresh Routers job...");
        }
        int randomDelay = 1500 * (rand.nextInt(3) + 1) + rand.nextInt(1000) + rand.nextInt(1000) + rand.nextInt(1000) * (rand.nextInt(3) + 1);
        String refresh = this.getContext().getProperty(PROP_RERUN_DELAY_MS);
        if (netDbCount > 3000) {
            randomDelay *= 10;
            if (this._log.shouldDebug()) {
                this._log.debug("Over 3000 known peers, queuing next RouterInfo check to run in " + randomDelay / 1000 + "s...");
            }
        } else if (refresh == null) {
            randomDelay = this.getContext().jobQueue().getMaxLag() > 150L || this.getContext().throttle().getMessageDelay() > 750L ? (randomDelay *= rand.nextInt(3) + 1) : (netDbCount < 500 || this.getContext().router().getUptime() < 1800000L ? Math.max(Math.min(randomDelay - 6000, randomDelay - rand.nextInt(7000)), 300 + rand.nextInt(150)) : (netDbCount < 1000 ? Math.max(randomDelay - rand.nextInt(1250) - rand.nextInt(1250), 400 + rand.nextInt(150)) : (netDbCount < 2000 ? (randomDelay -= rand.nextInt(750) / (rand.nextInt(3) + 1)) : (randomDelay -= rand.nextInt(750) / (rand.nextInt(3) + 1) * rand.nextInt(6) + 1))));
            this.requeue(randomDelay);
            if (this._log.shouldDebug()) {
                this._log.debug("Next RouterInfo check in " + randomDelay + "ms");
            }
        } else {
            this.requeue(Integer.valueOf(refresh).intValue());
            if (this._log.shouldDebug()) {
                this._log.debug("Next RouterInfo check in " + refresh + "ms");
            }
        }
    }

    private class Disconnector
    implements SimpleTimer.TimedEvent {
        private final Hash h;

        public Disconnector(Hash h) {
            this.h = h;
        }

        @Override
        public void timeReached() {
            RefreshRoutersJob.this.getContext().commSystem().forceDisconnect(this.h);
        }
    }
}

