/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class RepublishLeaseSetJob
extends JobImpl {
    private final Log _log;
    public static final long REPUBLISH_LEASESET_TIMEOUT = 120000L;
    private static final int RETRY_DELAY = 15000;
    private final Hash _dest;
    private final KademliaNetworkDatabaseFacade _facade;
    private long _lastPublished;

    public RepublishLeaseSetJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade, Hash destHash) {
        super(ctx);
        this._log = ctx.logManager().getLog(RepublishLeaseSetJob.class);
        this._facade = facade;
        this._dest = destHash;
    }

    @Override
    public String getName() {
        return "Republish Local LeaseSet";
    }

    @Override
    public void runJob() {
        if (!this.getContext().clientManager().shouldPublishLeaseSet(this._dest)) {
            return;
        }
        try {
            if (this.getContext().clientManager().isLocal(this._dest)) {
                LeaseSet ls = this._facade.lookupLeaseSetLocally(this._dest);
                if (ls != null) {
                    if (!ls.isCurrent(120000L)) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Not publishing expired LOCAL LeaseSet [" + this._dest.toBase32().substring(0, 6) + "]", new Exception("Publish expired LOCAL lease?"));
                        }
                    } else {
                        if (this._log.shouldInfo()) {
                            this._log.info("[Job " + this.getJobId() + "] Publishing LeaseSet for " + this._dest.toBase32());
                        }
                        this.getContext().statManager().addRateData("netDb.republishLeaseSetCount", 1L);
                        this._facade.sendStore(this._dest, ls, null, new OnRepublishFailure(ls), 120000L, null);
                        this._lastPublished = this.getContext().clock().now();
                    }
                } else if (this._log.shouldWarn()) {
                    this._log.warn("Client [" + this._dest.toBase32().substring(0, 6) + "] is local, but no valid LeaseSet found; being rebuilt?");
                }
                return;
            }
            if (this._log.shouldInfo()) {
                this._log.info("Client [" + this._dest.toBase32().substring(0, 6) + "] is no longer local; not republishing LeaseSet");
            }
            this._facade.stopPublishing(this._dest);
        }
        catch (RuntimeException re) {
            if (this._log.shouldError()) {
                this._log.error("Uncaught error republishing the LeaseSet", re);
            }
            this._facade.stopPublishing(this._dest);
            throw re;
        }
    }

    void requeueRepublish() {
        if (this._log.shouldWarn()) {
            this._log.warn("Failed to publish LeaseSet for [" + this._dest.toBase32().substring(0, 6) + "]");
        }
        this.getContext().jobQueue().removeJob(this);
        this.requeue((15000 + this.getContext().random().nextInt(15000)) / 5 * 7);
    }

    public long lastPublished() {
        return this._lastPublished;
    }

    private class OnRepublishFailure
    extends JobImpl {
        private final LeaseSet _ls;

        public OnRepublishFailure(LeaseSet ls) {
            super(RepublishLeaseSetJob.this.getContext());
            this._ls = ls;
        }

        @Override
        public String getName() {
            return "Timeout LeaseSet Publication";
        }

        @Override
        public void runJob() {
            LeaseSet ls = RepublishLeaseSetJob.this._facade.lookupLeaseSetLocally(this._ls.getHash());
            if (ls != null && ls.getEarliestLeaseDate() == this._ls.getEarliestLeaseDate()) {
                RepublishLeaseSetJob.this.requeueRepublish();
            } else if (RepublishLeaseSetJob.this._log.shouldWarn()) {
                RepublishLeaseSetJob.this._log.warn("Not requeueing failed publication of LeaseSet [" + this._ls.getDestination().toBase32().substring(0, 6) + "] -> Newer LeaseSet exists");
            }
        }
    }
}

