/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.ExploreJob;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;
import net.i2p.util.SystemVersion;

class StartExplorersJob
extends JobImpl {
    private final Log _log;
    private final KademliaNetworkDatabaseFacade _facade;
    private static final int MAX_PER_RUN = 2;
    private static final int MIN_RERUN_DELAY_MS = 180000;
    private static final int MAX_RERUN_DELAY_MS = 1200000;
    private static final int STARTUP_TIME = 0x6DDD00;
    private static final int MIN_ROUTERS = 1000;
    private static final int LOW_ROUTERS = 2000;
    private static final int MAX_ROUTERS = 4000;
    private static final int MIN_FFS = 200;
    static final int LOW_FFS = 400;
    private static final long MAX_LAG = 150L;
    private static final long MAX_MSG_DELAY = 650L;
    private final long _msgIDBloomXor = RandomSource.getInstance().nextLong(0xFFFFFFFFL);
    static final String PROP_EXPLORE_DELAY = "router.explorePeersDelay";
    static final String PROP_EXPLORE_BUCKETS = "router.exploreBuckets";
    static final String PROP_FORCE_EXPLORE = "router.exploreWhenFloodfill";

    public StartExplorersJob(RouterContext context, KademliaNetworkDatabaseFacade facade) {
        super(context);
        this._log = context.logManager().getLog(StartExplorersJob.class);
        this._facade = facade;
    }

    @Override
    public String getName() {
        return "Start NetDb Explorers";
    }

    @Override
    public void runJob() {
        boolean isCpuHighLoad;
        int count = this._facade.getDataStore().size();
        boolean forceExplore = this.getContext().getBooleanProperty(PROP_FORCE_EXPLORE);
        boolean isFF = this._facade.floodfillEnabled();
        boolean bl = isCpuHighLoad = SystemVersion.getCPULoad() > 90 && SystemVersion.getCPULoadAvg() > 90;
        if (!isFF || forceExplore) {
            if (this.getContext().jobQueue().getMaxLag() <= 150L && this.getContext().throttle().getMessageDelay() <= 650L && this.getContext().commSystem().getStatus() != CommSystemFacade.Status.DISCONNECTED) {
                int num = 2;
                String exploreBuckets = this.getContext().getProperty(PROP_EXPLORE_BUCKETS);
                if (exploreBuckets == null) {
                    if (count < 1000) {
                        num *= 8;
                    } else if (count < 2000) {
                        num *= 5;
                    }
                    if (this.getContext().router().getUptime() < 0x6DDD00L && count < 4000) {
                        num *= 2;
                    }
                    if (count < 4000) {
                        ++num;
                    }
                    if (this.getContext().router().isHidden() && count < 1000) {
                        num += 2;
                    }
                    if (this.getContext().jobQueue().getMaxLag() > 250L || this.getContext().throttle().getMessageDelay() > 500L) {
                        num = 2;
                    }
                    if (this.getContext().jobQueue().getMaxLag() > 500L || this.getContext().throttle().getMessageDelay() > 1000L || isCpuHighLoad) {
                        num = 1;
                    }
                } else {
                    num = Integer.valueOf(exploreBuckets);
                }
                Set<Hash> toExplore = this.selectKeysToExplore(num);
                if (this._log.shouldInfo()) {
                    this._log.info("Exploring " + num + " buckets during this run");
                }
                this._facade.removeFromExploreKeys(toExplore);
                long delay = 0L;
                int ffs = this.getContext().peerManager().countPeersByCapability('f');
                boolean needffs = ffs < 200;
                boolean lowffs = ffs < 400;
                for (Hash key : toExplore) {
                    boolean realexpl = !(needffs && this.getContext().random().nextInt(2) == 0 || lowffs && this.getContext().random().nextInt(3) == 0);
                    ExploreJob j = new ExploreJob(this.getContext(), this._facade, key, realexpl, this._msgIDBloomXor);
                    RandomSource random = this.getContext().random();
                    if ((delay += (long)(500 + ((Random)random).nextInt(250))) > 0L) {
                        j.getTiming().setStartAfter(this.getContext().clock().now() + delay);
                        this.getContext().jobQueue().addJob(j);
                    }
                    if (this._log.shouldInfo() && realexpl) {
                        this._log.info("Exploring for new peers in " + delay + "ms");
                        continue;
                    }
                    this._log.info("Exploring for new floodfills in " + delay + "ms");
                }
            }
            String exploreDelay = this.getContext().getProperty(PROP_EXPLORE_DELAY);
            long delay = this.getNextRunDelay();
            long laggedDelay = 180000L;
            if (exploreDelay != null && !isCpuHighLoad) {
                if (this._log.shouldInfo()) {
                    this._log.info("Next Peer Exploration run in " + Integer.valueOf(exploreDelay) + "s");
                }
                this.requeue(Integer.valueOf(exploreDelay) * 1000);
            } else if (this.getContext().jobQueue().getMaxLag() > 500L || this.getContext().throttle().getMessageDelay() > 750L || isCpuHighLoad) {
                if (this._log.shouldInfo()) {
                    this._log.info("Next Peer Exploration run in " + laggedDelay / 1000L + "s (router is under load)");
                }
                this.requeue(laggedDelay);
            } else {
                if (this._log.shouldInfo()) {
                    this._log.info("Next Peer Exploration run in " + delay / 1000L + "s");
                }
                this.requeue(delay);
            }
        } else if (this._log.shouldInfo()) {
            this._log.info("Not initiating Peer Exploration -> We are a floodfill (router.exploreWhenFloodfill=true to override)");
        }
    }

    public void updateExploreSchedule() {
    }

    private long getNextRunDelay() {
        String exploreDelay = this.getContext().getProperty(PROP_EXPLORE_DELAY);
        String exploreWhenFloodfill = this.getContext().getProperty(PROP_FORCE_EXPLORE);
        Boolean isFloodfill = this._facade.floodfillEnabled();
        Boolean isHidden = this.getContext().router().isHidden();
        RouterInfo ri = this.getContext().router().getRouterInfo();
        Boolean isK = ri != null && ri.getCapabilities().contains("K");
        int netDbSize = this.getContext().netDb().getKnownRouters();
        long uptime = this.getContext().router().getUptime();
        long delay = this.getContext().clock().now() - this._facade.getLastExploreNewDate();
        if (exploreDelay == null) {
            if (delay > 1200000L && !isFloodfill.booleanValue()) {
                return 1200000L;
            }
            if (isFloodfill.booleanValue() && (exploreWhenFloodfill == null || exploreWhenFloodfill == "false") && uptime > 0x6DDD00L || netDbSize > 4000) {
                return 2400000L;
            }
            if (uptime < 0x6DDD00L && netDbSize < 1000 || isHidden.booleanValue() || isK.booleanValue()) {
                return 180000L;
            }
            if (netDbSize > 4000) {
                return 4800000L;
            }
            return delay;
        }
        return Integer.valueOf(exploreDelay) * 1000;
    }

    private Set<Hash> selectKeysToExplore(int num) {
        Set<Hash> queued = this._facade.getExploreKeys();
        HashSet<Hash> rv = new HashSet<Hash>(num);
        for (Hash key : queued) {
            rv.add(key);
            if (rv.size() < num) continue;
            break;
        }
        for (int i = rv.size(); i < num; ++i) {
            byte[] hash = new byte[32];
            this.getContext().random().nextBytes(hash);
            Hash key = new Hash(hash);
            rv.add(key);
        }
        if (this._log.shouldInfo()) {
            this._log.info("Keys waiting for exploration: " + queued.size());
        }
        return rv;
    }
}

