/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.ProfilePersistenceHelper;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class TunnelHistory {
    private final RouterContext _context;
    private final Log _log;
    private final AtomicLong _lifetimeAgreedTo = new AtomicLong();
    private final AtomicLong _lifetimeRejected = new AtomicLong();
    private volatile long _lastAgreedTo;
    private volatile long _lastRejectedCritical;
    private volatile long _lastRejectedBandwidth;
    private volatile long _lastRejectedTransient;
    private volatile long _lastRejectedProbabalistic;
    private final AtomicLong _lifetimeFailed = new AtomicLong();
    private volatile long _lastFailed;
    private final RateStat _rejectRate;
    private final RateStat _failRate;
    private final String _statGroup;
    static final long[] RATES = new long[]{600000L, 3600000L, 86400000L};
    public static final int TUNNEL_REJECT_PROBABALISTIC_REJECT = 10;
    public static final int TUNNEL_REJECT_TRANSIENT_OVERLOAD = 20;
    public static final int TUNNEL_REJECT_BANDWIDTH = 30;
    public static final int TUNNEL_REJECT_CRIT = 50;
    private static final String NL = System.getProperty("line.separator");
    private static final String HR = "# ----------------------------------------------------------------------------------------";

    public TunnelHistory(RouterContext context, String statGroup) {
        this._context = context;
        this._log = context.logManager().getLog(TunnelHistory.class);
        this._statGroup = statGroup;
        this._rejectRate = new RateStat("tunnelHistory.rejectRate", "How often does this peer reject a tunnel request?", statGroup, RATES);
        this._failRate = new RateStat("tunnelHistory.failRate", "How often do tunnels this peer accepts fail?", statGroup, RATES);
    }

    public long getLifetimeAgreedTo() {
        return this._lifetimeAgreedTo.get();
    }

    public long getLifetimeRejected() {
        return this._lifetimeRejected.get();
    }

    public long getLifetimeFailed() {
        return this._lifetimeFailed.get();
    }

    public long getLastAgreedTo() {
        return this._lastAgreedTo;
    }

    public long getLastRejectedCritical() {
        return this._lastRejectedCritical;
    }

    public long getLastRejectedBandwidth() {
        return this._lastRejectedBandwidth;
    }

    public long getLastRejectedTransient() {
        return this._lastRejectedTransient;
    }

    public long getLastRejectedProbabalistic() {
        return this._lastRejectedProbabalistic;
    }

    public long getLastFailed() {
        return this._lastFailed;
    }

    public void incrementProcessed(int processedSuccessfully, int failedProcessing) {
    }

    public void incrementAgreedTo() {
        this._lifetimeAgreedTo.incrementAndGet();
        this._lastAgreedTo = this._context.clock().now();
    }

    public void incrementRejected(int severity) {
        this._lifetimeRejected.incrementAndGet();
        long now = this._context.clock().now();
        if (severity >= 50) {
            this._lastRejectedCritical = now;
        } else if (severity >= 30) {
            this._lastRejectedBandwidth = now;
        } else if (severity >= 20) {
            this._lastRejectedTransient = now;
        } else if (severity >= 10) {
            this._lastRejectedProbabalistic = now;
        }
        this._rejectRate.addData(1L);
    }

    public void incrementFailed(int pct) {
        this._lifetimeFailed.incrementAndGet();
        this._failRate.addData(pct);
        this._lastFailed = this._context.clock().now();
    }

    public RateStat getRejectionRate() {
        return this._rejectRate;
    }

    public RateStat getFailedRate() {
        return this._failRate;
    }

    public void coalesceStats() {
        if (this._log.shouldDebug()) {
            this._log.debug("Coalescing Profile Manager stats");
        }
        this._rejectRate.coalesceStats();
        this._failRate.coalesceStats();
    }

    public void store(OutputStream out) throws IOException {
        this.store(out, true);
    }

    public void store(OutputStream out, boolean addComments) throws IOException {
        StringBuilder buf = new StringBuilder(512);
        if (addComments) {
            buf.append(HR).append(NL);
            buf.append("# Tunnel History").append(NL);
            buf.append(HR).append(NL).append(NL);
        }
        if (this._lastAgreedTo != 0L) {
            TunnelHistory.addDate(buf, addComments, "lastAgreedTo", this._lastAgreedTo, "Last time peer agreed to participate in a tunnel:");
        }
        if (this._lastFailed != 0L) {
            TunnelHistory.addDate(buf, addComments, "lastFailed", this._lastFailed, "Last time of participating tunnel failure for peer:");
        }
        if (this._lastRejectedCritical != 0L) {
            TunnelHistory.addDate(buf, addComments, "lastRejectedCritical", this._lastRejectedCritical, "Last time peer refused tunnel participation (Critical):");
        }
        if (this._lastRejectedBandwidth != 0L) {
            TunnelHistory.addDate(buf, addComments, "lastRejectedBandwidth", this._lastRejectedBandwidth, "Last time peer refused tunnel participation (Bandwidth):");
        }
        if (this._lastRejectedTransient != 0L) {
            TunnelHistory.addDate(buf, addComments, "lastRejectedTransient", this._lastRejectedTransient, "Last time peer refused tunnel participation (Transient):");
        }
        if (this._lastRejectedProbabalistic != 0L) {
            TunnelHistory.addDate(buf, addComments, "lastRejectedProbabalistic", this._lastRejectedProbabalistic, "Last time peer refused tunnel participation (Probabalistic):");
        }
        TunnelHistory.add(buf, addComments, "lifetimeAgreedTo", this._lifetimeAgreedTo.get(), "Total tunnels peer agreed to participate in: " + this._lifetimeAgreedTo.get());
        TunnelHistory.add(buf, addComments, "lifetimeFailed", this._lifetimeFailed.get(), "Total failed tunnels peer agreed to participate in: " + this._lifetimeFailed.get());
        TunnelHistory.add(buf, addComments, "lifetimeRejected", this._lifetimeRejected.get(), "Total tunnels peer refused to participate in: " + this._lifetimeRejected.get());
        out.write(buf.toString().getBytes("UTF-8"));
        this._rejectRate.store(out, "tunnelHistory.rejectRate", addComments);
        this._failRate.store(out, "tunnelHistory.failRate", addComments);
    }

    private static void addDate(StringBuilder buf, boolean addComments, String name, long val, String description) {
        if (addComments) {
            String when = val > 0L ? new Date(val).toString() : "Never";
            TunnelHistory.add(buf, true, name, val, description + ' ' + when);
        } else {
            TunnelHistory.add(buf, false, name, val, description);
        }
    }

    private static void add(StringBuilder buf, boolean addComments, String name, long val, String description) {
        if (addComments) {
            buf.append("# ").append(description).append(NL);
        } else {
            buf.append("tunnels.").append(name).append('=').append(val).append(NL);
        }
    }

    public void load(Properties props) {
        this._lastAgreedTo = TunnelHistory.getLong(props, "tunnels.lastAgreedTo");
        this._lastFailed = TunnelHistory.getLong(props, "tunnels.lastFailed");
        this._lastRejectedCritical = TunnelHistory.getLong(props, "tunnels.lastRejectedCritical");
        this._lastRejectedBandwidth = TunnelHistory.getLong(props, "tunnels.lastRejectedBandwidth");
        this._lastRejectedTransient = TunnelHistory.getLong(props, "tunnels.lastRejectedTransient");
        this._lastRejectedProbabalistic = TunnelHistory.getLong(props, "tunnels.lastRejectedProbabalistic");
        this._lifetimeAgreedTo.set(TunnelHistory.getLong(props, "tunnels.lifetimeAgreedTo"));
        this._lifetimeFailed.set(TunnelHistory.getLong(props, "tunnels.lifetimeFailed"));
        this._lifetimeRejected.set(TunnelHistory.getLong(props, "tunnels.lifetimeRejected"));
        try {
            this._rejectRate.load(props, "tunnelHistory.rejectRate", true);
            this._failRate.load(props, "tunnelHistory.failRate", true);
        }
        catch (IllegalArgumentException iae) {
            this._log.warn("TunnelHistory rates are corrupt, resetting...", iae);
        }
    }

    private static final long getLong(Properties props, String key) {
        return ProfilePersistenceHelper.getLong(props, key);
    }
}

