/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.io.File;
import java.io.IOException;
import net.i2p.data.DataFormatException;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;

public class PersistRouterInfoJob
extends JobImpl {
    public PersistRouterInfoJob(RouterContext ctx) {
        super(ctx);
    }

    @Override
    public String getName() {
        return "Store Updated Router Information";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runJob() {
        Log _log = this.getContext().logManager().getLog(PersistRouterInfoJob.class);
        if (_log.shouldDebug()) {
            _log.debug("Saving our updated RouterInfo file to disk");
        }
        File infoFile = new File(this.getContext().getRouterDir(), "router.info");
        RouterInfo info = this.getContext().router().getRouterInfo();
        SecureFileOutputStream fos = null;
        Object object = this.getContext().router().routerInfoFileLock;
        synchronized (object) {
            try {
                fos = new SecureFileOutputStream(infoFile);
                info.writeBytes(fos);
            }
            catch (DataFormatException dfe) {
                _log.error("Error rebuilding our RouterInfo", dfe);
            }
            catch (IOException ioe) {
                _log.error("Error saving our updated RouterInfo file", ioe);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException dfe) {}
                }
            }
        }
    }
}

