/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import com.southernstorm.noise.protocol.ChaChaPolyCipherState;
import com.southernstorm.noise.protocol.HandshakeState;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.i2p.crypto.HKDF;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.InboundEstablishState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.PeerStateDestroyed;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Payload;
import net.i2p.router.transport.udp.SSU2Util;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.HexDump;
import net.i2p.util.SimpleTimer;
import net.i2p.util.VersionComparator;

class InboundEstablishState2
extends InboundEstablishState
implements SSU2Payload.PayloadCallback {
    private final UDPTransport _transport;
    private final InetSocketAddress _aliceSocketAddress;
    private final long _rcvConnID;
    private final long _sendConnID;
    private final long _token;
    private final HandshakeState _handshakeState;
    private byte[] _sendHeaderEncryptKey1;
    private byte[] _sendHeaderEncryptKey2;
    private byte[] _rcvHeaderEncryptKey2;
    private byte[] _sessCrForReTX;
    private byte[][] _sessConfFragments;
    private long _timeReceived;
    private long _skew;
    private int _mtu;
    private PeerState2 _pstate;
    private List<UDPPacket> _queuedDataPackets;
    private static final boolean ENFORCE_TOKEN = true;
    private static final long MAX_SKEW = 120000L;
    private static final String MIN_RELAY_VERSION = "0.9.57";

    public InboundEstablishState2(RouterContext ctx, UDPTransport transport, UDPPacket packet) throws GeneralSecurityException {
        super(ctx, (InetSocketAddress)packet.getPacket().getSocketAddress());
        this._transport = transport;
        DatagramPacket pkt = packet.getPacket();
        this._aliceSocketAddress = (InetSocketAddress)pkt.getSocketAddress();
        this._handshakeState = new HandshakeState("XK-SSU2", 2, transport.getXDHFactory());
        this._handshakeState.getLocalKeyPair().setKeys(transport.getSSU2StaticPrivKey(), 0, transport.getSSU2StaticPubKey(), 0);
        byte[] introKey = transport.getSSU2StaticIntroKey();
        this._sendHeaderEncryptKey1 = introKey;
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] data = pkt.getData();
        this._rcvConnID = DataHelper.fromLong8(data, off);
        this._sendConnID = DataHelper.fromLong8(data, off + 16);
        if (this._rcvConnID == this._sendConnID) {
            throw new GeneralSecurityException("Identical Connection IDs");
        }
        int type = data[off + 12] & 0xFF;
        long token = DataHelper.fromLong8(data, off + 24);
        if (type == 10) {
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] Received TokenRequest from: " + this._aliceSocketAddress);
            }
            this._currentState = InboundEstablishState.InboundState.IB_STATE_TOKEN_REQUEST_RECEIVED;
            ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
            chacha.initializeKey(introKey, 0);
            long n = DataHelper.fromLong(data, off + 8, 4);
            chacha.setNonce(n);
            chacha.decryptWithAd(data, off, 32, data, off + 32, data, off + 32, len - 32);
            chacha.destroy();
            this.processPayload(data, off + 32, len - 48, true);
            this._sendHeaderEncryptKey2 = introKey;
            while ((token = ctx.random().nextLong()) == 0L) {
            }
            this._token = token;
        } else if (!(type != 0 || token != 0L && this._transport.getEstablisher().isInboundTokenValid(this._remoteHostId, token))) {
            if (this._log.shouldInfo()) {
                this._log.info("[SSU2] Invalid token [" + token + "] in SessionRequest from: " + this._aliceSocketAddress);
            }
            if (token == 0L) {
                throw new GeneralSecurityException("Zero token in SessionRequest from: " + this._aliceSocketAddress);
            }
            this._currentState = InboundEstablishState.InboundState.IB_STATE_REQUEST_BAD_TOKEN_RECEIVED;
            this._sendHeaderEncryptKey2 = introKey;
            while ((token = ctx.random().nextLong()) == 0L) {
            }
            this._token = token;
            this._timeReceived = this._establishBegin;
        } else {
            if ((data[off + 32 + SSU2Util.KEY_LEN - 1] & 0x80) != 0) {
                throw new GeneralSecurityException("BAD PK message 1");
            }
            this._token = token;
            this._handshakeState.start();
            this._handshakeState.mixHash(data, off, 32);
            try {
                this._handshakeState.readMessage(data, off + 32, len - 32, data, off + 32);
            }
            catch (GeneralSecurityException gse) {
                if (this._log.shouldDebug()) {
                    this._log.debug("[SSU2] Session request error -> State at failure: " + this._handshakeState + '\n' + HexDump.dump(data, off, len), gse);
                }
                throw gse;
            }
            this.processPayload(data, off + 32, len - (32 + SSU2Util.KEY_LEN + 16), true);
            this._sendHeaderEncryptKey2 = SSU2Util.hkdf(this._context, this._handshakeState.getChainingKey(), "SessCreateHeader");
            this._currentState = InboundEstablishState.InboundState.IB_STATE_REQUEST_RECEIVED;
        }
        if (this._currentState == InboundEstablishState.InboundState.IB_STATE_FAILED) {
            throw new GeneralSecurityException("Termination block in Session/Token Request");
        }
        if (this._timeReceived == 0L) {
            this._currentState = InboundEstablishState.InboundState.IB_STATE_FAILED;
            throw new GeneralSecurityException("No DateTime block in Session/Token Request");
        }
        this._skew = this._establishBegin - this._timeReceived;
        if (this._skew > 120000L || this._skew < -120000L) {
            this._currentState = InboundEstablishState.InboundState.IB_STATE_FAILED;
            UDPPacket retry = this._transport.getBuilder2().buildRetryPacket(this, 7);
            this._transport.send(retry);
            throw new GeneralSecurityException("Max skew of 2m exceeded (" + this._skew + "ms) in Session/Token Request (Retry sent)");
        }
        this.packetReceived();
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] New request type " + type + " len " + len + " on " + this);
        }
    }

    @Override
    public int getVersion() {
        return 2;
    }

    private void processPayload(byte[] payload, int offset, int length, boolean isHandshake) throws GeneralSecurityException {
        try {
            int blocks = SSU2Payload.processPayload(this._context, this, payload, offset, length, isHandshake, null);
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] Processed " + blocks + " blocks on " + this);
            }
        }
        catch (RIException rie) {
            if (this._log.shouldInfo()) {
                this._log.info("[SSU2] RouterInfo error: " + rie.getMessage());
            }
            int reason = rie.getReason();
            PeerStateDestroyed psd = this.createPeerStateDestroyed(reason);
            this._transport.addRecentlyClosed(psd);
            try {
                UDPPacket pkt = this._transport.getBuilder2().buildSessionDestroyPacket(reason, psd);
                this._transport.send(pkt);
                if (this._log.shouldInfo()) {
                    this._log.info("[SSU2] Sending TERMINATION reason " + reason + " to " + psd);
                    this._log.info("[SSU2] InboundEstablishState Payload Error", rie);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new GeneralSecurityException("IES2 Payload Error: " + this, rie);
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldInfo()) {
                this._log.info("[SSU2] InboundEstablishState Payload Error", dfe);
            }
            throw new GeneralSecurityException("IES2 Payload Error: " + this, dfe);
        }
        catch (Exception e) {
            if (!e.toString().contains("RouterInfo store fail") && this._log.shouldInfo()) {
                this._log.info("[SSU2] InboundEstablishState Payload Error\n" + HexDump.dump(payload, 0, length), e);
            }
            throw new GeneralSecurityException("IES2 Payload Error", e);
        }
    }

    @Override
    public void gotDateTime(long time) {
        this._timeReceived = time;
    }

    @Override
    public void gotOptions(byte[] options, boolean isHandshake) {
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Received OPTIONS block");
        }
    }

    @Override
    public void gotRI(RouterInfo ri, boolean isHandshake, boolean flood) throws DataFormatException {
        boolean isOld;
        if (isHandshake) {
            throw new DataFormatException("RouterInfo in SessionRequest");
        }
        if (this._receivedUnconfirmedIdentity != null) {
            throw new DataFormatException("Duplicate RouterInfo in SessionConfirmed");
        }
        this._receivedUnconfirmedIdentity = ri.getIdentity();
        boolean isIPv6 = this._aliceIP.length == 16;
        List<RouterAddress> addrs = this._transport.getTargetAddresses(ri);
        RouterAddress ra = null;
        String mismatchMessage = null;
        for (RouterAddress addr : addrs) {
            String caps;
            if (addrs.size() > 1 && addr.getTransportStyle().equals("SSU") && addr.getOption("s") == null) continue;
            String host = addr.getHost();
            if (host == null) {
                host = "";
            }
            if ((caps = addr.getOption("caps")) == null) {
                caps = "";
            }
            if (!isIPv6 ? !host.contains(".") && !caps.contains("4") : !host.contains(":") && !caps.contains("6")) continue;
            ra = addr;
            byte[] infoIP = ra.getIP();
            if (infoIP == null || infoIP.length != this._aliceIP.length) break;
            if (isIPv6 ? (infoIP[0] & 0xFE) == 2 || DataHelper.eq(this._aliceIP, 0, infoIP, 0, 8) : DataHelper.eq(this._aliceIP, infoIP)) continue;
            mismatchMessage = "IP mismatch actual IP " + Addresses.toString(this._aliceIP) + " in RI: ";
            break;
        }
        if (ra == null) {
            throw new DataFormatException("No SSU2 address, IPv6? " + isIPv6 + ": " + ri);
        }
        String siv = ra.getOption("i");
        if (siv == null) {
            throw new DataFormatException("No SSU2 IKey");
        }
        byte[] ik = Base64.decode(siv);
        if (ik == null) {
            throw new DataFormatException("BAD SSU2 IKey");
        }
        if (ik.length != 32) {
            throw new DataFormatException("BAD SSU2 IKey length");
        }
        String ss = ra.getOption("s");
        if (ss == null) {
            throw new DataFormatException("No SSU2 S");
        }
        byte[] s = Base64.decode(ss);
        if (s == null) {
            throw new DataFormatException("BAD SSU2 S");
        }
        if (s.length != 32) {
            throw new DataFormatException("BAD SSU2 S length");
        }
        byte[] nb = new byte[32];
        this._handshakeState.getRemotePublicKey().getPublicKey(nb, 0);
        if (!DataHelper.eqCT(s, 0, nb, 0, SSU2Util.KEY_LEN)) {
            throw new DataFormatException("S mismatch in RouterInfo: " + ri);
        }
        this._sendHeaderEncryptKey1 = ik;
        Hash h = this._receivedUnconfirmedIdentity.calculateHash();
        boolean isBanned = this._context.banlist().isBanlisted(h);
        if (isBanned) {
            if (ri.verifySignature()) {
                this._context.blocklist().add(this._aliceIP);
            }
            throw new RIException("Router is banned: " + h.toBase64(), 17);
        }
        if (ri.getNetworkId() != this._context.router().getNetworkID()) {
            if (ri.verifySignature()) {
                this._context.blocklist().add(this._aliceIP);
            }
            throw new RIException("SSU2 network ID mismatch", 21);
        }
        if (mismatchMessage != null) {
            this._context.banlist().banlistRouter(h, " <b>\u279c</b> Invalid SSU address", null, null, this._context.clock().now() + 14400000L);
            this._context.commSystem().forceDisconnect(h);
            if (this._log.shouldWarn() && !isBanned) {
                this._log.warn("Banning for 4h and immediately disconnecting from Router [" + h.toBase64().substring(0, 6) + "] -> Invalid SSU address");
            }
            if (ri.verifySignature()) {
                this._context.blocklist().add(this._aliceIP);
            }
            throw new RIException(mismatchMessage + ri, 17);
        }
        if (!"2".equals(ra.getOption("v"))) {
            throw new RIException("BAD SSU2 v", 20);
        }
        String cap = ri.getCapabilities();
        String bw = ri.getBandwidthTier();
        boolean reachable = cap != null && cap.indexOf(82) >= 0;
        boolean isSlow = cap != null && !cap.equals("") && bw.equals("K") || bw.equals("L") || bw.equals("M") || bw.equals("N");
        String version = ri.getVersion();
        boolean bl = isOld = VersionComparator.comp(version, "0.9.61") < 0;
        if (!reachable && isSlow && isOld) {
            this._context.banlist().banlistRouter(h, " <b>\u279c</b> Old and slow (" + version + " / " + bw + "U)", null, null, this._context.clock().now() + 14400000L);
            if (ri.verifySignature()) {
                this._context.blocklist().add(this._aliceIP);
            }
            if (this._log.shouldWarn() && !isBanned) {
                this._log.warn("Banning for 4h and immediately disconnecting from Router [" + h.toBase64().substring(0, 6) + "] -> " + version + " / " + bw + (!reachable ? "U" : ""));
            }
            this._context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
            throw new RIException("Old and slow: " + h, 17);
        }
        String smtu = ra.getOption("mtu");
        int mtu = 0;
        try {
            mtu = Integer.parseInt(smtu);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (mtu == 0) {
            mtu = ra.getTransportStyle().equals("SSU2") ? 1500 : (isIPv6 ? 1280 : 1484);
        } else if (mtu == 1276 && ra.getTransportStyle().equals("SSU")) {
            mtu = 1280;
        } else {
            if (mtu < 1280) {
                throw new RIException("MTU too small " + mtu, 5);
            }
            mtu = ra.getTransportStyle().equals("SSU2") ? Math.min(Math.max(mtu, 1280), 1500) : (isIPv6 ? Math.min(Math.max(mtu, 1280), 1488) : Math.min(Math.max(mtu, 1292), 1484));
        }
        this._mtu = mtu;
        try {
            RouterInfo old = this._context.netDb().store(h, ri);
            if (flood && !ri.equals(old)) {
                FloodfillNetworkDatabaseFacade fndf = (FloodfillNetworkDatabaseFacade)this._context.netDb();
                if (fndf.floodConditional(ri)) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("[SSU2] Flooded the RouterInfo: " + h);
                    }
                } else if (this._log.shouldInfo()) {
                    this._log.info("[SSU2] Flood request but we didn't: " + h);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            long now = this._context.clock().now();
            long published = ri.getPublished();
            int reason = published > now + 120000L || published < now - 3600000L ? 7 : 13;
            throw new RIException("RouterInfo store fail: " + ri, reason, iae);
        }
        this._receivedConfirmedIdentity = this._receivedUnconfirmedIdentity;
        if (this._introductionRequested) {
            String caps;
            if (this.getSentPort() < 1024 || !this._transport.canIntroduce(isIPv6)) {
                this._introductionRequested = false;
            } else if (VersionComparator.comp(ri.getVersion(), MIN_RELAY_VERSION) < 0) {
                this._introductionRequested = false;
                caps = ri.getCapabilities();
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] Not offering to relay to Router version " + ri.getVersion() + " caps " + caps + ": " + this);
                }
            } else {
                caps = ri.getCapabilities();
                if (caps.indexOf(82) >= 0 && this._context.random().nextInt(4) != 0) {
                    this._introductionRequested = false;
                    if (this._log.shouldWarn()) {
                        this._log.warn("[SSU2] Not offering to relay to Router version " + ri.getVersion() + " caps " + caps + ": " + this);
                    }
                }
            }
        }
        this.createPeerState();
    }

    @Override
    public void gotRIFragment(byte[] data, boolean isHandshake, boolean flood, boolean isGzipped, int frag, int totalFrags) {
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Received RouterInfo fragment [" + frag + " / " + totalFrags + "]");
        }
        throw new IllegalStateException("fragmented RouterInfo");
    }

    @Override
    public void gotAddress(byte[] ip, int port) {
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Received IP address: " + Addresses.toString(ip, port));
        }
        this._bobIP = ip;
    }

    @Override
    public void gotRelayTagRequest() {
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Received RelayTagRequest on " + this);
        }
        this._introductionRequested = true;
    }

    @Override
    public void gotRelayTag(long tag) {
    }

    @Override
    public void gotRelayRequest(byte[] data) {
        if (this._receivedConfirmedIdentity == null) {
            throw new IllegalStateException("RouterInfo must be sent first");
        }
    }

    @Override
    public void gotRelayResponse(int status, byte[] data) {
        if (this._receivedConfirmedIdentity == null) {
            throw new IllegalStateException("RouterInfo must be sent first");
        }
    }

    @Override
    public void gotRelayIntro(Hash aliceHash, byte[] data) {
        if (this._receivedConfirmedIdentity == null) {
            throw new IllegalStateException("RouterInfo must be sent first");
        }
    }

    @Override
    public void gotPeerTest(int msg, int status, Hash h, byte[] data) {
        if (this._receivedConfirmedIdentity == null) {
            throw new IllegalStateException("RouterInfo must be sent first");
        }
        this._transport.getPeerTestManager().receiveTest(this._remoteHostId, this._pstate, msg, status, h, data);
    }

    @Override
    public void gotToken(long token, long expires) {
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Received Token: " + token + " expires " + DataHelper.formatTime(expires) + " on " + this);
        }
        if (this._receivedConfirmedIdentity == null) {
            throw new IllegalStateException("RouterInfo must be sent first");
        }
        this._transport.getEstablisher().addOutboundToken(this._remoteHostId, token, expires);
    }

    @Override
    public void gotI2NP(I2NPMessage msg) {
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Received I2NP block: " + msg);
        }
        if (this.getState() != InboundEstablishState.InboundState.IB_STATE_CREATED_SENT) {
            throw new IllegalStateException("I2NP in SessionRequest");
        }
        if (this._receivedConfirmedIdentity == null) {
            throw new IllegalStateException("RouterInfo must be sent first");
        }
        this._pstate.gotI2NP(msg);
    }

    @Override
    public void gotFragment(byte[] data, int off, int len, long messageID, int frag, boolean isLast) throws DataFormatException {
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Received FRAGMENT block: " + messageID);
        }
        if (this.getState() != InboundEstablishState.InboundState.IB_STATE_CREATED_SENT) {
            throw new IllegalStateException("I2NP in SessionRequest");
        }
        if (this._receivedConfirmedIdentity == null) {
            throw new IllegalStateException("RouterInfo must be sent first");
        }
        this._pstate.gotFragment(data, off, len, messageID, frag, isLast);
    }

    @Override
    public void gotACK(long ackThru, int acks, byte[] ranges) {
        throw new IllegalStateException("ACK in Handshake");
    }

    @Override
    public void gotTermination(int reason, long count) {
        if (this._log.shouldInfo()) {
            this._log.info("[SSU2] Received TERMINATION block -> Reason: " + reason + "; Count: " + count + "\n* " + this);
        }
        this.fail();
        this._transport.getEstablisher().receiveSessionDestroy(this._remoteHostId);
    }

    @Override
    public void gotPathChallenge(RemoteHostId from, byte[] data) {
        throw new IllegalStateException("BAD block in handshake");
    }

    @Override
    public void gotPathResponse(RemoteHostId from, byte[] data) {
        throw new IllegalStateException("BAD block in handshake");
    }

    @Override
    public synchronized void fail() {
        this._handshakeState.destroy();
        super.fail();
    }

    @Override
    public void generateSessionKey() {
        throw new UnsupportedOperationException();
    }

    public long getSendConnID() {
        return this._sendConnID;
    }

    public long getRcvConnID() {
        return this._rcvConnID;
    }

    public long getToken() {
        return this._token;
    }

    public EstablishmentManager.Token getNextToken() {
        if (this._aliceIP.length == 4 && this._transport.isSymNatted()) {
            return null;
        }
        return this._transport.getEstablisher().getInboundToken(this._remoteHostId);
    }

    public HandshakeState getHandshakeState() {
        return this._handshakeState;
    }

    public byte[] getSendHeaderEncryptKey1() {
        return this._sendHeaderEncryptKey1;
    }

    public byte[] getRcvHeaderEncryptKey1() {
        return this._transport.getSSU2StaticIntroKey();
    }

    public byte[] getSendHeaderEncryptKey2() {
        return this._sendHeaderEncryptKey2;
    }

    public synchronized byte[] getRcvHeaderEncryptKey2() {
        return this._rcvHeaderEncryptKey2;
    }

    public InetSocketAddress getSentAddress() {
        return this._aliceSocketAddress;
    }

    @Override
    public synchronized void createdPacketSent() {
        if (this._rcvHeaderEncryptKey2 == null) {
            this._rcvHeaderEncryptKey2 = SSU2Util.hkdf(this._context, this._handshakeState.getChainingKey(), "SessionConfirmed");
        }
        this._lastSend = this._context.clock().now();
        long delay = this._createdSentCount == 0 ? RETRANSMIT_DELAY : Math.min(RETRANSMIT_DELAY << this._createdSentCount, MAX_DELAY);
        ++this._createdSentCount;
        this._nextSend = this._lastSend + delay;
        this._currentState = InboundEstablishState.InboundState.IB_STATE_CREATED_SENT;
    }

    public synchronized void retryPacketSent() {
        if (this._currentState == InboundEstablishState.InboundState.IB_STATE_FAILED) {
            return;
        }
        if (this._currentState != InboundEstablishState.InboundState.IB_STATE_RETRY_SENT && this._currentState != InboundEstablishState.InboundState.IB_STATE_REQUEST_BAD_TOKEN_RECEIVED && this._currentState != InboundEstablishState.InboundState.IB_STATE_TOKEN_REQUEST_RECEIVED) {
            throw new IllegalStateException("BAD state for Retry Sent: " + (Object)((Object)this._currentState));
        }
        this._lastSend = this._context.clock().now();
        if (this._currentState == InboundEstablishState.InboundState.IB_STATE_RETRY_SENT) {
            this._nextSend = this._establishBegin + 5L * RETRANSMIT_DELAY;
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Retransmit RETRY on " + this);
            }
        } else {
            this._currentState = InboundEstablishState.InboundState.IB_STATE_RETRY_SENT;
            this._nextSend = this._lastSend + 5L * RETRANSMIT_DELAY;
        }
    }

    public synchronized void receiveSessionOrTokenRequestAfterRetry(UDPPacket packet) throws GeneralSecurityException {
        try {
            this.locked_receiveSessionOrTokenRequestAfterRetry(packet);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] Session or Token Request error after retry", gse);
            }
            this.fail();
            throw gse;
        }
    }

    private void locked_receiveSessionOrTokenRequestAfterRetry(UDPPacket packet) throws GeneralSecurityException {
        long token;
        DatagramPacket pkt = packet.getPacket();
        SocketAddress from = pkt.getSocketAddress();
        if (!from.equals(this._aliceSocketAddress)) {
            throw new GeneralSecurityException("Address mismatch -> Request: " + this._aliceSocketAddress + " Conf: " + from);
        }
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] data = pkt.getData();
        long rid = DataHelper.fromLong8(data, off);
        if (rid != this._rcvConnID) {
            throw new GeneralSecurityException("Connection ID mismatch -> 1: " + this._rcvConnID + " 2: " + rid);
        }
        long sid = DataHelper.fromLong8(data, off + 16);
        if (sid != this._sendConnID) {
            throw new GeneralSecurityException("Connection ID mismatch -> 1: " + this._sendConnID + " 2: " + sid);
        }
        int type = data[off + 12] & 0xFF;
        if (this._currentState != InboundEstablishState.InboundState.IB_STATE_RETRY_SENT) {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Received out-of-order or RETRANSMIT message " + type + " on: " + this);
            }
            return;
        }
        if (type == 10) {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Received RETRANSMIT TokenRequest on: " + this);
            }
            long now = this._context.clock().now();
            this._nextSend = Math.max(now, this._lastSend + 750L);
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Received SessionRequest after retry on: " + this);
        }
        if ((token = DataHelper.fromLong8(data, off + 24)) != this._token) {
            throw new GeneralSecurityException("Token mismatch -> Expected: " + this._token + " Received: " + token);
        }
        this._handshakeState.start();
        this._handshakeState.mixHash(data, off, 32);
        try {
            this._handshakeState.readMessage(data, off + 32, len - 32, data, off + 32);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] SessionRequest error -> State at failure: " + this._handshakeState + '\n' + HexDump.dump(data, off, len), gse);
            }
            throw gse;
        }
        this._timeReceived = 0L;
        this.processPayload(data, off + 32, len - (32 + SSU2Util.KEY_LEN + 16), true);
        this.packetReceived();
        if (this._currentState == InboundEstablishState.InboundState.IB_STATE_FAILED) {
            throw new GeneralSecurityException("Termination block in SessionRequest");
        }
        if (this._timeReceived == 0L) {
            throw new GeneralSecurityException("No DateTime block in SessionRequest");
        }
        this._rtt = (int)(this._nextSend - this._lastSend);
        this._skew = this._nextSend - this._timeReceived - (long)(this._rtt / 2);
        if (this._skew > 120000L || this._skew < -120000L) {
            UDPPacket retry = this._transport.getBuilder2().buildRetryPacket(this, 7);
            this._transport.send(retry);
            throw new GeneralSecurityException("Max skew of 2m exceeded (" + this._skew + "ms) in SessionRequest");
        }
        this._sendHeaderEncryptKey2 = SSU2Util.hkdf(this._context, this._handshakeState.getChainingKey(), "SessCreateHeader");
        this._currentState = InboundEstablishState.InboundState.IB_STATE_REQUEST_RECEIVED;
    }

    public synchronized PeerState2 receiveSessionConfirmed(UDPPacket packet) throws GeneralSecurityException {
        try {
            return this.locked_receiveSessionConfirmed(packet);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] SessionConfirmed error", gse);
            }
            this.fail();
            throw gse;
        }
    }

    private PeerState2 locked_receiveSessionConfirmed(UDPPacket packet) throws GeneralSecurityException {
        if (this._currentState != InboundEstablishState.InboundState.IB_STATE_CREATED_SENT && this._currentState != InboundEstablishState.InboundState.IB_STATE_CONFIRMED_PARTIALLY) {
            throw new GeneralSecurityException("BAD state for SessionConfirmed: " + (Object)((Object)this._currentState));
        }
        DatagramPacket pkt = packet.getPacket();
        SocketAddress from = pkt.getSocketAddress();
        if (!from.equals(this._aliceSocketAddress)) {
            throw new GeneralSecurityException("Address mismatch -> Request: " + this._aliceSocketAddress + " Conf: " + from);
        }
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] data = pkt.getData();
        long rid = DataHelper.fromLong8(data, off);
        if (rid != this._rcvConnID) {
            throw new GeneralSecurityException("Connection ID mismatch -> Request: " + this._rcvConnID + " Conf: " + rid);
        }
        byte fragbyte = data[off + 13];
        int frag = fragbyte >> 4 & 0xF;
        int totalfrag = fragbyte & 0xF;
        if (totalfrag > 0 && frag > totalfrag - 1) {
            throw new GeneralSecurityException("BAD SessionConfirmed fragment [" + frag + " / " + totalfrag + "]");
        }
        if (totalfrag > 1) {
            byte[] fragdata;
            if (this._sessConfFragments == null) {
                this._sessConfFragments = new byte[totalfrag][];
                this._currentState = InboundEstablishState.InboundState.IB_STATE_CONFIRMED_PARTIALLY;
                this._sessCrForReTX = null;
                this._nextSend = this._lastSend + 60000L;
            } else {
                if (this._sessConfFragments.length != totalfrag) {
                    throw new GeneralSecurityException("BAD SessionConfirmed fragment [" + frag + " / " + totalfrag + "]");
                }
                if (this._sessConfFragments[frag] != null) {
                    if (this._log.shouldInfo()) {
                        this._log.info("[SSU2] Received duplicate SessionConfirmed fragment [" + frag + "] on " + this);
                    }
                    return null;
                }
            }
            if (this._log.shouldInfo()) {
                this._log.info("[SSU2] Received " + len + " bytes SessionConfirmed fragment [" + frag + '/' + totalfrag + "] on " + this);
            }
            if (frag == 0) {
                fragdata = new byte[len];
                System.arraycopy(data, off, fragdata, 0, len);
            } else {
                fragdata = new byte[len -= 16];
                System.arraycopy(data, off + 16, fragdata, 0, len);
            }
            this._sessConfFragments[frag] = fragdata;
            int totalsize = 0;
            for (int i = 0; i < totalfrag; ++i) {
                if (this._sessConfFragments[i] == null) {
                    if (this._log.shouldInfo()) {
                        this._log.info("[SSU2] Still missing at least one SessionConfirmed fragment on " + this);
                    }
                    return null;
                }
                totalsize += this._sessConfFragments[i].length;
            }
            len = totalsize;
            off = 0;
            data = new byte[len];
            int joff = 0;
            for (int i = 0; i < totalfrag; ++i) {
                byte[] f = this._sessConfFragments[i];
                System.arraycopy(f, 0, data, joff, f.length);
                joff += f.length;
            }
            if (this._log.shouldInfo()) {
                this._log.info("[SSU2] Have all " + totalfrag + " SessionConfirmed fragments (total length: " + len + " bytes) on " + this);
            }
        }
        this._handshakeState.mixHash(data, off, 16);
        try {
            this._handshakeState.readMessage(data, off + 16, len - 16, data, off + 16);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] SessionConfirmed error -> State at failure: " + this._handshakeState + '\n' + HexDump.dump(data, off, len), gse);
            }
            throw gse;
        }
        this.processPayload(data, off + 16, len - (16 + SSU2Util.KEY_LEN + 16 + 16), false);
        this.packetReceived();
        if (this._currentState == InboundEstablishState.InboundState.IB_STATE_FAILED) {
            throw new GeneralSecurityException("Termination block in SessionConfirmed");
        }
        this._sessCrForReTX = null;
        if (this._receivedConfirmedIdentity == null) {
            throw new GeneralSecurityException("No RouterInfo in SessionConfirmed");
        }
        this._currentState = InboundEstablishState.InboundState.IB_STATE_CONFIRMED_COMPLETELY;
        return this._pstate;
    }

    private void createPeerState() {
        byte[] ckd = this._handshakeState.getChainingKey();
        byte[] k_ab = new byte[32];
        byte[] k_ba = new byte[32];
        HKDF hkdf = new HKDF(this._context);
        hkdf.calculate(ckd, SSU2Util.ZEROLEN, k_ab, k_ba, 0);
        byte[] d_ab = new byte[32];
        byte[] h_ab = new byte[32];
        byte[] d_ba = new byte[32];
        byte[] h_ba = new byte[32];
        hkdf.calculate(k_ab, SSU2Util.ZEROLEN, "HKDFSSU2DataKeys", d_ab, h_ab, 0);
        hkdf.calculate(k_ba, SSU2Util.ZEROLEN, "HKDFSSU2DataKeys", d_ba, h_ba, 0);
        ChaChaPolyCipherState sender = new ChaChaPolyCipherState();
        sender.initializeKey(d_ba, 0);
        ChaChaPolyCipherState rcvr = new ChaChaPolyCipherState();
        rcvr.initializeKey(d_ab, 0);
        Arrays.fill(ckd, (byte)0);
        Arrays.fill(k_ab, (byte)0);
        Arrays.fill(k_ba, (byte)0);
        Arrays.fill(d_ab, (byte)0);
        Arrays.fill(d_ba, (byte)0);
        this._handshakeState.destroy();
        if (this._createdSentCount == 1) {
            this._rtt = (int)(this._context.clock().now() - this._lastSend);
        }
        this._pstate = new PeerState2(this._context, this._transport, this._aliceSocketAddress, this._receivedConfirmedIdentity.calculateHash(), true, this._rtt, sender, rcvr, this._sendConnID, this._rcvConnID, this._sendHeaderEncryptKey1, h_ba, h_ab);
        this._pstate.adjustClockSkew(this._skew - (long)(this._rtt / 2) - 100L);
        this._pstate.setHisMTU(this._mtu);
        boolean isIPv6 = this._aliceIP.length == 16;
        RouterAddress ra = this._transport.getCurrentExternalAddress(isIPv6);
        if (ra != null) {
            this._pstate.setOurAddress(ra.getIP(), ra.getPort());
        }
        if (this._introductionRequested) {
            long tag = 1L + this._context.random().nextLong(0xFFFFFFFFL);
            this.setSentRelayTag(tag);
            this._pstate.setWeRelayToThemAs(tag);
        }
        this._pstate.sendAck0();
    }

    private PeerStateDestroyed createPeerStateDestroyed(int reason) {
        byte[] ckd = this._handshakeState.getChainingKey();
        byte[] k_ab = new byte[32];
        byte[] k_ba = new byte[32];
        HKDF hkdf = new HKDF(this._context);
        hkdf.calculate(ckd, SSU2Util.ZEROLEN, k_ab, k_ba, 0);
        byte[] d_ab = new byte[32];
        byte[] h_ab = new byte[32];
        byte[] d_ba = new byte[32];
        byte[] h_ba = new byte[32];
        hkdf.calculate(k_ab, SSU2Util.ZEROLEN, "HKDFSSU2DataKeys", d_ab, h_ab, 0);
        hkdf.calculate(k_ba, SSU2Util.ZEROLEN, "HKDFSSU2DataKeys", d_ba, h_ba, 0);
        ChaChaPolyCipherState sender = new ChaChaPolyCipherState();
        sender.initializeKey(d_ba, 0);
        ChaChaPolyCipherState rcvr = new ChaChaPolyCipherState();
        rcvr.initializeKey(d_ab, 0);
        this._handshakeState.destroy();
        return new PeerStateDestroyed(this._context, this._transport, this._remoteHostId, this._sendConnID, this._rcvConnID, sender, rcvr, this._sendHeaderEncryptKey1, h_ba, h_ab, reason);
    }

    public synchronized void createdPacketSent(DatagramPacket pkt) {
        if (this._sessCrForReTX == null) {
            byte[] data = pkt.getData();
            int off = pkt.getOffset();
            int len = pkt.getLength();
            this._sessCrForReTX = new byte[len];
            System.arraycopy(data, off, this._sessCrForReTX, 0, len);
        }
        this.createdPacketSent();
    }

    public synchronized UDPPacket getRetransmitSessionCreatedPacket() {
        if (this._sessCrForReTX == null) {
            return null;
        }
        if (this._log.shouldInfo()) {
            this._log.info("[SSU2] RETRANSMIT SessionCreated on " + this);
        }
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        System.arraycopy(this._sessCrForReTX, 0, data, off, this._sessCrForReTX.length);
        pkt.setLength(this._sessCrForReTX.length);
        pkt.setSocketAddress(this._aliceSocketAddress);
        packet.setMessageType(71);
        packet.setPriority(550);
        this.createdPacketSent();
        return packet;
    }

    public synchronized PeerState2 getPeerState() {
        if (this._pstate != null) {
            this._currentState = InboundEstablishState.InboundState.IB_STATE_COMPLETE;
            if (this._queuedDataPackets != null) {
                for (UDPPacket packet : this._queuedDataPackets) {
                    if (this._log.shouldInfo()) {
                        this._log.info("[SSU2] Passing possible data " + packet + " to PeerState2: " + this);
                    }
                    this._pstate.receivePacket(packet);
                    packet.release();
                }
                this._queuedDataPackets.clear();
            }
        }
        return this._pstate;
    }

    public synchronized void queuePossibleDataPacket(UDPPacket packet) {
        if (this._currentState == InboundEstablishState.InboundState.IB_STATE_FAILED) {
            return;
        }
        if (this._pstate == null) {
            if (this._queuedDataPackets == null) {
                this._queuedDataPackets = new ArrayList<UDPPacket>(4);
            } else if (this._queuedDataPackets.size() >= 10) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] Not queueing possible data " + packet + ", too many queued on " + this);
                }
                return;
            }
            if (this._log.shouldInfo()) {
                this._log.info("[SSU2] Queueing possible data " + packet + " on " + this);
            }
            DatagramPacket pkt = packet.getPacket();
            UDPPacket packet2 = UDPPacket.acquire(this._context, true);
            DatagramPacket pkt2 = packet2.getPacket();
            System.arraycopy(pkt.getData(), pkt.getOffset(), pkt2.getData(), pkt2.getOffset(), pkt.getLength());
            pkt2.setLength(pkt.getLength());
            pkt2.setSocketAddress(pkt.getSocketAddress());
            this._queuedDataPackets.add(packet2);
        } else {
            if (this._log.shouldInfo()) {
                this._log.info("[SSU2] Passing possible data " + packet + " to PeerState2: " + this);
            }
            this._pstate.receivePacket(packet);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("InboundEstablishState ");
        buf.append(Addresses.toString(this._aliceIP, this._alicePort));
        buf.append("\n* Lifetime: ").append(DataHelper.formatDuration(this.getLifetime()));
        buf.append("; Receive ID: ").append(this._rcvConnID);
        buf.append("; Send ID: ").append(this._sendConnID);
        buf.append("; Token: ").append(this._token);
        if (this._sentRelayTag > 0L) {
            buf.append("; RelayTag: ").append(this._sentRelayTag);
        }
        buf.append(' ').append((Object)this._currentState);
        return buf.toString();
    }

    private class Disconnector
    implements SimpleTimer.TimedEvent {
        private final Hash h;

        public Disconnector(Hash h) {
            this.h = h;
        }

        @Override
        public void timeReached() {
            InboundEstablishState2.this._context.commSystem().forceDisconnect(this.h);
        }
    }

    private static class RIException
    extends DataFormatException {
        private final int rsn;

        public RIException(String msg, int reason) {
            super(msg);
            this.rsn = reason;
        }

        public RIException(String msg, int reason, Throwable t) {
            super(msg, t);
            this.rsn = reason;
        }

        public int getReason() {
            return this.rsn;
        }

        @Override
        public String getMessage() {
            return "Code " + this.rsn + ": " + super.getMessage();
        }
    }
}

