/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.PacketBuilder2;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.PeerTestManager;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Payload;
import net.i2p.router.transport.udp.SSU2Util;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.VersionComparator;

class IntroductionManager {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final PacketBuilder2 _builder2;
    private final Map<Long, PeerState> _outbound;
    private final Map<Long, PeerState> _inbound;
    private final ConcurrentHashMap<Long, PeerState2> _nonceToAlice;
    private final Set<InetAddress> _recentHolePunches;
    private long _lastHolePunchClean;
    private static final int MAX_INBOUND = 20;
    public static final int MAX_OUTBOUND = 100;
    private static final long PUNCH_CLEAN_TIME = 5000L;
    private static final int MAX_PUNCHES = 20;
    private static final long INTRODUCER_EXPIRATION = 4800000L;
    private static final String MIN_IPV6_INTRODUCER_VERSION = "0.9.50";
    private static final long MAX_SKEW = 120000L;

    public IntroductionManager(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(IntroductionManager.class);
        this._transport = transport;
        this._builder2 = transport.getBuilder2();
        this._outbound = new ConcurrentHashMap<Long, PeerState>(100);
        this._inbound = new ConcurrentHashMap<Long, PeerState>(20);
        this._nonceToAlice = this._builder2 != null ? new ConcurrentHashMap(20) : null;
        this._recentHolePunches = new HashSet<InetAddress>(16);
        ctx.statManager().createRateStat("udp.receiveRelayIntro", "Received a relayed request from introducer", "Transport [UDP]", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.receiveRelayRequest", "Received a good request to relay to someone else", "Transport [UDP]", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.receiveRelayRequestBadTag", "Received relay requests with bad/expired tag", "Transport [UDP]", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.relayBadIP", "Received IP or port was bad", "Transport [UDP]", UDPTransport.RATES);
    }

    public void reset() {
        this._inbound.clear();
        this._outbound.clear();
    }

    public void add(PeerState peer) {
        long id2;
        boolean added;
        if (peer == null) {
            return;
        }
        if (!TransportUtil.isValidPort(peer.getRemotePort())) {
            return;
        }
        long id = peer.getWeRelayToThemAs();
        boolean bl = added = id > 0L;
        if (added) {
            this._outbound.put(id, peer);
        }
        if ((id2 = peer.getTheyRelayToUsAs()) > 0L && this._inbound.size() < 20) {
            added = true;
            this._inbound.put(id2, peer);
        }
    }

    public void remove(PeerState peer) {
        long id2;
        if (peer == null) {
            return;
        }
        long id = peer.getWeRelayToThemAs();
        if (id > 0L) {
            this._outbound.remove(id);
        }
        if ((id2 = peer.getTheyRelayToUsAs()) > 0L) {
            this._inbound.remove(id2);
        }
    }

    public boolean isInboundTagValid(long tag) {
        return this._inbound.containsKey(tag);
    }

    private PeerState get(long id) {
        return this._outbound.get(id);
    }

    public int pickInbound(RouterAddress current, boolean ipv6, Properties ssuOptions, int howMany) {
        int i;
        if (this._log.shouldDebug()) {
            this._log.debug("Picking inbound out of " + this._inbound.size());
        }
        if (this._inbound.isEmpty()) {
            return 0;
        }
        ArrayList<PeerState> peers = new ArrayList<PeerState>(this._inbound.values());
        int sz = peers.size();
        Collections.sort(peers, new PeerStateComparator());
        int found = 0;
        long now = this._context.clock().now();
        long inactivityCutoff = now - 600000L;
        if (sz <= howMany + 2) {
            inactivityCutoff -= 300000L;
        }
        ArrayList<Introducer> introducers = new ArrayList<Introducer>(howMany);
        String exp = Long.toString((now + 4800000L) / 1000L);
        int ssu2count = 0;
        if (current != null) {
            UDPAddress ua = new UDPAddress(current);
            for (int i2 = 0; i2 < ua.getIntroducerCount(); ++i2) {
                long tag;
                long lexp = ua.getIntroducerExpiration(i2);
                if (lexp > 0L && lexp < now + 1200000L || !this.isInboundTagValid(tag = ua.getIntroducerTag(i2))) continue;
                String sexp = Long.toString(ua.getIntroducerExpiration(i2) / 1000L);
                Introducer intro = new Introducer(ua.getIntroducerHash(i2), tag, sexp);
                ++ssu2count;
                if (this._log.shouldInfo()) {
                    this._log.info("Reusing introducer: " + ua.getIntroducerHash(i2));
                }
                introducers.add(intro);
                ++found;
            }
        }
        block3: for (i = 0; i < sz && found < howMany; ++i) {
            PeerState cur = (PeerState)peers.get(i);
            if (cur.isIPv6() != ipv6) continue;
            Hash hash = cur.getRemotePeer();
            String b64 = hash.toBase64();
            for (Introducer intro : introducers) {
                if (!b64.equals(intro.shash)) continue;
                continue block3;
            }
            RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(hash);
            if (ri == null) {
                if (this._log.shouldInfo()) {
                    this._log.info("No local RouterInfo for selected peer [" + cur + "]");
                }
                DatabaseLookupMessage dlm = new DatabaseLookupMessage(this._context);
                dlm.setSearchKey(hash);
                dlm.setSearchType(DatabaseLookupMessage.Type.RI);
                dlm.setMessageExpiration(now + 10000L);
                dlm.setFrom(this._context.routerHash());
                this._transport.send(dlm, cur);
                cur.setLastSendTime(now);
                continue;
            }
            List<RouterAddress> ras = this._transport.getTargetAddresses(ri);
            if (ras.isEmpty()) {
                if (!this._log.shouldInfo()) continue;
                this._log.info("Selected peer has no SSU address: " + ri);
                continue;
            }
            if (this._context.banlist().isBanlisted(hash) || this._transport.wasUnreachable(hash)) {
                if (!this._log.shouldInfo()) continue;
                this._log.info("Router is failing, blocklisted or was unreachable: " + cur);
                continue;
            }
            if (cur.getLastReceiveTime() < inactivityCutoff && cur.getLastSendTime() < inactivityCutoff && cur.getIntroducerTime() + 1200000L < now) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Router has been idle too long: " + cur);
                continue;
            }
            int oldFound = found;
            for (RouterAddress ra : ras) {
                int port;
                String host;
                byte[] ip = ra.getIP();
                if (ip == null || (host = ip.length == 4 ? ra.getHost() : Addresses.toString(ip)) == null || !this.isValid(ip, port = ra.getPort(), true)) continue;
                if ((!ipv6 && ip.length == 16 || ipv6 && ip.length == 4) && VersionComparator.comp(ri.getVersion(), MIN_IPV6_INTRODUCER_VERSION) < 0) {
                    if (!this._log.shouldInfo()) continue;
                    this._log.info("Would have picked IPv6 introducer for IPv4 or IPv4 introducer for IPv6 but they don't support it: " + cur);
                    continue;
                }
                cur.setIntroducerTime();
                Introducer intro = new Introducer(hash, cur.getTheyRelayToUsAs(), exp);
                ++ssu2count;
                introducers.add(intro);
                ++found;
                break;
            }
            if (oldFound == found || !this._log.shouldInfo()) continue;
            this._log.info("Selecting introducer: " + cur);
        }
        Collections.sort(introducers);
        for (i = 0; i < found; ++i) {
            int j;
            Introducer in = (Introducer)introducers.get(i);
            ssuOptions.setProperty("ih" + i, in.shash);
            ssuOptions.setProperty("itag" + i, in.stag);
            String sexp = in.sexp;
            if (current != null && (j = 0) < 3) {
                String oexp = null;
                if (in.shash.equals(current.getOption("ih" + j)) && in.stag.equals(current.getOption("itag" + j))) {
                    oexp = current.getOption("iexp" + j);
                }
                if (oexp != null) {
                    try {
                        long oex = Long.parseLong(oexp) * 1000L;
                        if (oex > now + 1200000L) {
                            sexp = oexp;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            ssuOptions.setProperty("iexp" + i, sexp);
        }
        this.pingIntroducers();
        return found;
    }

    public void pingIntroducers() {
        long now = this._context.clock().now();
        long pingCutoff = now - 6300000L;
        long inactivityCutoff = now - 82500L;
        Iterator<PeerState> iter = this._inbound.values().iterator();
        while (iter.hasNext()) {
            PeerState cur = iter.next();
            if (cur.getIntroducerTime() <= pingCutoff || cur.getLastSendOrPingTime() >= inactivityCutoff) continue;
            if (this._log.shouldDebug()) {
                this._log.debug("Pinging introducer: " + cur);
            }
            cur.setLastPingTime(now);
            try {
                UDPPacket ping = this._builder2.buildPing((PeerState2)cur);
                this._transport.send(ping);
            }
            catch (IOException ioe) {
                iter.remove();
            }
        }
    }

    int introducerCount(boolean ipv6) {
        int rv = 0;
        for (PeerState ps : this._inbound.values()) {
            if (ps.isIPv6() != ipv6) continue;
            ++rv;
        }
        return rv;
    }

    int introducedCount() {
        return this._outbound.size();
    }

    void receiveRelayRequest(PeerState2 alice, byte[] data) {
        SimpleDataStructure spk;
        int rcode;
        long time = DataHelper.fromLong(data, 8, 4) * 1000L;
        long now = this._context.clock().now();
        alice.setLastReceiveTime(now);
        long skew = time - now;
        if (skew > 120000L || skew < -120000L) {
            if (this._log.shouldWarn()) {
                this._log.warn("Too skewed for relay req from " + alice);
            }
            return;
        }
        int ver = data[12] & 0xFF;
        if (ver != 2) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad relay req version " + ver + " from " + alice);
            }
            return;
        }
        long nonce = DataHelper.fromLong(data, 0, 4);
        long tag = DataHelper.fromLong(data, 4, 4);
        PeerState charlie = this._outbound.get(tag);
        RouterInfo aliceRI = null;
        if (charlie == null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Relay tag not found " + tag + " from " + alice);
            }
            rcode = 5;
        } else if (charlie.getVersion() != 2) {
            if (this._log.shouldWarn()) {
                this._log.warn("Receive SSU2 relay request from " + alice + " for SSU1 " + charlie);
            }
            rcode = 5;
        } else {
            aliceRI = this._context.netDb().lookupRouterInfoLocally(alice.getRemotePeer());
            if (aliceRI != null) {
                spk = aliceRI.getIdentity().getSigningPublicKey();
                if (SSU2Util.validateSig(this._context, SSU2Util.RELAY_REQUEST_PROLOGUE, this._context.routerHash(), charlie.getRemotePeer(), data, (SigningPublicKey)spk)) {
                    PeerState2 old = this._nonceToAlice.putIfAbsent(nonce, alice);
                    rcode = old != null && !old.equals(alice) ? 1 : 0;
                } else {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Signature failed relay request\n" + aliceRI);
                    }
                    rcode = 4;
                }
            } else {
                if (this._log.shouldWarn()) {
                    this._log.warn("Alice RI not found " + alice);
                }
                rcode = 6;
            }
        }
        if (rcode == 0) {
            boolean gzip;
            if (this._log.shouldInfo()) {
                this._log.info("Received relay request from " + alice + " for tag " + tag + " nonce " + nonce + " and relaying with " + charlie);
            }
            byte[] idata = new byte[33 + data.length];
            System.arraycopy(alice.getRemotePeer().getData(), 0, idata, 1, 32);
            System.arraycopy(data, 0, idata, 33, data.length);
            int avail = charlie.getMTU() - ((charlie.isIPv6() ? 80 : 60) + 3 + idata.length + 3 + 2);
            byte[] info = aliceRI.toByteArray();
            byte[] gzipped = DataHelper.compress(info, 0, info.length, 9);
            if (this._log.shouldDebug()) {
                this._log.debug("Alice RI: " + info.length + " bytes uncompressed, " + gzipped.length + " compressed, charlie MTU " + charlie.getMTU() + ", available " + avail);
            }
            boolean bl = gzip = gzipped.length < info.length;
            if (gzip) {
                info = gzipped;
            }
            try {
                if (info.length <= avail) {
                    SSU2Payload.RIBlock riblock = new SSU2Payload.RIBlock(info, 0, info.length, false, gzip, 0, 1);
                    UDPPacket packet = this._builder2.buildRelayIntro(idata, riblock, (PeerState2)charlie);
                    this._transport.send(packet);
                } else {
                    DatabaseStoreMessage dbsm = new DatabaseStoreMessage(this._context);
                    dbsm.setEntry(aliceRI);
                    dbsm.setMessageExpiration(now + 10000L);
                    this._transport.send(dbsm, charlie);
                    UDPPacket packet = this._builder2.buildRelayIntro(idata, null, (PeerState2)charlie);
                    new DelaySend(packet, 40L);
                }
                charlie.setLastSendTime(now);
                return;
            }
            catch (IOException ioe) {
                rcode = 1;
            }
        }
        try {
            spk = this._context.keyManager().getSigningPrivateKey();
            data = SSU2Util.createRelayResponseData(this._context, this._context.routerHash(), rcode, nonce, null, 0, spk, 0L);
            if (data == null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("sig fail");
                }
                return;
            }
            if (this._log.shouldInfo()) {
                this._log.info("Send RelayReponse rejection as Bob (Reason: " + rcode + ") to Alice " + alice);
            }
            UDPPacket packet = this._builder2.buildRelayResponse(data, alice);
            alice.setLastSendTime(now);
            this._transport.send(packet);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void receiveRelayIntro(PeerState2 bob, Hash alice, byte[] data) {
        this.receiveRelayIntro(bob, alice, data, 0);
    }

    private boolean receiveRelayIntro(PeerState2 bob, Hash alice, byte[] data, int retryCount) {
        RouterInfo aliceRI = null;
        if (retryCount >= 5) {
            aliceRI = this._context.netDb().lookupRouterInfoLocally(alice);
        } else if (!this._context.banlist().isBanlisted(alice) && (aliceRI = this._context.netDb().lookupRouterInfoLocally(alice)) == null) {
            if (this._log.shouldInfo()) {
                this._log.info("Delay after " + retryCount + " retries, no RI for " + alice.toBase64());
            }
            if (retryCount == 0) {
                new DelayIntro(bob, alice, data);
            }
            return false;
        }
        this.receiveRelayIntro(bob, alice, data, aliceRI);
        return true;
    }

    private void receiveRelayIntro(PeerState2 bob, Hash alice, byte[] data, RouterInfo aliceRI) {
        long token;
        int rcode;
        InetAddress aliceIP;
        long now;
        long nonce = DataHelper.fromLong(data, 0, 4);
        long tag = DataHelper.fromLong(data, 4, 4);
        long time = DataHelper.fromLong(data, 8, 4) * 1000L;
        long skew = time - (now = this._context.clock().now());
        if (skew > 120000L || skew < -120000L) {
            if (this._log.shouldWarn()) {
                this._log.warn("Too skewed for relay intro from " + bob);
            }
            return;
        }
        int ver = data[12] & 0xFF;
        if (ver != 2) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad relay intro version " + ver + " from " + bob);
            }
            return;
        }
        int iplen = data[13] & 0xFF;
        if (iplen != 6 && iplen != 18) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad IP length " + iplen + " from " + bob);
            }
            return;
        }
        boolean isIPv6 = iplen == 18;
        int testPort = (int)DataHelper.fromLong(data, 14, 2);
        byte[] testIP = new byte[iplen - 2];
        System.arraycopy(data, 16, testIP, 0, iplen - 2);
        try {
            aliceIP = InetAddress.getByAddress(testIP);
        }
        catch (UnknownHostException uhe) {
            return;
        }
        SessionKey aliceIntroKey = null;
        PeerState aps = this._transport.getPeerState(alice);
        if (this._transport.isSymNatted()) {
            rcode = 65;
        } else if (aps != null && aps.isIPv6() == isIPv6) {
            rcode = 68;
        } else if (this._context.banlist().isBanlisted(alice) || this._context.blocklist().isBlocklisted(testIP)) {
            rcode = 69;
        } else if (!TransportUtil.isValidPort(testPort) || !this._transport.isValid(testIP) || this._transport.isTooClose(testIP)) {
            rcode = 65;
        } else if (aliceRI != null) {
            SigningPublicKey spk = aliceRI.getIdentity().getSigningPublicKey();
            if (SSU2Util.validateSig(this._context, SSU2Util.RELAY_REQUEST_PROLOGUE, bob.getRemotePeer(), this._context.routerHash(), data, spk)) {
                aliceIntroKey = PeerTestManager.getIntroKey(this.getAddress(aliceRI, isIPv6));
                rcode = aliceIntroKey != null ? 0 : 65;
            } else {
                if (this._log.shouldWarn()) {
                    this._log.warn("Signature failed relay intro\n" + aliceRI);
                }
                rcode = 67;
            }
        } else {
            if (this._log.shouldWarn()) {
                this._log.warn("Alice's RouterInfo  [" + alice + "] not found for relay intro from " + bob);
            }
            rcode = 70;
        }
        byte[] ourIP = null;
        RouterAddress ourra = this._transport.getCurrentExternalAddress(isIPv6);
        if (ourra != null) {
            ourIP = ourra.getIP();
            if (ourIP == null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("No IP address to send in RelayReponse");
                }
                rcode = 65;
            }
        } else {
            if (this._log.shouldWarn()) {
                this._log.warn("No address to send in RelayReponse");
            }
            rcode = 65;
        }
        int ourPort = this._transport.getRequestedPort();
        if (rcode == 0) {
            RemoteHostId aliceID = new RemoteHostId(testIP, testPort);
            EstablishmentManager.Token tok = this._transport.getEstablisher().getInboundToken(aliceID, 60000L);
            token = tok.getToken();
        } else {
            token = 0L;
        }
        SigningPrivateKey spk = this._context.keyManager().getSigningPrivateKey();
        data = SSU2Util.createRelayResponseData(this._context, bob.getRemotePeer(), rcode, nonce, ourIP, ourPort, spk, token);
        if (data == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("sig fail");
            }
            return;
        }
        try {
            UDPPacket packet = this._builder2.buildRelayResponse(data, bob);
            if (this._log.shouldInfo()) {
                this._log.info("Send RelayResponse " + rcode + " as Charlie  nonce " + nonce + " to Bob " + bob + " with token " + token + " for Alice " + Addresses.toString(testIP, testPort) + ' ' + aliceRI);
            }
            this._transport.send(packet);
            bob.setLastSendTime(now);
        }
        catch (IOException ioe) {
            return;
        }
        if (rcode == 0) {
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] Sending hole punch to " + Addresses.toString(testIP, testPort));
            }
            long sendId = nonce << 32 | nonce;
            long rcvId = sendId ^ 0xFFFFFFFFFFFFFFFFL;
            UDPPacket packet = this._builder2.buildHolePunch(aliceIP, testPort, aliceIntroKey, sendId, rcvId, data);
            this._transport.send(packet);
        }
    }

    void receiveRelayResponse(PeerState2 peer, int status, byte[] data) {
        long nonce = DataHelper.fromLong(data, 0, 4);
        long time = DataHelper.fromLong(data, 4, 4) * 1000L;
        long now = this._context.clock().now();
        peer.setLastReceiveTime(now);
        long skew = time - now;
        if (skew > 120000L || skew < -120000L) {
            if (this._log.shouldWarn()) {
                this._log.warn("Too skewed for relay resp from " + peer);
            }
            return;
        }
        int ver = data[8] & 0xFF;
        if (ver != 2) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad relay intro version " + ver + " from " + peer);
            }
            return;
        }
        PeerState2 alice = this._nonceToAlice.remove(nonce);
        if (alice != null) {
            RouterInfo charlie = this._context.netDb().lookupRouterInfoLocally(peer.getRemotePeer());
            if (charlie != null) {
                byte[] signedData = status == 0 ? Arrays.copyOfRange(data, 0, data.length - 8) : data;
                SigningPublicKey spk = charlie.getIdentity().getSigningPublicKey();
                if (!SSU2Util.validateSig(this._context, SSU2Util.RELAY_RESPONSE_PROLOGUE, this._context.routerHash(), null, signedData, spk) && this._log.shouldWarn()) {
                    this._log.warn("Signature failed RelayReponse as Bob from Charlie:\n" + charlie);
                }
            } else if (this._log.shouldWarn()) {
                this._log.warn("Signer's RouterInfo not found " + peer);
            }
            byte[] idata = new byte[2 + data.length];
            idata[1] = (byte)status;
            System.arraycopy(data, 0, idata, 2, data.length);
            try {
                UDPPacket packet = this._builder2.buildRelayResponse(idata, alice);
                if (this._log.shouldDebug()) {
                    this._log.debug("Received RelayReponse " + status + " as Bob, forwarding  nonce " + nonce + " to Alice " + alice);
                }
                this._transport.send(packet);
                alice.setLastSendTime(now);
            }
            catch (IOException iOException) {}
        } else {
            if (this._log.shouldDebug()) {
                this._log.debug("Received RelayReponse " + status + " as Alice  nonce " + nonce + " from " + peer);
            }
            this._transport.getEstablisher().receiveRelayResponse(peer, nonce, status, data);
        }
    }

    void receiveHolePunch(RemoteHostId charlie, byte[] data) {
    }

    private RouterAddress getAddress(RouterInfo ri, boolean isIPv6) {
        List<RouterAddress> addrs = this._transport.getTargetAddresses(ri);
        return PeerTestManager.getAddress(addrs, isIPv6);
    }

    private boolean isValid(byte[] ip, int port, boolean allowIPv6) {
        return TransportUtil.isValidPort(port) && ip != null && (ip.length == 4 || allowIPv6 && ip.length == 16) && this._transport.isValid(ip) && !this._transport.isTooClose(ip) && !this._context.blocklist().isBlocklisted(ip);
    }

    public void cleanup() {
        if (this._nonceToAlice == null || this._nonceToAlice.isEmpty()) {
            return;
        }
        Iterator<PeerState2> iter = this._nonceToAlice.values().iterator();
        while (iter.hasNext()) {
            PeerState2 state = iter.next();
            if (!state.isDead()) continue;
            iter.remove();
        }
    }

    private class DelaySend
    extends SimpleTimer2.TimedEvent {
        private final UDPPacket pkt;

        public DelaySend(UDPPacket packet, long delay) {
            super(IntroductionManager.this._context.simpleTimer2());
            this.pkt = packet;
            this.schedule(delay);
        }

        @Override
        public void timeReached() {
            IntroductionManager.this._transport.send(this.pkt);
        }
    }

    private class DelayIntro
    extends SimpleTimer2.TimedEvent {
        private final PeerState2 bob;
        private final Hash alice;
        private final byte[] data;
        private volatile int count;
        private static final long DELAY = 50L;

        public DelayIntro(PeerState2 b, Hash a, byte[] d) {
            super(IntroductionManager.this._context.simpleTimer2());
            this.bob = b;
            this.alice = a;
            this.data = d;
            this.schedule(50L);
        }

        @Override
        public void timeReached() {
            boolean ok;
            if (!(ok = IntroductionManager.this.receiveRelayIntro(this.bob, this.alice, this.data, ++this.count))) {
                this.reschedule(50L << this.count);
            }
        }
    }

    private static class Introducer
    implements Comparable<Introducer> {
        public final String stag;
        public final String sexp;
        public final String shash;

        public Introducer(Hash h, long tag, String exp) {
            this.stag = String.valueOf(tag);
            this.sexp = exp;
            this.shash = h.toBase64();
        }

        @Override
        public int compareTo(Introducer i) {
            return this.stag.compareTo(i.stag);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Introducer)) {
                return false;
            }
            Introducer i = (Introducer)o;
            return this.compareTo(i) == 0;
        }

        public int hashCode() {
            return this.stag.hashCode();
        }
    }

    private static class PeerStateComparator
    implements Comparator<PeerState> {
        private PeerStateComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            long d = r.getKeyEstablishedTime() - l.getKeyEstablishedTime();
            if (d < 0L) {
                return -1;
            }
            if (d > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

