/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.util.CDPQEntry;
import net.i2p.util.Log;

class OutboundMessageState
implements CDPQEntry {
    private final I2PAppContext _context;
    private final Log _log;
    private final OutNetMessage _message;
    private final I2NPMessage _i2npMessage;
    private final PeerState _peer;
    private final long _expiration;
    private final byte[] _messageBuf;
    private final int _fragmentSize;
    private long _fragmentAcks;
    private final int _numFragments;
    private final byte[] _fragmentSends;
    private final long _startedOn;
    private int _pushCount;
    private int _maxSends;
    private long _enqueueTime;
    private volatile long _seqNum;
    private int _allowedSendBytes;
    private final AtomicInteger _nacks = new AtomicInteger();
    public static final int MAX_MSG_SIZE = 32768;
    private static final long EXPIRATION = 10000L;

    public OutboundMessageState(I2PAppContext context, I2NPMessage msg, PeerState peer) {
        this(context, null, msg, peer);
    }

    public OutboundMessageState(I2PAppContext context, OutNetMessage m, PeerState peer) {
        this(context, m, m.getMessage(), peer);
    }

    private OutboundMessageState(I2PAppContext context, OutNetMessage m, I2NPMessage msg, PeerState peer) {
        if (msg == null || peer == null) {
            throw new IllegalArgumentException();
        }
        this._context = context;
        this._log = this._context.logManager().getLog(OutboundMessageState.class);
        this._message = m;
        this._i2npMessage = msg;
        this._peer = peer;
        this._startedOn = this._context.clock().now();
        this._expiration = this._startedOn + 10000L;
        int totalSize = this._peer.getVersion() == 2 ? this._i2npMessage.getMessageSize() - 7 : this._i2npMessage.getRawMessageSize();
        if (totalSize > 32768) {
            throw new IllegalArgumentException("Size too large! " + totalSize);
        }
        this._messageBuf = new byte[totalSize];
        if (this._peer.getVersion() == 2) {
            this._i2npMessage.toRawByteArrayNTCP2(this._messageBuf, 0);
        } else {
            this._i2npMessage.toRawByteArray(this._messageBuf);
        }
        int first = this._fragmentSize = this._peer.fragmentSize();
        if (peer.getVersion() > 1) {
            first += 5;
        }
        int numFragments = 1;
        if (first < totalSize && first + ((numFragments += (totalSize - first) / this._fragmentSize) - 1) * this._fragmentSize < totalSize) {
            ++numFragments;
        }
        if (numFragments > 64) {
            throw new IllegalArgumentException("Fragmenting a " + totalSize + " message into " + numFragments + " fragments - too many!");
        }
        this._numFragments = numFragments;
        this._fragmentAcks = this._numFragments < 64 ? OutboundMessageState.mask(this._numFragments) - 1L : -1L;
        this._fragmentSends = numFragments > 1 ? new byte[numFragments] : null;
    }

    public int getVersion() {
        return this._peer.getVersion();
    }

    private static long mask(int fragment) {
        return 1L << fragment;
    }

    public OutNetMessage getMessage() {
        return this._message;
    }

    public long getMessageId() {
        return this._i2npMessage.getUniqueId();
    }

    public int incrementNACKs() {
        return this._nacks.incrementAndGet();
    }

    public int getNACKs() {
        return this._nacks.get();
    }

    public void clearNACKs() {
        this._nacks.set(0);
    }

    public PeerState getPeer() {
        return this._peer;
    }

    public boolean isExpired() {
        return this._expiration < this._context.clock().now();
    }

    public boolean isExpired(long now) {
        return this._expiration < now;
    }

    public synchronized boolean isComplete() {
        return this._fragmentAcks == 0L;
    }

    public synchronized int getUnackedSize() {
        int rv = 0;
        if (this.isComplete()) {
            return rv;
        }
        int lastSize = this._messageBuf.length % this._fragmentSize;
        if (lastSize == 0) {
            lastSize = this._fragmentSize;
        }
        int overhead = this._peer.fragmentOverhead();
        for (int i = 0; i < this._numFragments; ++i) {
            if (!this.needsSending(i)) continue;
            rv = i + 1 == this._numFragments ? (rv += lastSize) : (rv += this._fragmentSize);
            rv += overhead;
        }
        return rv;
    }

    public synchronized int getUnackedFragments() {
        if (this.isComplete()) {
            return 0;
        }
        if (this._numFragments == 1) {
            return 1;
        }
        int rv = 0;
        for (int i = 0; i < this._numFragments; ++i) {
            if (!this.needsSending(i)) continue;
            ++rv;
        }
        return rv;
    }

    public synchronized boolean hasUnsentFragments() {
        if (this.isComplete()) {
            return false;
        }
        if (this._numFragments == 1) {
            return this._maxSends == 0;
        }
        for (int i = this._numFragments - 1; i >= 0; --i) {
            if (this._fragmentSends[i] != 0) continue;
            return true;
        }
        return false;
    }

    private int getMinSendCount() {
        byte rv = 127;
        for (int i = 0; i < this._numFragments; ++i) {
            byte count;
            if (!this.needsSending(i) || (count = this._fragmentSends[i]) >= rv) continue;
            rv = count;
        }
        return rv;
    }

    public synchronized int getMinSendSize() {
        if (this.isComplete()) {
            return 0;
        }
        int overhead = this._peer.fragmentOverhead();
        if (this._numFragments == 1) {
            return this._messageBuf.length + overhead;
        }
        if (this._pushCount == 0) {
            return this.fragmentSize(this._numFragments - 1) + overhead;
        }
        int minSendCount = this.getMinSendCount();
        int rv = this._fragmentSize;
        for (int i = 0; i < this._numFragments; ++i) {
            int sz;
            if (!this.needsSending(i) || this._fragmentSends[i] != minSendCount || (sz = this.fragmentSize(i) + overhead) >= rv) continue;
            rv = sz;
        }
        return rv;
    }

    public synchronized int getSendSize(int max) {
        if (this.isComplete()) {
            return 0;
        }
        int overhead = this._peer.fragmentOverhead();
        if (this._numFragments == 1) {
            int rv = this._messageBuf.length + overhead;
            return rv <= max ? rv : 0;
        }
        int minSendCount = this.getMinSendCount();
        int rv = 0;
        for (int i = this._numFragments - 1; i >= 0; --i) {
            if (!this.needsSending(i) || this._fragmentSends[i] != minSendCount) continue;
            int sz = this.fragmentSize(i) + overhead;
            int tot = rv + sz;
            if (tot <= max) {
                rv = tot;
                continue;
            }
            if (!this._log.shouldInfo()) continue;
            this._log.info("Send window limited to " + (max - rv) + ", not sending fragment " + i + " for " + this.toString());
        }
        if (rv > 0) {
            this._allowedSendBytes = rv;
        }
        return rv;
    }

    public synchronized boolean needsSending(int fragment) {
        return (this._fragmentAcks & OutboundMessageState.mask(fragment)) != 0L;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._startedOn;
    }

    public synchronized boolean acked(ACKBitfield bitfield) {
        int highest = bitfield.highestReceived();
        for (int i = 0; i <= highest && i < this._numFragments; ++i) {
            if (!bitfield.received(i)) continue;
            this._fragmentAcks &= OutboundMessageState.mask(i) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return this.isComplete();
    }

    public synchronized boolean acked(int fragmentNum) {
        this._fragmentAcks &= OutboundMessageState.mask(fragmentNum) ^ 0xFFFFFFFFFFFFFFFFL;
        return this.isComplete();
    }

    public synchronized int getMaxSends() {
        return this._maxSends;
    }

    public synchronized int getPushCount() {
        return this._pushCount;
    }

    public synchronized int push(List<PacketBuilder.Fragment> toSend) {
        int rv = 0;
        if (this._allowedSendBytes <= 0 || this._numFragments == 1) {
            for (int i = 0; i < this._numFragments; ++i) {
                if (!this.needsSending(i)) continue;
                toSend.add(new PacketBuilder.Fragment(this, i));
                ++rv;
                if (this._fragmentSends == null) continue;
                int n = i;
                this._fragmentSends[n] = (byte)(this._fragmentSends[n] + 1);
                if (this._fragmentSends[i] <= this._maxSends) continue;
                this._maxSends = this._fragmentSends[i];
            }
            if (this._fragmentSends == null) {
                ++this._maxSends;
            }
        } else {
            int minSendCount = this.getMinSendCount();
            int sent = 0;
            int overhead = this._peer.fragmentOverhead();
            for (int i = this._numFragments - 1; i >= 0; --i) {
                int sz;
                byte count;
                if (!this.needsSending(i) || (count = this._fragmentSends[i]) != minSendCount || (sz = this.fragmentSize(i) + overhead) > this._allowedSendBytes - sent) continue;
                sent += sz;
                toSend.add(new PacketBuilder.Fragment(this, i));
                ++rv;
                int n = i;
                this._fragmentSends[n] = (byte)(this._fragmentSends[n] + 1);
                if (this._fragmentSends[i] > this._maxSends) {
                    this._maxSends = this._fragmentSends[i];
                }
                if (this._allowedSendBytes - sent <= overhead) break;
            }
        }
        if (rv > 0) {
            ++this._pushCount;
            if (this._log.shouldDebug()) {
                this._log.debug("Pushed " + rv + " fragments for " + this.toString());
            }
        } else if (this._log.shouldDebug()) {
            this._log.debug("Nothing pushed??? allowedSendBytes=" + this._allowedSendBytes + " for " + this.toString());
        }
        this._allowedSendBytes = 0;
        return rv;
    }

    public int getFragmentCount() {
        return this._numFragments;
    }

    public int getMessageSize() {
        return this._messageBuf.length;
    }

    public int fragmentSize(int fragmentNum) {
        if (fragmentNum == 0) {
            int fs = this._fragmentSize;
            if (this._peer.getVersion() > 1) {
                fs += 5;
            }
            return Math.min(this._messageBuf.length, fs);
        }
        if (fragmentNum + 1 == this._numFragments) {
            int last = this._messageBuf.length - fragmentNum * this._fragmentSize;
            if (this._peer.getVersion() > 1) {
                last -= 5;
            }
            return last;
        }
        return this._fragmentSize;
    }

    public int writeFragment(byte[] out, int outOffset, int fragmentNum) {
        int toSend;
        int end;
        int start = this._fragmentSize * fragmentNum;
        if (fragmentNum > 0 && this._peer.getVersion() > 1) {
            start += 5;
        }
        if ((end = start + (toSend = this.fragmentSize(fragmentNum))) <= this._messageBuf.length && outOffset + toSend <= out.length) {
            System.arraycopy(this._messageBuf, start, out, outOffset, toSend);
            return toSend;
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Error: " + start + '/' + end + '/' + outOffset + '/' + out.length);
        }
        return -1;
    }

    @Override
    public void setEnqueueTime(long now) {
        this._enqueueTime = now;
    }

    @Override
    public long getEnqueueTime() {
        return this._enqueueTime;
    }

    @Override
    public void drop() {
        this._peer.getTransport().failed(this, false);
    }

    @Override
    public void setSeqNum(long num) {
        this._seqNum = num;
    }

    @Override
    public long getSeqNum() {
        return this._seqNum;
    }

    @Override
    public int getPriority() {
        return this._message != null ? this._message.getPriority() : 550;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("\n* Outbound Message: [").append(this._i2npMessage.getUniqueId());
        buf.append("] Seq: ").append(this._seqNum);
        buf.append("; Type: ").append(this._i2npMessage.getType());
        buf.append("; Size: ").append(this._messageBuf.length).append(" bytes");
        if (this._numFragments > 1) {
            buf.append("; Fragments: ").append(this._numFragments);
        }
        buf.append("; Volleys: ").append(this._maxSends);
        buf.append("; Lifetime: ").append(this.getLifetime()).append("ms");
        if (!this.isComplete()) {
            if (this._nacks.get() > 0) {
                buf.append("; NACKs: ").append(this._nacks);
            }
            if (this._fragmentSends != null) {
                int i;
                buf.append("\n* UnACKed fragments: [ ");
                for (i = 0; i < this._numFragments; ++i) {
                    if (!this.needsSending(i)) continue;
                    buf.append(i).append(' ');
                }
                buf.append("]; Sizes (bytes): [ ");
                for (i = 0; i < this._numFragments; ++i) {
                    buf.append(this.fragmentSize(i)).append(' ');
                }
                buf.append("]; Fragments sent: [ ");
                for (i = 0; i < this._numFragments; ++i) {
                    buf.append(this._fragmentSends[i]).append(' ');
                }
                buf.append("]");
            } else {
                buf.append(" (UnACKed)");
            }
        }
        return buf.toString();
    }
}

