/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.InboundEstablishState;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

class PacketBuilder {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    static final int TYPE_FIRST = 42;
    static final int TYPE_ACK = 42;
    static final int TYPE_PUNCH = 43;
    static final int TYPE_RESP = 44;
    static final int TYPE_INTRO = 45;
    static final int TYPE_RREQ = 46;
    static final int TYPE_TCB = 47;
    static final int TYPE_TBC = 48;
    static final int TYPE_TTA = 49;
    static final int TYPE_TFA = 50;
    static final int TYPE_CONF = 51;
    static final int TYPE_SREQ = 52;
    static final int TYPE_CREAT = 53;
    public static final int HEADER_SIZE = 37;
    public static final int FRAGMENT_HEADER_SIZE = 7;
    public static final int DATA_HEADER_SIZE = 46;
    public static final int IP_HEADER_SIZE = 20;
    public static final int UDP_HEADER_SIZE = 8;
    public static final int MIN_DATA_PACKET_OVERHEAD = 74;
    public static final int IPV6_HEADER_SIZE = 40;
    public static final int MIN_IPV6_DATA_PACKET_OVERHEAD = 94;
    public static final int ABSOLUTE_MAX_ACKS = 255;
    private static final int MAX_RESEND_ACKS_LARGE = 9;
    private static final int MAX_RESEND_ACKS_SMALL = 4;
    private static final String PROP_PADDING = "i2np.udp.padding";
    private static final boolean DEFAULT_ENABLE_PADDING = true;
    private static final byte SESSION_REQUEST_FLAG_BYTE = 0;
    private static final byte SESSION_CREATED_FLAG_BYTE = 16;
    private static final byte SESSION_CONFIRMED_FLAG_BYTE = 32;
    private static final byte PEER_RELAY_REQUEST_FLAG_BYTE = 48;
    private static final byte PEER_RELAY_RESPONSE_FLAG_BYTE = 64;
    private static final byte PEER_RELAY_INTRO_FLAG_BYTE = 80;
    private static final byte DATA_FLAG_BYTE = 96;
    private static final byte PEER_TEST_FLAG_BYTE = 112;
    private static final byte SESSION_DESTROY_FLAG_BYTE = -128;
    static final int PRIORITY_HIGH = 550;
    private static final int PRIORITY_LOW = 100;
    private static final int MAX_IDENTITY_FRAGMENT_SIZE = 512;
    private static final int MAX_PAD2 = 16;

    public PacketBuilder(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._transport = transport;
        this._log = ctx.logManager().getLog(PacketBuilder.class);
    }

    public static int getMaxAdditionalFragmentSize(PeerState peer, int numFragments, int curDataSize) {
        int available = peer.getMTU() - curDataSize;
        available = peer.isIPv6() ? (available -= 94) : (available -= 74);
        return available -= numFragments * 7;
    }

    public UDPPacket buildPacket(OutboundMessageState state, int fragment, PeerState peer, Collection<Long> ackIdsRemaining, int newAckCount, List<ACKBitfield> partialACKsRemaining) {
        List<Fragment> frags = Collections.singletonList(new Fragment(state, fragment));
        return this.buildPacket(frags, peer, ackIdsRemaining, newAckCount, partialACKsRemaining);
    }

    public UDPPacket buildPacket(List<Fragment> fragments, PeerState peer, Collection<Long> ackIdsRemaining, int newAckCount, List<ACKBitfield> partialACKsRemaining) {
        int i;
        int explicitToSend;
        int off;
        int ipHeaderSize;
        StringBuilder msg = null;
        if (this._log.shouldInfo()) {
            msg = new StringBuilder(256);
            msg.append("Data packet sent to [").append(peer.getRemotePeer().toBase64().substring(0, 6) + "]");
        }
        int numFragments = fragments.size();
        int dataSize = 0;
        int priority = 0;
        for (int i2 = 0; i2 < numFragments; ++i2) {
            Fragment frag = fragments.get(i2);
            OutboundMessageState state = frag.state;
            int pri = state.getPriority();
            if (pri > priority) {
                priority = pri;
            }
            int fragment = frag.num;
            int sz = state.fragmentSize(fragment);
            dataSize += sz;
            if (msg == null) continue;
            msg.append("\n* Fragment ").append(i2);
            msg.append(": [MsgID ").append(state.getMessageId()).append("] ").append(fragment);
            msg.append(" of ").append(state.getFragmentCount());
            msg.append(" Size: ").append(sz).append(" bytes");
        }
        if (dataSize < 0) {
            return null;
        }
        int currentMTU = peer.getMTU();
        int availableForAcks = currentMTU - dataSize;
        if (peer.isIPv6()) {
            availableForAcks -= 94;
            ipHeaderSize = 40;
        } else {
            availableForAcks -= 74;
            ipHeaderSize = 20;
        }
        if (numFragments > 1) {
            availableForAcks -= (numFragments - 1) * 7;
        }
        int availableForExplicitAcks = availableForAcks;
        UDPPacket packet = this.buildPacketHeader((byte)96);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int n = off = 37;
        data[n] = (byte)(data[n] | 4);
        int partialAcksToSend = 0;
        if (availableForExplicitAcks >= 6 && !partialACKsRemaining.isEmpty()) {
            for (ACKBitfield bf : partialACKsRemaining) {
                if (partialAcksToSend >= 255) break;
                int bits = bf.highestReceived() + 1;
                if (bits <= 0) continue;
                int acksz = bits / 7;
                if (bits % 7 > 0) {
                    ++acksz;
                }
                acksz += 4;
                if (partialAcksToSend == 0) {
                    ++acksz;
                }
                if (availableForExplicitAcks < acksz) break;
                availableForExplicitAcks -= acksz;
                ++partialAcksToSend;
            }
            if (partialAcksToSend > 0) {
                int n2 = off;
                data[n2] = (byte)(data[n2] | 0x40);
            }
        }
        if (availableForExplicitAcks >= 5 && !ackIdsRemaining.isEmpty()) {
            int n3 = off;
            data[n3] = (byte)(data[n3] | 0xFFFFFF80);
        }
        ++off;
        if (msg != null) {
            msg.append("\n* Total data: ").append(dataSize).append(" bytes; MTU: ").append(currentMTU).append("; ").append(newAckCount).append(" new full ACKs requested: ").append(ackIdsRemaining.size() - newAckCount).append(" Resend ACKs requested; ").append(partialACKsRemaining.size()).append(" Partial ACKs requested\n* ").append(availableForAcks).append(" Available for all ACKs; ").append(availableForExplicitAcks).append(" Available for full ACKs");
        }
        if ((explicitToSend = Math.min(255, Math.min(newAckCount + (currentMTU > 620 ? 9 : 4), Math.min((availableForExplicitAcks - 1) / 4, ackIdsRemaining.size())))) > 0) {
            if (msg != null) {
                msg.append("\n* ").append(explicitToSend).append(" full ACKs included:");
            }
            data[off++] = (byte)explicitToSend;
            Iterator<Long> iter = ackIdsRemaining.iterator();
            for (i = 0; i < explicitToSend && iter.hasNext(); ++i) {
                Long ackId = iter.next();
                iter.remove();
                DataHelper.toLong(data, off, 4, ackId);
                off += 4;
                if (msg == null) continue;
                msg.append(' ').append(ackId);
            }
        }
        if (partialAcksToSend > 0) {
            if (msg != null) {
                msg.append("\n* ").append(partialAcksToSend).append(" partial ACKs included:");
            }
            int origNumRemaining = partialACKsRemaining.size();
            int numPartialOffset = off++;
            Iterator<ACKBitfield> iter = partialACKsRemaining.iterator();
            for (int i3 = 0; i3 < partialAcksToSend && iter.hasNext(); ++i3) {
                int bits;
                ACKBitfield bitfield = iter.next();
                if (bitfield.receivedComplete() || (bits = bitfield.highestReceived() + 1) <= 0) continue;
                int size = bits / 7;
                if (bits % 7 > 0) {
                    ++size;
                }
                DataHelper.toLong(data, off, 4, bitfield.getMessageId());
                off += 4;
                for (int curByte = 0; curByte < size; ++curByte) {
                    data[off] = curByte + 1 < size ? -128 : 0;
                    for (int curBit = 0; curBit < 7; ++curBit) {
                        if (!bitfield.received(curBit + 7 * curByte)) continue;
                        int n4 = off;
                        data[n4] = (byte)(data[n4] | (byte)(1 << curBit));
                    }
                    ++off;
                }
                iter.remove();
                if (msg == null) continue;
                msg.append(' ').append(bitfield).append(" with ACK bytes: ").append(size);
            }
            DataHelper.toLong(data, numPartialOffset, 1, origNumRemaining - partialACKsRemaining.size());
        }
        data[off++] = (byte)numFragments;
        int sizeWritten = 0;
        for (i = 0; i < numFragments; ++i) {
            Fragment frag = fragments.get(i);
            OutboundMessageState state = frag.state;
            int fragment = frag.num;
            DataHelper.toLong(data, off, 4, state.getMessageId());
            data[off += 4] = (byte)(fragment << 1);
            if (fragment == state.getFragmentCount() - 1) {
                int n5 = off;
                data[n5] = (byte)(data[n5] | 1);
            }
            int fragSize = state.fragmentSize(fragment);
            DataHelper.toLong(data, ++off, 2, fragSize);
            int n6 = off;
            data[n6] = (byte)(data[n6] & 0x3F);
            int sz = state.writeFragment(data, off += 2, fragment);
            off += sz;
            sizeWritten += sz;
        }
        if (sizeWritten != dataSize) {
            if (sizeWritten < 0) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Write failed for " + DataHelper.toString(fragments));
                }
            } else {
                this._log.error("Size written: " + sizeWritten + " but size: " + dataSize + " for " + DataHelper.toString(fragments));
            }
            packet.release();
            return null;
        }
        if (dataSize == 0) {
            this._log.error("Sending zero-size fragment??? for " + DataHelper.toString(fragments));
        }
        off = this.pad1(data, off);
        off = this.pad2(data, off, currentMTU - (ipHeaderSize + 8));
        pkt.setLength(off);
        if (msg != null) {
            msg.append("; Packet size ").append(off + (ipHeaderSize + 8) + " bytes");
            this._log.info(msg.toString());
        }
        this.authenticate(packet, peer.getCurrentCipherKey(), peer.getCurrentMACKey());
        PacketBuilder.setTo(packet, peer.getRemoteIPAddress(), peer.getRemotePort());
        if (this._log.shouldWarn()) {
            int maxMTU;
            int n7 = maxMTU = peer.isIPv6() ? 1488 : 1484;
            if (off + (ipHeaderSize + 8) > maxMTU) {
                this._log.warn("Size is " + off + " for " + packet + " data size " + dataSize + " pkt size " + (off + (ipHeaderSize + 8)) + " MTU " + currentMTU + ' ' + availableForAcks + " for all ACKs, " + availableForExplicitAcks + " for full ACKs, " + explicitToSend + " full ACKs included, " + partialAcksToSend + " partial ACKs included,  Fragments: " + DataHelper.toString(fragments), new Exception());
            }
        }
        packet.setPriority(priority);
        return packet;
    }

    public UDPPacket buildPing(PeerState peer) {
        return this.buildACK(peer, Collections.emptyList());
    }

    public UDPPacket buildACK(PeerState peer, List<ACKBitfield> ackBitfields) {
        int i;
        UDPPacket packet = this.buildPacketHeader((byte)96);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        StringBuilder msg = null;
        if (this._log.shouldDebug()) {
            msg = new StringBuilder(128);
            msg.append("Building ACK packet to [").append(peer.getRemotePeer().toBase64().substring(0, 6) + "]\n* ");
        }
        int fullACKCount = 0;
        int partialACKCount = 0;
        for (i = 0; i < ackBitfields.size(); ++i) {
            if (ackBitfields.get(i).receivedComplete()) {
                ++fullACKCount;
                continue;
            }
            ++partialACKCount;
        }
        if (fullACKCount > 255 || partialACKCount > 255) {
            throw new IllegalArgumentException("Too many ACKs full/partial " + fullACKCount + '/' + partialACKCount);
        }
        if (fullACKCount > 0) {
            int n = off;
            data[n] = (byte)(data[n] | 0xFFFFFF80);
        }
        if (partialACKCount > 0) {
            int n = off;
            data[n] = (byte)(data[n] | 0x40);
        }
        ++off;
        if (fullACKCount > 0) {
            data[off++] = (byte)fullACKCount;
            for (i = 0; i < ackBitfields.size(); ++i) {
                ACKBitfield bf = ackBitfields.get(i);
                if (!bf.receivedComplete()) continue;
                DataHelper.toLong(data, off, 4, bf.getMessageId());
                off += 4;
                if (msg == null) continue;
                msg.append(" Full ACK: ").append(bf.getMessageId());
            }
        }
        if (partialACKCount > 0) {
            data[off++] = (byte)partialACKCount;
            for (i = 0; i < ackBitfields.size(); ++i) {
                ACKBitfield bitfield = ackBitfields.get(i);
                if (bitfield.receivedComplete()) continue;
                DataHelper.toLong(data, off, 4, bitfield.getMessageId());
                off += 4;
                int bits = bitfield.highestReceived() + 1;
                int size = bits / 7;
                if (bits == 0 || bits % 7 > 0) {
                    ++size;
                }
                for (int curByte = 0; curByte < size; ++curByte) {
                    data[off] = curByte + 1 < size ? -128 : 0;
                    for (int curBit = 0; curBit < 7; ++curBit) {
                        if (!bitfield.received(curBit + 7 * curByte)) continue;
                        int n = off;
                        data[n] = (byte)(data[n] | (byte)(1 << curBit));
                    }
                    ++off;
                }
                if (msg == null) continue;
                msg.append(" partial ACK: ").append(bitfield).append(" with ACK bytes: ").append(size);
            }
        }
        data[off++] = 0;
        if (msg != null) {
            this._log.debug(msg.toString());
        }
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, peer.getCurrentCipherKey(), peer.getCurrentMACKey());
        PacketBuilder.setTo(packet, peer.getRemoteIPAddress(), peer.getRemotePort());
        packet.setPriority(fullACKCount > 0 || partialACKCount > 0 ? 550 : 100);
        return packet;
    }

    public UDPPacket buildSessionCreatedPacket(InboundEstablishState state, int externalPort, SessionKey ourIntroKey) {
        int padding;
        UDPPacket packet = this.buildPacketHeader((byte)16);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        InetAddress to = null;
        try {
            to = InetAddress.getByAddress(state.getSentIP());
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldError()) {
                this._log.error("How did we think this was a valid IP address?  " + state.getRemoteHostId().toString());
            }
            packet.release();
            return null;
        }
        state.prepareSessionCreated();
        byte[] sentIP = state.getSentIP();
        if (sentIP == null || sentIP.length <= 0 || !this._transport.isValid(sentIP)) {
            if (this._log.shouldError()) {
                this._log.error("How did our sent IP address become invalid? " + state);
            }
            state.fail();
            packet.release();
            return null;
        }
        System.arraycopy(state.getSentY(), 0, data, off, state.getSentY().length);
        off += state.getSentY().length;
        data[off++] = (byte)sentIP.length;
        System.arraycopy(sentIP, 0, data, off, sentIP.length);
        DataHelper.toLong(data, off += sentIP.length, 2, state.getSentPort());
        DataHelper.toLong(data, off += 2, 4, state.getSentRelayTag());
        DataHelper.toLong(data, off += 4, 4, state.getSentSignedOnTime());
        Signature sig = state.getSentSignature();
        int siglen = sig.length();
        System.arraycopy(sig.getData(), 0, data, off += 4, siglen);
        off += siglen;
        int rem = siglen % 16;
        if (rem > 0) {
            padding = 16 - rem;
            this._context.random().nextBytes(data, off, padding);
            off += padding;
        } else {
            padding = 0;
        }
        if (this._log.shouldDebug()) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("Sending SessionCreated:");
            buf.append(" Alice: ").append(Addresses.toString(sentIP, state.getSentPort()));
            buf.append(" Bob: ").append(Addresses.toString(state.getReceivedOurIP(), externalPort));
            buf.append(" RelayTag: ").append(state.getSentRelayTag());
            buf.append("\n* SignedOn: ").append(state.getSentSignedOnTime());
            buf.append("\n* Signature: ").append(Base64.encode(sig.getData()));
            buf.append("\n* RawCreated: ").append(Base64.encode(data, 0, off));
            buf.append("\n* SignedTime: ").append(Base64.encode(data, off - padding - siglen - 4, 4));
            this._log.debug(buf.toString());
        }
        byte[] iv = SimpleByteCache.acquire(16);
        this._context.random().nextBytes(iv);
        int encrWrite = siglen + padding;
        int sigBegin = off - encrWrite;
        this._context.aes().encrypt(data, sigBegin, data, sigBegin, state.getCipherKey(), iv, encrWrite);
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, ourIntroKey, ourIntroKey, iv);
        PacketBuilder.setTo(packet, to, state.getSentPort());
        SimpleByteCache.release(iv);
        packet.setMessageType(53);
        packet.setPriority(550);
        return packet;
    }

    public UDPPacket buildSessionRequestPacket(OutboundEstablishState state) {
        byte[] options;
        int off = 37;
        boolean ext = state.isExtendedOptionsAllowed();
        if (ext) {
            options = new byte[2];
            boolean intro = state.needIntroduction();
            if (intro) {
                options[1] = 1;
            }
            if (this._log.shouldInfo()) {
                this._log.info("Sending SessionRequest with extended options; need intro? " + intro + ' ' + state);
            }
            off += 3;
        } else {
            options = null;
        }
        UDPPacket packet = this.buildPacketHeader((byte)0, options);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        byte[] toIP = state.getSentIP();
        if (!this._transport.isValid(toIP)) {
            packet.release();
            return null;
        }
        InetAddress to = null;
        try {
            to = InetAddress.getByAddress(toIP);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldError()) {
                this._log.error("How did we think this was a valid IP address? " + state.getRemoteHostId().toString());
            }
            packet.release();
            return null;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Sending SessionRequest to " + Addresses.toString(toIP));
        }
        byte[] x = state.getSentX();
        System.arraycopy(x, 0, data, off, x.length);
        off += x.length;
        data[off++] = (byte)toIP.length;
        System.arraycopy(toIP, 0, data, off, toIP.length);
        int port = state.getSentPort();
        DataHelper.toLong(data, off += toIP.length, 2, port);
        off += 2;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, state.getIntroKey(), state.getIntroKey());
        PacketBuilder.setTo(packet, to, port);
        packet.setMessageType(52);
        packet.setPriority(550);
        return packet;
    }

    public UDPPacket[] buildSessionConfirmedPackets(OutboundEstablishState state, RouterIdentity ourIdentity) {
        byte[] identity = ourIdentity.toByteArray();
        int numFragments = identity.length / 512;
        if (numFragments * 512 != identity.length) {
            ++numFragments;
        }
        UDPPacket[] packets = new UDPPacket[numFragments];
        for (int i = 0; i < numFragments; ++i) {
            packets[i] = this.buildSessionConfirmedPacket(state, i, numFragments, identity);
        }
        return packets;
    }

    private UDPPacket buildSessionConfirmedPacket(OutboundEstablishState state, int fragmentNum, int numFragments, byte[] identity) {
        UDPPacket packet = this.buildPacketHeader((byte)32);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        InetAddress to = null;
        try {
            to = InetAddress.getByAddress(state.getSentIP());
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldError()) {
                this._log.error("How did we think this was a valid IP address? " + state.getRemoteHostId().toString());
            }
            packet.release();
            return null;
        }
        data[off] = (byte)(fragmentNum << 4);
        int n = off++;
        data[n] = (byte)(data[n] | numFragments & 0xF);
        int curFragSize = 512;
        if (fragmentNum == numFragments - 1 && identity.length % 512 != 0) {
            curFragSize = identity.length % 512;
        }
        DataHelper.toLong(data, off, 2, curFragSize);
        int curFragOffset = fragmentNum * 512;
        System.arraycopy(identity, curFragOffset, data, off += 2, curFragSize);
        off += curFragSize;
        if (fragmentNum == numFragments - 1) {
            DataHelper.toLong(data, off, 4, state.getSentSignedOnTime());
            Signature sig = state.getSentSignature();
            int siglen = sig.length();
            int mod = (off += 4) + siglen & 0xF;
            if (mod != 0) {
                int paddingRequired = 16 - mod;
                this._context.random().nextBytes(data, off, paddingRequired);
                off += paddingRequired;
            }
            System.arraycopy(sig.getData(), 0, data, off, siglen);
            off += siglen;
        } else {
            off = this.pad1(data, off);
        }
        pkt.setLength(off);
        this.authenticate(packet, state.getCipherKey(), state.getMACKey());
        PacketBuilder.setTo(packet, to, state.getSentPort());
        packet.setMessageType(51);
        packet.setPriority(550);
        return packet;
    }

    public UDPPacket buildSessionDestroyPacket(PeerState peer) {
        if (this._log.shouldDebug()) {
            this._log.debug("Building SessionDestroy packet to " + peer.getRemotePeer());
        }
        return this.buildSessionDestroyPacket(peer.getCurrentCipherKey(), peer.getCurrentMACKey(), peer.getRemoteIPAddress(), peer.getRemotePort());
    }

    public UDPPacket buildSessionDestroyPacket(OutboundEstablishState peer) {
        InetAddress addr;
        SessionKey cipherKey = peer.getCipherKey();
        SessionKey macKey = peer.getMACKey();
        byte[] ip = peer.getSentIP();
        int port = peer.getSentPort();
        if (cipherKey == null || macKey == null || ip == null || port <= 0) {
            if (this._log.shouldDebug()) {
                this._log.debug("Cannot send SessionDestroy packet to " + peer + " - incomplete info");
            }
            return null;
        }
        try {
            addr = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Building SessionDestroy packet to " + peer);
        }
        return this.buildSessionDestroyPacket(cipherKey, macKey, addr, port);
    }

    public UDPPacket buildSessionDestroyPacket(InboundEstablishState peer) {
        InetAddress addr;
        SessionKey cipherKey = peer.getCipherKey();
        SessionKey macKey = peer.getMACKey();
        byte[] ip = peer.getSentIP();
        int port = peer.getSentPort();
        if (cipherKey == null || macKey == null || ip == null || port <= 0) {
            if (this._log.shouldDebug()) {
                this._log.debug("Cannot send SessionDestroy packet to " + peer + " - incomplete info");
            }
            return null;
        }
        try {
            addr = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Building SessionDestroy packet to " + peer);
        }
        return this.buildSessionDestroyPacket(cipherKey, macKey, addr, port);
    }

    private UDPPacket buildSessionDestroyPacket(SessionKey cipherKey, SessionKey macKey, InetAddress addr, int port) {
        UDPPacket packet = this.buildPacketHeader((byte)-128);
        int off = 37;
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, cipherKey, macKey);
        PacketBuilder.setTo(packet, addr, port);
        packet.setPriority(100);
        return packet;
    }

    public UDPPacket buildPeerTestFromAlice(InetAddress toIP, int toPort, SessionKey toIntroKey, long nonce, SessionKey aliceIntroKey) {
        return this.buildPeerTestFromAlice(toIP, toPort, toIntroKey, toIntroKey, nonce, aliceIntroKey);
    }

    public UDPPacket buildPeerTestFromAlice(InetAddress toIP, int toPort, SessionKey toCipherKey, SessionKey toMACKey, long nonce, SessionKey aliceIntroKey) {
        UDPPacket packet = this.buildPacketHeader((byte)112);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        if (this._log.shouldDebug()) {
            this._log.debug("Sending Peer Test " + nonce + " to Bob");
        }
        DataHelper.toLong(data, off, 4, nonce);
        off += 4;
        data[off++] = 0;
        DataHelper.toLong(data, off, 2, 0L);
        System.arraycopy(aliceIntroKey.getData(), 0, data, off += 2, 32);
        off += 32;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, toCipherKey, toMACKey);
        PacketBuilder.setTo(packet, toIP, toPort);
        packet.setMessageType(50);
        packet.setPriority(100);
        return packet;
    }

    public UDPPacket buildPeerTestToAlice(InetAddress aliceIP, int alicePort, SessionKey aliceIntroKey, SessionKey charlieIntroKey, long nonce) {
        return this.buildPeerTestToAlice(aliceIP, alicePort, aliceIntroKey, aliceIntroKey, charlieIntroKey, nonce);
    }

    public UDPPacket buildPeerTestToAlice(InetAddress aliceIP, int alicePort, SessionKey aliceCipherKey, SessionKey aliceMACKey, SessionKey charlieIntroKey, long nonce) {
        UDPPacket packet = this.buildPacketHeader((byte)112);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        if (this._log.shouldDebug()) {
            this._log.debug("Sending Peer Test " + nonce + " to Alice");
        }
        DataHelper.toLong(data, off, 4, nonce);
        off += 4;
        byte[] ip = aliceIP.getAddress();
        data[off++] = (byte)ip.length;
        System.arraycopy(ip, 0, data, off, ip.length);
        DataHelper.toLong(data, off += ip.length, 2, alicePort);
        System.arraycopy(charlieIntroKey.getData(), 0, data, off += 2, 32);
        off += 32;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, aliceCipherKey, aliceMACKey);
        PacketBuilder.setTo(packet, aliceIP, alicePort);
        packet.setMessageType(49);
        packet.setPriority(100);
        return packet;
    }

    public UDPPacket buildPeerTestToCharlie(InetAddress aliceIP, int alicePort, SessionKey aliceIntroKey, long nonce, InetAddress charlieIP, int charliePort, SessionKey charlieCipherKey, SessionKey charlieMACKey) {
        UDPPacket packet = this.buildPacketHeader((byte)112);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        if (this._log.shouldDebug()) {
            this._log.debug("Sending Peer Test " + nonce + " to Charlie");
        }
        DataHelper.toLong(data, off, 4, nonce);
        off += 4;
        byte[] ip = aliceIP.getAddress();
        data[off++] = (byte)ip.length;
        System.arraycopy(ip, 0, data, off, ip.length);
        DataHelper.toLong(data, off += ip.length, 2, alicePort);
        System.arraycopy(aliceIntroKey.getData(), 0, data, off += 2, 32);
        off += 32;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, charlieCipherKey, charlieMACKey);
        PacketBuilder.setTo(packet, charlieIP, charliePort);
        packet.setMessageType(48);
        packet.setPriority(100);
        return packet;
    }

    public UDPPacket buildPeerTestToBob(InetAddress bobIP, int bobPort, InetAddress aliceIP, int alicePort, SessionKey aliceIntroKey, long nonce, SessionKey bobCipherKey, SessionKey bobMACKey) {
        UDPPacket packet = this.buildPacketHeader((byte)112);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        if (this._log.shouldDebug()) {
            this._log.debug("Sending Peer Test " + nonce + " to Bob");
        }
        DataHelper.toLong(data, off, 4, nonce);
        off += 4;
        byte[] ip = aliceIP.getAddress();
        data[off++] = (byte)ip.length;
        System.arraycopy(ip, 0, data, off, ip.length);
        DataHelper.toLong(data, off += ip.length, 2, alicePort);
        System.arraycopy(aliceIntroKey.getData(), 0, data, off += 2, 32);
        off += 32;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, bobCipherKey, bobMACKey);
        PacketBuilder.setTo(packet, bobIP, bobPort);
        packet.setMessageType(47);
        packet.setPriority(100);
        return packet;
    }

    public List<UDPPacket> buildRelayRequest(UDPTransport transport, EstablishmentManager emgr, OutboundEstablishState state, SessionKey ourIntroKey) {
        UDPAddress addr = state.getRemoteAddress();
        int count = addr.getIntroducerCount();
        ArrayList<UDPPacket> rv = new ArrayList<UDPPacket>(count);
        long cutoff = this._context.clock().now() + 300000L;
        for (int i = 0; i < count; ++i) {
            UDPPacket pkt;
            InetAddress iaddr = addr.getIntroducerHost(i);
            int iport = addr.getIntroducerPort(i);
            byte[] ikey = addr.getIntroducerKey(i);
            long tag = addr.getIntroducerTag(i);
            long exp = addr.getIntroducerExpiration(i);
            if (iaddr == null) {
                if (!this._log.shouldInfo()) continue;
                this._log.info("Cannot build a RelayRequest for [" + state.getRemoteIdentity().calculateHash().toBase64().substring(0, 6) + "] slot " + i + " -> No address");
                continue;
            }
            if (ikey == null || tag <= 0L) {
                if (!this._log.shouldWarn()) continue;
                this._log.warn("Cannot build a RelayRequest for [" + state.getRemoteIdentity().calculateHash().toBase64().substring(0, 6) + "] slot " + i + " -> No key/tag");
                continue;
            }
            if (exp > 0L && exp < cutoff) {
                if (!this._log.shouldWarn()) continue;
                this._log.warn("Cannot build a RelayRequest for " + Addresses.toString(iaddr.getAddress(), iport) + " [" + state.getRemoteIdentity().calculateHash().toBase64().substring(0, 6) + "] \n* Expired: " + DataHelper.formatTime(exp));
                continue;
            }
            if (!emgr.isValid(iaddr.getAddress(), iport) || Arrays.equals(iaddr.getAddress(), this._transport.getExternalIP()) && !this._transport.allowLocal()) {
                if (!this._log.shouldWarn()) continue;
                this._log.warn("Cannot build a RelayRequest for [" + state.getRemoteIdentity().calculateHash().toBase64().substring(0, 6) + "] \n* Reason: Introducer address is INVALID or blocklisted: " + Addresses.toString(iaddr.getAddress(), iport));
                continue;
            }
            SessionKey cipherKey = null;
            SessionKey macKey = null;
            PeerState bobState = null;
            if (ikey.length == 32) {
                bobState = transport.getPeerState(new Hash(ikey));
            }
            if (bobState == null) {
                RemoteHostId rhid = new RemoteHostId(iaddr.getAddress(), iport);
                bobState = transport.getPeerState(rhid);
            }
            if (bobState != null) {
                if (bobState.getVersion() > 1) {
                    if (!this._log.shouldWarn()) continue;
                    this._log.warn("Cannot build SSU1 RelayRequest for [" + state.getRemoteIdentity().calculateHash().toBase64().substring(0, 6) + "] through SSU2-connected Introducer " + bobState);
                    continue;
                }
                cipherKey = bobState.getCurrentCipherKey();
                macKey = bobState.getCurrentMACKey();
            }
            if (cipherKey == null || macKey == null) {
                macKey = cipherKey = new SessionKey(ikey);
                if (this._log.shouldInfo()) {
                    this._log.info("Sending RelayRequest (with intro key) to " + Addresses.toString(iaddr.getAddress(), iport));
                }
            } else if (this._log.shouldInfo()) {
                this._log.info("Sending RelayRequest (in-session) to " + Addresses.toString(iaddr.getAddress(), iport));
            }
            if ((pkt = this.buildRelayRequest(iaddr, iport, cipherKey, macKey, tag, ourIntroKey, state.getIntroNonce())) != null) {
                rv.add(pkt);
                continue;
            }
            if (!this._log.shouldWarn()) continue;
            this._log.warn("Cannot build a RelayRequest for " + Addresses.toString(iaddr.getAddress(), iport) + " [" + state.getRemoteIdentity().calculateHash().toBase64().substring(0, 6) + "] -> No valid address to send to");
        }
        return rv;
    }

    private UDPPacket buildRelayRequest(InetAddress introHost, int introPort, SessionKey cipherKey, SessionKey macKey, long introTag, SessionKey ourIntroKey, long introNonce) {
        int ourPort;
        byte[] ourIP;
        UDPPacket packet = this.buildPacketHeader((byte)48);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        if (introHost instanceof Inet6Address) {
            RouterAddress ra = this._transport.getCurrentExternalAddress(true);
            if (ra == null && (ra = this._transport.getCurrentExternalAddress(false)) == null) {
                return null;
            }
            byte[] ip = ra.getIP();
            if (ip == null) {
                return null;
            }
            if (ip.length != 16) {
                ourIP = ip;
                ourPort = this._transport.getRequestedPort();
            } else {
                ourIP = null;
                ourPort = 0;
            }
        } else {
            ourIP = null;
            ourPort = 0;
        }
        DataHelper.toLong(data, off, 4, introTag);
        off += 4;
        if (ourIP != null) {
            data[off++] = (byte)ourIP.length;
            System.arraycopy(ourIP, 0, data, off, ourIP.length);
            off += ourIP.length;
        } else {
            data[off++] = 0;
        }
        DataHelper.toLong(data, off, 2, ourPort);
        off += 2;
        data[off++] = 0;
        System.arraycopy(ourIntroKey.getData(), 0, data, off, 32);
        off += 32;
        if (this._log.shouldDebug()) {
            this._log.debug("Wrote Alice intro key: " + Base64.encode(data, off - 32, 32) + " with nonce " + introNonce + " size=" + (off + 4 + (16 - (off + 4) % 16)) + " and data: " + Base64.encode(data, 0, off));
        }
        DataHelper.toLong(data, off, 4, introNonce);
        off += 4;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, cipherKey, macKey);
        PacketBuilder.setTo(packet, introHost, introPort);
        packet.setMessageType(46);
        packet.setPriority(550);
        return packet;
    }

    UDPPacket buildRelayIntro(RemoteHostId alice, PeerState charlie, UDPPacketReader.RelayRequestReader request) {
        UDPPacket packet = this.buildPacketHeader((byte)80);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        if (this._log.shouldInfo()) {
            this._log.info("Sending intro to " + charlie + " for " + alice);
        }
        byte[] ip = alice.getIP();
        data[off++] = (byte)ip.length;
        System.arraycopy(ip, 0, data, off, ip.length);
        DataHelper.toLong(data, off += ip.length, 2, alice.getPort());
        off += 2;
        int sz = request.readChallengeSize();
        data[off++] = (byte)sz;
        if (sz > 0) {
            request.readChallengeData(data, off);
            off += sz;
        }
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, charlie.getCurrentCipherKey(), charlie.getCurrentMACKey());
        PacketBuilder.setTo(packet, charlie.getRemoteIPAddress(), charlie.getRemotePort());
        packet.setMessageType(45);
        packet.setPriority(100);
        return packet;
    }

    UDPPacket buildRelayResponse(RemoteHostId alice, PeerState charlie, long nonce, SessionKey cipherKey, SessionKey macKey) {
        InetAddress aliceAddr = null;
        try {
            aliceAddr = InetAddress.getByAddress(alice.getIP());
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        UDPPacket packet = this.buildPacketHeader((byte)64);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        if (this._log.shouldInfo()) {
            this._log.info("Sending RelayResponse to " + alice + " for " + charlie + " with key " + cipherKey);
        }
        byte[] charlieIP = charlie.getRemoteIP();
        data[off++] = (byte)charlieIP.length;
        System.arraycopy(charlieIP, 0, data, off, charlieIP.length);
        DataHelper.toLong(data, off += charlieIP.length, 2, charlie.getRemotePort());
        off += 2;
        byte[] aliceIP = alice.getIP();
        data[off++] = (byte)aliceIP.length;
        System.arraycopy(aliceIP, 0, data, off, aliceIP.length);
        DataHelper.toLong(data, off += aliceIP.length, 2, alice.getPort());
        DataHelper.toLong(data, off += 2, 4, nonce);
        off += 4;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, cipherKey, macKey);
        PacketBuilder.setTo(packet, aliceAddr, alice.getPort());
        packet.setMessageType(44);
        packet.setPriority(100);
        return packet;
    }

    public UDPPacket buildHolePunch(InetAddress to, int port) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        if (this._log.shouldInfo()) {
            this._log.info("Sending relayholepunchto " + to + ":" + port);
        }
        packet.getPacket().setLength(0);
        PacketBuilder.setTo(packet, to, port);
        packet.setMessageType(43);
        packet.setPriority(550);
        return packet;
    }

    public UDPPacket buildPacket(byte[] data, InetAddress to, int port) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] d = packet.getPacket().getData();
        System.arraycopy(data, 0, d, 0, data.length);
        packet.getPacket().setLength(data.length);
        PacketBuilder.setTo(packet, to, port);
        return packet;
    }

    private UDPPacket buildPacketHeader(byte flagByte) {
        return this.buildPacketHeader(flagByte, null);
    }

    private UDPPacket buildPacketHeader(byte flagByte, byte[] extendedOptions) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        if (extendedOptions != null) {
            flagByte = (byte)(flagByte | 4);
        }
        data[off] = flagByte;
        long now = (this._context.clock().now() + 500L) / 1000L;
        DataHelper.toLong(data, ++off, 4, now);
        if (extendedOptions != null) {
            off += 4;
            int len = extendedOptions.length;
            if (len > 255) {
                throw new IllegalArgumentException();
            }
            data[off++] = (byte)len;
            System.arraycopy(extendedOptions, 0, data, off, len);
        }
        return packet;
    }

    private static void setTo(UDPPacket packet, InetAddress ip, int port) {
        DatagramPacket pkt = packet.getPacket();
        pkt.setAddress(ip);
        pkt.setPort(port);
    }

    private int pad1(byte[] data, int off) {
        int mod = off & 0xF;
        if (mod == 0) {
            return off;
        }
        int padSize = 16 - mod;
        this._context.random().nextBytes(data, off, padSize);
        return off + padSize;
    }

    private int pad2(byte[] data, int off) {
        if (!this._context.getProperty(PROP_PADDING, true)) {
            return off;
        }
        int padSize = this._context.random().nextInt(16);
        if (padSize == 0) {
            return off;
        }
        this._context.random().nextBytes(data, off, padSize);
        return off + padSize;
    }

    private int pad2(byte[] data, int off, int maxLen) {
        if (!this._context.getProperty(PROP_PADDING, true)) {
            return off;
        }
        if (off >= maxLen) {
            return off;
        }
        int padSize = this._context.random().nextInt(Math.min(16, 1 + maxLen - off));
        if (padSize == 0) {
            return off;
        }
        this._context.random().nextBytes(data, off, padSize);
        return off + padSize;
    }

    private void authenticate(UDPPacket packet, SessionKey cipherKey, SessionKey macKey) {
        byte[] iv = SimpleByteCache.acquire(16);
        this._context.random().nextBytes(iv);
        this.authenticate(packet, cipherKey, macKey, iv);
        SimpleByteCache.release(iv);
    }

    private void authenticate(UDPPacket packet, SessionKey cipherKey, SessionKey macKey, byte[] iv) {
        int off;
        DatagramPacket pkt = packet.getPacket();
        int hmacOff = off = pkt.getOffset();
        int encryptOffset = off + 16 + 16;
        int totalSize = pkt.getLength() - 16 - 16 - off;
        int mod = totalSize & 0xF;
        int encryptSize = totalSize - mod;
        byte[] data = pkt.getData();
        this._context.aes().encrypt(data, encryptOffset, data, encryptOffset, cipherKey, iv, encryptSize);
        System.arraycopy(data, encryptOffset, data, off, totalSize);
        System.arraycopy(iv, 0, data, off += totalSize, 16);
        off += 16;
        int plval = totalSize;
        int netid = this._context.router().getNetworkID();
        if (netid != 2) {
            plval ^= netid - 2 << 8;
        }
        DataHelper.toLong(data, off, 2, plval);
        int hmacLen = totalSize + 16 + 2;
        byte[] ba = SimpleByteCache.acquire(32);
        this._transport.getHMAC().calculate(macKey, data, hmacOff, hmacLen, ba, 0);
        if (this._log.shouldDebug()) {
            this._log.debug("Authenticating UDP packet (" + pkt.getLength() + " bytes)\n* IV: " + Base64.encode(iv) + "\n* Raw MAC: " + Base64.encode(ba) + "\n* MAC key: " + macKey);
        }
        System.arraycopy(data, hmacOff, data, encryptOffset, totalSize);
        System.arraycopy(ba, 0, data, hmacOff, 16);
        SimpleByteCache.release(ba);
        System.arraycopy(iv, 0, data, hmacOff + 16, 16);
    }

    public static class Fragment {
        public final OutboundMessageState state;
        public final int num;

        public Fragment(OutboundMessageState state, int num) {
            this.state = state;
            this.num = num;
        }

        public String toString() {
            return "Fragment " + this.num + " (" + this.state.fragmentSize(this.num) + " bytes)" + this.state;
        }
    }
}

