/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import com.southernstorm.noise.protocol.CipherState;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.InboundMessageState;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Bitfield;
import net.i2p.router.transport.udp.SSU2Header;
import net.i2p.router.transport.udp.SSU2Payload;
import net.i2p.router.transport.udp.SSU2Sender;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.HexDump;
import net.i2p.util.SimpleTimer2;

public class PeerState2
extends PeerState
implements SSU2Payload.PayloadCallback,
SSU2Bitfield.Callback,
SSU2Sender {
    private final long _sendConnID;
    private final long _rcvConnID;
    private final AtomicInteger _packetNumber = new AtomicInteger();
    private final AtomicInteger _lastAckHashCode = new AtomicInteger(-1);
    private final CipherState _sendCha;
    private final CipherState _rcvCha;
    private final byte[] _sendHeaderEncryptKey1;
    private final byte[] _rcvHeaderEncryptKey1;
    private final byte[] _sendHeaderEncryptKey2;
    private final byte[] _rcvHeaderEncryptKey2;
    private final SSU2Bitfield _receivedMessages;
    private final SSU2Bitfield _ackedMessages;
    private final ConcurrentHashMap<Long, List<PacketBuilder.Fragment>> _sentMessages;
    private final ACKTimer _ackTimer;
    private long _sentMessagesLastExpired;
    private byte[] _ourIP;
    private int _ourPort;
    private int _destroyReason;
    private byte[][] _sessConfForReTX;
    private long _sessConfSentTime;
    private int _sessConfSentCount;
    private final Object _migrationLock = new Object();
    private MigrationState _migrationState = MigrationState.MIGRATION_STATE_NONE;
    private long _migrationStarted;
    private long _migrationNextSendTime;
    private byte[] _pathChallengeData;
    private long _pathChallengeSendCount;
    private RemoteHostId _pendingRemoteHostId;
    private RemoteHostId _previousRemoteHostId;
    private static final int MAX_PATH_CHALLENGE_SENDS = 4;
    private static final long MAX_PATH_CHALLENGE_TIME = 30000L;
    private static final long PATH_CHALLENGE_DELAY = 5000L;
    public static final int MIN_SSU_IPV4_MTU = 1292;
    public static final int MAX_SSU_IPV4_MTU = 1484;
    public static final int DEFAULT_SSU_IPV4_MTU = 1484;
    public static final int MIN_SSU_IPV6_MTU = 1280;
    public static final int MAX_SSU_IPV6_MTU = 1488;
    public static final int DEFAULT_SSU_IPV6_MTU = 1280;
    public static final int MIN_MTU = 1280;
    public static final int MAX_MTU = 1500;
    public static final int DEFAULT_MTU = 1500;
    private static final int BITFIELD_SIZE = 512;
    private static final int MAX_SESS_CONF_RETX = 5;
    private static final long SENT_MESSAGES_CLEAN_TIME = 60000L;

    public PeerState2(RouterContext ctx, UDPTransport transport, InetSocketAddress remoteAddress, Hash remotePeer, boolean isInbound, int rtt, CipherState sendCha, CipherState rcvCha, long sendID, long rcvID, byte[] sendHdrKey1, byte[] sendHdrKey2, byte[] rcvHdrKey2) {
        super(ctx, transport, remoteAddress, remotePeer, isInbound, rtt);
        this._sendConnID = sendID;
        this._rcvConnID = rcvID;
        this._sendCha = sendCha;
        this._rcvCha = rcvCha;
        this._sendHeaderEncryptKey1 = sendHdrKey1;
        this._rcvHeaderEncryptKey1 = transport.getSSU2StaticIntroKey();
        this._sendHeaderEncryptKey2 = sendHdrKey2;
        this._rcvHeaderEncryptKey2 = rcvHdrKey2;
        this._receivedMessages = new SSU2Bitfield(512, 0L);
        this._ackedMessages = new SSU2Bitfield(512, 0L);
        this._sentMessages = new ConcurrentHashMap(32);
        this._sentMessagesLastExpired = this._keyEstablishedTime;
        if (isInbound) {
            this._receivedMessages.set(0L);
        } else {
            this._packetNumber.set(1);
        }
        this._ackTimer = new ACKTimer();
    }

    void sendAck0() {
        if (!this._isInbound) {
            return;
        }
        long tag = this.getWeRelayToThemAs();
        try {
            UDPPacket pkt;
            if (tag > 0L) {
                SSU2Payload.RelayTagBlock block = new SSU2Payload.RelayTagBlock(tag);
                pkt = this._transport.getBuilder2().buildPacket(Collections.emptyList(), Collections.singletonList(block), (SSU2Sender)this);
                if (this._log.shouldInfo()) {
                    this._log.info("Sending ack 0 with tag " + tag + " on " + this);
                }
            } else {
                pkt = this._transport.getBuilder2().buildACK(this);
            }
            this._transport.send(pkt);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    int fragmentSize() {
        return this._mtu - (this._remoteIP.length == 4 ? 60 : 80) - 8;
    }

    @Override
    int fragmentOverhead() {
        return (this._remoteIP.length == 4 ? 60 : 80) + 3 + 5;
    }

    @Override
    void clearWantedACKSendSince() {
        if (this._sentMessages.isEmpty()) {
            this._wantACKSendSince = 0L;
        }
    }

    @Override
    protected synchronized void messagePartiallyReceived(long now) {
        if (this._wantACKSendSince <= 0L) {
            this._wantACKSendSince = now;
            this._ackTimer.schedule();
        }
    }

    @Override
    int finishMessages(long now) {
        if (now >= this._sentMessagesLastExpired + 60000L) {
            this._sentMessagesLastExpired = now;
            if (!this._sentMessages.isEmpty()) {
                long ahead = (long)this._packetNumber.get() - this._ackedMessages.getHighestSet();
                if (ahead > 512L) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Fail after " + ahead + "unacked packets on " + this);
                    }
                    this._transport.sendDestroy(this, 14);
                    this._transport.dropPeer(this, true, "Too many unacked packets");
                }
                if (this._log.shouldDebug()) {
                    this._log.debug("[SSU2] finishMessages() over " + this._sentMessages.size() + " pending acks");
                }
                Iterator<List<PacketBuilder.Fragment>> iter = this._sentMessages.values().iterator();
                block0: while (iter.hasNext()) {
                    List<PacketBuilder.Fragment> frags = iter.next();
                    for (PacketBuilder.Fragment f : frags) {
                        OutboundMessageState state = f.state;
                        if (state.isComplete() || state.isExpired(now)) continue;
                        continue block0;
                    }
                    iter.remove();
                    if (!this._log.shouldInfo()) continue;
                    this._log.info("[SSU2] Cleaned from sentMessages: " + frags);
                }
            }
        }
        return super.finishMessages(now);
    }

    @Override
    List<OutboundMessageState> allocateSend(long now) {
        if (!(this._isInbound || this._ackedMessages.getOffset() != 0L || this._ackedMessages.get(0L) || this.checkRetransmitSessionConfirmed(this._context.clock().now(), false))) {
            return null;
        }
        return super.allocateSend(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkRetransmitSessionConfirmed(long now, boolean force) {
        UDPPacket[] packets = null;
        PeerState2 peerState2 = this;
        synchronized (peerState2) {
            if (this._sessConfForReTX != null && (force || this._sessConfSentTime + (OutboundEstablishState.RETRANSMIT_DELAY << this._sessConfSentCount - 1) < now)) {
                if (this._sessConfSentCount >= 5) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("[SSU2] Fail, no SessionConfirmed ACK received " + this);
                    }
                    try {
                        UDPPacket pkt = this._transport.getBuilder2().buildSessionDestroyPacket(14, this);
                        this._transport.send(pkt);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this._transport.dropPeer(this, true, "No Sess Conf ACK rcvd");
                    this._sessConfForReTX = null;
                    return false;
                }
                ++this._sessConfSentCount;
                this._sessConfSentTime = now;
                packets = this.getRetransmitSessionConfirmedPackets();
            }
        }
        if (packets != null) {
            if (this._log.shouldInfo()) {
                this._log.info("[SSU2] Retransmitting SessionConfirmed to " + this);
            }
            for (int i = 0; i < packets.length; ++i) {
                this._transport.send(packets[i]);
            }
        }
        return true;
    }

    @Override
    List<Long> getCurrentFullACKs() {
        throw new UnsupportedOperationException();
    }

    @Override
    List<Long> getCurrentResendACKs() {
        throw new UnsupportedOperationException();
    }

    @Override
    void removeACKMessage(Long messageId) {
        throw new UnsupportedOperationException();
    }

    @Override
    void fetchPartialACKs(List<ACKBitfield> rv) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getNextPacketNumber() throws IOException {
        if (this._dead) {
            IOException ioe = new IOException("Peer is dead: " + this._remotePeer.toBase64());
            if (this._log.shouldDebug()) {
                this._log.debug("Dead: " + this, ioe);
            } else if (this._log.shouldInfo()) {
                this._log.info("Router [" + this._remotePeer.toBase64().substring(0, 6) + "] is dead: " + this);
            }
            throw ioe;
        }
        return this._packetNumber.getAndIncrement();
    }

    protected long getNextPacketNumberNoThrow() {
        return this._packetNumber.getAndIncrement();
    }

    @Override
    public long getSendConnID() {
        return this._sendConnID;
    }

    @Override
    public CipherState getSendCipher() {
        return this._sendCha;
    }

    @Override
    public byte[] getSendHeaderEncryptKey1() {
        return this._sendHeaderEncryptKey1;
    }

    @Override
    public byte[] getSendHeaderEncryptKey2() {
        return this._sendHeaderEncryptKey2;
    }

    @Override
    public void setDestroyReason(int reason) {
        this._destroyReason = reason;
    }

    long getRcvConnID() {
        return this._rcvConnID;
    }

    byte[] getRcvHeaderEncryptKey1() {
        return this._rcvHeaderEncryptKey1;
    }

    byte[] getRcvHeaderEncryptKey2() {
        return this._rcvHeaderEncryptKey2;
    }

    int getDestroyReason() {
        return this._destroyReason;
    }

    CipherState getRcvCipher() {
        return this._rcvCha;
    }

    void setOurAddress(byte[] ip, int port) {
        this._ourIP = ip;
        this._ourPort = port;
    }

    byte[] getOurIP() {
        return this._ourIP;
    }

    int getOurPort() {
        return this._ourPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSU2Bitfield getReceivedMessages() {
        PeerState2 peerState2 = this;
        synchronized (peerState2) {
            this._wantACKSendSince = 0L;
            this._lastACKSend = this._context.clock().now();
        }
        return this._receivedMessages;
    }

    @Override
    public SSU2Bitfield getAckedMessages() {
        return this._ackedMessages;
    }

    void receivePacket(UDPPacket packet) {
        this.receivePacket(packet.getRemoteHost(), packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receivePacket(RemoteHostId from, UDPPacket packet) {
        block38: {
            DatagramPacket dpacket = packet.getPacket();
            byte[] data = dpacket.getData();
            int off = dpacket.getOffset();
            int len = dpacket.getLength();
            try {
                boolean ackImmediate;
                SSU2Header.Header header = SSU2Header.trialDecryptShortHeader(packet, this._rcvHeaderEncryptKey1, this._rcvHeaderEncryptKey2);
                if (header == null) {
                    if (len > 2 && len < 35 && this._log.shouldWarn()) {
                        this._log.warn("[SSU2] Inbound packet too short [" + len + " bytes] " + this);
                    }
                    return;
                }
                if (header.getDestConnID() != this._rcvConnID) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("[SSU2] BAD Destination ConnectionID \n* " + header + " -> Size: " + len + " bytes " + this);
                    }
                    if (!this._isInbound && this._ackedMessages.getOffset() == 0L && !this._ackedMessages.get(0L)) {
                        this.checkRetransmitSessionConfirmed(this._context.clock().now(), true);
                    }
                    return;
                }
                if (header.getType() != 6) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("[SSU2] BAD " + len + " byte data packet [Type " + (header.getType() & 0xFF) + "] received " + this);
                    }
                    return;
                }
                long n = header.getPacketNumber();
                SSU2Header.acceptTrialDecrypt(packet, header);
                Object object = this._rcvCha;
                synchronized (object) {
                    this._rcvCha.setNonce(n);
                    this._rcvCha.decryptWithAd(header.data, data, off + 16, data, off + 16, len - 16);
                }
                if (this._receivedMessages.set(n)) {
                    object = this;
                    synchronized (object) {
                        ++this._packetsReceivedDuplicate;
                    }
                    if (this._log.shouldWarn()) {
                        this._log.warn("[SSU2] Duplicate packet received [#" + n + "] " + this);
                    }
                    return;
                }
                int payloadLen = len - 32;
                if (this._log.shouldDebug()) {
                    this._log.debug("[SSU2] New " + len + " byte packet [#" + n + "] received " + this);
                }
                SSU2Payload.processPayload(this._context, this, data, off + 16, payloadLen, false, from);
                this.packetReceived(payloadLen);
                if (!this._dead) {
                    boolean limitSending = false;
                    Object object2 = this._migrationLock;
                    synchronized (object2) {
                        switch (this._migrationState) {
                            case MIGRATION_STATE_NONE: {
                                if (from.equals(this._remoteHostId)) break;
                                if (from.getIP().length == this._remoteHostId.getIP().length && n == this._receivedMessages.getHighestSet() && TransportUtil.isValidPort(from.getPort()) && this._transport.isValid(from.getIP())) {
                                    if (this._log.shouldInfo()) {
                                        this._log.info("[SSU2] Starting connection migration to " + from + this);
                                    }
                                    this._migrationState = MigrationState.MIGRATION_STATE_PENDING;
                                    this._migrationStarted = this._context.clock().now();
                                    this._migrationNextSendTime = this._migrationStarted + 5000L;
                                    this._pathChallengeData = new byte[8];
                                    this._context.random().nextBytes(this._pathChallengeData);
                                    this._pathChallengeSendCount = 1L;
                                    this._pendingRemoteHostId = from;
                                    this.sendPathChallenge(dpacket.getAddress(), from.getPort());
                                    this.setLastSendTime(this._migrationStarted);
                                } else if (this._log.shouldInfo()) {
                                    this._log.info("[SSU2] Not migrating connection to " + from + this);
                                }
                                limitSending = true;
                                break;
                            }
                            case MIGRATION_STATE_PENDING: {
                                if (from.equals(this._remoteHostId)) {
                                    this._migrationState = MigrationState.MIGRATION_STATE_NONE;
                                    if (!this._log.shouldInfo()) break;
                                    this._log.info("[SSU2] Cancelling connection migration on " + this);
                                    break;
                                }
                                long now = this._context.clock().now();
                                if (now > this._migrationStarted + 30000L || this._pathChallengeSendCount > 4L) {
                                    this._migrationState = MigrationState.MIGRATION_STATE_NONE;
                                    if (!this._log.shouldWarn()) break;
                                    this._log.warn("[SSU2] Connection migration failed " + this);
                                    break;
                                }
                                if (from.equals(this._pendingRemoteHostId)) {
                                    if (this._log.shouldInfo()) {
                                        this._log.info("[SSU2] Connection migration pending, received another packet from " + from + this);
                                    }
                                    if (now > this._migrationNextSendTime) {
                                        this._migrationNextSendTime = now + (5000L << (int)this._pathChallengeSendCount);
                                        ++this._pathChallengeSendCount;
                                        this.sendPathChallenge(dpacket.getAddress(), from.getPort());
                                        this.setLastSendTime(now);
                                    }
                                    limitSending = true;
                                    break;
                                }
                                if (this._log.shouldInfo()) {
                                    this._log.info("[SSU2] Connection migration pending, received packet from 3rd address " + from + this);
                                }
                                limitSending = true;
                            }
                        }
                    }
                    if (limitSending) {
                        this.ECNReceived();
                    }
                }
                boolean bl = ackImmediate = (header.data[13] & 1) != 0;
                if (ackImmediate) {
                    this._ackTimer.scheduleImmediate();
                }
            }
            catch (Exception e) {
                if (!this._log.shouldWarn()) break block38;
                this._log.warn("[SSU2] Received BAD encrypted packet from: " + this + '\n' + HexDump.dump(data, off, len), e);
            }
        }
    }

    private void sendPathChallenge(InetAddress toIP, int toPort) {
        if (this._log.shouldInfo()) {
            this._log.info("[SSU2] Sending path challenge to " + toIP.toString().replace("/", "") + ":" + toPort + this);
        }
        ArrayList<SSU2Payload.Block> blocks = new ArrayList<SSU2Payload.Block>(3);
        blocks.add(new SSU2Payload.DateTimeBlock(this._context));
        blocks.add(new SSU2Payload.AddressBlock(toIP.getAddress(), toPort));
        blocks.add(new SSU2Payload.PathChallengeBlock(this._pathChallengeData));
        try {
            UDPPacket packet = this._transport.getBuilder2().buildPacket(Collections.emptyList(), blocks, (SSU2Sender)this);
            DatagramPacket pkt = packet.getPacket();
            pkt.setAddress(toIP);
            pkt.setPort(toPort);
            this._transport.send(packet);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void gotDateTime(long time) {
        this.adjustClockSkew(this._context.clock().now() - time - 100L);
    }

    @Override
    public void gotOptions(byte[] options, boolean isHandshake) {
    }

    @Override
    public void gotRI(RouterInfo ri, boolean isHandshake, boolean flood) throws DataFormatException {
        block10: {
            if (this._log.shouldDebug()) {
                this._log.debug("Received RouterInfo in data phase " + ri + "\non: " + this);
            }
            try {
                Hash h = ri.getHash();
                if (h.equals(this._context.routerHash())) {
                    return;
                }
                RouterInfo old = this._context.netDb().store(h, ri);
                if (flood && !ri.equals(old)) {
                    FloodfillNetworkDatabaseFacade fndf = (FloodfillNetworkDatabaseFacade)this._context.netDb();
                    if ((old == null || ri.getPublished() > old.getPublished()) && fndf.floodConditional(ri)) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Flooded RouterInfo [" + h.toBase64().substring(0, 6) + "]");
                        }
                    } else if (this._log.shouldInfo()) {
                        this._log.info("Declined flooding RouterInfo [" + h.toBase64().substring(0, 6) + "]");
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                if (this._log.shouldDebug()) {
                    this._log.debug("RouterInfo store failure: " + ri, iae);
                }
                if (!this._log.shouldWarn()) break block10;
                this._log.warn("Failed NetDBStore of RouterInfo [" + ri.getHash().toBase64().substring(0, 6) + "] \n* " + iae.getMessage());
            }
        }
    }

    @Override
    public void gotRIFragment(byte[] data, boolean isHandshake, boolean flood, boolean isGzipped, int frag, int totalFrags) {
        throw new IllegalStateException("RouterInfo fragment in Data phase");
    }

    @Override
    public void gotAddress(byte[] ip, int port) {
        this._ourIP = ip;
        this._ourPort = port;
    }

    @Override
    public void gotRelayTagRequest() {
        long tag;
        if (this._log.shouldInfo()) {
            this._log.info("[SSU2] Received RELAY TAG REQUEST " + this);
        }
        if ((tag = this.getWeRelayToThemAs()) <= 0L && this._transport.canIntroduce(this.isIPv6())) {
            tag = 1L + this._context.random().nextLong(0xFFFFFFFFL);
            this.setWeRelayToThemAs(tag);
            this._transport.getIntroManager().add(this);
        }
        if (tag > 0L) {
            SSU2Payload.RelayTagBlock block = new SSU2Payload.RelayTagBlock(tag);
            try {
                UDPPacket pkt = this._transport.getBuilder2().buildPacket(Collections.emptyList(), Collections.singletonList(block), (SSU2Sender)this);
                this._transport.send(pkt);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void gotRelayTag(long tag) {
        long old = this.getTheyRelayToUsAs();
        if (old != 0L) {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Received NEW tag [" + tag + "] but had previous tag [" + old + "] " + this);
            }
            return;
        }
        this.setTheyRelayToUsAs(tag);
        this._transport.getIntroManager().add(this);
    }

    @Override
    public void gotRelayRequest(byte[] data) {
        this._transport.getIntroManager().receiveRelayRequest(this, data);
        this.messagePartiallyReceived();
    }

    @Override
    public void gotRelayResponse(int status, byte[] data) {
        this._transport.getIntroManager().receiveRelayResponse(this, status, data);
        this.messagePartiallyReceived();
    }

    @Override
    public void gotRelayIntro(Hash aliceHash, byte[] data) {
        this._transport.getIntroManager().receiveRelayIntro(this, aliceHash, data);
        this.messagePartiallyReceived();
    }

    @Override
    public void gotPeerTest(int msg, int status, Hash h, byte[] data) {
        this._transport.getPeerTestManager().receiveTest(this._remoteHostId, this, msg, status, h, data);
        this.messagePartiallyReceived();
    }

    @Override
    public void gotToken(long token, long expires) {
        if (this._log.shouldInfo()) {
            this._log.info("[SSU2] Received TOKEN block: " + token + " expires " + DataHelper.formatTime(expires) + this);
        }
        this._transport.getEstablisher().addOutboundToken(this._remoteHostId, token, expires);
    }

    @Override
    public void gotI2NP(I2NPMessage msg) {
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Received I2NP block: " + msg);
        }
        int size = msg.getMessageSize() - 7;
        long messageId = msg.getUniqueId();
        this.messageFullyReceived(messageId, size);
        if (this._transport.getInboundFragments().messageReceived(messageId)) {
            this._context.statManager().addRateData("udp.ignoreRecentDuplicate", 1L);
            if (this._log.shouldInfo()) {
                this._log.info("[SSU2] Received duplicate message [MsgID " + messageId + "]" + this);
            }
            return;
        }
        this._transport.messageReceived(msg, null, this._remotePeer, 0L, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gotFragment(byte[] data, int off, int len, long messageId, int frag, boolean isLast) throws DataFormatException {
        boolean messageDup;
        InboundMessageState state;
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Received FRAGMENT block: " + messageId + " fragment " + frag + " (" + len + " bytes) isLast? " + isLast + " from " + this._remotePeer.toBase64());
        }
        boolean messageComplete = false;
        boolean messageExpired = false;
        Object object = this._inboundMessages;
        synchronized (object) {
            state = (InboundMessageState)this._inboundMessages.get(messageId);
            if (state == null) {
                messageDup = this._transport.getInboundFragments().wasRecentlyReceived(messageId);
                if (messageDup) {
                    state = null;
                } else {
                    state = new InboundMessageState(this._context, messageId, this._remotePeer, data, off, len, frag, isLast);
                    this._inboundMessages.put(messageId, state);
                }
            } else {
                messageDup = state.hasFragment(frag);
                if (!messageDup) {
                    boolean fragmentOK = state.receiveFragment(data, off, len, frag, isLast);
                    if (!fragmentOK) {
                        return;
                    }
                    if (state.isComplete()) {
                        messageComplete = true;
                        this._inboundMessages.remove(messageId);
                    } else if (state.isExpired()) {
                        messageExpired = true;
                        this._inboundMessages.remove(messageId);
                    }
                }
            }
        }
        if (messageDup) {
            this.messagePartiallyReceived();
            if (frag == 0) {
                this._context.statManager().addRateData("udp.ignoreRecentDuplicate", 1L);
            }
            object = this;
            synchronized (object) {
                ++this._packetsReceivedDuplicate;
            }
            if (this._log.shouldInfo()) {
                if (state != null) {
                    this._log.info("[SSU2] Recieved duplicate fragment [" + frag + "] for " + state);
                } else {
                    this._log.info("[SSU2] Received duplicate fragment [" + frag + "] " + this);
                }
                return;
            }
        }
        if (messageComplete) {
            this.messageFullyReceived(messageId, state.getCompleteSize());
            if (this._transport.getInboundFragments().messageReceived(messageId)) {
                this._context.statManager().addRateData("udp.ignoreRecentDuplicate", 1L);
                if (this._log.shouldInfo()) {
                    this._log.info("[SSU2] Received duplicate message [MsgID " + messageId + "]" + this);
                }
                return;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] Complete message received! " + state);
            }
            this._context.statManager().addRateData("udp.receivedCompleteTime", state.getLifetime(), state.getLifetime());
            this._context.statManager().addRateData("udp.receivedCompleteFragments", state.getFragmentCount(), state.getLifetime());
            this.receiveMessage(state);
        } else if (messageExpired) {
            this.messagePartiallyReceived();
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Message expired while only being partially read: " + state);
            }
            this._context.messageHistory().droppedInboundMessage(state.getMessageId(), state.getFrom(), "expired while partially read: " + state.toString());
            state.releaseResources();
        } else {
            this.messagePartiallyReceived();
        }
    }

    @Override
    public void gotACK(long ackThru, int acks, byte[] ranges) {
        block4: {
            int hc = (int)ackThru << 8 ^ acks << 24 ^ DataHelper.hashCode(ranges);
            if (this._lastAckHashCode.getAndSet(hc) == hc) {
                return;
            }
            try {
                SSU2Bitfield ackbf = SSU2Bitfield.fromACKBlock(ackThru, acks, ranges, ranges != null ? ranges.length / 2 : 0);
                if (this._log.shouldDebug()) {
                    this._log.debug("[SSU2] Received new ACK block from " + this._remotePeer.toBase64().substring(0, 6) + ' ' + SSU2Bitfield.toString(ackThru, acks, ranges, ranges != null ? ranges.length / 2 : 0));
                }
                ackbf.forEachAndNot(this._ackedMessages, this);
            }
            catch (Exception e) {
                if (!this._log.shouldWarn()) break block4;
                this._log.warn("[SSU2] Received Bad ACK block\n" + SSU2Bitfield.toString(ackThru, acks, ranges, ranges != null ? ranges.length / 2 : 0) + "\nACK through " + ackThru + " acnt " + acks + (ranges != null ? " Ranges:\n" + HexDump.dump(ranges) : "") + "" + this, e);
            }
        }
    }

    @Override
    public void gotTermination(int reason, long count) {
        if (this._log.shouldInfo()) {
            this._log.info("[SSU2] Received TERMINATION block -> Reason: " + reason + "; Count: " + count + " " + this);
        }
        if (reason != 1 && !this._dead) {
            try {
                UDPPacket pkt = this._transport.getBuilder2().buildSessionDestroyPacket(1, this);
                this._transport.send(pkt);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._transport.getEstablisher().receiveSessionDestroy(this._remoteHostId, this);
            this._dead = true;
        }
    }

    @Override
    public void gotPathChallenge(RemoteHostId from, byte[] data) {
        if (this._log.shouldInfo()) {
            this._log.info("Received PATH CHALLENGE block, length: " + data.length + " " + this);
        }
        SSU2Payload.PathResponseBlock block = new SSU2Payload.PathResponseBlock(data);
        try {
            UDPPacket pkt = this._transport.getBuilder2().buildPacket(Collections.emptyList(), Collections.singletonList(block), (SSU2Sender)this);
            this._transport.send(pkt);
            long now = this._context.clock().now();
            this.setLastSendTime(now);
            this.setLastReceiveTime(now);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gotPathResponse(RemoteHostId from, byte[] data) {
        if (this._log.shouldInfo()) {
            this._log.info("Received PATH RESPONSE block, length: " + data.length + " " + this);
        }
        Object object = this._migrationLock;
        synchronized (object) {
            switch (this._migrationState) {
                case MIGRATION_STATE_PENDING: {
                    if (from.equals(this._pendingRemoteHostId) && DataHelper.eq(data, this._pathChallengeData)) {
                        this._migrationState = MigrationState.MIGRATION_STATE_NONE;
                        this._pathChallengeData = null;
                        if (this._log.shouldInfo()) {
                            this._log.info("Connection migration successful, changed address from " + this._remoteHostId + " to " + from + this);
                        }
                        this._transport.changePeerAddress(this, from);
                        this._mtu = 1280;
                        if (this.isIPv6() || !this._transport.isSymNatted()) {
                            EstablishmentManager.Token token = this._transport.getEstablisher().getInboundToken(from);
                            SSU2Payload.NewTokenBlock block = new SSU2Payload.NewTokenBlock(token);
                            try {
                                UDPPacket pkt = this._transport.getBuilder2().buildPacket(Collections.emptyList(), Collections.singletonList(block), (SSU2Sender)this);
                                this._transport.send(pkt);
                                long now = this._context.clock().now();
                                this.setLastSendTime(now);
                                this.setLastReceiveTime(now);
                            }
                            catch (IOException iOException) {}
                            break;
                        }
                        this.messagePartiallyReceived();
                        break;
                    }
                    this.messagePartiallyReceived();
                    break;
                }
                default: {
                    this.messagePartiallyReceived();
                }
            }
        }
    }

    void changeAddress(RemoteHostId id) {
        this._previousRemoteHostId = this._remoteHostId;
        this._remoteHostId = id;
        this._remotePort = id.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveMessage(InboundMessageState state) {
        int sz = state.getCompleteSize();
        try {
            byte[] buf = new byte[sz];
            int numFragments = state.getFragmentCount();
            ByteArray[] fragments = state.getFragments();
            int off = 0;
            for (int i = 0; i < numFragments; ++i) {
                ByteArray ba = fragments[i];
                int len = ba.getValid();
                System.arraycopy(ba.getData(), 0, buf, off, len);
                off += len;
            }
            if (off != sz) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] Hmm, offset of the fragments = " + off + " while the state says " + sz);
                }
                return;
            }
            I2NPMessage msg = I2NPMessageImpl.fromRawByteArrayNTCP2(this._context, buf, 0, sz, null);
            this._transport.messageReceived(msg, null, this._remotePeer, state.getLifetime(), sz);
        }
        catch (I2NPMessageException ime) {
            if (this._log.shouldInfo()) {
                this._log.warn("[SSU2] Message invalid: " + state + "\n* PeerState: " + this + ime);
            } else if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Message invalid: " + state + "\n* PeerState: " + this + "\n* Error: " + ime.getMessage());
            }
        }
        catch (RuntimeException e) {
            if (this._log.shouldInfo()) {
                this._log.warn("[SSU2] Error handling a message: " + state, e);
            } else if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Error handling a message: " + state + "\n* Error: " + e.getMessage());
            }
        }
        finally {
            state.releaseResources();
        }
    }

    @Override
    public void fragmentsSent(long pktNum, int length, List<PacketBuilder.Fragment> fragments) {
        List<PacketBuilder.Fragment> old = this._sentMessages.putIfAbsent(pktNum, fragments);
        if (old != null) {
            if (this._log.shouldInfo()) {
                this._log.info("[SSU2] Duplicate data packet [#" + pktNum + "] sent to " + this);
            }
        } else if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] New " + length + " byte data packet [#" + pktNum + "] sent with " + fragments.size() + " fragments to " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bitSet(long pktNum) {
        if (pktNum == 0L && !this._isInbound) {
            PeerState2 peerState2 = this;
            synchronized (peerState2) {
                this._sessConfForReTX = null;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] New ACK of SessionConfirmed " + this);
            }
            return;
        }
        List<PacketBuilder.Fragment> fragments = this._sentMessages.remove(pktNum);
        if (fragments == null) {
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] New ACK of packet " + pktNum + " not found " + this);
            }
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] New ACK of packet " + pktNum + " containing " + fragments.size() + " fragments " + this);
        }
        long highest = -1L;
        for (PacketBuilder.Fragment f : fragments) {
            long sn;
            OutboundMessageState state = f.state;
            if (this.acked(f)) {
                if (this._log.shouldDebug()) {
                    this._log.debug("[SSU2] New ACK of fragment " + f.num + state);
                }
            } else if (this._log.shouldInfo()) {
                this._log.info("[SSU2] Duplicate ACK of fragment " + f.num + state);
            }
            if ((sn = state.getSeqNum()) <= highest) continue;
            highest = sn;
        }
        if (highest >= 0L) {
            this.highestSeqNumAcked(highest);
        }
    }

    synchronized void confirmedPacketsSent(byte[][] data) {
        if (this._sessConfForReTX == null) {
            this._sessConfForReTX = data;
        }
        this._sessConfSentTime = this._context.clock().now();
        ++this._sessConfSentCount;
    }

    private synchronized UDPPacket[] getRetransmitSessionConfirmedPackets() {
        if (this._sessConfForReTX == null) {
            return null;
        }
        UDPPacket[] rv = new UDPPacket[this._sessConfForReTX.length];
        InetAddress addr = this.getRemoteIPAddress();
        for (int i = 0; i < rv.length; ++i) {
            UDPPacket packet;
            rv[i] = packet = UDPPacket.acquire(this._context, false);
            DatagramPacket pkt = packet.getPacket();
            byte[] data = pkt.getData();
            int off = pkt.getOffset();
            System.arraycopy(this._sessConfForReTX[i], 0, data, off, this._sessConfForReTX[i].length);
            pkt.setLength(this._sessConfForReTX[i].length);
            pkt.setAddress(addr);
            pkt.setPort(this._remotePort);
            packet.setMessageType(71);
            packet.setPriority(550);
        }
        return rv;
    }

    @Override
    public byte getFlags() {
        return this.shouldRequestImmediateAck() ? (byte)1 : 0;
    }

    boolean isDead() {
        return this._dead;
    }

    private class ACKTimer
    extends SimpleTimer2.TimedEvent {
        public ACKTimer() {
            super(PeerState2.this._context.simpleTimer2());
        }

        public void schedule() {
            long delta = Math.max(10, Math.min(PeerState2.this._rtt / 6, 150));
            if (PeerState2.this._log.shouldDebug()) {
                PeerState2.this._log.debug("[SSU2] Sending delayed ACK in " + delta + "ms to " + PeerState2.this);
            }
            this.reschedule(delta, true);
        }

        public void scheduleImmediate() {
            PeerState2.this._wantACKSendSince = PeerState2.this._context.clock().now();
            long delta = Math.min(PeerState2.this._rtt / 16, 5);
            if (PeerState2.this._log.shouldDebug()) {
                PeerState2.this._log.debug("[SSU2] Sending immediate ACK in " + delta + ": " + PeerState2.this);
            }
            this.reschedule(delta, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            PeerState2 peerState2 = PeerState2.this;
            synchronized (peerState2) {
                if (PeerState2.this._wantACKSendSince <= 0L) {
                    if (PeerState2.this._log.shouldDebug()) {
                        PeerState2.this._log.debug("[SSU2] Already ACKed " + PeerState2.this);
                    }
                    return;
                }
                PeerState2.this._wantACKSendSince = 0L;
            }
            try {
                UDPPacket ack = PeerState2.this._transport.getBuilder2().buildACK(PeerState2.this);
                if (PeerState2.this._log.shouldDebug()) {
                    PeerState2.this._log.debug("[SSU2] ACKTimer sending ACKs to " + PeerState2.this);
                }
                PeerState2.this._transport.send(ack);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static enum MigrationState {
        MIGRATION_STATE_NONE,
        MIGRATION_STATE_PENDING,
        MIGRATION_STATE_CANCELLED,
        MIGRATION_STATE_FAILED,
        MIGRATION_STATE_SUCCESS;

    }
}

