/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.FragmentHandler;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.HopProcessor;
import net.i2p.router.tunnel.OutboundMessageDistributor;
import net.i2p.router.tunnel.RouterFragmentHandler;
import net.i2p.router.tunnel.TunnelDispatcher;
import net.i2p.util.Log;

class OutboundTunnelEndpoint {
    private final RouterContext _context;
    private final Log _log;
    private final HopConfig _config;
    private final HopProcessor _processor;
    private final FragmentHandler _handler;
    private final OutboundMessageDistributor _outDistributor;
    private int _lsdsm;
    private int _ridsm;
    private int _i2npmsg;
    private int _totalmsg;

    public OutboundTunnelEndpoint(RouterContext ctx, HopConfig config, HopProcessor processor) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(OutboundTunnelEndpoint.class);
        this._config = config;
        this._processor = processor;
        this._handler = new RouterFragmentHandler(ctx, new DefragmentedHandler());
        this._outDistributor = new OutboundMessageDistributor(ctx, 200);
        this._i2npmsg = 0;
        this._ridsm = 0;
        this._lsdsm = 0;
        this._totalmsg = 0;
    }

    public void dispatch(TunnelDataMessage msg, Hash recvFrom) {
        Hash h;
        this._config.incrementProcessedMessages();
        byte[] data = msg.getData();
        boolean ok = this._processor.process(data, 0, data.length, recvFrom);
        if (!ok) {
            if (this._log.shouldInfo()) {
                this._log.info("Invalid IV, dropping at Outbound Endpoint... " + this._config);
            }
            return;
        }
        ok = this._handler.receiveTunnelMessage(data, 0, data.length);
        if (!ok && (h = this._config.getReceiveFrom()) != null) {
            if (this._log.shouldWarn()) {
                this._log.warn(this.toString() + ": Blaming [" + h.toBase64().substring(0, 6) + "] -> 50%");
            }
            this._context.profileManager().tunnelFailed(h, 50);
        }
    }

    public String toString() {
        return "OutboundEndpoint [TunnelId " + this._config.getReceiveTunnelId() + "]";
    }

    private class DefragmentedHandler
    implements FragmentHandler.DefragmentedReceiver {
        private DefragmentedHandler() {
        }

        @Override
        public void receiveComplete(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
            DatabaseStoreMessage dsm;
            DatabaseEntry entry;
            OutboundTunnelEndpoint.this._totalmsg++;
            if (toRouter == null) {
                if (OutboundTunnelEndpoint.this._log.shouldWarn()) {
                    OutboundTunnelEndpoint.this._log.warn("Dropping messsage at Outbound Endpoint -> Unsupported delivery instruction type (LOCAL)");
                }
                return;
            }
            int type = msg.getType();
            if (type == 1 && (entry = (dsm = (DatabaseStoreMessage)msg).getEntry()).getType() == 0) {
                long now = OutboundTunnelEndpoint.this._context.clock().now();
                long date = entry.getDate();
                if (date < now - 3600000L) {
                    if (OutboundTunnelEndpoint.this._log.shouldWarn()) {
                        OutboundTunnelEndpoint.this._log.warn("Dropping " + (toTunnel == null ? "DIRECT" : "") + " DbStoreMsg of stale RouterInfo [" + dsm.getKey().toBase64().substring(0, 6) + "] at Outbound Endpoint to Router [" + toRouter.toBase64().substring(0, 6) + "]");
                    }
                    return;
                }
                if (date > now + 120000L) {
                    if (OutboundTunnelEndpoint.this._log.shouldWarn()) {
                        OutboundTunnelEndpoint.this._log.warn("Dropping " + (toTunnel == null ? "DIRECT" : "") + " DbStoreMsg of future RouterInfo [" + dsm.getKey().toBase64().substring(0, 6) + "] at Outbound Endpoint to Router [" + toRouter.toBase64().substring(0, 6) + "]");
                    }
                    return;
                }
            }
            if (OutboundTunnelEndpoint.this._log.shouldInfo()) {
                OutboundTunnelEndpoint.this._log.info("Outbound tunnel " + OutboundTunnelEndpoint.this._config + " received a full message: " + msg + " to be forwarded on to [" + toRouter.toBase64().substring(0, 6) + "]" + (toTunnel != null ? ":" + toTunnel.getTunnelId() : ""));
            }
            if (toTunnel == null) {
                int msgtype = msg.getType();
                if (msgtype == 1) {
                    DatabaseStoreMessage dsm2 = (DatabaseStoreMessage)msg;
                    if (!dsm2.getEntry().isLeaseSet()) {
                        OutboundTunnelEndpoint.this._ridsm++;
                        OutboundTunnelEndpoint.this._context.statManager().addRateData("tunnel.outboundTunnelEndpointFwdRIDSM", 1L);
                        if (OutboundTunnelEndpoint.this._log.shouldLog(20)) {
                            OutboundTunnelEndpoint.this._log.info("OutboundEndpoint RouterInfo DbStoreMsg (Count: " + OutboundTunnelEndpoint.this._ridsm + "/" + OutboundTunnelEndpoint.this._totalmsg + ") from [TunnelId " + OutboundTunnelEndpoint.this._config.getReceiveTunnelId() + "] to Router [" + toRouter.toBase64().substring(0, 6) + "] with message: " + dsm2);
                        }
                    } else {
                        OutboundTunnelEndpoint.this._lsdsm++;
                        if (OutboundTunnelEndpoint.this._log.shouldLog(20)) {
                            OutboundTunnelEndpoint.this._log.info("OutboundEndpoint LeaseSet DbStoreMsg (Count: " + OutboundTunnelEndpoint.this._lsdsm + "/" + OutboundTunnelEndpoint.this._totalmsg + ") from [TunnelId " + OutboundTunnelEndpoint.this._config.getReceiveTunnelId() + "] to Router " + toRouter.toBase64().substring(0, 6) + "] with message: " + dsm2);
                        }
                    }
                } else {
                    OutboundTunnelEndpoint.this._i2npmsg++;
                    if (OutboundTunnelEndpoint.this._log.shouldLog(20)) {
                        OutboundTunnelEndpoint.this._log.info("OutboundEndpoint I2NP Message (Count: " + OutboundTunnelEndpoint.this._i2npmsg + "/" + OutboundTunnelEndpoint.this._totalmsg + ") from [TunnelId " + OutboundTunnelEndpoint.this._config.getReceiveTunnelId() + "] to Router [" + toRouter.toBase64().substring(0, 6) + "] with message: " + msg);
                    }
                }
            }
            int size = msg.getMessageSize();
            boolean toUs = OutboundTunnelEndpoint.this._context.routerHash().equals(toRouter);
            if (!toUs && OutboundTunnelEndpoint.this._context.tunnelDispatcher().shouldDropParticipatingMessage(TunnelDispatcher.Location.OBEP, type, size)) {
                return;
            }
            OutboundTunnelEndpoint.this._outDistributor.distribute(msg, toRouter, toTunnel);
        }
    }
}

