/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.PendingGatewayMessage;
import net.i2p.router.tunnel.PumpedTunnelGateway;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;

class TunnelGatewayPumper
implements Runnable {
    private final RouterContext _context;
    private final Log _log;
    private final Set<PumpedTunnelGateway> _wantsPumping;
    private final Set<PumpedTunnelGateway> _backlogged;
    private final List<Thread> _threads;
    private volatile boolean _stop;
    private static final int MIN_PUMPERS = 1;
    private static final int MAX_PUMPERS;
    private final int _pumpers;
    private static final long REQUEUE_TIME;
    private static final int POISON_PTG = -99999;

    public TunnelGatewayPumper(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelGatewayPumper.class);
        this._wantsPumping = new LinkedHashSet<PumpedTunnelGateway>(1024);
        this._backlogged = new HashSet<PumpedTunnelGateway>(1024);
        this._threads = new CopyOnWriteArrayList<Thread>();
        this._pumpers = ctx.getBooleanProperty("i2p.dummyTunnelManager") ? 1 : MAX_PUMPERS;
        for (int i = 0; i < this._pumpers; ++i) {
            I2PThread t = new I2PThread(this, "TunnGWPumper " + (i + 1) + '/' + this._pumpers, true);
            t.setPriority(10);
            this._threads.add(t);
            ((Thread)t).start();
        }
    }

    public void stopPumping() {
        long adjusted;
        this._stop = true;
        this._wantsPumping.clear();
        for (int i = 0; i < this._pumpers; ++i) {
            PoisonPTG poison = new PoisonPTG(this._context);
            this.wantsPumping(poison);
        }
        long l = adjusted = SystemVersion.getCPULoad() > 90 && SystemVersion.getCPULoadAvg() > 90 ? REQUEUE_TIME * 3L / 2L : REQUEUE_TIME;
        if (SystemVersion.getCPULoad() > 95 && SystemVersion.getCPULoadAvg() >= 95) {
            adjusted = REQUEUE_TIME * 2L;
        }
        if (this._log.shouldWarn() && adjusted != REQUEUE_TIME) {
            this._log.warn("Router JVM under sustained high CPU load, increasing pump interval from " + REQUEUE_TIME + " to " + adjusted + "ms");
        }
        for (int i = 1; i <= 5 && !this._wantsPumping.isEmpty(); ++i) {
            try {
                Thread.sleep((long)i * adjusted);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (Thread t : this._threads) {
            t.interrupt();
        }
        this._threads.clear();
        this._wantsPumping.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wantsPumping(PumpedTunnelGateway gw) {
        if (!this._stop) {
            Set<PumpedTunnelGateway> set = this._wantsPumping;
            synchronized (set) {
                if (!this._backlogged.contains(gw) && this._wantsPumping.add(gw)) {
                    this._wantsPumping.notify();
                }
            }
        }
    }

    @Override
    public void run() {
        try {
            this.run2();
        }
        finally {
            this._threads.remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run2() {
        TunnelGateway gw = null;
        ArrayList<PendingGatewayMessage> queueBuf = new ArrayList<PendingGatewayMessage>(32);
        boolean requeue = false;
        while (!this._stop) {
            try {
                Set<PumpedTunnelGateway> set = this._wantsPumping;
                synchronized (set) {
                    if (requeue && gw != null) {
                        this._wantsPumping.remove(gw);
                        if (this._backlogged.add((PumpedTunnelGateway)gw)) {
                            this._context.simpleTimer2().addEvent(new Requeue((PumpedTunnelGateway)gw), REQUEUE_TIME);
                        }
                    }
                    gw = null;
                    if (this._wantsPumping.isEmpty()) {
                        this._wantsPumping.wait();
                    } else {
                        Iterator<PumpedTunnelGateway> iter = this._wantsPumping.iterator();
                        gw = iter.next();
                        iter.remove();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (gw == null) continue;
            if (gw.getMessagesSent() == -99999) break;
            requeue = ((PumpedTunnelGateway)gw).pump(queueBuf);
        }
    }

    static {
        int n = SystemVersion.isSlow() || SystemVersion.getCores() <= 4 && SystemVersion.getMaxMemory() < 0x18000000L ? 2 : (MAX_PUMPERS = SystemVersion.getMaxMemory() < 0x40000000L ? 3 : Math.max(6, SystemVersion.getCores() / 2));
        REQUEUE_TIME = SystemVersion.isSlow() ? 50L : (SystemVersion.getCores() < 4 && SystemVersion.getMaxMemory() < 0x20000000L ? 40L : (SystemVersion.getMaxMemory() > 0x40000000L && SystemVersion.getCores() > 4 ? 10L : 30L));
    }

    private static class PoisonPTG
    extends PumpedTunnelGateway {
        public PoisonPTG(RouterContext ctx) {
            super(ctx, null, null, null, null);
        }

        @Override
        public int getMessagesSent() {
            return -99999;
        }
    }

    private class Requeue
    implements SimpleTimer.TimedEvent {
        private final PumpedTunnelGateway _ptg;

        public Requeue(PumpedTunnelGateway ptg) {
            this._ptg = ptg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            Set set = TunnelGatewayPumper.this._wantsPumping;
            synchronized (set) {
                TunnelGatewayPumper.this._backlogged.remove(this._ptg);
                if (TunnelGatewayPumper.this._wantsPumping.add(this._ptg)) {
                    TunnelGatewayPumper.this._wantsPumping.notify();
                }
            }
        }
    }
}

