/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.io.File;
import net.i2p.crypto.ChaCha20;
import net.i2p.crypto.EncType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.BuildRequestRecord;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class BuildMessageProcessor {
    private final RouterContext ctx;
    private final Log log;
    private final DecayingBloomFilter _filter;

    public BuildMessageProcessor(RouterContext ctx) {
        this.ctx = ctx;
        this.log = ctx.logManager().getLog(this.getClass());
        this._filter = this.selectFilter();
    }

    private DecayingBloomFilter selectFilter() {
        int duration;
        boolean isEC;
        long maxMemory = SystemVersion.getMaxMemory();
        boolean isSlow = SystemVersion.isSlow();
        boolean isAndroid = SystemVersion.isAndroid();
        int m = maxMemory < 0x10000000L ? 17 : (isSlow || isAndroid ? 18 : (maxMemory >= 0x40000000L ? 25 : (maxMemory >= 0x20000000L ? 24 : (maxMemory >= 0x10000000L ? 23 : 19))));
        File f = new File(this.ctx.getConfigDir(), "router.keys.dat");
        boolean bl = isEC = f.length() < 663L;
        if (isEC) {
            duration = 480000;
            m = Math.max(m - 3, 17);
        } else {
            duration = 3600000;
        }
        if (this.log.shouldInfo()) {
            this.log.info("Selected Bloom filter m = " + m);
        }
        return new DecayingBloomFilter(this.ctx, duration, 32, "TunnelBMP", m);
    }

    public BuildRequestRecord decrypt(TunnelBuildMessage msg, Hash ourHash, PrivateKey privKey) {
        EncryptedBuildRecord data;
        int i;
        byte[] iv;
        BuildRequestRecord rv = null;
        int ourHop = -1;
        byte[] ourHashData = ourHash.getData();
        boolean isShort = msg.getType() == 25;
        for (int i2 = 0; i2 < msg.getRecordCount(); ++i2) {
            EncryptedBuildRecord rec = msg.getRecord(i2);
            boolean eq = DataHelper.eq(ourHashData, 0, rec.getData(), 0, 16);
            if (!eq) continue;
            try {
                rv = new BuildRequestRecord(this.ctx, privKey, rec);
                if (isShort) {
                    SessionKey sk = rv.getChaChaReplyKey();
                    boolean isDup = this._filter.add(sk.getData(), 0, 32);
                    if (isDup) {
                        if (this.log.shouldWarn()) {
                            this.log.warn("[MsgID " + msg.getUniqueId() + "] Duplicate " + (Object)((Object)privKey.getType()) + " record received " + rv);
                        }
                        this.ctx.statManager().addRateData("tunnel.buildRequestDup", 1L);
                        return null;
                    }
                } else {
                    boolean isBad = SessionKey.INVALID_KEY.equals(rv.readReplyKey());
                    if (isBad) {
                        if (this.log.shouldWarn()) {
                            this.log.warn("[MsgID " + msg.getUniqueId() + "] Bad reply key (i2pd bug) " + rv);
                        }
                        this.ctx.statManager().addRateData("tunnel.buildRequestBadReplyKey", 1L);
                        return null;
                    }
                    boolean isEC = this.ctx.keyManager().getPrivateKey().getType() == EncType.ECIES_X25519;
                    int off = isEC ? 104 : 136;
                    boolean isDup = this._filter.add(rv.getData(), off, 32);
                    if (isDup) {
                        if (this.log.shouldWarn()) {
                            this.log.warn("[MsgID " + msg.getUniqueId() + "] Duplicate " + (Object)((Object)privKey.getType()) + " record received " + rv);
                        }
                        this.ctx.statManager().addRateData("tunnel.buildRequestDup", 1L);
                        return null;
                    }
                }
                if (this.log.shouldDebug()) {
                    this.log.debug("[MsgID " + msg.getUniqueId() + "] Matching " + (Object)((Object)privKey.getType()) + " record found " + rv);
                }
                ourHop = i2;
                break;
            }
            catch (DataFormatException dfe) {
                if (!this.log.shouldWarn()) continue;
                this.log.warn("[MsgID " + msg.getUniqueId() + "] Matching " + (Object)((Object)privKey.getType()) + " record decryption failure \n* " + dfe.getMessage());
            }
        }
        if (rv == null) {
            return null;
        }
        if (isShort) {
            byte[] replyKey = rv.getChaChaReplyKey().getData();
            iv = new byte[12];
            for (i = 0; i < msg.getRecordCount(); ++i) {
                if (i == ourHop) continue;
                data = msg.getRecord(i);
                byte[] bytes = data.getData();
                iv[4] = (byte)i;
                ChaCha20.encrypt(replyKey, iv, bytes, 0, bytes, 0, 218);
            }
        } else {
            SessionKey replyKey = rv.readReplyKey();
            iv = rv.readReplyIV();
            for (i = 0; i < msg.getRecordCount(); ++i) {
                if (i == ourHop) continue;
                data = msg.getRecord(i);
                byte[] bytes = data.getData();
                this.ctx.aes().encrypt(bytes, 0, bytes, 0, replyKey, iv, 0, 528);
            }
        }
        msg.setRecord(ourHop, null);
        return rv;
    }
}

