/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

class RequestThrottler {
    private final RouterContext context;
    private final ObjectCounter<Hash> counter;
    private final Log _log;
    private static final int LIFETIME_PORTION = 4;
    private static boolean isSlow = SystemVersion.isSlow();
    private static boolean isQuadCore = SystemVersion.getCores() >= 4;
    private static boolean isHexaCore = SystemVersion.getCores() >= 6;
    private static final int MIN_LIMIT = (isSlow ? 32 : 64) / 4;
    private static final int MAX_LIMIT = (isSlow ? 256 : (isHexaCore ? 512 : 384)) / 4;
    private static final int PERCENT_LIMIT = 6;
    private static final long CLEAN_TIME = 165000L;
    private static final boolean DEFAULT_SHOULD_THROTTLE = true;
    private static final String PROP_SHOULD_THROTTLE = "router.enableTransitThrottle";
    private static final boolean DEFAULT_SHOULD_DISCONNECT = false;
    private static final String PROP_SHOULD_DISCONNECT = "router.enableImmediateDisconnect";

    RequestThrottler(RouterContext ctx) {
        this.context = ctx;
        this.counter = new ObjectCounter();
        this._log = ctx.logManager().getLog(RequestThrottler.class);
        ctx.simpleTimer2().addPeriodicEvent(new Cleaner(), 165000L);
    }

    boolean shouldThrottle(Hash h) {
        String MIN_VERSION;
        RouterInfo ri = this.context.netDb().lookupRouterInfoLocally(h);
        boolean isUnreachable = ri != null && ri.getCapabilities().indexOf(82) < 0;
        boolean isLowShare = ri != null && (ri.getCapabilities().indexOf(75) >= 0 || ri.getCapabilities().indexOf(76) >= 0 || ri.getCapabilities().indexOf(77) >= 0 || ri.getCapabilities().indexOf(78) >= 0);
        boolean isFast = ri != null && (ri.getCapabilities().indexOf(79) >= 0 || ri.getCapabilities().indexOf(80) >= 0 || ri.getCapabilities().indexOf(88) >= 0);
        boolean isLTier = ri != null && (ri.getCapabilities().indexOf(75) >= 0 || ri.getCapabilities().indexOf(76) >= 0);
        int numTunnels = this.context.tunnelManager().getParticipatingCount();
        int portion = isSlow ? 6 : 4;
        int min = (isSlow ? MIN_LIMIT / 2 : MIN_LIMIT) / portion;
        int max = (isSlow ? MAX_LIMIT / 2 : MAX_LIMIT) / portion;
        int percent = (isSlow ? 3 : 6) / portion;
        int limit = isUnreachable || isLowShare ? Math.min(MIN_LIMIT, Math.max(MAX_LIMIT / 8, numTunnels * 3 / 100)) : (isFast ? Math.min(MIN_LIMIT * 3 / 2, Math.max(MAX_LIMIT * 3 / 2, numTunnels * 6 / 100)) : Math.min(MIN_LIMIT, Math.max(MAX_LIMIT, numTunnels * 6 / 100)));
        int count = this.counter.increment(h);
        boolean rv = count > limit;
        boolean enableThrottle = this.context.getProperty(PROP_SHOULD_THROTTLE, true);
        boolean shouldDisconnect = this.context.getProperty(PROP_SHOULD_DISCONNECT, false);
        boolean noSSU = true;
        boolean isFF = false;
        String v = MIN_VERSION = "0.9.61";
        String country = "unknown";
        boolean noCountry = true;
        boolean isOld = VersionComparator.comp(v, MIN_VERSION) < 0;
        long uptime = this.context.router().getUptime();
        if (ri != null) {
            for (RouterAddress ra : ri.getAddresses()) {
                if (!ra.getTransportStyle().equals("SSU") && !ra.getTransportStyle().equals("SSU2")) continue;
                noSSU = false;
                break;
            }
            if (ri.getCapabilities().contains("f")) {
                isFF = true;
            }
            v = ri.getVersion();
            country = this.context.commSystem().getCountry(h);
            if (country != null && country != "unknown") {
                noCountry = false;
            }
        }
        if (SystemVersion.getCPULoad() > 95 && SystemVersion.getCPULoadAvg() > 95 && this._log.shouldWarn()) {
            this._log.warn("Rejecting tunnel request from Router [" + h.toBase64().substring(0, 6) + "] -> CPU is under sustained high load");
        }
        if (isFF && (noSSU || isUnreachable)) {
            if (noSSU) {
                this.context.banlist().banlistRouter(h, " <b>\u279c</b> Floodfill with SSU disabled", null, null, this.context.clock().now() + 14400000L);
                if (this._log.shouldWarn()) {
                    this._log.warn("Banning Floodfill [" + h.toBase64().substring(0, 6) + "] for 4h -> No SSU transport enabled");
                }
            } else {
                this.context.banlist().banlistRouter(h, " <b>\u279c</b> Floodfill is unreachable / firewalled", null, null, this.context.clock().now() + 14400000L);
                if (this._log.shouldWarn()) {
                    this._log.warn("Banning Floodfill [" + h.toBase64().substring(0, 6) + "] for 4h -> Unreachable / firewalled");
                }
            }
            if (shouldDisconnect) {
                this.context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
            }
        }
        if (isLTier && isUnreachable && isOld) {
            if (this._log.shouldWarn() && !this.context.banlist().isBanlisted(h)) {
                this._log.warn("Banning for 4h and immediately disconnecting from [" + h.toBase64().substring(0, 6) + "] -> LU / " + v);
            }
            this.context.banlist().banlistRouter(h, " <b>\u279c</b> LU and older than current version", null, null, this.context.clock().now() + 14400000L);
            this.context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
        } else if (isOld && (isUnreachable || isLowShare)) {
            if (isUnreachable) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Dropping all connections from [" + h.toBase64().substring(0, 6) + "] -> Unreachable / " + v);
                }
            } else if (this._log.shouldWarn()) {
                this._log.warn("Dropping all connections from [" + h.toBase64().substring(0, 6) + "] -> Slow / " + v);
            }
            this.context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
        } else if (rv && enableThrottle) {
            if (count > limit * 5 / 3) {
                int bantime = isLowShare || isUnreachable ? 3600000 : 1800000;
                int period = bantime / 60 / 1000;
                if (count == limit * 5 / 3 + 1) {
                    this.context.banlist().banlistRouter(h, " <b>\u279c</b> Excessive tunnel requests", null, null, this.context.clock().now() + (long)bantime);
                    this.context.simpleTimer2().addEvent(new Disconnector(h), 660000L);
                    if (this._log.shouldWarn()) {
                        this._log.warn("Banning " + (isLowShare || isUnreachable ? "slow or unreachable" : "") + " Router [" + h.toBase64().substring(0, 6) + "] for " + period + "m\n* Excessive tunnel requests (Requested: " + count + " / Hard limit " + limit * 5 / 3 + " in " + 660 / portion + "s)");
                    }
                } else {
                    if (this._log.shouldInfo()) {
                        this._log.info("Rejecting tunnel requests from temp banned Router [" + h.toBase64().substring(0, 6) + "] -> (Requested: " + count + " / Hard limit: " + limit * 5 / 3 + " in " + 660 / portion + "s)");
                    }
                    this.context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
                }
            } else if (this._log.shouldWarn()) {
                this._log.warn("Throttling tunnel requests from " + (isLowShare || isUnreachable ? "slow or unreachable" : "") + " Router [" + h.toBase64().substring(0, 6) + "] -> Requested: " + count + " / Hard limit: " + limit + " in " + 660 / portion + "s");
            }
        }
        if (rv && count == 2 * limit) {
            this.context.banlist().banlistRouter(h, "Excessive tunnel requests", null, null, this.context.clock().now() + 1800000L);
            this.context.simpleTimer2().addEvent(new Disconnector(h), 660000L);
            if (this._log.shouldWarn()) {
                this._log.warn("Banning Router [" + h.toBase64().substring(0, 6) + "] for 30m -> Excessive tunnel requests (Requested: " + count + " / Hard limit: " + limit + ")");
            }
        }
        return rv;
    }

    private class Disconnector
    implements SimpleTimer.TimedEvent {
        private final Hash h;

        public Disconnector(Hash h) {
            this.h = h;
        }

        @Override
        public void timeReached() {
            RequestThrottler.this.context.commSystem().forceDisconnect(this.h);
        }
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        @Override
        public void timeReached() {
            RequestThrottler.this.counter.clear();
        }
    }
}

