/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.app.NavService;
import net.i2p.router.web.App;

public class NavHelper
implements NavService,
ClientApp {
    private final Map<String, App> _apps = new ConcurrentHashMap<String, App>(4);
    private final Map<String, byte[]> _binary = new ConcurrentHashMap<String, byte[]>(4);

    @Override
    public void registerApp(String appName, String displayName, String path, String tooltip, String iconpath) {
        if (iconpath != null && !iconpath.startsWith("/")) {
            iconpath = null;
        }
        this._apps.put(appName, new App(displayName, tooltip, path, iconpath));
    }

    @Override
    public void unregisterApp(String name) {
        this._apps.remove(name);
    }

    public byte[] getBinary(String name) {
        if (name != null) {
            return this._binary.get(name);
        }
        return null;
    }

    public void setBinary(String name, byte[] arr) {
        this._binary.put(name, arr);
    }

    public Map<String, String> getClientAppLinks() {
        if (this._apps.isEmpty()) {
            return null;
        }
        HashMap<String, String> rv = new HashMap<String, String>(this._apps.size());
        StringBuilder buf = new StringBuilder(128);
        for (Map.Entry<String, App> e : this._apps.entrySet()) {
            String appName = e.getKey();
            App app = e.getValue();
            String path = app.url;
            if (path == null) continue;
            String name = app.name;
            String tip = app.desc;
            buf.setLength(0);
            this.getClientAppImg(buf, appName, app.icon);
            I2PAppContext ctx = I2PAppContext.getGlobalContext();
            buf.append(" <a target=_blank href=\"").append(path.replace(" ", "%20")).append("\"");
            if (tip != null) {
                buf.append(" title=\"").append(tip).append("\"");
            }
            buf.append('>').append(name.replace(" ", "&nbsp;")).append("</a>\n");
            rv.put(name, buf.toString());
        }
        return rv;
    }

    private void getClientAppImg(StringBuilder buf, String name, String iconpath) {
        if (iconpath != null) {
            buf.append("<img src=\"").append(iconpath).append("\"");
        } else {
            buf.append("<img src=\"/themes/console/images/plugin.svg\"");
        }
        buf.append(" height=16 width=16 alt=\"\" hidden>");
    }

    public List<App> getClientApps(I2PAppContext ctx) {
        if (this._apps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<App> rv = new ArrayList<App>(this._apps.size());
        for (Map.Entry<String, App> e : this._apps.entrySet()) {
            String icon;
            String name = e.getKey();
            App mapp = e.getValue();
            if (mapp.url == null) continue;
            String tip = mapp.desc;
            if (tip == null) {
                tip = "";
            }
            if ((icon = mapp.icon) == null) {
                icon = name.equals("i2pbote") ? "/themes/console/images/email.png" : "/themes/console/images/plugin.png";
            }
            App app = new App(mapp.name, tip, mapp.url, icon);
            rv.add(app);
        }
        return rv;
    }

    public static NavHelper getInstance() {
        return NavHelper.getInstance(I2PAppContext.getGlobalContext());
    }

    public static NavHelper getInstance(I2PAppContext ctx) {
        ClientAppManager cmgr = ctx.clientAppManager();
        if (cmgr != null) {
            return (NavHelper)cmgr.getRegisteredApp("NavHelper");
        }
        return null;
    }

    @Override
    public void startup() {
    }

    @Override
    public void shutdown(String[] args) {
        this._apps.clear();
        this._binary.clear();
    }

    @Override
    public ClientAppState getState() {
        return ClientAppState.RUNNING;
    }

    @Override
    public String getName() {
        return "NavHelper";
    }

    @Override
    public String getDisplayName() {
        return "Nav Helper";
    }
}

