/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.Collections;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.web.PluginStarter;
import net.i2p.util.Log;
import org.eclipse.jetty.server.Server;

class PluginStopper
extends PluginStarter {
    private final Server _server;

    public PluginStopper(RouterContext ctx, Server server) {
        super(ctx);
        this._server = server;
    }

    @Override
    public void run() {
        this.stopPlugins();
    }

    private void stopPlugins() {
        Log log = this._context.logManager().getLog(PluginStopper.class);
        List<String> pl = PluginStopper.getPlugins();
        Collections.reverse(pl);
        for (String app : pl) {
            if (PluginStopper.isPluginRunning(app, this._context, this._server)) {
                try {
                    if (log.shouldInfo()) {
                        log.info("Stopping plugin: " + app);
                    }
                    PluginStopper.stopPlugin(this._context, this._server, app);
                }
                catch (Throwable e) {
                    if (!log.shouldWarn()) continue;
                    log.warn("Failed to stop plugin: " + app, e);
                }
                continue;
            }
            if (!log.shouldInfo()) continue;
            log.info("Plugin not running: " + app);
        }
    }
}

