/*
 * Decompiled with CFR 0.152.
 */
package io.pack200;

import io.pack200.Attribute;
import io.pack200.ConstantPool;
import io.pack200.Constants;
import io.pack200.Fixups;
import io.pack200.Instruction;
import io.pack200.Package;
import java.util.Arrays;
import java.util.Collection;

class Code
extends Attribute.Holder {
    Package.Class.Method m;
    private static final ConstantPool.Entry[] noRefs = ConstantPool.noRefs;
    int max_stack;
    int max_locals;
    ConstantPool.Entry[] handler_class = noRefs;
    int[] handler_start = Constants.noInts;
    int[] handler_end = Constants.noInts;
    int[] handler_catch = Constants.noInts;
    byte[] bytes;
    Fixups fixups;
    Object insnMap;
    static final boolean shrinkMaps = true;

    public Code(Package.Class.Method m) {
        this.m = m;
    }

    public Package.Class.Method getMethod() {
        return this.m;
    }

    public Package.Class thisClass() {
        return this.m.thisClass();
    }

    public Package getPackage() {
        return this.m.thisClass().getPackage();
    }

    @Override
    public ConstantPool.Entry[] getCPMap() {
        return this.m.getCPMap();
    }

    int getLength() {
        return this.bytes.length;
    }

    int getMaxStack() {
        return this.max_stack;
    }

    void setMaxStack(int ms) {
        this.max_stack = ms;
    }

    int getMaxNALocals() {
        int argsize = this.m.getArgumentSize();
        return this.max_locals - argsize;
    }

    void setMaxNALocals(int ml) {
        int argsize = this.m.getArgumentSize();
        this.max_locals = argsize + ml;
    }

    int getHandlerCount() {
        assert (this.handler_class.length == this.handler_start.length);
        assert (this.handler_class.length == this.handler_end.length);
        assert (this.handler_class.length == this.handler_catch.length);
        return this.handler_class.length;
    }

    void setHandlerCount(int h) {
        if (h > 0) {
            this.handler_class = new ConstantPool.Entry[h];
            this.handler_start = new int[h];
            this.handler_end = new int[h];
            this.handler_catch = new int[h];
        }
    }

    void setBytes(byte[] bytes) {
        this.bytes = bytes;
        if (this.fixups != null) {
            this.fixups.setBytes(bytes);
        }
    }

    void setInstructionMap(int[] insnMap, int mapLen) {
        this.insnMap = this.allocateInstructionMap(insnMap, mapLen);
    }

    void setInstructionMap(int[] insnMap) {
        this.setInstructionMap(insnMap, insnMap.length);
    }

    int[] getInstructionMap() {
        return this.expandInstructionMap(this.getInsnMap());
    }

    void addFixups(Collection<Fixups.Fixup> moreFixups) {
        if (this.fixups == null) {
            this.fixups = new Fixups(this.bytes);
        }
        assert (this.fixups.getBytes() == this.bytes);
        this.fixups.addAll((Collection<? extends Fixups.Fixup>)moreFixups);
    }

    @Override
    public void trimToSize() {
        if (this.fixups != null) {
            this.fixups.trimToSize();
            if (this.fixups.size() == 0) {
                this.fixups = null;
            }
        }
        super.trimToSize();
    }

    @Override
    protected void visitRefs(int mode, Collection<ConstantPool.Entry> refs) {
        int verbose = this.getPackage().verbose;
        if (verbose > 2) {
            System.out.println("Reference scan " + this);
        }
        refs.addAll(Arrays.asList(this.handler_class));
        if (this.fixups != null) {
            this.fixups.visitRefs(refs);
        } else {
            ConstantPool.Entry[] cpMap = this.getCPMap();
            for (Instruction i = this.instructionAt(0); i != null; i = i.next()) {
                int cpref;
                if (verbose > 4) {
                    System.out.println(i);
                }
                if ((cpref = i.getCPIndex()) < 0) continue;
                refs.add(cpMap[cpref]);
            }
        }
        super.visitRefs(mode, refs);
    }

    private Object allocateInstructionMap(int[] insnMap, int mapLen) {
        int PClimit = this.getLength();
        if (PClimit <= 255) {
            byte[] map = new byte[mapLen + 1];
            for (int i = 0; i < mapLen; ++i) {
                map[i] = (byte)(insnMap[i] + -128);
            }
            map[mapLen] = (byte)(PClimit + -128);
            return map;
        }
        if (PClimit < 65535) {
            short[] map = new short[mapLen + 1];
            for (int i = 0; i < mapLen; ++i) {
                map[i] = (short)(insnMap[i] + Short.MIN_VALUE);
            }
            map[mapLen] = (short)(PClimit + Short.MIN_VALUE);
            return map;
        }
        int[] map = Arrays.copyOf(insnMap, mapLen + 1);
        map[mapLen] = PClimit;
        return map;
    }

    private int[] expandInstructionMap(Object map0) {
        int[] imap;
        if (map0 instanceof byte[]) {
            byte[] map = (byte[])map0;
            imap = new int[map.length - 1];
            for (int i = 0; i < imap.length; ++i) {
                imap[i] = map[i] - -128;
            }
        } else if (map0 instanceof short[]) {
            short[] map = (short[])map0;
            imap = new int[map.length - 1];
            for (int i = 0; i < imap.length; ++i) {
                imap[i] = map[i] - -128;
            }
        } else {
            int[] map = (int[])map0;
            imap = Arrays.copyOfRange(map, 0, map.length - 1);
        }
        return imap;
    }

    Object getInsnMap() {
        if (this.insnMap != null) {
            return this.insnMap;
        }
        int[] map = new int[this.getLength()];
        int fillp = 0;
        for (Instruction i = this.instructionAt(0); i != null; i = i.next()) {
            map[fillp++] = i.getPC();
        }
        this.insnMap = this.allocateInstructionMap(map, fillp);
        return this.insnMap;
    }

    public int encodeBCI(int bci) {
        int i;
        int len;
        if (bci <= 0 || bci > this.getLength()) {
            return bci;
        }
        Object map0 = this.getInsnMap();
        if (map0 instanceof byte[]) {
            byte[] map = (byte[])map0;
            len = map.length;
            i = Arrays.binarySearch(map, (byte)(bci + -128));
        } else if (map0 instanceof short[]) {
            short[] map = (short[])map0;
            len = map.length;
            i = Arrays.binarySearch(map, (short)(bci + Short.MIN_VALUE));
        } else {
            int[] map = (int[])map0;
            len = map.length;
            i = Arrays.binarySearch(map, bci);
        }
        assert (i != -1);
        assert (i != 0);
        assert (i != len);
        assert (i != -len - 1);
        return i >= 0 ? i : len + bci - (-i - 1);
    }

    public int decodeBCI(int bciCode) {
        int i;
        int len;
        if (bciCode <= 0 || bciCode > this.getLength()) {
            return bciCode;
        }
        Object map0 = this.getInsnMap();
        if (map0 instanceof byte[]) {
            byte[] map = (byte[])map0;
            len = map.length;
            if (bciCode < len) {
                return map[bciCode] - -128;
            }
            i = Arrays.binarySearch(map, (byte)(bciCode + -128));
            if (i < 0) {
                i = -i - 1;
            }
            int key = bciCode - len + -128;
            while (map[i - 1] - (i - 1) > key) {
                --i;
            }
        } else if (map0 instanceof short[]) {
            short[] map = (short[])map0;
            len = map.length;
            if (bciCode < len) {
                return map[bciCode] - Short.MIN_VALUE;
            }
            i = Arrays.binarySearch(map, (short)(bciCode + Short.MIN_VALUE));
            if (i < 0) {
                i = -i - 1;
            }
            int key = bciCode - len + Short.MIN_VALUE;
            while (map[i - 1] - (i - 1) > key) {
                --i;
            }
        } else {
            int[] map = (int[])map0;
            len = map.length;
            if (bciCode < len) {
                return map[bciCode];
            }
            i = Arrays.binarySearch(map, bciCode);
            if (i < 0) {
                i = -i - 1;
            }
            int key = bciCode - len;
            while (map[i - 1] - (i - 1) > key) {
                --i;
            }
        }
        return bciCode - len + i;
    }

    public void finishRefs(ConstantPool.Index ix) {
        if (this.fixups != null) {
            this.fixups.finishRefs(ix);
            this.fixups = null;
        }
    }

    Instruction instructionAt(int pc) {
        return Instruction.at(this.bytes, pc);
    }

    static boolean flagsRequireCode(int flags) {
        return (flags & 0x500) == 0;
    }

    public String toString() {
        return this.m + ".Code";
    }

    public int getInt(int pc) {
        return Instruction.getInt(this.bytes, pc);
    }

    public int getShort(int pc) {
        return Instruction.getShort(this.bytes, pc);
    }

    public int getByte(int pc) {
        return Instruction.getByte(this.bytes, pc);
    }

    void setInt(int pc, int x) {
        Instruction.setInt(this.bytes, pc, x);
    }

    void setShort(int pc, int x) {
        Instruction.setShort(this.bytes, pc, x);
    }

    void setByte(int pc, int x) {
        Instruction.setByte(this.bytes, pc, x);
    }
}

