/*
 * Decompiled with CFR 0.152.
 */
package io.pack200;

import io.pack200.Attribute;
import io.pack200.PackerImpl;
import io.pack200.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

final class PropMap
implements SortedMap<String, String> {
    private final TreeMap<String, String> theMap = new TreeMap();
    private static Map<String, String> defaultProps;

    @Override
    public String put(String key, String value) {
        String oldValue = this.theMap.put(key, value);
        return oldValue;
    }

    private static String getPropertyValue(String key, String defaultValue) {
        PrivilegedAction<String> pa = () -> System.getProperty(key);
        String s = AccessController.doPrivileged(pa);
        return s != null ? s : defaultValue;
    }

    PropMap() {
        this.theMap.putAll(defaultProps);
    }

    SortedMap<String, String> prefixMap(String prefix) {
        int len = prefix.length();
        if (len == 0) {
            return this;
        }
        char nextch = (char)(prefix.charAt(len - 1) + '\u0001');
        String limit = prefix.substring(0, len - 1) + nextch;
        return this.subMap(prefix, limit);
    }

    String getProperty(String s) {
        return this.get(s);
    }

    String getProperty(String s, String defaultVal) {
        String val = this.getProperty(s);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    String setProperty(String s, String val) {
        return this.put(s, val);
    }

    List<String> getProperties(String prefix) {
        Collection<String> values = this.prefixMap(prefix).values();
        ArrayList<String> res = new ArrayList<String>(values.size());
        res.addAll(values);
        while (res.remove(null)) {
        }
        return res;
    }

    private boolean toBoolean(String val) {
        return Boolean.valueOf(val);
    }

    boolean getBoolean(String s) {
        return this.toBoolean(this.getProperty(s));
    }

    boolean setBoolean(String s, boolean val) {
        return this.toBoolean(this.setProperty(s, String.valueOf(val)));
    }

    int toInteger(String val) {
        return this.toInteger(val, 0);
    }

    int toInteger(String val, int def) {
        if (val == null) {
            return def;
        }
        if ("true".equals(val)) {
            return 1;
        }
        if ("false".equals(val)) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    int getInteger(String s, int def) {
        return this.toInteger(this.getProperty(s), def);
    }

    int getInteger(String s) {
        return this.toInteger(this.getProperty(s));
    }

    int setInteger(String s, int val) {
        return this.toInteger(this.setProperty(s, String.valueOf(val)));
    }

    long toLong(String val) {
        try {
            return val == null ? 0L : Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid value");
        }
    }

    long getLong(String s) {
        return this.toLong(this.getProperty(s));
    }

    long setLong(String s, long val) {
        return this.toLong(this.setProperty(s, String.valueOf(val)));
    }

    int getTime(String s) {
        String sval = this.getProperty(s, "0");
        if ("now".equals(sval)) {
            return (int)((System.currentTimeMillis() + 500L) / 1000L);
        }
        long lval = this.toLong(sval);
        long recentSecondCount = 1000000000L;
        if (lval < 10000000000L && !"0".equals(sval)) {
            Utils.log.warning("Supplied modtime appears to be seconds rather than milliseconds: " + sval);
        }
        return (int)((lval + 500L) / 1000L);
    }

    void list(PrintStream out) {
        PrintWriter outw = new PrintWriter(out);
        this.list(outw);
        outw.flush();
    }

    void list(PrintWriter out) {
        out.println("#PACK200[");
        Set<Map.Entry<String, String>> defaults = defaultProps.entrySet();
        for (Map.Entry<String, String> e : this.theMap.entrySet()) {
            if (defaults.contains(e)) continue;
            out.println("  " + e.getKey() + " = " + e.getValue());
        }
        out.println("#]");
    }

    @Override
    public int size() {
        return this.theMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.theMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.theMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.theMap.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.theMap.get(key);
    }

    @Override
    public String remove(Object key) {
        return this.theMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.theMap.putAll(m);
    }

    @Override
    public void clear() {
        this.theMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.theMap.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.theMap.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.theMap.entrySet();
    }

    @Override
    public Comparator<? super String> comparator() {
        return this.theMap.comparator();
    }

    @Override
    public SortedMap<String, String> subMap(String fromKey, String toKey) {
        return this.theMap.subMap(fromKey, toKey);
    }

    @Override
    public SortedMap<String, String> headMap(String toKey) {
        return this.theMap.headMap(toKey);
    }

    @Override
    public SortedMap<String, String> tailMap(String fromKey) {
        return this.theMap.tailMap(fromKey);
    }

    @Override
    public String firstKey() {
        return this.theMap.firstKey();
    }

    @Override
    public String lastKey() {
        return this.theMap.lastKey();
    }

    static {
        Properties props = new Properties();
        String propValue = PropMap.getPropertyValue("io.pack200.disable.native", "false");
        props.put("io.pack200.disable.native", String.valueOf(Boolean.parseBoolean(propValue)));
        int verbose = 0;
        try {
            verbose = Integer.decode(PropMap.getPropertyValue("io.pack200.verbose", "0"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        props.put("io.pack200.verbose", String.valueOf(verbose));
        props.put("pack.segment.limit", "-1");
        props.put("pack.keep.file.order", "true");
        props.put("pack.modification.time", "keep");
        props.put("pack.deflate.hint", "keep");
        props.put("pack.unknown.attribute", "pass");
        props.put("io.pack200.class.format.error", PropMap.getPropertyValue("io.pack200.class.format.error", "pass"));
        props.put("pack.effort", "5");
        String propFile = "intrinsic.properties";
        PrivilegedAction<InputStream> pa = () -> PackerImpl.class.getResourceAsStream(propFile);
        try (InputStream propStr = AccessController.doPrivileged(pa);){
            if (propStr == null) {
                throw new RuntimeException(propFile + " cannot be loaded");
            }
            props.load(propStr);
        }
        catch (IOException ee) {
            throw new RuntimeException(ee);
        }
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            if (!key.startsWith("attribute.")) continue;
            e.setValue(Attribute.normalizeLayoutString(val));
        }
        HashMap<Object, Object> temp = new HashMap<Object, Object>(props);
        defaultProps = temp;
    }
}

