/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.elgamal;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.elgamal.impl.ElGamalPrivateKeyImpl;
import net.i2p.crypto.elgamal.impl.ElGamalPublicKeyImpl;
import net.i2p.crypto.elgamal.spec.ElGamalGenParameterSpec;
import net.i2p.crypto.elgamal.spec.ElGamalParameterSpec;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.RandomSource;

public final class KeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int DEFAULT_STRENGTH = 2048;
    private ElGamalParameterSpec elgParams;
    private boolean initialized;

    @Override
    public void initialize(int strength, SecureRandom random) {
        if (strength != 2048) {
            throw new InvalidParameterException("Unknown key type.");
        }
        this.elgParams = CryptoConstants.I2P_ELGAMAL_2048_SPEC;
        try {
            this.initialize(this.elgParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParameterException("key type not configurable.");
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params instanceof ElGamalParameterSpec) {
            this.elgParams = (ElGamalParameterSpec)params;
            if (!this.elgParams.equals(CryptoConstants.I2P_ELGAMAL_2048_SPEC)) {
                throw new InvalidAlgorithmParameterException("unsupported ElGamalParameterSpec");
            }
        } else if (params instanceof ElGamalGenParameterSpec) {
            ElGamalGenParameterSpec elgGPS = (ElGamalGenParameterSpec)params;
            if (elgGPS.getPrimeSize() != 2048) {
                throw new InvalidAlgorithmParameterException("unsupported prime size");
            }
            this.elgParams = CryptoConstants.I2P_ELGAMAL_2048_SPEC;
        } else {
            throw new InvalidAlgorithmParameterException("parameter object not a ElGamalParameterSpec");
        }
        this.initialized = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialized) {
            this.initialize(2048, (SecureRandom)RandomSource.getInstance());
        }
        KeyGenerator kg = KeyGenerator.getInstance();
        SimpleDataStructure[] keys = kg.generatePKIKeys();
        PublicKey pubKey = (PublicKey)keys[0];
        PrivateKey privKey = (PrivateKey)keys[1];
        ElGamalPublicKeyImpl epubKey = new ElGamalPublicKeyImpl(new NativeBigInteger(1, pubKey.getData()), this.elgParams);
        ElGamalPrivateKeyImpl eprivKey = new ElGamalPrivateKeyImpl(new NativeBigInteger(1, privKey.getData()), this.elgParams);
        return new KeyPair(epubKey, eprivKey);
    }
}

