/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.i2p.data.Base32;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.KeyCertificate;
import net.i2p.data.KeysAndCert;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.LHMCache;
import net.i2p.util.SystemVersion;

public class Destination
extends KeysAndCert {
    private String _cachedB64;
    private static final int CACHE_SIZE;
    private static final int MIN_CACHE_SIZE = 32;
    private static final int MAX_CACHE_SIZE = 512;
    private static final Map<SigningPublicKey, Destination> _cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination create(InputStream in) throws DataFormatException, IOException {
        Destination rv;
        byte[] padding;
        PublicKey pk = PublicKey.create(in);
        SigningPublicKey sk = SigningPublicKey.create(in);
        Certificate c = Certificate.create(in);
        if (c.getCertificateType() == 5) {
            KeyCertificate kcert = c.toKeyCertificate();
            byte[] pad1 = pk.getPadding(kcert);
            byte[] pad2 = sk.getPadding(kcert);
            padding = Destination.combinePadding(pad1, pad2);
            pk = pk.toTypedKey(kcert);
            sk = sk.toTypedKey(kcert);
            c = kcert;
        } else {
            padding = null;
        }
        Map<SigningPublicKey, Destination> map = _cache;
        synchronized (map) {
            rv = _cache.get(sk);
            if (rv != null && rv.getPublicKey().equals(pk) && rv.getCertificate().equals(c) && DataHelper.eq(rv.getPadding(), padding)) {
                return rv;
            }
            rv = new Destination(pk, sk, c, padding);
            _cache.put(sk, rv);
        }
        return rv;
    }

    public Destination() {
    }

    public Destination(String s) throws DataFormatException {
        this.fromBase64(s);
    }

    private Destination(PublicKey pk, SigningPublicKey sk, Certificate c, byte[] padding) {
        int sz;
        if (padding != null && (sz = pk.length() + sk.length() + padding.length) != 384) {
            throw new IllegalArgumentException("bad total length " + sz);
        }
        this._publicKey = pk;
        this._signingKey = sk;
        this._certificate = c;
        this.setPadding(padding);
    }

    public int writeBytes(byte[] target, int offset) {
        int cur = offset;
        System.arraycopy(this._publicKey.getData(), 0, target, cur, PublicKey.KEYSIZE_BYTES);
        cur += PublicKey.KEYSIZE_BYTES;
        cur = this.writePaddingBytes(target, cur);
        int spkTrunc = Math.min(SigningPublicKey.KEYSIZE_BYTES, this._signingKey.length());
        System.arraycopy(this._signingKey.getData(), 0, target, cur, spkTrunc);
        cur += spkTrunc;
        cur += this._certificate.writeBytes(target, cur);
        return cur - offset;
    }

    @Deprecated
    public int readBytes(byte[] source, int offset) throws DataFormatException {
        if (source == null) {
            throw new DataFormatException("Null source");
        }
        if (source.length <= offset + PublicKey.KEYSIZE_BYTES + SigningPublicKey.KEYSIZE_BYTES) {
            throw new DataFormatException("Not enough data (len=" + source.length + " off=" + offset + ")");
        }
        if (this._publicKey != null || this._signingKey != null || this._certificate != null) {
            throw new IllegalStateException();
        }
        int cur = offset;
        this._publicKey = PublicKey.create(source, cur);
        this._signingKey = SigningPublicKey.create(source, cur += PublicKey.KEYSIZE_BYTES);
        this._certificate = Certificate.create(source, cur += SigningPublicKey.KEYSIZE_BYTES);
        return (cur += this._certificate.size()) - offset;
    }

    public int size() {
        int rv = PublicKey.KEYSIZE_BYTES + this._signingKey.length();
        if (this._certificate.getCertificateType() == 5) {
            rv += 7;
            if (this._paddingBlocks > 1) {
                rv += 32 * this._paddingBlocks;
            } else {
                byte[] padding = this.getPadding();
                if (padding != null) {
                    rv += padding.length;
                }
            }
        } else {
            rv += this._certificate.size();
        }
        return rv;
    }

    @Override
    public String toBase64() {
        if (this._cachedB64 == null) {
            this._cachedB64 = super.toBase64();
        }
        return this._cachedB64;
    }

    public String toBase32() {
        try {
            return Base32.encode(this.getHash().getData()) + ".b32.i2p";
        }
        catch (IllegalStateException ise) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<SigningPublicKey, Destination> map = _cache;
        synchronized (map) {
            _cache.clear();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof Destination;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        CACHE_SIZE = (int)Math.min(512L, Math.max(32L, maxMemory / 512L * 1024L));
        _cache = new LHMCache<SigningPublicKey, Destination>(CACHE_SIZE);
    }
}

