/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;

public class ReceiveMessageBeginMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 6;
    private int _sessionId = -1;
    private long _messageId = -1L;

    public long getSessionId() {
        return this._sessionId;
    }

    @Override
    public SessionId sessionId() {
        return this._sessionId >= 0 ? new SessionId(this._sessionId) : null;
    }

    public void setSessionId(long id) {
        this._sessionId = (int)id;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public void setMessageId(long id) {
        this._messageId = id;
    }

    @Override
    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = (int)DataHelper.readLong(in, 2);
            this._messageId = DataHelper.readLong(in, 4);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        throw new UnsupportedOperationException("This shouldn't be called... use writeMessage(out)");
    }

    @Override
    public void writeMessage(OutputStream out) throws I2CPMessageException, IOException {
        int len = 6;
        try {
            DataHelper.writeLong(out, 4, len);
            out.write(6);
            DataHelper.writeLong(out, 2, this._sessionId);
            DataHelper.writeLong(out, 4, this._messageId);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to write the message length or type", dfe);
        }
    }

    @Override
    public int getType() {
        return 6;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[ReceiveMessageBeginMessage: ");
        buf.append(" SessionId: ").append(this._sessionId);
        buf.append("; MessageId: ").append(this._messageId);
        buf.append("]");
        return buf.toString();
    }
}

