/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;
import net.i2p.util.ByteArrayStream;

public class RequestLeaseSetMessage
extends I2CPMessageImpl {
    private static final long serialVersionUID = 1L;
    public static final int MESSAGE_TYPE = 21;
    private SessionId _sessionId;
    private final ArrayList<TunnelEndpoint> _endpoints = new ArrayList(6);
    private Date _end;

    public SessionId getSessionId() {
        return this._sessionId;
    }

    @Override
    public SessionId sessionId() {
        return this._sessionId;
    }

    public void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    public int getEndpoints() {
        return this._endpoints.size();
    }

    public Hash getRouter(int endpoint) {
        if (endpoint < 0 || this._endpoints.size() <= endpoint) {
            return null;
        }
        return this._endpoints.get(endpoint).getRouter();
    }

    public TunnelId getTunnelId(int endpoint) {
        if (endpoint < 0 || this._endpoints.size() <= endpoint) {
            return null;
        }
        return this._endpoints.get(endpoint).getTunnelId();
    }

    @Deprecated
    public void remoteEndpoint(int endpoint) {
        if (endpoint >= 0 && endpoint < this._endpoints.size()) {
            this._endpoints.remove(endpoint);
        }
    }

    public void addEndpoint(Hash router, TunnelId tunnel) {
        if (router == null) {
            throw new IllegalArgumentException("Null router (tunnel=" + tunnel + ")");
        }
        if (tunnel == null) {
            throw new IllegalArgumentException("Null tunnel (router=" + router + ")");
        }
        this._endpoints.add(new TunnelEndpoint(router, tunnel));
    }

    public Date getEndDate() {
        return this._end;
    }

    public void setEndDate(Date end) {
        this._end = end;
    }

    @Override
    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            int numTunnels = in.read();
            this._endpoints.clear();
            for (int i = 0; i < numTunnels; ++i) {
                Hash router = Hash.create(in);
                TunnelId tunnel = new TunnelId();
                tunnel.readBytes(in);
                this._endpoints.add(new TunnelEndpoint(router, tunnel));
            }
            this._end = DataHelper.readDate(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._sessionId == null) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        int len = 3 + this._endpoints.size() * 36 + 8;
        ByteArrayStream os = new ByteArrayStream(len);
        try {
            this._sessionId.writeBytes(os);
            os.write((byte)this._endpoints.size());
            for (int i = 0; i < this._endpoints.size(); ++i) {
                Hash router = this.getRouter(i);
                router.writeBytes(os);
                TunnelId tunnel = this.getTunnelId(i);
                tunnel.writeBytes(os);
            }
            DataHelper.writeDate(os, this._end);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    @Override
    public int getType() {
        return 21;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("RequestLeaseSetMessage: ");
        buf.append("\n* SessionId: ").append(this.getSessionId());
        buf.append("\n* Tunnels:");
        for (int i = 0; i < this.getEndpoints(); ++i) {
            buf.append("\n* RouterIdentity: ").append(this.getRouter(i));
            buf.append("\n* TunnelId: ").append(this.getTunnelId(i));
        }
        buf.append("\n* EndDate: ").append(this.getEndDate());
        return buf.toString();
    }

    private static class TunnelEndpoint
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Hash _router;
        private final TunnelId _tunnelId;

        public TunnelEndpoint(Hash router, TunnelId id) {
            this._router = router;
            this._tunnelId = id;
        }

        public Hash getRouter() {
            return this._router;
        }

        public TunnelId getTunnelId() {
            return this._tunnelId;
        }
    }
}

