/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import gnu.getopt.Getopt;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.i2p.I2PAppContext;
import net.i2p.data.Base32;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.util.I2PAppThread;
import net.i2p.util.InternalSocket;
import net.i2p.util.Log;
import net.i2p.util.PasswordManager;
import net.i2p.util.ReusableGZIPInputStream;
import net.i2p.util.SSLEepGet;
import net.i2p.util.SocketTimeout;
import net.i2p.util.SystemVersion;

public class EepGet {
    protected final I2PAppContext _context;
    protected final Log _log;
    protected final boolean _shouldProxy;
    protected final String _proxyHost;
    protected final int _proxyPort;
    protected final int _numRetries;
    private final long _minSize;
    private final long _maxSize;
    protected final String _outputFile;
    protected final OutputStream _outputStream;
    protected final String _url;
    protected String _actualURL;
    private final String _postData;
    private boolean _allowCaching;
    protected final List<StatusListener> _listeners;
    protected List<String> _extraHeaders;
    protected boolean _keepFetching;
    protected Socket _proxy;
    protected OutputStream _proxyOut;
    protected InputStream _proxyIn;
    protected OutputStream _out;
    protected long _alreadyTransferred;
    protected long _bytesTransferred;
    protected long _bytesRemaining;
    protected int _currentAttempt;
    protected int _responseCode = -1;
    protected String _responseText;
    protected boolean _shouldWriteErrorToOutput;
    protected String _etag;
    protected String _lastModified;
    protected final String _etagOrig;
    protected final String _lastModifiedOrig;
    protected boolean _encodingChunked;
    protected boolean _notModified;
    protected String _contentType;
    protected String _server;
    protected String _status;
    protected String _transferEncoding;
    protected String _contentEncoding;
    protected String _contentLanguage;
    protected String _cacheControl;
    protected String _acceptRanges;
    protected String _vary;
    protected String _expiryDate;
    protected String _cookie;
    protected String _referrerPolicy;
    protected String _xframeOptions;
    protected String _csp;
    protected String _xssProtection;
    protected String _xContentTypeOptions;
    protected String _xPoweredBy;
    protected boolean _transferFailed;
    protected volatile boolean _aborted;
    protected int _fetchHeaderTimeout;
    protected int _fetchTotalTimeout;
    protected int _fetchInactivityTimeout;
    protected int _redirects;
    protected String _redirectLocation;
    protected boolean _isGzippedResponse;
    protected IOException _decompressException;
    protected AuthState _authState;
    protected static final String USER_AGENT = "Wget/1.11.4";
    protected static final int CONNECT_TIMEOUT = 90000;
    protected static final int INACTIVITY_TIMEOUT = 120000;
    protected static final int MAX_COMPLETE_FAILS = 20;
    private static final char[] ILLEGAL = new char[]{'<', '>', ':', '\"', '/', '\\', '|', '?', '*', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\u007f'};
    private static final byte NL = 10;

    public EepGet(I2PAppContext ctx, String proxyHost, int proxyPort, int numRetries, String outputFile, String url) {
        this(ctx, true, proxyHost, proxyPort, numRetries, outputFile, url);
    }

    public EepGet(I2PAppContext ctx, String proxyHost, int proxyPort, int numRetries, String outputFile, String url, boolean allowCaching) {
        this(ctx, true, proxyHost, proxyPort, numRetries, outputFile, url, allowCaching, null);
    }

    public EepGet(I2PAppContext ctx, int numRetries, String outputFile, String url) {
        this(ctx, false, null, -1, numRetries, outputFile, url);
    }

    public EepGet(I2PAppContext ctx, int numRetries, String outputFile, String url, boolean allowCaching) {
        this(ctx, false, null, -1, numRetries, outputFile, url, allowCaching, null);
    }

    public EepGet(I2PAppContext ctx, boolean shouldProxy, String proxyHost, int proxyPort, int numRetries, String outputFile, String url) {
        this(ctx, shouldProxy, proxyHost, proxyPort, numRetries, outputFile, url, true, null);
    }

    public EepGet(I2PAppContext ctx, boolean shouldProxy, String proxyHost, int proxyPort, int numRetries, String outputFile, String url, String postData) {
        this(ctx, shouldProxy, proxyHost, proxyPort, numRetries, -1L, -1L, outputFile, null, url, true, null, postData);
    }

    public EepGet(I2PAppContext ctx, boolean shouldProxy, String proxyHost, int proxyPort, int numRetries, String outputFile, String url, boolean allowCaching, String etag) {
        this(ctx, shouldProxy, proxyHost, proxyPort, numRetries, -1L, -1L, outputFile, null, url, allowCaching, etag, null);
    }

    public EepGet(I2PAppContext ctx, boolean shouldProxy, String proxyHost, int proxyPort, int numRetries, String outputFile, String url, boolean allowCaching, String etag, String lastModified) {
        this(ctx, shouldProxy, proxyHost, proxyPort, numRetries, -1L, -1L, outputFile, null, url, allowCaching, etag, lastModified, null);
    }

    public EepGet(I2PAppContext ctx, boolean shouldProxy, String proxyHost, int proxyPort, int numRetries, long minSize, long maxSize, String outputFile, OutputStream outputStream, String url, boolean allowCaching, String etag, String postData) {
        this(ctx, shouldProxy, proxyHost, proxyPort, numRetries, minSize, maxSize, outputFile, outputStream, url, allowCaching, etag, null, postData);
    }

    public EepGet(I2PAppContext ctx, boolean shouldProxy, String proxyHost, int proxyPort, int numRetries, long minSize, long maxSize, String outputFile, OutputStream outputStream, String url, boolean allowCaching, String etag, String lastModified, String postData) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._shouldProxy = proxyHost != null && proxyHost.length() > 0 && proxyPort > 0 && shouldProxy;
        this._proxyHost = proxyHost;
        this._proxyPort = proxyPort;
        this._numRetries = numRetries;
        this._minSize = minSize;
        this._maxSize = maxSize;
        this._outputFile = outputFile;
        this._outputStream = outputStream;
        this._url = url;
        this._actualURL = url;
        this._postData = postData;
        this._bytesRemaining = -1L;
        this._fetchHeaderTimeout = 90000;
        this._listeners = new ArrayList<StatusListener>(1);
        this._allowCaching = allowCaching;
        this._etag = etag;
        this._lastModified = lastModified;
        this._etagOrig = etag;
        this._lastModifiedOrig = lastModified;
    }

    public static void main(String[] args) {
        EepGet get;
        String proxyHost = "127.0.0.1";
        int proxyPort = 4444;
        int numRetries = 10;
        int markSize = 1024;
        int lineLen = 10;
        long inactivityTimeout = 120000L;
        String etag = null;
        String saveAs = null;
        ArrayList<String> extra = null;
        String username = null;
        String password = null;
        boolean error = false;
        Getopt g = new Getopt("eepget", args, "p:cn:t:e:o:m:l:h:u:x:");
        try {
            int c;
            block17: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 112: {
                        String s = g.getOptarg();
                        int colon = s.indexOf(58);
                        if (colon >= 0) {
                            if (colon > 0) {
                                proxyHost = s.substring(0, colon);
                            }
                            String port = s.substring(colon + 1);
                            proxyPort = Integer.parseInt(port);
                            continue block17;
                        }
                        proxyHost = s;
                        continue block17;
                    }
                    case 99: {
                        proxyHost = "";
                        proxyPort = 0;
                        continue block17;
                    }
                    case 110: {
                        numRetries = Integer.parseInt(g.getOptarg());
                        continue block17;
                    }
                    case 116: {
                        inactivityTimeout = 1000 * Integer.parseInt(g.getOptarg());
                        continue block17;
                    }
                    case 101: {
                        etag = "\"" + g.getOptarg() + "\"";
                        continue block17;
                    }
                    case 111: {
                        saveAs = g.getOptarg();
                        continue block17;
                    }
                    case 109: {
                        markSize = Integer.parseInt(g.getOptarg());
                        continue block17;
                    }
                    case 108: {
                        lineLen = Integer.parseInt(g.getOptarg());
                        continue block17;
                    }
                    case 104: {
                        String a = g.getOptarg();
                        int eq = a.indexOf(61);
                        if (eq > 0) {
                            if (extra == null) {
                                extra = new ArrayList<String>(2);
                            }
                            String key = a.substring(0, eq);
                            String val = a.substring(eq + 1);
                            extra.add(key);
                            extra.add(val);
                            continue block17;
                        }
                        error = true;
                        continue block17;
                    }
                    case 117: {
                        username = g.getOptarg();
                        continue block17;
                    }
                    case 120: {
                        password = g.getOptarg();
                        continue block17;
                    }
                }
                error = true;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            error = true;
        }
        if (error || args.length - g.getOptind() != 1) {
            System.out.println(EepGet.usage());
            System.exit(1);
        }
        String url = args[g.getOptind()];
        if (saveAs == null) {
            saveAs = EepGet.suggestName(url);
        }
        if (url.startsWith("https://")) {
            boolean shouldProxy;
            if (etag != null) {
                System.err.println("Etag option unsupported with https");
                System.exit(1);
            }
            boolean bl = shouldProxy = proxyHost != null && proxyHost.length() > 0 && proxyPort > 0;
            get = shouldProxy ? new SSLEepGet(I2PAppContext.getGlobalContext(), SSLEepGet.ProxyType.HTTP, proxyHost, proxyPort, saveAs, url) : new SSLEepGet(I2PAppContext.getGlobalContext(), saveAs, url);
        } else {
            get = new EepGet(I2PAppContext.getGlobalContext(), true, proxyHost, proxyPort, numRetries, saveAs, url, true, etag);
        }
        if (extra != null) {
            for (int i = 0; i < extra.size(); i += 2) {
                get.addHeader((String)extra.get(i), (String)extra.get(i + 1));
            }
        }
        if (username != null) {
            if (password == null) {
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                    do {
                        System.err.print("Proxy password: ");
                        password = r.readLine();
                        if (password != null) continue;
                        throw new IOException();
                    } while ((password = password.trim()).length() <= 0);
                }
                catch (IOException ioe) {
                    System.exit(1);
                }
            }
            get.addAuthorization(username, password);
        }
        EepGet eepGet = get;
        eepGet.getClass();
        get.addStatusListener(eepGet.new CLIStatusListener(markSize, lineLen));
        if (!get.fetch(90000L, -1L, inactivityTimeout)) {
            System.exit(1);
        }
    }

    public static String suggestName(String url) {
        String name;
        URI nameURL = null;
        try {
            nameURL = new URI(url);
        }
        catch (URISyntaxException e) {
            String msg = e.getLocalizedMessage();
            if (msg != null) {
                System.err.println(msg);
            }
            System.err.println("Please enter a properly formed URL.");
            System.exit(1);
        }
        String path = nameURL.getRawPath();
        Pattern slashes = Pattern.compile("/+");
        Matcher matcher = slashes.matcher(path);
        if (path.equals("") || matcher.matches()) {
            name = EepGet.sanitize(nameURL.getAuthority());
        } else {
            int last = path.lastIndexOf(47);
            if (last != path.length() - 1) {
                name = EepGet.sanitize(path.substring(last + 1));
            } else {
                int slash;
                int i = 1;
                while ((slash = path.lastIndexOf(47, last - i)) == last - i) {
                    ++i;
                }
                name = EepGet.sanitize(path.substring(slash + 1, path.length() - i));
            }
        }
        return name;
    }

    private static String sanitize(String name) {
        if (name.equals(".") || name.equals(" ")) {
            return "_";
        }
        String rv = name;
        if (rv.startsWith(".")) {
            rv = '_' + rv.substring(1);
        }
        if (rv.endsWith(".") || rv.endsWith(" ")) {
            rv = rv.substring(0, rv.length() - 1) + '_';
        }
        for (int i = 0; i < ILLEGAL.length; ++i) {
            if (rv.indexOf(ILLEGAL[i]) < 0) continue;
            rv = rv.replace(ILLEGAL[i], '_');
        }
        return rv;
    }

    private static String usage() {
        return "Usage:\n  eepget [opts] <url>   retrieve webpage or file from remote server\n\nOptions:\n  -c                    do not use proxy\n  -n <value>            number of retries (default 10)\n  -o <filename>         use specified output filename\n  -p <host:port>        use alternative proxy (default is 127.0.0.1:4444)\n  -t <value>            timeout in seconds (default 120)\n  -u <value>            proxy username\n  -x <value>            proxy password\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(StatusListener lsnr) {
        List<StatusListener> list = this._listeners;
        synchronized (list) {
            this._listeners.add(lsnr);
        }
    }

    public void stopFetching() {
        this._keepFetching = false;
    }

    public boolean fetch() {
        return this.fetch(this._fetchHeaderTimeout);
    }

    public boolean fetch(long fetchHeaderTimeout) {
        return this.fetch(fetchHeaderTimeout, -1L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetch(long fetchHeaderTimeout, long totalTimeout, long inactivityTimeout) {
        if (totalTimeout > 0L && fetchHeaderTimeout <= 0L) {
            fetchHeaderTimeout = totalTimeout;
        }
        this._fetchHeaderTimeout = (int)Math.min(fetchHeaderTimeout, Integer.MAX_VALUE);
        this._fetchTotalTimeout = (int)Math.min(totalTimeout, Integer.MAX_VALUE);
        this._fetchInactivityTimeout = (int)Math.min(inactivityTimeout, Integer.MAX_VALUE);
        this._keepFetching = true;
        if (this._log.shouldDebug()) {
            this._log.debug("Fetching (proxied? " + this._shouldProxy + ") url=" + this._actualURL);
        }
        while (this._keepFetching) {
            SocketTimeout timeout = null;
            if (this._fetchHeaderTimeout > 0) {
                final SocketTimeout stimeout = timeout = new SocketTimeout(this._fetchHeaderTimeout);
                final Thread thread = Thread.currentThread();
                timeout.setTimeoutCommand(new Runnable(){

                    @Override
                    public void run() {
                        if (EepGet.this._log.shouldDebug()) {
                            EepGet.this._log.debug("Timeout reached on " + EepGet.this._url + ": " + stimeout);
                        }
                        EepGet.this._aborted = true;
                        thread.interrupt();
                    }
                });
                if (this._fetchTotalTimeout > 0) {
                    timeout.setTotalTimeoutPeriod(this._fetchTotalTimeout);
                }
            }
            try {
                int i;
                for (i = 0; i < this._listeners.size(); i += 1) {
                    this._listeners.get(i).attempting(this._url);
                }
                this.sendRequest(timeout);
                if (timeout != null) {
                    timeout.resetTimer();
                }
                this.doFetch(timeout);
                if (this._transferFailed) break;
                i = 1;
                return i != 0;
            }
            catch (IOException ioe) {
                for (int i = 0; i < this._listeners.size(); ++i) {
                    this._listeners.get(i).attemptFailed(this._url, this._bytesTransferred, this._bytesRemaining, this._currentAttempt, this._numRetries, ioe);
                }
                int truncate = this._url.indexOf("&");
                if (this._log.shouldWarn()) {
                    if (this._url.contains("&") && this._url.contains("info_hash")) {
                        this._log.warn("Transfer failed [" + this._url.substring(0, truncate).replace("http://", "") + "...] (" + ioe.getMessage() + ")");
                    } else {
                        this._log.warn("Transfer failed [" + this._url + "] (" + ioe.getMessage() + ")");
                    }
                }
                if (ioe instanceof MalformedURLException || ioe instanceof UnknownHostException || ioe instanceof ConnectException) {
                    this._keepFetching = false;
                }
            }
            finally {
                if (timeout != null) {
                    timeout.cancel();
                }
                if (this._out != null) {
                    try {
                        this._out.close();
                    }
                    catch (IOException ioe) {}
                    this._out = null;
                }
                if (this._proxy != null) {
                    try {
                        this._proxy.close();
                        this._proxy = null;
                    }
                    catch (IOException ioe) {}
                }
            }
            ++this._currentAttempt;
            if (this._currentAttempt > this._numRetries || this._alreadyTransferred == 0L && this._currentAttempt > 20 || !this._keepFetching) break;
            this._redirects = 0;
            try {
                long delay = this._context.random().nextInt(60000);
                Thread.sleep(5000L + delay);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).transferFailed(this._url, this._bytesTransferred, this._bytesRemaining, this._currentAttempt);
        }
        int truncate = this._url.indexOf("&");
        if (this._log.shouldWarn()) {
            if (this._url.contains("&") && this._url.contains("info_hash")) {
                if (this._url.startsWith("https")) {
                    this._log.warn("Eepget error: All attempts failed for [" + this._url.substring(0, truncate) + "...]");
                } else {
                    this._log.warn("Eepget error: All attempts failed for [" + this._url.substring(7, truncate) + "...]");
                }
            } else {
                this._log.warn("Eepget error: All attempts failed for [" + this._url + "]");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFetch(SocketTimeout timeout) throws IOException {
        int i;
        int n;
        boolean strictSize;
        this._aborted = false;
        this.readHeaders();
        if (this._aborted) {
            throw new IOException("Eepget error: Timed out reading the HTTP headers");
        }
        if (this._proxy != null) {
            if (timeout != null) {
                if (this._fetchTotalTimeout > 0) {
                    timeout.resetTimer();
                } else {
                    timeout.cancel();
                    timeout = null;
                }
            }
            if (this._fetchInactivityTimeout > 0) {
                this._proxy.setSoTimeout(this._fetchInactivityTimeout);
            } else {
                this._proxy.setSoTimeout(120000);
            }
        } else if (timeout != null) {
            timeout.resetTimer();
            if (this._fetchInactivityTimeout > 0) {
                timeout.setInactivityTimeout(this._fetchInactivityTimeout);
            } else {
                timeout.setInactivityTimeout(120000L);
            }
        }
        if (this._redirectLocation != null) {
            block75: {
                try {
                    int n2;
                    if (this._redirectLocation.startsWith("http://")) {
                        this._actualURL = this._redirectLocation;
                        break block75;
                    }
                    if (this._redirectLocation.startsWith("https://")) {
                        SSLEepGet get;
                        if (this._proxy == null) {
                            throw new IOException("Redirect to https unsupported");
                        }
                        if (this._postData != null) {
                            throw new IOException("Redirect to https unsupported");
                        }
                        try {
                            this._proxy.close();
                            this._proxy = null;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (timeout != null) {
                            timeout.cancel();
                        }
                        if (this._shouldProxy) {
                            if (this._authState != null) {
                                throw new IOException("Redirect to https with proxy auth unsupported");
                            }
                            get = this._outputStream != null ? new SSLEepGet(this._context, SSLEepGet.ProxyType.HTTP, this._proxyHost, this._proxyPort, this._outputStream, this._redirectLocation) : new SSLEepGet(this._context, SSLEepGet.ProxyType.HTTP, this._proxyHost, this._proxyPort, this._outputFile, this._redirectLocation);
                        } else {
                            get = this._outputStream != null ? new SSLEepGet(this._context, this._outputStream, this._redirectLocation) : new SSLEepGet(this._context, this._outputFile, this._redirectLocation);
                        }
                        if (this._shouldWriteErrorToOutput) {
                            get.setWriteErrorToOutput();
                        }
                        if (this._extraHeaders != null) {
                            for (String string : this._extraHeaders) {
                                String[] kv = DataHelper.split(string, ":", 2);
                                if (kv.length != 2) continue;
                                get.addHeader(kv[0].trim(), kv[1].trim());
                            }
                        }
                        List<StatusListener> list = this._listeners;
                        synchronized (list) {
                            for (StatusListener sl : this._listeners) {
                                get.addStatusListener(sl);
                            }
                        }
                        this._actualURL = this._redirectLocation;
                        this._bytesRemaining = -1L;
                        this._redirectLocation = null;
                        this._etag = this._etagOrig;
                        this._lastModified = this._lastModifiedOrig;
                        this._contentType = null;
                        this._contentLanguage = null;
                        this._server = null;
                        this._status = null;
                        this._encodingChunked = false;
                        this._contentEncoding = null;
                        this._transferEncoding = null;
                        this._cacheControl = null;
                        this._acceptRanges = null;
                        this._vary = null;
                        this._expiryDate = null;
                        this._cookie = null;
                        this._referrerPolicy = null;
                        this._xframeOptions = null;
                        this._csp = null;
                        this._xssProtection = null;
                        this._xContentTypeOptions = null;
                        this._xPoweredBy = null;
                        this._transferFailed = !get.fetch(this._fetchHeaderTimeout, -1L, this._fetchInactivityTimeout);
                        this._keepFetching = false;
                        this._responseCode = get.getStatusCode();
                        this._responseText = get.getStatusText();
                        this._contentType = get.getContentType();
                        this._server = get.getServer();
                        this._status = get.getStatus();
                        this._transferEncoding = get.getTransferEncoding();
                        this._contentEncoding = get.getContentEncoding();
                        this._contentLanguage = get.getContentLanguage();
                        this._cacheControl = get.getCacheControl();
                        this._acceptRanges = get.getAcceptRanges();
                        this._vary = get.getVary();
                        this._expiryDate = get.getExpiryDate();
                        this._etag = get.getEtag();
                        this._lastModified = get.getLastModified();
                        this._notModified = get.getNotModified();
                        this._cookie = get.getCookie();
                        this._referrerPolicy = get.getReferrerPolicy();
                        this._xframeOptions = get.getXframeOptions();
                        this._csp = get.getCSP();
                        this._xssProtection = get.getXSSProtection();
                        this._xContentTypeOptions = get.getXContentTypeOptions();
                        this._xPoweredBy = get.getXPoweredBy();
                        return;
                    }
                    URI url = new URI(this._actualURL);
                    String host = url.getHost();
                    if (host == null) {
                        throw new MalformedURLException("Redirected to invalid URL");
                    }
                    int n3 = url.getPort();
                    if (n3 < 0) {
                        n2 = 80;
                    }
                    this._actualURL = this._redirectLocation.startsWith("/") ? "http://" + host + ":" + n2 + this._redirectLocation : "http://" + host + ":" + n2 + "/" + this._redirectLocation;
                }
                catch (URISyntaxException use) {
                    MalformedURLException ioe = new MalformedURLException("Redirected to invalid URL");
                    ioe.initCause(use);
                    throw ioe;
                }
            }
            AuthState as = this._authState;
            if (this._responseCode == 407) {
                if (!this._shouldProxy) {
                    throw new IOException("Proxy auth response from non-proxy");
                }
                if (as == null) {
                    throw new IOException("Proxy requires authentication");
                }
                if (as.authSent) {
                    throw new IOException("Proxy authentication failed");
                }
                if (this._log.shouldInfo()) {
                    this._log.info("Adding auth");
                }
            } else {
                ++this._redirects;
                if (this._redirects > 5) {
                    throw new IOException("Too many redirects: to " + this._redirectLocation);
                }
                if (this._log.shouldInfo()) {
                    this._log.info("Redirecting to " + this._redirectLocation);
                }
                if (as != null) {
                    as.authSent = false;
                }
            }
            this._bytesRemaining = -1L;
            this._redirectLocation = null;
            this._etag = this._etagOrig;
            this._lastModified = this._lastModifiedOrig;
            this._contentType = null;
            this._encodingChunked = false;
            this.sendRequest(timeout);
            this.doFetch(timeout);
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Headers read completely");
        }
        boolean bl = strictSize = this._bytesRemaining >= 0L;
        if (this._minSize > 0L && this._bytesRemaining < this._minSize) {
            throw new IOException("HTTP response size " + this._bytesRemaining + " violates minimum of " + this._minSize + " bytes");
        }
        if (this._maxSize > -1L && this._bytesRemaining > this._maxSize) {
            throw new IOException("HTTP response size " + this._bytesRemaining + " violates maximum of " + this._maxSize + " bytes");
        }
        Thread pusher = null;
        this._decompressException = null;
        if (this._isGzippedResponse) {
            if (this._log.shouldInfo()) {
                this._log.info("Gzipped response, starting decompressor");
            }
            PipedInputStream pipedInputStream = new PipedInputStream(65536);
            PipedOutputStream po = new PipedOutputStream(pipedInputStream);
            pusher = new I2PAppThread(new Gunzipper(pipedInputStream, this._out), "EepGet Decompressor");
            this._out = po;
            pusher.start();
        }
        int n4 = (int)this._bytesRemaining;
        byte[] buf = new byte[16384];
        while (!(!this._keepFetching || n <= 0 && strictSize || this._aborted)) {
            int read;
            int toRead = buf.length;
            if (strictSize && toRead > n) {
                toRead = n;
            }
            if ((read = this._proxyIn.read(buf, 0, toRead)) == -1) break;
            if (timeout != null) {
                timeout.resetTimer();
            }
            this._out.write(buf, 0, read);
            this._bytesTransferred += (long)read;
            if (this._maxSize > -1L && this._alreadyTransferred + (long)read > this._maxSize) {
                throw new IOException("Bytes transferred " + (this._alreadyTransferred + (long)read) + " violates maximum of " + this._maxSize + " bytes");
            }
            if ((n -= read) == 0 && this._encodingChunked) {
                int char1 = this._proxyIn.read();
                if (char1 == 13) {
                    int char2 = this._proxyIn.read();
                    if (char2 == 10) {
                        n = (int)this.readChunkLength();
                    } else {
                        this._out.write(char1);
                        this._out.write(char2);
                        this._bytesTransferred += 2L;
                        n -= 2;
                        read += 2;
                    }
                } else {
                    this._out.write(char1);
                    ++this._bytesTransferred;
                    --n;
                    ++read;
                }
            }
            if (timeout != null) {
                timeout.resetTimer();
            }
            if (this._bytesRemaining >= (long)read) {
                this._bytesRemaining -= (long)read;
            }
            if (read <= 0) continue;
            for (i = 0; i < this._listeners.size(); ++i) {
                this._listeners.get(i).bytesTransferred(this._alreadyTransferred, read, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url);
            }
            this._alreadyTransferred += (long)read;
        }
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
        if (this._isGzippedResponse) {
            try {
                pusher.join();
            }
            catch (InterruptedException toRead) {
                // empty catch block
            }
            pusher = null;
            if (this._decompressException != null) {
                this._keepFetching = false;
                throw this._decompressException;
            }
        }
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP data");
        }
        if (timeout != null) {
            timeout.cancel();
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Done transferring " + this._bytesTransferred + " (ok? " + !this._transferFailed + ")");
        }
        if (this._transferFailed) {
            if (!this._listeners.isEmpty()) {
                String s = this._responseText != null ? "Attempt failed: " + this._responseCode + ' ' + this._responseText : "Attempt failed: " + this._responseCode;
                IOException e = new IOException(s);
                for (i = 0; i < this._listeners.size(); ++i) {
                    this._listeners.get(i).attemptFailed(this._url, this._bytesTransferred, this._bytesRemaining, this._currentAttempt, this._numRetries, e);
                }
            }
        } else {
            if (this._minSize > 0L && this._alreadyTransferred < this._minSize) {
                throw new IOException("Bytes transferred " + this._alreadyTransferred + " violates minimum of " + this._minSize + " bytes");
            }
            if (this._bytesRemaining == -1L || n == 0) {
                for (int i2 = 0; i2 < this._listeners.size(); ++i2) {
                    this._listeners.get(i2).transferComplete(this._alreadyTransferred, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url, this._outputFile, this._notModified);
                }
            } else {
                throw new IOException("Disconnected on attempt " + (this._currentAttempt + 1) + " after " + this._bytesTransferred + " bytes transferred");
            }
        }
    }

    protected void readHeaders() throws IOException {
        String key = null;
        StringBuilder buf = new StringBuilder(32);
        boolean read = DataHelper.readLine(this._proxyIn, buf);
        if (!read) {
            throw new IOException("Unable to read the first line");
        }
        this._responseCode = this.handleStatus(buf.toString());
        boolean redirect = false;
        if (this._log.shouldDebug()) {
            this._log.debug(this._actualURL + " -> Status: " + this._status);
        }
        boolean rcOk = false;
        switch (this._responseCode) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 207: 
            case 208: 
            case 226: {
                if (this._outputStream != null) {
                    if (this._alreadyTransferred > 0L) {
                        rcOk = true;
                        this._keepFetching = false;
                        this._transferFailed = true;
                        break;
                    }
                    this._out = this._outputStream;
                } else {
                    this._out = new FileOutputStream(this._outputFile, false);
                }
                this._alreadyTransferred = 0L;
                rcOk = true;
                break;
            }
            case 206: {
                this._out = this._outputStream != null ? this._outputStream : new FileOutputStream(this._outputFile, true);
                rcOk = true;
                break;
            }
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                this._alreadyTransferred = 0L;
                rcOk = true;
                redirect = true;
                break;
            }
            case 304: {
                this._bytesRemaining = 0L;
                this._keepFetching = false;
                this._notModified = true;
                return;
            }
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 413: 
            case 414: 
            case 415: 
            case 418: 
            case 420: 
            case 421: 
            case 423: 
            case 424: 
            case 426: 
            case 428: 
            case 429: 
            case 431: 
            case 451: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 505: 
            case 506: 
            case 507: 
            case 508: 
            case 510: 
            case 511: {
                this._transferFailed = true;
                if (this._alreadyTransferred > 0L || !this._shouldWriteErrorToOutput) {
                    this._keepFetching = false;
                    return;
                }
                rcOk = true;
                if (this._out != null) break;
                if (this._outputStream != null) {
                    this._out = this._outputStream;
                    break;
                }
                this._out = new FileOutputStream(this._outputFile, true);
                break;
            }
            case 407: {
                this._alreadyTransferred = 0L;
                rcOk = this._authState != null ? !this._authState.authSent : false;
                redirect = rcOk;
                this._keepFetching = rcOk;
                break;
            }
            case 416: {
                this._bytesRemaining = 0L;
                if (this._alreadyTransferred > 0L || !this._shouldWriteErrorToOutput) {
                    this._keepFetching = false;
                    return;
                }
                rcOk = true;
                if (this._out != null) break;
                if (this._outputStream != null) {
                    this._out = this._outputStream;
                    break;
                }
                this._out = new FileOutputStream(this._outputFile, true);
                break;
            }
            case 504: {
                if (this._alreadyTransferred > 0L || !this._shouldWriteErrorToOutput || this._currentAttempt < this._numRetries) {
                    throw new IOException("HTTP Proxy timeout");
                }
                rcOk = true;
                if (this._out == null) {
                    this._out = this._outputStream != null ? this._outputStream : new FileOutputStream(this._outputFile, true);
                }
                this._transferFailed = true;
                break;
            }
            default: {
                if (this._alreadyTransferred > 0L || !this._shouldWriteErrorToOutput) {
                    this._keepFetching = false;
                } else {
                    rcOk = true;
                    if (this._out == null) {
                        this._out = this._outputStream != null ? this._outputStream : new FileOutputStream(this._outputFile, true);
                    }
                }
                this._transferFailed = true;
            }
        }
        this._isGzippedResponse = false;
        this._etag = null;
        this._lastModified = null;
        buf.setLength(0);
        byte[] lookahead = new byte[3];
        EepGet.increment(lookahead, 10);
        block15: do {
            int cur = this._proxyIn.read();
            switch (cur) {
                case -1: {
                    throw new IOException("EOF reading headers");
                }
                case 58: {
                    if (key == null) {
                        key = buf.toString();
                        buf.setLength(0);
                        EepGet.increment(lookahead, cur);
                        break;
                    }
                    buf.append((char)cur);
                    EepGet.increment(lookahead, cur);
                    break;
                }
                case 10: 
                case 13: {
                    if (key != null) {
                        this.handle(key, buf.toString());
                    }
                    buf.setLength(0);
                    key = null;
                    EepGet.increment(lookahead, cur);
                    if (!EepGet.isEndOfHeaders(lookahead)) continue block15;
                    if (!rcOk) {
                        throw new IOException("Invalid HTTP response: " + this._responseCode + ' ' + this._responseText);
                    }
                    if (this._encodingChunked) {
                        this._bytesRemaining = this.readChunkLength();
                    }
                    if (!redirect) {
                        this._redirectLocation = null;
                    } else if (this._responseCode == 407) {
                        this._redirectLocation = this._actualURL;
                    }
                    return;
                }
                default: {
                    buf.append((char)cur);
                    EepGet.increment(lookahead, cur);
                }
            }
        } while (buf.length() <= 4096);
        throw new IOException("Header line too long: " + buf.toString());
    }

    protected boolean shouldReadBody() {
        return true;
    }

    protected long readChunkLength() throws IOException {
        StringBuilder buf = new StringBuilder(8);
        int nl = 0;
        do {
            int cur = this._proxyIn.read();
            switch (cur) {
                case -1: {
                    throw new IOException("Chunk ended too soon");
                }
                case 10: 
                case 13: {
                    ++nl;
                }
            }
            buf.append((char)cur);
        } while (nl < 2);
        String len = buf.toString().trim();
        try {
            long bytes = Long.parseLong(len, 16);
            return bytes;
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Invalid chunk length [" + len + "]");
        }
    }

    private int handleStatus(String line) {
        String[] toks;
        line = line.trim();
        if (this._log.shouldDebug()) {
            this._log.debug("Status line: [" + line + "]");
        }
        if ((toks = DataHelper.split(line, " ", 3)).length < 2) {
            if (this._log.shouldWarn()) {
                this._log.warn("Error: status " + line);
            }
            return -1;
        }
        String rc = toks[1];
        try {
            this._responseText = toks.length >= 3 ? toks[2].trim() : null;
            return Integer.parseInt(rc);
        }
        catch (NumberFormatException nfe) {
            if (this._log.shouldWarn()) {
                this._log.warn("Error: Status is INVALID: " + line, nfe);
            }
            return -1;
        }
    }

    private void handle(String key, String val) {
        key = key.trim();
        val = val.trim();
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).headerReceived(this._url, this._currentAttempt, key, val);
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Header line: [" + key + "] = [" + val + "]");
        }
        if ((key = key.toLowerCase(Locale.US)).equals("content-length")) {
            try {
                this._bytesRemaining = Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        } else if (key.equals("etag")) {
            this._etag = val;
        } else if (key.equals("server")) {
            this._server = val;
        } else if (key.equals("status")) {
            this._status = val;
        } else if (key.equals("last-modified")) {
            this._lastModified = val;
        } else if (key.equals("cache-control")) {
            this._cacheControl = val;
        } else if (key.equals("accept-ranges")) {
            this._acceptRanges = val;
        } else if (key.equals("vary")) {
            this._vary = val;
        } else if (key.equals("expires")) {
            this._expiryDate = val;
        } else if (key.equals("content-language")) {
            this._contentLanguage = val;
        } else if (key.equals("transfer-encoding")) {
            this._encodingChunked = this.shouldReadBody() && val.toLowerCase(Locale.US).contains("chunked");
        } else if (key.equals("content-encoding")) {
            this._contentEncoding = val;
            if (!this._actualURL.endsWith(".gz") && !this._actualURL.endsWith(".tgz")) {
                this._isGzippedResponse = val.toLowerCase(Locale.US).contains("gzip");
            }
        } else if (key.equals("content-type")) {
            this._contentType = val;
        } else if (key.equals("location")) {
            this._redirectLocation = val;
        } else if (key.equals("set-cookie")) {
            this._cookie = val;
        } else if (key.equals("referrer-policy")) {
            this._referrerPolicy = val;
        } else if (key.equals("x-frame-options")) {
            this._xframeOptions = val;
        } else if (key.equals("x-content-type-options")) {
            this._xContentTypeOptions = val;
        } else if (key.equals("content-security-policy")) {
            this._csp = val;
        } else if (key.equals("x-xss-protection")) {
            this._xssProtection = val;
        } else if (key.equals("x-powered-by")) {
            this._xPoweredBy = val;
        } else if (key.equals("proxy-authenticate") && this._responseCode == 407 && this._authState != null && this._shouldProxy) {
            this._authState.setAuthChallenge(val);
        }
    }

    private static void increment(byte[] lookahead, int cur) {
        lookahead[0] = lookahead[1];
        lookahead[1] = lookahead[2];
        lookahead[2] = (byte)cur;
    }

    private static boolean isEndOfHeaders(byte[] lookahead) {
        return lookahead[2] == 10 && (lookahead[0] == 10 || lookahead[1] == 10);
    }

    protected void sendRequest(SocketTimeout timeout) throws IOException {
        String req;
        block24: {
            File outFile;
            if (this._outputStream == null && (outFile = new File(this._outputFile)).exists()) {
                this._alreadyTransferred = outFile.length();
            }
            req = this.getRequest();
            if (this._proxyIn != null) {
                try {
                    this._proxyIn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this._proxyOut != null) {
                try {
                    this._proxyOut.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this._proxy != null) {
                try {
                    this._proxy.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this._shouldProxy) {
                this._proxy = InternalSocket.getSocket(this._proxyHost, this._proxyPort);
            } else {
                try {
                    URI url = new URI(this._actualURL);
                    if ("http".equals(url.getScheme())) {
                        String host = url.getHost();
                        if (host == null) {
                            throw new MalformedURLException("URL is not supported: " + this._actualURL);
                        }
                        String hostlc = host.toLowerCase(Locale.US);
                        if (hostlc.endsWith(".i2p")) {
                            throw new UnknownHostException("I2P addresses must be proxied.");
                        }
                        if (hostlc.endsWith(".onion")) {
                            throw new UnknownHostException("Tor addresses must be proxied.");
                        }
                        int port = url.getPort();
                        if (port == -1) {
                            port = 80;
                        }
                        if (this._fetchHeaderTimeout > 0) {
                            this._proxy = new Socket();
                            this._proxy.setSoTimeout(this._fetchHeaderTimeout);
                            this._proxy.connect(new InetSocketAddress(host, port), this._fetchHeaderTimeout);
                        } else {
                            this._proxy = new Socket(host, port);
                        }
                        break block24;
                    }
                    throw new MalformedURLException("URL is not supported: " + this._actualURL);
                }
                catch (URISyntaxException use) {
                    MalformedURLException ioe = new MalformedURLException("Request URL is invalid");
                    ioe.initCause(use);
                    throw ioe;
                }
            }
        }
        this._proxyIn = this._proxy.getInputStream();
        if (!(this._proxy instanceof InternalSocket)) {
            this._proxyIn = new BufferedInputStream(this._proxyIn);
        }
        this._proxyOut = this._proxy.getOutputStream();
        if (timeout != null) {
            timeout.setSocket(this._proxy);
        }
        this._proxyOut.write(DataHelper.getUTF8(req));
        this._proxyOut.flush();
        if (this._log.shouldDebug()) {
            this._log.debug("Request flushed");
        }
    }

    protected String getRequest() throws IOException {
        String urlToSend;
        URI url;
        StringBuilder buf = new StringBuilder(2048);
        boolean post = false;
        if (this._postData != null && this._postData.length() > 0) {
            post = true;
        }
        try {
            url = new URI(this._actualURL);
        }
        catch (URISyntaxException use) {
            MalformedURLException ioe = new MalformedURLException("Bad URL: " + this._actualURL);
            ioe.initCause(use);
            throw ioe;
        }
        String host = url.getHost();
        if (host == null || host.length() <= 0) {
            throw new MalformedURLException("Bad URL, no host: " + url);
        }
        int port = url.getPort();
        String path = url.getRawPath();
        String query = url.getRawQuery();
        if (this._log.shouldDebug()) {
            this._log.debug("Requesting " + this._actualURL);
        }
        if (this._shouldProxy) {
            urlToSend = this._actualURL;
            if (!(path != null && path.length() > 0 || query != null && query.length() > 0)) {
                urlToSend = urlToSend + "/";
            }
        } else {
            urlToSend = path;
            if (urlToSend == null || urlToSend.length() <= 0) {
                urlToSend = "/";
            }
            if (query != null) {
                urlToSend = urlToSend + '?' + query;
            }
        }
        if (post) {
            buf.append("POST ");
        } else {
            buf.append("GET ");
        }
        buf.append(urlToSend).append(" HTTP/1.1\r\n");
        buf.append("Host: ").append(host);
        if (port >= 0) {
            buf.append(':').append(port);
        }
        buf.append("\r\n");
        if (this._alreadyTransferred > 0L) {
            buf.append("Range: bytes=");
            buf.append(this._alreadyTransferred);
            buf.append("-\r\n");
        }
        if (!this._allowCaching) {
            buf.append("Cache-Control: no-cache\r\nPragma: no-cache\r\n");
        }
        boolean uaOverridden = false;
        boolean etagOverridden = false;
        boolean lastmodOverridden = false;
        if (this._extraHeaders != null) {
            for (String hdr : this._extraHeaders) {
                String hlc = hdr.toLowerCase(Locale.US);
                if (hlc.startsWith("user-agent: ")) {
                    uaOverridden = true;
                } else if (hlc.startsWith("if-none-match: ")) {
                    etagOverridden = true;
                } else if (hlc.startsWith("if-modified-since: ")) {
                    lastmodOverridden = true;
                }
                buf.append(hdr).append("\r\n");
            }
        }
        if (this._server != null) {
            buf.append("Server: ");
            buf.append(this._server);
            buf.append("\r\n");
        }
        if (this._status != null) {
            buf.append("Status: ");
            buf.append(this._status);
            buf.append("\r\n");
        }
        if (this._cacheControl != null) {
            buf.append("Cache-Control: ");
            buf.append(this._cacheControl);
            buf.append("\r\n");
        }
        if (this._acceptRanges != null) {
            buf.append("Accept-Ranges: ");
            buf.append(this._acceptRanges);
            buf.append("\r\n");
        }
        if (this._vary != null) {
            buf.append("Vary: ");
            buf.append(this._vary);
            buf.append("\r\n");
        }
        if (this._expiryDate != null) {
            buf.append("Expires: ");
            buf.append(this._expiryDate);
            buf.append("\r\n");
        }
        if (this._transferEncoding != null) {
            buf.append("Transfer-Encoding: ");
            buf.append(this._transferEncoding);
            buf.append("\r\n");
        }
        if (this._contentEncoding != null) {
            buf.append("Content-Encoding: ");
            buf.append(this._contentEncoding);
            buf.append("\r\n");
        }
        if (this._cookie != null) {
            buf.append("Set-Cookie: ");
            buf.append(this._cookie);
            buf.append("\r\n");
        }
        if (this._referrerPolicy != null) {
            buf.append("Referrer-Policy: ");
            buf.append(this._referrerPolicy);
            buf.append("\r\n");
        }
        if (this._etag != null && this._alreadyTransferred <= 0L && !etagOverridden) {
            buf.append("If-None-Match: ");
            buf.append(this._etag);
            buf.append("\r\n");
        }
        if (this._lastModified != null && this._alreadyTransferred <= 0L && !lastmodOverridden) {
            buf.append("If-Modified-Since: ");
            buf.append(this._lastModified);
            buf.append("\r\n");
        }
        if (post) {
            buf.append("Content-length: ").append(this._postData.length()).append("\r\n");
        }
        buf.append("Accept-Encoding: ");
        if (path == null || !path.endsWith(".gz") && !path.endsWith(".tgz")) {
            buf.append("gzip");
        }
        buf.append("\r\n");
        if (!uaOverridden) {
            buf.append("User-Agent: Wget/1.11.4\r\n");
        }
        if (this._authState != null && this._shouldProxy && this._authState.authMode != AUTH_MODE.NONE) {
            buf.append("Proxy-Authorization: ");
            String method = post ? "POST" : "GET";
            buf.append(this._authState.getAuthHeader(method, urlToSend));
            buf.append("\r\n");
        }
        buf.append("Connection: close\r\n\r\n");
        if (post) {
            buf.append(this._postData);
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Request:\n" + buf.toString().trim());
        }
        return buf.toString();
    }

    public String getEtag() {
        return this._etag;
    }

    public String getLastModified() {
        return this._lastModified;
    }

    public boolean getNotModified() {
        return this._notModified;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getServer() {
        return this._server;
    }

    public String getContentLanguage() {
        if (this._contentLanguage != null && this._contentLanguage.equals("und")) {
            return "";
        }
        return this._contentLanguage;
    }

    public String getTransferEncoding() {
        return this._transferEncoding;
    }

    public String getContentEncoding() {
        return this._contentEncoding;
    }

    public String getCacheControl() {
        return this._cacheControl;
    }

    public String getAcceptRanges() {
        return this._acceptRanges;
    }

    public String getExpiryDate() {
        return this._expiryDate;
    }

    public String getCookie() {
        return this._cookie;
    }

    public String getReferrerPolicy() {
        return this._referrerPolicy;
    }

    public String getVary() {
        return this._vary;
    }

    public String getXframeOptions() {
        return this._xframeOptions;
    }

    public String getCSP() {
        return this._csp;
    }

    public String getXSSProtection() {
        return this._xssProtection;
    }

    public String getXContentTypeOptions() {
        return this._xContentTypeOptions;
    }

    public String getXPoweredBy() {
        return this._xPoweredBy;
    }

    public int getStatusCode() {
        return this._responseCode;
    }

    public String getStatusText() {
        return this._responseText;
    }

    public String getStatus() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(this._responseCode);
        if (this._responseText != null) {
            buf.append(' ');
            buf.append(this._responseText);
        }
        return buf.toString();
    }

    public void setWriteErrorToOutput() {
        this._shouldWriteErrorToOutput = true;
    }

    public void addHeader(String name, String value) {
        if (this._extraHeaders == null) {
            this._extraHeaders = new ArrayList<String>();
        }
        this._extraHeaders.add(name + ": " + value);
    }

    public void addAuthorization(String userName, String password) {
        if (this._shouldProxy) {
            if (this._authState != null) {
                throw new IllegalStateException();
            }
            this._authState = new AuthState(userName, password);
        }
    }

    public static Map<String, String> parseAuthArgs(String args) {
        HashMap<String, String> rv = new HashMap<String, String>(8);
        char[] data = args.toCharArray();
        StringBuilder buf = new StringBuilder(32);
        boolean isQuoted = false;
        String key = null;
        block5: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case '\"': {
                    if (isQuoted) {
                        if (key != null) {
                            rv.put(key, buf.toString().trim());
                            key = null;
                        }
                        buf.setLength(0);
                    }
                    isQuoted = !isQuoted;
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    if (isQuoted) {
                        buf.append(data[i]);
                        continue block5;
                    }
                    if (key != null) {
                        rv.put(key, buf.toString().trim());
                        key = null;
                    }
                    buf.setLength(0);
                    continue block5;
                }
                case '=': {
                    if (isQuoted) {
                        buf.append(data[i]);
                        continue block5;
                    }
                    key = buf.toString().trim().toLowerCase(Locale.US);
                    buf.setLength(0);
                    continue block5;
                }
                default: {
                    buf.append(data[i]);
                }
            }
        }
        if (key != null) {
            rv.put(key, buf.toString().trim());
        }
        return rv;
    }

    private static String lc8hex(int nc) {
        StringBuilder buf = new StringBuilder(8);
        for (int i = 28; i >= 0; i -= 4) {
            int v = nc >> i & 0xF;
            if (v < 10) {
                buf.append((char)(v + 48));
                continue;
            }
            buf.append((char)(v + 97 - 10));
        }
        return buf.toString();
    }

    protected class Gunzipper
    implements Runnable {
        private final InputStream _inRaw;
        private final OutputStream _out;

        public Gunzipper(InputStream in, OutputStream out) {
            this._inRaw = in;
            this._out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReusableGZIPInputStream in = ReusableGZIPInputStream.acquire();
            Object ba = null;
            long written = 0L;
            try {
                in.initialize(this._inRaw);
                DataHelper.copy(in, this._out);
            }
            catch (IOException ioe) {
                EepGet.this._decompressException = ioe;
                if (EepGet.this._log.shouldWarn()) {
                    EepGet.this._log.warn("Error decompressing: " + written + ", " + in.getTotalRead() + "/" + in.getTotalExpanded(), ioe);
                }
            }
            catch (OutOfMemoryError oom) {
                EepGet.this._decompressException = new IOException("OOM in HTTP Decompressor");
                EepGet.this._log.error("OOM in HTTP Decompressor", oom);
            }
            finally {
                if (this._out != null) {
                    try {
                        this._out.close();
                    }
                    catch (IOException ioe) {}
                }
                ReusableGZIPInputStream.release(in);
            }
        }
    }

    protected class AuthState {
        private final String username;
        private final String password;
        public AUTH_MODE authMode = AUTH_MODE.NONE;
        private String authChallenge;
        public boolean authSent;
        private int nonceCount;
        private String cnonce;
        private Map<String, String> args;

        public AuthState(String user, String pw) {
            this.username = user;
            this.password = pw;
        }

        public void setAuthChallenge(String auth) {
            String authLC = auth.toLowerCase(Locale.US);
            if (authLC.startsWith("basic ")) {
                if (this.authMode != AUTH_MODE.DIGEST) {
                    this.authMode = AUTH_MODE.BASIC;
                    this.authChallenge = auth.substring(6);
                    this.args = EepGet.parseAuthArgs(this.authChallenge);
                }
            } else if (authLC.startsWith("digest ")) {
                if (this.authMode != AUTH_MODE.DIGEST) {
                    String ac = auth.substring(7);
                    Map<String, String> aargs = EepGet.parseAuthArgs(ac);
                    String algo = aargs.get("algorithm");
                    if (algo != null && !(algo = algo.toLowerCase(Locale.US)).equals("sha-256") && !algo.equals("md5")) {
                        if (EepGet.this._log.shouldWarn()) {
                            EepGet.this._log.warn("Unsupported auth algorithm " + algo);
                        }
                        return;
                    }
                    this.authMode = AUTH_MODE.DIGEST;
                    this.authChallenge = ac;
                    this.args = aargs;
                } else if (EepGet.this._log.shouldDebug()) {
                    EepGet.this._log.debug("Ignoring auth algorithm " + auth);
                }
            } else if (this.authMode == AUTH_MODE.NONE) {
                this.authMode = AUTH_MODE.UNKNOWN;
                this.authChallenge = null;
                this.args = null;
            }
            this.nonceCount = 0;
        }

        public String getAuthHeader(String method, String uri) throws IOException {
            switch (this.authMode) {
                case BASIC: {
                    this.authSent = true;
                    return "Basic " + Base64.encode(DataHelper.getUTF8(this.username + ':' + this.password), true);
                }
                case DIGEST: {
                    if (this.authChallenge == null) {
                        throw new IOException("Bad proxy auth response");
                    }
                    Map<String, String> outArgs = this.generateAuthArgs(method, uri);
                    if (outArgs == null) {
                        throw new IOException("Bad proxy auth response");
                    }
                    StringBuilder buf = new StringBuilder(256);
                    buf.append("Digest");
                    for (Map.Entry<String, String> e : outArgs.entrySet()) {
                        buf.append(' ').append(e.getKey()).append('=').append(e.getValue());
                    }
                    this.authSent = true;
                    return buf.toString();
                }
            }
            throw new IOException("Unknown proxy auth type " + this.authChallenge);
        }

        public Map<String, String> generateAuthArgs(String method, String uri) throws IOException {
            String kdMiddle;
            HashMap<String, String> rv = new HashMap<String, String>(12);
            String realm = this.args.get("realm");
            String nonce = this.args.get("nonce");
            String qop = this.args.get("qop");
            String opaque = this.args.get("opaque");
            String algorithm = this.args.get("algorithm");
            boolean isSHA256 = false;
            if (algorithm == null) {
                algorithm = "MD5";
            } else {
                isSHA256 = algorithm.toLowerCase(Locale.US).equals("sha-256");
            }
            rv.put("algorithm", algorithm);
            if (realm == null || nonce == null) {
                if (EepGet.this._log.shouldInfo()) {
                    EepGet.this._log.info("Bad digest request: " + DataHelper.toString(this.args));
                }
                throw new IOException("Bad auth response");
            }
            rv.put("username", '\"' + this.username + '\"');
            rv.put("realm", '\"' + realm + '\"');
            rv.put("nonce", '\"' + nonce + '\"');
            rv.put("uri", '\"' + uri + '\"');
            if (opaque != null) {
                rv.put("opaque", '\"' + opaque + '\"');
            }
            if ("auth".equals(qop)) {
                rv.put("qop", "\"auth\"");
                if (this.cnonce == null) {
                    byte[] rand = new byte[5];
                    EepGet.this._context.random().nextBytes(rand);
                    this.cnonce = Base32.encode(rand);
                }
                rv.put("cnonce", '\"' + this.cnonce + '\"');
                String nc = EepGet.lc8hex(++this.nonceCount);
                rv.put("nc", nc);
                kdMiddle = ':' + nc + ':' + this.cnonce + ':' + qop;
            } else {
                kdMiddle = "";
            }
            String a1 = this.username + ':' + realm + ':' + this.password;
            String ha1 = isSHA256 ? PasswordManager.sha256Hex(a1) : PasswordManager.md5Hex(a1);
            String a2 = method + ':' + uri;
            String ha2 = isSHA256 ? PasswordManager.sha256Hex(a2) : PasswordManager.md5Hex(a2);
            String kd = ha1 + ':' + nonce + kdMiddle + ':' + ha2;
            rv.put("response", '\"' + (isSHA256 ? PasswordManager.sha256Hex(kd) : PasswordManager.md5Hex(kd)) + '\"');
            return rv;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }

    protected static enum AUTH_MODE {
        NONE,
        BASIC,
        DIGEST,
        UNKNOWN;

    }

    protected class CLIStatusListener
    implements StatusListener {
        private final int _markSize;
        private final int _lineSize;
        private final long _startedOn;
        private long _written;
        private long _previousWritten;
        private long _discarded;
        private long _lastComplete;
        private boolean _firstTime;
        private final DecimalFormat _pct = new DecimalFormat("00.0%");

        public CLIStatusListener() {
            this(1024, 40);
        }

        public CLIStatusListener(int markSize, int lineSize) {
            this._markSize = markSize;
            this._lineSize = lineSize;
            this._startedOn = this._lastComplete = EepGet.this._context.clock().now();
            this._firstTime = true;
        }

        @Override
        public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
            if (this._firstTime) {
                if (alreadyTransferred > 0L) {
                    this._previousWritten = alreadyTransferred;
                    System.out.println(" \u2022 File found (" + alreadyTransferred + " bytes) - attempting to resume\u2026\n");
                }
                this._firstTime = false;
            }
            if (this._written == 0L && alreadyTransferred == 0L && this._previousWritten > 0L) {
                System.out.println(" \u2022 Server does not support resume - discarding " + this._previousWritten + " bytes\n");
                this._discarded += this._previousWritten;
                this._previousWritten = 0L;
            }
            for (int i = 0; i < currentWrite; ++i) {
                ++this._written;
                if (this._markSize <= 0 || this._written % (long)this._markSize != 0L || this._lineSize <= 0 || this._written % ((long)this._markSize * (long)this._lineSize) != 0L) continue;
                long now = EepGet.this._context.clock().now();
                long timeToSend = now - this._lastComplete;
                if (timeToSend > 0L) {
                    StringBuilder buf = new StringBuilder(50);
                    Formatter fmt = new Formatter(buf);
                    Float received = Float.valueOf(Float.valueOf(this._written).floatValue() / 1024.0f);
                    if (received.floatValue() > 1024.0f) {
                        received = Float.valueOf(received.floatValue() / 1024.0f);
                        fmt.format("%3.2f", received);
                        buf.append("M  ");
                    } else {
                        fmt.format("%3.0f", received);
                        buf.append("K  ");
                    }
                    double lineKBytes = (double)this._markSize * (double)this._lineSize / 1024.0;
                    double kbps = lineKBytes / ((double)timeToSend / 1000.0);
                    fmt.format("%7.2f", kbps);
                    buf.append("KB/s");
                    if (bytesRemaining > 0L) {
                        double pct = 100.0 * ((double)this._written + (double)this._previousWritten) / ((double)alreadyTransferred + (double)currentWrite + (double)bytesRemaining);
                        buf.append("  [");
                        fmt.format("%4.1f", pct);
                        buf.append("%]");
                    }
                    if (SystemVersion.isWindows()) {
                        System.out.println(" \u25fc " + buf.toString());
                    } else {
                        System.out.println("\u001b[1A\u001b[K\r \u25fc " + buf.toString());
                    }
                    fmt.close();
                }
                this._lastComplete = now;
            }
        }

        @Override
        public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
            long transferred = this._firstTime ? 0L : alreadyTransferred - this._previousWritten;
            System.out.println();
            if (notModified) {
                System.out.println(" \u2022 Source not modified since last download");
            } else {
                if (bytesRemaining > 0L) {
                    if (SystemVersion.isWindows()) {
                        System.out.println(" \u2714 Transfer of " + url + " complete (" + transferred + " bytes transferred, " + (bytesRemaining - bytesTransferred) + " bytes remaining" + (this._discarded > 0L ? " and " + this._discarded + " bytes discarded" : ")"));
                    } else {
                        System.out.println("\u001b[1A\u001b[1A\u001b[K\r \u2714 Transfer of " + url + " complete (" + transferred + " bytes transferred, " + (bytesRemaining - bytesTransferred) + " bytes remaining" + (this._discarded > 0L ? " and " + this._discarded + " bytes discarded" : ")"));
                    }
                } else if (SystemVersion.isWindows()) {
                    System.out.println(" \u2714 Transfer of " + url + " complete (" + transferred + " bytes transferred" + (this._discarded > 0L ? ", " + this._discarded + " bytes discarded" : ")"));
                } else {
                    System.out.println("\u001b[1A\u001b[1A\u001b[K\r \u2714 Transfer of " + url + " complete (" + transferred + " bytes transferred" + (this._discarded > 0L ? ", " + this._discarded + " bytes discarded" : ")"));
                }
                long timeToSend = EepGet.this._context.clock().now() - this._startedOn;
                StringBuilder buf = new StringBuilder(128);
                buf.append(" \u2022 Transfer time: " + DataHelper.formatDuration(timeToSend));
                if (transferred > 0L && outputFile != null) {
                    buf.append(" @ ");
                    if (timeToSend <= 0L) {
                        timeToSend = 1L;
                    }
                    long kbps = (long)(1000.0 * (double)transferred / (double)timeToSend);
                    buf.append(DataHelper.formatSize2Decimal(kbps, false));
                    buf.append("Bps");
                    System.out.println(buf.toString());
                    long sz = new File(outputFile).length();
                    if (sz <= 0L) {
                        sz = alreadyTransferred;
                    }
                    System.out.println(" \u2714 Saved to: " + outputFile + " (" + sz + " bytes)");
                }
            }
            if (EepGet.this._lastModified != null) {
                System.out.println(" \u2022 Last Modified: " + EepGet.this._lastModified);
            }
            if (EepGet.this._etag != null) {
                System.out.println(" \u2022 ETag: " + EepGet.this._etag);
            }
        }

        @Override
        public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
            System.out.println(" \u2716 Attempt " + (currentAttempt + 1) + " to retrieve " + url + " failed");
            System.out.println(" \u2022 Transferred " + bytesTransferred + " bytes (" + (bytesRemaining < 0L ? "unknown" : Long.toString(bytesRemaining) + " bytes") + " remaining)");
            System.out.println(" \u2022 " + cause.getMessage());
            this._previousWritten += this._written;
            this._written = 0L;
        }

        @Override
        public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
            System.out.println(" \u2716 Transfer of " + url + " failed after " + (currentAttempt + 1) + " retries");
            System.out.println(" \u2022 Transfer size: " + bytesTransferred + " with " + (bytesRemaining < 0L ? "unknown" : Long.toString(bytesRemaining) + " bytes") + " remaining");
            long timeToSend = EepGet.this._context.clock().now() - this._startedOn;
            StringBuilder buf = new StringBuilder(128);
            buf.append(" \u2022 Transfer time: " + DataHelper.formatDuration(timeToSend));
            if (timeToSend <= 0L) {
                timeToSend = 1L;
            }
            long kbps = (long)(1000.0 * (double)bytesTransferred / (double)timeToSend);
            buf.append(" @ ");
            buf.append(DataHelper.formatSize2Decimal(kbps, false));
            buf.append("Bps");
            System.out.println(buf.toString());
        }

        @Override
        public void attempting(String url) {
        }

        @Override
        public void headerReceived(String url, int currentAttempt, String key, String val) {
        }
    }

    public static interface StatusListener {
        public void bytesTransferred(long var1, int var3, long var4, long var6, String var8);

        public void transferComplete(long var1, long var3, long var5, String var7, String var8, boolean var9);

        public void attemptFailed(String var1, long var2, long var4, int var6, int var7, Exception var8);

        public void transferFailed(String var1, long var2, long var4, int var6);

        public void headerReceived(String var1, int var2, String var3, String var4);

        public void attempting(String var1);
    }
}

