/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.client.streaming.IncomingConnectionFilter;
import net.i2p.client.streaming.RouterRestartException;
import net.i2p.client.streaming.StatefulConnectionFilter;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.I2PTunnelTask;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.TunnelController;
import net.i2p.i2ptunnel.TunnelControllerGroup;
import net.i2p.i2ptunnel.access.FilterFactory;
import net.i2p.i2ptunnel.access.InvalidDefinitionException;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PSSLSocketFactory;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class I2PTunnelServer
extends I2PTunnelTask
implements Runnable {
    protected final Log _log;
    protected final I2PSocketManager sockMgr;
    protected volatile I2PServerSocket i2pss;
    private final Object lock = new Object();
    protected final Object slock = new Object();
    protected final Object sslLock = new Object();
    protected InetAddress remoteHost;
    protected int remotePort;
    private final boolean _usePool;
    protected final Logging l;
    private I2PSSLSocketFactory _sslFactory;
    private static final long DEFAULT_READ_TIMEOUT = -1L;
    protected long readTimeout = -1L;
    private static final String PROP_USE_POOL = "i2ptunnel.usePool";
    private static final boolean DEFAULT_USE_POOL = true;
    public static final String PROP_USE_SSL = "useSSL";
    public static final String PROP_UNIQUE_LOCAL = "enableUniqueLocal";
    public static final String PROP_ALT_PKF = "altPrivKeyFile";
    protected static volatile long __serverId = 0L;
    private static final String PROP_HANDLER_COUNT = "i2ptunnel.blockingHandlerCount";
    private static final long MAXMEM = SystemVersion.getMaxMemory();
    private static final int DEFAULT_HANDLER_COUNT = MAXMEM < 0x20000000L || SystemVersion.isSlow() ? 128 : (MAXMEM < 0x40000000L ? 512 : 1024);
    private static final int MIN_HANDLERS = 1;
    private static final long HANDLER_KEEPALIVE_MS = 40000L;
    protected I2PTunnelTask task;
    protected boolean bidir;
    private ThreadPoolExecutor _executor;
    protected volatile ThreadPoolExecutor _clientExecutor;
    private final Map<Integer, InetSocketAddress> _socketMap = new ConcurrentHashMap<Integer, InetSocketAddress>(4);
    private int DEFAULT_LOCALPORT;
    protected int localPort = this.DEFAULT_LOCALPORT = 4488;
    private volatile StatefulConnectionFilter _filter;
    private static final int RETRY_DELAY = 15000;
    private static final int MAX_RETRIES = 20;

    public I2PTunnelServer(InetAddress host, int port, String privData, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super("server at " + host + ':' + port, notifyThis, tunnel);
        this._log = tunnel.getContext().logManager().getLog(this.getClass());
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode(privData));
        this.l = l;
        this.remoteHost = host;
        this.remotePort = port;
        this._usePool = this.getUsePool();
        this.buildSocketMap(tunnel.getClientOptions());
        this.sockMgr = this.createManager(bais);
    }

    public I2PTunnelServer(InetAddress host, int port, File privkey, String privkeyname, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super("server at " + host + ':' + port, notifyThis, tunnel);
        this._log = tunnel.getContext().logManager().getLog(this.getClass());
        this.l = l;
        this.remoteHost = host;
        this.remotePort = port;
        this._usePool = this.getUsePool();
        this.buildSocketMap(tunnel.getClientOptions());
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(privkey);
            this.sockMgr = this.createManager(fis);
        }
        catch (IOException ioe) {
            this._log.error("Cannot read private key data for " + privkeyname, ioe);
            this.notifyEvent("openServerResult", "error");
            throw new IllegalArgumentException("Error starting server", ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public I2PTunnelServer(InetAddress host, int port, InputStream privData, String privkeyname, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super("server at " + host + ':' + port, notifyThis, tunnel);
        this._log = tunnel.getContext().logManager().getLog(this.getClass());
        this.l = l;
        this.remoteHost = host;
        this.remotePort = port;
        this._usePool = this.getUsePool();
        this.buildSocketMap(tunnel.getClientOptions());
        this.sockMgr = this.createManager(privData);
    }

    public I2PTunnelServer(InetAddress host, int port, I2PSocketManager sktMgr, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super("server at " + host + ':' + port, notifyThis, tunnel);
        this.l = l;
        this.remoteHost = host;
        this.remotePort = port;
        this._log = tunnel.getContext().logManager().getLog(this.getClass());
        this._usePool = false;
        this.buildSocketMap(tunnel.getClientOptions());
        this.sockMgr = sktMgr;
        this.open = true;
    }

    private boolean getUsePool() {
        boolean rv;
        boolean bl = rv = !this.getClass().equals(I2PTunnelServer.class);
        if (rv) {
            String usePool = this.getTunnel().getClientOptions().getProperty(PROP_USE_POOL);
            rv = usePool != null ? Boolean.parseBoolean(usePool) : true;
        }
        return rv;
    }

    private I2PSocketManager createManager(InputStream privData) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.getTunnel().getClientOptions());
        int portNum = 7654;
        if (this.getTunnel().port != null) {
            try {
                portNum = Integer.parseInt(this.getTunnel().port);
            }
            catch (NumberFormatException nfe) {
                this._log.error("Invalid port specified [" + this.getTunnel().port + "], reverting to " + portNum);
            }
        }
        if (this.getTunnel().filterDefinition != null) {
            File filterDefinition = new File(this.getTunnel().filterDefinition);
            I2PAppContext context = this.getTunnel().getContext();
            try {
                this._filter = FilterFactory.createFilter(context, filterDefinition);
            }
            catch (IOException | InvalidDefinitionException bad) {
                throw new IllegalArgumentException("Bad filter definition file: " + bad.getMessage(), bad);
            }
        }
        IncomingConnectionFilter filter = this._filter == null ? IncomingConnectionFilter.ALLOW : this._filter;
        try {
            I2PSocketManager rv = I2PSocketManagerFactory.createDisconnectedManager(privData, this.getTunnel().host, portNum, props, filter);
            rv.setName("I2PTunnel Server");
            this.getTunnel().addSession(rv.getSession());
            String alt = props.getProperty(PROP_ALT_PKF);
            if (alt != null) {
                this.addSubsession(rv, alt);
            }
            I2PSocketManager i2PSocketManager = rv;
            return i2PSocketManager;
        }
        catch (I2PSessionException ise) {
            throw new IllegalArgumentException("Can't create socket manager", ise);
        }
        finally {
            try {
                privData.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private I2PSession addSubsession(I2PSocketManager sMgr, String alt) {
        File altFile = TunnelController.filenameToFile(alt);
        if (altFile == null) {
            return null;
        }
        I2PSession sess = sMgr.getSession();
        if (sess.getMyDestination().getSigType() != SigType.DSA_SHA1) {
            return null;
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.getTunnel().getClientOptions());
        String name = props.getProperty("inbound.nickname");
        if (name != null) {
            props.setProperty("inbound.nickname", name + " (EdDSA)");
        }
        if ((name = props.getProperty("outbound.nickname")) != null) {
            props.setProperty("outbound.nickname", name + " (EdDSA)");
        }
        props.setProperty("i2cp.destination.sigType", "EdDSA_SHA512_Ed25519");
        FileInputStream privData = null;
        try {
            privData = new FileInputStream(altFile);
            I2PSession rv = sMgr.addSubsession(privData, props);
            if (rv.isOffline()) {
                long exp = rv.getOfflineExpiration();
                long remaining = exp - this.getTunnel().getContext().clock().now();
                if (remaining <= 600000L) {
                    String msg = remaining > 0L ? "Offline signature for tunnel " + name + " alternate destination expires in " + DataHelper.formatTime(exp) : "Offline signature for tunnel " + name + " alternate destination expired " + DataHelper.formatTime(exp);
                    this._log.log(50, msg);
                    throw new IllegalArgumentException(msg);
                }
                if (remaining < 5184000000L) {
                    String msg = "Offline signature for tunnel " + name + " alternate destination expires in " + DataHelper.formatDuration(remaining);
                    this._log.logAlways(30, msg);
                    this.l.log("WARNING: " + msg);
                }
            }
            I2PSession i2PSession = rv;
            return i2PSession;
        }
        catch (IOException ioe) {
            this._log.error("Failed to add sub-session", ioe);
            I2PSession i2PSession = null;
            return i2PSession;
        }
        catch (I2PSessionException ise) {
            this._log.error("Failed to add sub-session", ise);
            I2PSession i2PSession = null;
            return i2PSession;
        }
        finally {
            if (privData != null) {
                try {
                    privData.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void connectManager() {
        int retries = 0;
        I2PSession session = this.sockMgr.getSession();
        if (session.isOffline()) {
            long exp = session.getOfflineExpiration();
            long remaining = exp - this.getTunnel().getContext().clock().now();
            Properties props = this.getTunnel().getClientOptions();
            String name = props.getProperty("inbound.nickname");
            if (name == null && (name = props.getProperty("outbound.nickname")) == null) {
                name = "";
            }
            if (remaining <= 600000L) {
                String msg = remaining > 0L ? "Offline signature for tunnel " + name + " expires in " + DataHelper.formatTime(exp) : "Offline signature for tunnel " + name + " expired " + DataHelper.formatTime(exp);
                this._log.log(50, msg);
                throw new IllegalArgumentException(msg);
            }
            if (remaining < 5184000000L) {
                String msg = "Offline signature for tunnel " + name + " expires in " + DataHelper.formatDuration(remaining);
                this._log.logAlways(30, msg);
                this.l.log("WARNING: " + msg);
            }
        }
        while (session.isClosed()) {
            try {
                session.connect();
                List<I2PSession> subs = this.sockMgr.getSubsessions();
                if (subs.isEmpty()) continue;
                for (I2PSession sub : subs) {
                    try {
                        sub.connect();
                        if (!this._log.shouldInfo()) continue;
                        this._log.info("Connected sub-session " + sub);
                    }
                    catch (I2PSessionException ise) {
                        String msg = "Unable to connect sub-session " + sub;
                        this.l.log(msg);
                        this._log.error(msg, ise);
                    }
                }
            }
            catch (I2PSessionException ise) {
                boolean fail;
                String portNum = this.getTunnel().port;
                if (portNum == null) {
                    portNum = Integer.toString(7654);
                }
                String msg = this.getTunnel().getContext().isRouterContext() ? "Unable to build tunnels for server at " + this.remoteHost.getHostAddress() + ':' + this.remotePort : "Unable to connect to the router at " + this.getTunnel().host + ':' + portNum + " and build tunnels for server at " + this.remoteHost.getHostAddress() + ':' + this.remotePort;
                String exmsg = ise.getMessage();
                boolean bl = fail = exmsg != null && exmsg.contains("session limit exceeded");
                if (fail || ++retries >= 20) {
                    msg = msg + ", giving up";
                    this.l.log(msg);
                    this._log.log(50, msg, ise);
                    throw new IllegalArgumentException(msg, ise);
                }
                msg = msg + ", retrying in 15 seconds";
                this.l.log(msg);
                this._log.error(msg);
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.l.log("Tunnels ready for server at " + this.remoteHost.getHostAddress() + ':' + this.remotePort);
        this.notifyEvent("openServerResult", "ok");
        this.open = true;
    }

    public synchronized void startRunning() {
        this.connectManager();
        StatefulConnectionFilter filter = this._filter;
        if (filter != null) {
            filter.start();
        }
        boolean isDaemon = this.getTunnel().getContext().isRouterContext();
        I2PAppThread t = new I2PAppThread(this, "Server " + this.remoteHost + ':' + this.remotePort, isDaemon);
        t.setPriority(10);
        ((Thread)t).start();
    }

    public void setReadTimeout(long ms) {
        this.readTimeout = ms;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean close(boolean forced) {
        if (!this.open) {
            return true;
        }
        if (this.task != null) {
            this.task.close(forced);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!forced && this.sockMgr.listSockets().size() != 0) {
                this.l.log("There are still active connections!");
                for (I2PSocket skt : this.sockMgr.listSockets()) {
                    this.l.log("->" + skt);
                }
                return false;
            }
            this.l.log("Stopping tunnels for server at " + this.remoteHost + ':' + this.remotePort);
            this.open = false;
            try {
                if (this.i2pss != null) {
                    this.i2pss.close();
                    this.i2pss = null;
                }
                I2PSession session = this.sockMgr.getSession();
                this.getTunnel().removeSession(session);
                session.destroySession();
            }
            catch (I2PException ex) {
                this._log.error("Error destroying the session", ex);
            }
            if (this._usePool && this._executor != null) {
                this._executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
                this._executor.shutdownNow();
            }
            return true;
        }
    }

    @Override
    public synchronized boolean destroy() {
        this.close(true);
        this.sockMgr.destroySocketManager();
        StatefulConnectionFilter filter = this._filter;
        if (filter != null) {
            filter.stop();
        }
        return true;
    }

    @Override
    public void optionsUpdated(I2PTunnel tunnel) {
        String p;
        if (this.getTunnel() != tunnel || this.sockMgr == null) {
            return;
        }
        Properties props = tunnel.getClientOptions();
        this.sockMgr.setDefaultOptions(this.sockMgr.buildOptions(props));
        String h = props.getProperty("targetHost");
        if (h != null) {
            try {
                this.remoteHost = InetAddress.getByName(h);
            }
            catch (UnknownHostException uhe) {
                this.l.log("Unknown host: " + h);
            }
        }
        if ((p = props.getProperty("targetPort")) != null) {
            try {
                int port = Integer.parseInt(p);
                if (port > 0 && port <= 65535) {
                    this.remotePort = port;
                } else {
                    this.l.log("Bad port: " + port);
                }
            }
            catch (NumberFormatException nfe) {
                this.l.log("Bad port: " + p);
            }
        }
        this.buildSocketMap(props);
    }

    private void buildSocketMap(Properties props) {
        this._socketMap.clear();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith("targetForPort.")) continue;
            key = key.substring("targetForPort.".length());
            try {
                int myPort = Integer.parseInt(key);
                String host = (String)e.getValue();
                int colon = host.indexOf(58);
                int port = Integer.parseInt(host.substring(colon + 1));
                host = host.substring(0, colon);
                InetSocketAddress isa = new InetSocketAddress(host, port);
                if (isa.isUnresolved()) {
                    this.l.log("Warning - cannot resolve address for port " + key + ": " + host);
                }
                this._socketMap.put(myPort, isa);
            }
            catch (NumberFormatException nfe) {
                this.l.log("Bad socket spec for port " + key + ": " + e.getValue());
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.l.log("Bad socket spec for port " + key + ": " + e.getValue());
            }
        }
    }

    protected int getHandlerCount() {
        int rv = DEFAULT_HANDLER_COUNT;
        String cnt = this.getTunnel().getClientOptions().getProperty(PROP_HANDLER_COUNT);
        if (cnt != null) {
            try {
                rv = Integer.parseInt(cnt);
                if (rv <= 0) {
                    rv = DEFAULT_HANDLER_COUNT;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rv;
    }

    @Override
    public void run() {
        TunnelControllerGroup tcg;
        this.i2pss = this.sockMgr.getServerSocket();
        if (this._log.shouldInfo()) {
            if (this._usePool) {
                this._log.info("Starting executor with " + this.getHandlerCount() + " threads max");
            } else {
                this._log.info("Threads disabled, running blockingHandles inline");
            }
        }
        if (this._usePool) {
            this._executor = new CustomThreadPoolExecutor(this.getHandlerCount(), "ServerHandler pool " + this.remoteHost + ':' + this.remotePort);
        }
        this._clientExecutor = (tcg = TunnelControllerGroup.getInstance()) != null ? tcg.getClientExecutor() : new TunnelControllerGroup.CustomThreadPoolExecutor();
        Closeable i2ps = null;
        while (this.open) {
            try {
                i2ps = null;
                I2PServerSocket ci2pss = this.i2pss;
                if (ci2pss == null) {
                    throw new I2PException("I2PServerSocket closed");
                }
                i2ps = ci2pss.accept();
                if (this._usePool) {
                    try {
                        this._executor.execute(new Handler((I2PSocket)i2ps));
                    }
                    catch (RejectedExecutionException ree) {
                        try {
                            i2ps.reset();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (!this.open) continue;
                        this._log.logAlways(30, "ServerHandler queue full, dropping incoming connection to " + this.remoteHost + ':' + this.remotePort + "; increase server max threads or " + PROP_HANDLER_COUNT + "; current is " + this.getHandlerCount());
                    }
                    continue;
                }
                this.blockingHandle((I2PSocket)i2ps);
            }
            catch (RouterRestartException rre) {
                this._log.logAlways(30, "Waiting for router restart...");
                if (i2ps != null) {
                    try {
                        i2ps.close();
                    }
                    catch (IOException ree) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException ree) {
                    // empty catch block
                }
                this._log.logAlways(30, "Reconnecting to router after restart");
                this.i2pss = this.sockMgr.getServerSocket();
            }
            catch (I2PException ipe) {
                String s = "Error accepting server socket connection - KILLING THE TUNNEL SERVER!";
                this._log.log(50, s, ipe);
                this.l.log(s + ": " + ipe);
                TunnelController tc = this.getTunnel().getController();
                if (tc != null) {
                    tc.stopTunnel();
                } else {
                    this.close(true);
                }
                if (i2ps == null) break;
                try {
                    i2ps.close();
                }
                catch (IOException iOException) {}
                break;
            }
            catch (ConnectException ce) {
                if (i2ps != null) {
                    try {
                        i2ps.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!this.open) break;
                if (this._log.shouldError()) {
                    this._log.error("Error accepting server socket connection \n* " + ce.getMessage());
                }
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.i2pss = this.sockMgr.getServerSocket();
            }
            catch (SocketTimeoutException ste) {
                if (i2ps == null) continue;
                try {
                    i2ps.close();
                }
                catch (IOException iOException) {}
            }
            catch (RuntimeException e) {
                if (this._log.shouldError()) {
                    this._log.error("Uncaught exception accepting", e);
                }
                if (i2ps != null) {
                    try {
                        i2ps.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this._executor != null && !this._executor.isTerminating() && !this._executor.isShutdown()) {
            this._executor.shutdownNow();
        }
    }

    public boolean shouldUsePool() {
        return this._usePool;
    }

    protected void blockingHandle(I2PSocket socket) {
        if (this._log.shouldInfo()) {
            this._log.info("Incoming connection to " + this.toString().replace("/", "") + " (port " + socket.getLocalPort() + ")\n* From: " + socket.getPeerDestination().calculateHash() + " port " + socket.getPort());
        }
        long afterAccept = this.getTunnel().getContext().clock().now();
        long afterSocket = -1L;
        try {
            socket.setReadTimeout(this.readTimeout);
            Socket s = this.getSocket(socket.getPeerDestination().calculateHash(), socket.getLocalPort());
            afterSocket = this.getTunnel().getContext().clock().now();
            I2PTunnelRunner t = new I2PTunnelRunner(s, socket, this.slock, null, null, null, (I2PTunnelRunner.FailCallback)null);
            t.setPriority(10);
            this._clientExecutor.execute(t);
            long afterHandle = this.getTunnel().getContext().clock().now();
            long timeToHandle = afterHandle - afterAccept;
            if (timeToHandle > 1500L && this._log.shouldInfo()) {
                this._log.info("Took a while (" + timeToHandle + "ms) to handle the request for " + this.remoteHost + ':' + this.remotePort + "\n* Socket create: " + (afterSocket - afterAccept) + "ms");
            }
        }
        catch (SocketException ex) {
            int port = socket.getLocalPort();
            try {
                socket.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this._log.shouldError()) {
                this._log.error("Error connecting to server " + this.getSocketString(port));
            }
        }
        catch (IOException ex) {
            this._log.error("Error while waiting for I2PConnections", ex);
        }
    }

    protected Socket getSocket(Hash from, int incomingPort) throws IOException {
        InetSocketAddress isa;
        InetAddress host = this.remoteHost;
        int port = this.remotePort;
        if (incomingPort != 0 && !this._socketMap.isEmpty() && (isa = this._socketMap.get(incomingPort)) != null) {
            host = isa.getAddress();
            if (host == null) {
                throw new IOException("Cannot resolve " + isa.getHostName());
            }
            port = isa.getPort();
        }
        boolean force = incomingPort == 443 || incomingPort == 22;
        return this.getSocket(from, host, port, force);
    }

    protected String getSocketString(int incomingPort) {
        InetSocketAddress isa;
        if (incomingPort != 0 && !this._socketMap.isEmpty() && (isa = this._socketMap.get(incomingPort)) != null) {
            return isa.toString().replace("/", "");
        }
        return this.remoteHost.toString().replace("/", "") + ':' + this.remotePort;
    }

    protected Socket getSocket(Hash from, InetAddress remoteHost, int remotePort) throws IOException {
        return this.getSocket(from, remoteHost, remotePort, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getSocket(Hash from, InetAddress remoteHost, int remotePort, boolean forceNonSSL) throws IOException {
        String opt = this.getTunnel().getClientOptions().getProperty(PROP_USE_SSL);
        if (!forceNonSSL && Boolean.parseBoolean(opt)) {
            Object object = this.sslLock;
            synchronized (object) {
                if (this._sslFactory == null) {
                    try {
                        this._sslFactory = new I2PSSLSocketFactory(this.getTunnel().getContext(), true, "certificates/i2ptunnel");
                    }
                    catch (GeneralSecurityException gse) {
                        IOException ioe = new IOException("SSL Fail");
                        ioe.initCause(gse);
                        throw ioe;
                    }
                }
            }
            return this._sslFactory.createSocket(remoteHost, remotePort);
        }
        boolean unique = Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_UNIQUE_LOCAL));
        if (unique && remoteHost.isLoopbackAddress()) {
            byte[] addr;
            if (remoteHost instanceof Inet4Address) {
                addr = new byte[4];
                addr[0] = 127;
                System.arraycopy(from.getData(), 0, addr, 1, 3);
            } else {
                addr = new byte[16];
                addr[0] = -3;
                System.arraycopy(from.getData(), 0, addr, 1, 15);
            }
            InetAddress local = InetAddress.getByAddress(addr);
            return new Socket(remoteHost, remotePort, local, 0);
        }
        return new Socket(remoteHost, remotePort);
    }

    private class Handler
    implements Runnable {
        private final I2PSocket _i2ps;

        public Handler(I2PSocket socket) {
            this._i2ps = socket;
        }

        @Override
        public void run() {
            try {
                I2PTunnelServer.this.blockingHandle(this._i2ps);
            }
            catch (Throwable t) {
                I2PTunnelServer.this._log.error("Uncaught error in I2PTunnel server", t);
            }
        }
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private final String _name;
        private final AtomicLong _executorThreadCount = new AtomicLong();

        public CustomThreadFactory(String name) {
            this._name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread rv = Executors.defaultThreadFactory().newThread(r);
            rv.setName(this._name + "[" + this._executorThreadCount.incrementAndGet() + "]");
            rv.setPriority(10);
            rv.setDaemon(true);
            return rv;
        }
    }

    private static class CustomThreadPoolExecutor
    extends ThreadPoolExecutor {
        public CustomThreadPoolExecutor(int max, String name) {
            super(1, max, 40000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new CustomThreadFactory(name));
        }
    }
}

