/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.access;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.i2p.data.Hash;
import net.i2p.i2ptunnel.access.DestTracker;
import net.i2p.i2ptunnel.access.FilterDefinitionElement;
import net.i2p.i2ptunnel.access.InvalidDefinitionException;
import net.i2p.i2ptunnel.access.Threshold;

class FileFilterDefinitionElement
extends FilterDefinitionElement {
    private final File file;
    private final Map<Hash, DestTracker> lastLoaded = new HashMap<Hash, DestTracker>();
    private volatile long lastLoading;

    FileFilterDefinitionElement(File file, Threshold threshold) {
        super(threshold);
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void update(Map<Hash, DestTracker> map) throws IOException {
        if (!this.file.exists() || !this.file.isFile()) {
            return;
        }
        if (this.file.lastModified() <= this.lastLoading) {
            Map<Hash, DestTracker> map2 = this.lastLoaded;
            synchronized (map2) {
                Iterator<Map.Entry<Hash, DestTracker>> iterator = this.lastLoaded.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    Map.Entry<Hash, DestTracker> entry = iterator.next();
                    if (map.containsKey(entry.getKey())) continue;
                    map.put(entry.getKey(), entry.getValue());
                }
            }
        }
        this.lastLoading = System.currentTimeMillis();
        Map<Hash, DestTracker> map3 = this.lastLoaded;
        synchronized (map3) {
            this.lastLoaded.clear();
        }
        BufferedReader reader = null;
        try {
            String b32;
            reader = new BufferedReader(new FileReader(this.file));
            while ((b32 = reader.readLine()) != null) {
                Hash hash = FileFilterDefinitionElement.fromBase32(b32);
                if (map.containsKey(hash)) continue;
                DestTracker newTracker = new DestTracker(hash, this.threshold);
                map.put(hash, newTracker);
                Map<Hash, DestTracker> map4 = this.lastLoaded;
                synchronized (map4) {
                    this.lastLoaded.put(hash, newTracker);
                }
            }
            return;
        }
        catch (InvalidDefinitionException bad32) {
            throw new IOException("Invalid entry in tunnel filter access list (bad b32)", bad32);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

