/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.sam.SAMDatagramReceiver;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMMessageSess;
import net.i2p.sam.SAMRawReceiver;
import net.i2p.sam.SAMv3DatagramServer;
import net.i2p.sam.SAMv3DatagramSession;
import net.i2p.sam.SAMv3Handler;
import net.i2p.sam.SAMv3RawSession;
import net.i2p.sam.SAMv3StreamSession;
import net.i2p.sam.Session;
import net.i2p.sam.SessionRecord;
import net.i2p.sam.SessionsDB;
import net.i2p.util.I2PAppThread;

class MasterSession
extends SAMv3StreamSession
implements SAMDatagramReceiver,
SAMRawReceiver,
SAMMessageSess,
I2PSessionMuxedListener {
    private final SAMv3Handler handler;
    private final SAMv3DatagramServer dgs;
    private final Map<String, SAMMessageSess> sessions;
    private final StreamAcceptor streamAcceptor;
    private static final String[] INVALID_OPTS = new String[]{"PORT", "HOST", "FROM_PORT", "TO_PORT", "PROTOCOL", "LISTEN_PORT", "LISTEN_PROTOCOL"};

    public MasterSession(String nick, SAMv3DatagramServer dgServer, SAMv3Handler handler, Properties props) throws IOException, DataFormatException, SAMException {
        super(nick);
        for (int i = 0; i < INVALID_OPTS.length; ++i) {
            String p = INVALID_OPTS[i];
            if (!props.containsKey(p)) continue;
            throw new SAMException("Illegal option " + p + " specificied in MASTER session");
        }
        this.dgs = dgServer;
        this.sessions = new ConcurrentHashMap<String, SAMMessageSess>(4);
        this.handler = handler;
        I2PSession isess = this.socketMgr.getSession();
        isess.addMuxedSessionListener(this, 0, 0);
        this.streamAcceptor = new StreamAcceptor();
    }

    @Override
    public void start() {
        I2PAppThread t = new I2PAppThread(this.streamAcceptor, "SAMMasterAcceptor");
        ((Thread)t).start();
    }

    public synchronized String add(String nick, String style, Properties props) {
        Session sess;
        int listenProtocol;
        SAMv3Handler subhandler;
        int listenPort;
        SessionRecord rec;
        block26: {
            if (props.containsKey("DESTINATION")) {
                return "SESSION ADD may not contain DESTINATION";
            }
            rec = SAMv3Handler.sSessionsHash.get(nick);
            if (rec != null || this.sessions.containsKey(nick)) {
                return "Duplicate ID " + nick;
            }
            listenPort = 0;
            String slp = (String)props.remove("LISTEN_PORT");
            if (slp == null) {
                slp = props.getProperty("FROM_PORT");
            }
            if (slp != null) {
                try {
                    listenPort = Integer.parseInt(slp);
                    if (listenPort < 0 || listenPort > 65535) {
                        return "Invalid LISTEN_PORT " + slp;
                    }
                }
                catch (NumberFormatException nfe) {
                    return "Invalid LISTEN_PORT " + slp;
                }
            }
            try {
                Session ssess;
                I2PSession isess = this.socketMgr.getSession();
                subhandler = new SAMv3Handler(this.handler.getClientSocket(), this.handler.verMajor, this.handler.verMinor, this.handler.getBridge());
                if (style.equals("RAW")) {
                    if (!props.containsKey("PORT")) {
                        return "RAW subsession must specify PORT";
                    }
                    listenProtocol = 18;
                    String spr = (String)props.remove("LISTEN_PROTOCOL");
                    if (spr == null) {
                        spr = props.getProperty("PROTOCOL");
                    }
                    if (spr != null) {
                        try {
                            listenProtocol = Integer.parseInt(spr);
                            if (listenProtocol < 0 || listenProtocol > 255 || listenProtocol == 6) {
                                return "Bad RAW LISTEN_PPROTOCOL " + spr;
                            }
                        }
                        catch (NumberFormatException nfe) {
                            return "Bad LISTEN_PROTOCOL " + spr;
                        }
                    }
                    SAMv3RawSession ssess2 = new SAMv3RawSession(nick, props, this.handler, isess, listenProtocol, listenPort, this.dgs);
                    subhandler.setSession(ssess2);
                    sess = ssess2;
                    break block26;
                }
                if (style.equals("DATAGRAM")) {
                    if (!props.containsKey("PORT")) {
                        return "DATAGRAM subsession must specify PORT";
                    }
                    listenProtocol = 17;
                    ssess = new SAMv3DatagramSession(nick, props, this.handler, isess, listenPort, this.dgs);
                    subhandler.setSession((SAMv3DatagramSession)ssess);
                    sess = ssess;
                    break block26;
                }
                if (style.equals("STREAM")) {
                    listenProtocol = 6;
                    ssess = new SAMv3StreamSession(nick, props, this.handler, this.socketMgr, listenPort);
                    subhandler.setSession((SAMv3StreamSession)ssess);
                    sess = ssess;
                    break block26;
                }
                return "Unrecognized SESSION STYLE " + style;
            }
            catch (IOException e) {
                return e.toString();
            }
            catch (DataFormatException e) {
                return e.toString();
            }
            catch (SAMException e) {
                return e.toString();
            }
            catch (I2PSessionException e) {
                return e.toString();
            }
        }
        for (SAMMessageSess s : this.sessions.values()) {
            if (listenProtocol != s.getListenProtocol() || listenPort != s.getListenPort()) continue;
            return "Duplicate protocol " + listenProtocol + " and port " + listenPort;
        }
        rec = new SessionRecord(this.getDestination().toBase64(), props, subhandler);
        try {
            SAMv3Handler.sSessionsHash.putDupDestOK(nick, rec);
            this.sessions.put(nick, sess);
        }
        catch (SessionsDB.ExistingIdException e) {
            return "Duplicate ID " + nick;
        }
        if (this._log.shouldWarn()) {
            this._log.warn("added " + style + " proto " + listenProtocol + " port " + listenPort);
        }
        sess.start();
        return null;
    }

    public synchronized String remove(String nick, Properties props) {
        boolean ok;
        SAMMessageSess sess = this.sessions.remove(nick);
        if (sess != null) {
            ok = SAMv3Handler.sSessionsHash.del(nick);
            sess.close();
            if (this._log.shouldWarn()) {
                this._log.warn("removed " + sess + " proto " + sess.getListenProtocol() + " port " + sess.getListenPort());
            }
        } else {
            ok = false;
        }
        if (!ok) {
            return "ID " + nick + " not found";
        }
        return null;
    }

    @Override
    public void receiveDatagramBytes(Destination sender, byte[] data, int proto, int fromPort, int toPort) throws IOException {
        throw new IOException("master session");
    }

    @Override
    public void stopDatagramReceiving() {
    }

    @Override
    public void receiveRawBytes(byte[] data, int proto, int fromPort, int toPort) throws IOException {
        throw new IOException("master session");
    }

    @Override
    public void stopRawReceiving() {
    }

    @Override
    public void connect(SAMv3Handler handler, String dest, Properties props) throws I2PException {
        throw new I2PException("master session");
    }

    @Override
    public void accept(SAMv3Handler handler, boolean verbose) throws SAMException {
        throw new SAMException("master session");
    }

    @Override
    public void startForwardingIncoming(Properties props, boolean sendPorts) throws SAMException {
        throw new SAMException("master session");
    }

    @Override
    public void stopForwardingIncoming() {
    }

    @Override
    public int getListenProtocol() {
        return 0;
    }

    @Override
    public int getListenPort() {
        return 0;
    }

    @Override
    public synchronized void close() {
        this.streamAcceptor.stopRunning();
        for (Map.Entry<String, SAMMessageSess> e : this.sessions.entrySet()) {
            SAMv3Handler.sSessionsHash.del(e.getKey());
            e.getValue().close();
        }
        this.sessions.clear();
        super.close();
    }

    @Override
    public void disconnected(I2PSession session) {
        if (this._log.shouldDebug()) {
            this._log.debug("I2P session disconnected");
        }
        this.close();
    }

    @Override
    public void errorOccurred(I2PSession session, String message, Throwable error) {
        if (this._log.shouldDebug()) {
            this._log.debug("I2P error: " + message, error);
        }
        this.close();
    }

    @Override
    public void messageAvailable(I2PSession session, int msgId, long size) {
        this.messageAvailable(session, msgId, size, 0, 0, 0);
    }

    @Override
    public void messageAvailable(I2PSession session, int msgId, long size, int proto, int fromPort, int toPort) {
        try {
            byte[] msg = session.receiveMessage(msgId);
            if (msg == null) {
                return;
            }
            this.messageReceived(msg, proto, fromPort, toPort);
        }
        catch (I2PSessionException e) {
            this._log.error("Error fetching I2P message", e);
            this.close();
        }
    }

    @Override
    public void reportAbuse(I2PSession session, int severity) {
        this._log.warn("Abuse reported (severity: " + severity + ")");
        this.close();
    }

    private void messageReceived(byte[] msg, int proto, int fromPort, int toPort) {
        if (this._log.shouldWarn()) {
            this._log.warn("Unhandled message received, length = " + msg.length + " protocol: " + proto + " from port: " + fromPort + " to port: " + toPort);
        }
    }

    private class StreamAcceptor
    implements Runnable {
        private volatile boolean stop;

        public void stopRunning() {
            this.stop = true;
        }

        @Override
        public void run() {
            if (MasterSession.this._log.shouldWarn()) {
                MasterSession.this._log.warn("Stream acceptor started");
            }
            I2PServerSocket i2pss = MasterSession.this.socketMgr.getServerSocket();
            while (!this.stop) {
                I2PSocket i2ps;
                try {
                    i2ps = i2pss.accept();
                    if (i2ps == null) {
                        continue;
                    }
                }
                catch (SocketTimeoutException ste) {
                    continue;
                }
                catch (ConnectException ce) {
                    if (MasterSession.this._log.shouldWarn()) {
                        MasterSession.this._log.warn("Error accepting", ce);
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                catch (I2PException ipe) {
                    if (!MasterSession.this._log.shouldWarn()) break;
                    MasterSession.this._log.warn("Error accepting", ipe);
                    break;
                }
                int port = i2ps.getLocalPort();
                SAMMessageSess foundSess = null;
                Collection all = MasterSession.this.sessions.values();
                Iterator iter = all.iterator();
                while (iter.hasNext()) {
                    SAMMessageSess sess = (SAMMessageSess)iter.next();
                    if (sess.getListenProtocol() != 6) {
                        iter.remove();
                        continue;
                    }
                    if (sess.getListenPort() != port) continue;
                    foundSess = sess;
                    break;
                }
                if (foundSess == null) {
                    for (SAMMessageSess sess : all) {
                        if (sess.getListenPort() != 0) continue;
                        foundSess = sess;
                        break;
                    }
                }
                if (foundSess != null) {
                    SAMv3StreamSession ssess = (SAMv3StreamSession)foundSess;
                    boolean ok = ssess.queueSocket(i2ps);
                    if (ok) continue;
                    MasterSession.this._log.logAlways(30, "Accept queue overflow for " + ssess);
                    try {
                        i2ps.reset();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                if (!MasterSession.this._log.shouldWarn()) continue;
                MasterSession.this._log.warn("No subsession found for incoming streaming connection on port " + port);
            }
            if (MasterSession.this._log.shouldWarn()) {
                MasterSession.this._log.warn("Stream acceptor stopped");
            }
        }
    }
}

