/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import gnu.getopt.Getopt;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.data.DataHelper;
import net.i2p.sam.Handler;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMHandler;
import net.i2p.sam.SAMHandlerFactory;
import net.i2p.sam.SAMSecureSession;
import net.i2p.sam.SAMSecureSessionInterface;
import net.i2p.sam.SAMv3DatagramServer;
import net.i2p.sam.SSLServerSocketChannel;
import net.i2p.sam.SSLUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PSSLSocketFactory;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SystemVersion;

public class SAMBridge
implements Runnable,
ClientApp {
    private final Log _log;
    private volatile ServerSocketChannel serverSocket;
    private final String _listenHost;
    private final int _listenPort;
    private final Properties i2cpProps;
    private final boolean _useSSL;
    private final File _configFile;
    private volatile Thread _runner;
    private final Object _v3DGServerLock = new Object();
    private SAMv3DatagramServer _v3DGServer;
    private final SAMSecureSessionInterface _secureSession;
    private final String persistFilename;
    private final Map<String, String> nameToPrivKeys;
    private final Set<Handler> _handlers;
    private volatile boolean acceptConnections = true;
    private final ClientAppManager _mgr;
    private volatile ClientAppState _state = ClientAppState.UNINITIALIZED;
    private static final int SAM_LISTENPORT = 7656;
    public static final String DEFAULT_SAM_KEYFILE = "sam.keys";
    static final String DEFAULT_SAM_CONFIGFILE = "sam.config";
    private static final String PROP_SAM_KEYFILE = "sam.keyfile";
    private static final String PROP_SAM_SSL = "sam.useSSL";
    public static final String PROP_TCP_HOST = "sam.tcp.host";
    public static final String PROP_TCP_PORT = "sam.tcp.port";
    public static final String PROP_AUTH = "sam.auth";
    public static final String PROP_PW_PREFIX = "sam.auth.";
    public static final String PROP_PW_SUFFIX = ".shash";
    protected static final String DEFAULT_TCP_HOST = "127.0.0.1";
    protected static final String DEFAULT_TCP_PORT = "7656";
    public static final String PROP_DATAGRAM_HOST = "sam.udp.host";
    public static final String PROP_DATAGRAM_PORT = "sam.udp.port";
    protected static final String DEFAULT_DATAGRAM_HOST = "127.0.0.1";
    protected static final int DEFAULT_DATAGRAM_PORT_INT = 7655;
    protected static final String DEFAULT_DATAGRAM_PORT = Integer.toString(7655);

    public SAMBridge(I2PAppContext context, ClientAppManager mgr, String[] args) throws Exception {
        this._log = context.logManager().getLog(SAMBridge.class);
        this._mgr = mgr;
        this._secureSession = null;
        Options options = SAMBridge.getOptions(args);
        this._listenHost = options.host;
        this._listenPort = options.port;
        this._useSSL = options.isSSL;
        if (this._useSSL && !SystemVersion.isJava7()) {
            throw new IllegalArgumentException("SSL requires Java 7 or higher");
        }
        this.persistFilename = options.keyFile;
        this._configFile = options.configFile;
        this.nameToPrivKeys = new HashMap<String, String>(8);
        this._handlers = new HashSet<Handler>(8);
        this.i2cpProps = options.opts;
        this._state = ClientAppState.INITIALIZED;
    }

    public SAMBridge(String listenHost, int listenPort, boolean isSSL, Properties i2cpProps, String persistFile, File configFile) {
        this(listenHost, listenPort, isSSL, i2cpProps, persistFile, configFile, null);
    }

    public SAMBridge(String listenHost, int listenPort, boolean isSSL, Properties i2cpProps, String persistFile, File configFile, SAMSecureSessionInterface secureSession) {
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(SAMBridge.class);
        this._mgr = null;
        this._listenHost = listenHost;
        this._listenPort = listenPort;
        this._useSSL = isSSL;
        this._secureSession = secureSession;
        if (this._useSSL && !SystemVersion.isJava7()) {
            throw new IllegalArgumentException("SSL requires Java 7 or higher");
        }
        this.i2cpProps = i2cpProps;
        this.persistFilename = persistFile;
        this._configFile = configFile;
        this.nameToPrivKeys = new HashMap<String, String>(8);
        this._handlers = new HashSet<Handler>(8);
        this.loadKeys();
        try {
            this.openSocket();
        }
        catch (IOException e) {
            if (this._log.shouldError()) {
                this._log.error("Error starting SAM Bridge on " + (listenHost == null ? "0.0.0.0" : listenHost) + ":" + listenPort, e);
            }
            throw new RuntimeException(e);
        }
        this._state = ClientAppState.INITIALIZED;
    }

    private void openSocket() throws IOException {
        if (!("127.0.0.1".equals(this._listenHost) || "localhost".equals(this._listenHost) || "::1".equals(this._listenHost) || "0:0:0:0:0:0:0:1".equals(this._listenHost) || this._useSSL && Boolean.parseBoolean(this.i2cpProps.getProperty(PROP_AUTH)))) {
            String m = "SECURITY WARNING: SAM interface not restricted to localhost, and SSL and Authentication are not enabled.\n* Remote access to local services may be possible -> Please check command line and configuration.";
            this._log.logAlways(30, m);
            System.out.println(m);
        }
        if (this._useSSL) {
            SSLServerSocketFactory fact = SSLUtil.initializeFactory(this.i2cpProps);
            InetAddress addr = this._listenHost != null && !this._listenHost.equals("0.0.0.0") ? InetAddress.getByName(this._listenHost) : null;
            SSLServerSocket sock = (SSLServerSocket)fact.createServerSocket(this._listenPort, 0, addr);
            I2PSSLSocketFactory.setProtocolsAndCiphers(sock);
            this.serverSocket = new SSLServerSocketChannel(sock);
        } else {
            this.serverSocket = ServerSocketChannel.open();
            if (this._listenHost != null && !this._listenHost.equals("0.0.0.0")) {
                this.serverSocket.socket().bind(new InetSocketAddress(this._listenHost, this._listenPort));
                if (this._log.shouldDebug()) {
                    this._log.debug("SAM Bridge listening on " + this._listenHost + ":" + this._listenPort);
                }
            } else {
                this.serverSocket.socket().bind(new InetSocketAddress(this._listenPort));
                if (this._log.shouldDebug()) {
                    this._log.debug("SAM Bridge listening on 0.0.0.0:" + this._listenPort);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKeystream(String name) {
        Map<String, String> map = this.nameToPrivKeys;
        synchronized (map) {
            String val = this.nameToPrivKeys.get(name);
            if (val == null) {
                return null;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeystream(String name, String stream) {
        Map<String, String> map = this.nameToPrivKeys;
        synchronized (map) {
            this.nameToPrivKeys.put(name, stream);
        }
        this.storeKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeys() {
        Map<String, String> map = this.nameToPrivKeys;
        synchronized (map) {
            this.nameToPrivKeys.clear();
            File file = new File(this.persistFilename);
            if (!file.exists()) {
                if (file.isAbsolute()) {
                    return;
                }
                file = new File(I2PAppContext.getGlobalContext().getConfigDir(), this.persistFilename);
                if (!file.exists()) {
                    return;
                }
            }
            try {
                Properties props = new Properties();
                DataHelper.loadProps(props, file);
                Properties foo = props;
                this.nameToPrivKeys.putAll(foo);
                if (this._log.shouldInfo()) {
                    this._log.info("Loaded " + this.nameToPrivKeys.size() + " private keys from " + file);
                }
            }
            catch (IOException ioe) {
                this._log.error("Unable to read the keys from " + file, ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeKeys() {
        Map<String, String> map = this.nameToPrivKeys;
        synchronized (map) {
            File file = new File(this.persistFilename);
            if (!file.exists() && !file.isAbsolute()) {
                file = new File(I2PAppContext.getGlobalContext().getConfigDir(), this.persistFilename);
            }
            try {
                OrderedProperties props = new OrderedProperties();
                props.putAll(this.nameToPrivKeys);
                DataHelper.storeProps(props, file);
                if (this._log.shouldInfo()) {
                    this._log.info("Saved " + this.nameToPrivKeys.size() + " private keys to " + file);
                }
            }
            catch (IOException ioe) {
                this._log.error("Error writing out the SAM keys to " + file, ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Handler handler) {
        if (this._log.shouldDebug()) {
            this._log.debug("Registered " + handler);
        }
        Set<Handler> set = this._handlers;
        synchronized (set) {
            this._handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Handler handler) {
        if (this._log.shouldDebug()) {
            this._log.debug("Unregistered " + handler);
        }
        Set<Handler> set = this._handlers;
        synchronized (set) {
            this._handlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopHandlers() {
        ArrayList<Handler> handlers = null;
        Set<Handler> set = this._handlers;
        synchronized (set) {
            if (!this._handlers.isEmpty()) {
                handlers = new ArrayList<Handler>(this._handlers);
                this._handlers.clear();
            }
        }
        if (handlers != null) {
            for (Handler handler : handlers) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Stopping " + handler + "...");
                }
                handler.stopHandling();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SAMv3DatagramServer getV3DatagramServer(Properties props) throws IOException {
        int port;
        String host = props.getProperty(PROP_DATAGRAM_HOST, "127.0.0.1");
        String portStr = props.getProperty(PROP_DATAGRAM_PORT, DEFAULT_DATAGRAM_PORT);
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            port = 7655;
        }
        Object object = this._v3DGServerLock;
        synchronized (object) {
            if (this._v3DGServer == null) {
                this._v3DGServer = new SAMv3DatagramServer(this, host, port, props);
                this._v3DGServer.start();
            } else if (this._v3DGServer.getPort() != port || !this._v3DGServer.getHost().equals(host)) {
                throw new IOException("Already have SAMv3 DatagramServer with host: " + host + ":" + port);
            }
            return this._v3DGServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startup() throws IOException {
        if (this._state != ClientAppState.INITIALIZED) {
            return;
        }
        this.changeState(ClientAppState.STARTING);
        Set<Handler> set = this._handlers;
        synchronized (set) {
            this._handlers.clear();
        }
        this.loadKeys();
        try {
            this.openSocket();
        }
        catch (IOException e) {
            if (this._log.shouldError()) {
                this._log.error("Error starting SAM Bridge on " + (this._listenHost == null ? "0.0.0.0" : this._listenHost) + ":" + this._listenPort, e);
            }
            this.changeState(ClientAppState.START_FAILED, e);
            throw e;
        }
        this.startThread();
    }

    @Override
    public synchronized void shutdown(String[] args) {
        if (this._state != ClientAppState.RUNNING) {
            return;
        }
        this.changeState(ClientAppState.STOPPING);
        this.acceptConnections = false;
        this.stopHandlers();
        if (this._runner != null) {
            this._runner.interrupt();
        } else {
            this.changeState(ClientAppState.STOPPED);
        }
    }

    @Override
    public ClientAppState getState() {
        return this._state;
    }

    @Override
    public String getName() {
        return "SAM";
    }

    @Override
    public String getDisplayName() {
        return "SAM " + this._listenHost + ':' + this._listenPort;
    }

    private void changeState(ClientAppState state) {
        this.changeState(state, null);
    }

    private synchronized void changeState(ClientAppState state, Exception e) {
        this._state = state;
        if (this._mgr != null) {
            this._mgr.notify(this, state, null, e);
        }
    }

    public static void main(String[] args) {
        try {
            Options options = SAMBridge.getOptions(args);
            SAMBridge bridge = new SAMBridge(options.host, options.port, options.isSSL, options.opts, options.keyFile, options.configFile);
            bridge.startThread();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            SAMBridge.usage();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            SAMBridge.usage();
            throw new RuntimeException(e);
        }
    }

    private void startThread() {
        I2PAppThread t = new I2PAppThread(this, "SAMListener " + this._listenPort);
        if (Boolean.parseBoolean(System.getProperty("sam.shutdownOnOOM"))) {
            t.addOOMEventThreadListener(new I2PThread.OOMEventListener(){

                @Override
                public void outOfMemory(OutOfMemoryError err) {
                    err.printStackTrace();
                    System.err.println("OOMed, die die die");
                    System.exit(-1);
                }
            });
        }
        t.start();
        this._runner = t;
    }

    private static Options getOptions(String[] args) throws Exception {
        int remaining;
        boolean shouldSave;
        int startArgs;
        int startOpts;
        int c;
        String keyfile = null;
        int port = -1;
        String host = null;
        boolean isSSL = false;
        String cfile = null;
        Getopt g = new Getopt("SAM", args, "hsc:");
        block15: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 115: {
                    isSSL = true;
                    continue block15;
                }
                case 99: {
                    cfile = g.getOptarg();
                    continue block15;
                }
            }
            throw new HelpRequestedException();
        }
        for (startOpts = startArgs = g.getOptind(); startOpts < args.length && !args[startOpts].contains("="); ++startOpts) {
        }
        int numArgs = startOpts - startArgs;
        switch (numArgs) {
            case 0: {
                break;
            }
            case 2: {
                keyfile = args[startArgs];
                try {
                    port = Integer.parseInt(args[startArgs + 1]);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new HelpRequestedException();
                }
            }
            case 3: {
                keyfile = args[startArgs];
                host = args[startArgs + 1];
                try {
                    port = Integer.parseInt(args[startArgs + 2]);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new HelpRequestedException();
                }
            }
            default: {
                throw new HelpRequestedException();
            }
        }
        String scfile = cfile != null ? cfile : DEFAULT_SAM_CONFIGFILE;
        File file = new File(scfile);
        if (!file.isAbsolute()) {
            file = new File(I2PAppContext.getGlobalContext().getConfigDir(), scfile);
        }
        Properties opts = new Properties();
        if (file.exists()) {
            DataHelper.loadProps(opts, file);
        } else if (cfile != null) {
            throw new IllegalArgumentException("Config file not found: " + file);
        }
        if (host == null) {
            host = opts.getProperty(PROP_TCP_HOST, "127.0.0.1");
        }
        if (port < 0) {
            try {
                port = Integer.parseInt(opts.getProperty(PROP_TCP_PORT, DEFAULT_TCP_PORT));
            }
            catch (NumberFormatException nfe) {
                throw new HelpRequestedException();
            }
        }
        if (keyfile == null) {
            keyfile = opts.getProperty(PROP_SAM_KEYFILE, DEFAULT_SAM_KEYFILE);
        }
        if (!isSSL) {
            isSSL = Boolean.parseBoolean(opts.getProperty(PROP_SAM_SSL));
        }
        if (isSSL && (shouldSave = SSLUtil.verifyKeyStore(opts))) {
            DataHelper.storeProps(opts, file);
        }
        if ((remaining = args.length - startOpts) > 0) {
            SAMBridge.parseOptions(args, startOpts, opts);
        }
        return new Options(host, port, isSSL, opts, keyfile, file);
    }

    private static void parseOptions(String[] args, int startArgs, Properties props) throws HelpRequestedException {
        for (int i = startArgs; i < args.length; ++i) {
            int eq = args[i].indexOf(61);
            if (eq <= 0) {
                throw new HelpRequestedException();
            }
            if (eq >= args[i].length() - 1) {
                throw new HelpRequestedException();
            }
            String key = args[i].substring(0, eq);
            String val = args[i].substring(eq + 1);
            key = key.trim();
            val = val.trim();
            if (key.length() <= 0 || val.length() <= 0) {
                throw new HelpRequestedException();
            }
            props.setProperty(key, val);
        }
    }

    private static void usage() {
        System.err.println("Usage: SAMBridge [-s] [-c sam.config] [keyfile [listenHost] listenPortNum[ name=val]*]\nor:\n       SAMBridge [ name=val ]*\n -s: Use SSL\n -c sam.config: Specify config file\n keyfile: location to persist private keys (default sam.keys)\n listenHost: interface to listen on (0.0.0.0 for all interfaces)\n listenPort: port to listen for SAM connections on (default 7656)\n name=val: options to pass when connecting via I2CP, such as \n           i2cp.host=localhost and i2cp.port=7654\n\nHost and ports of the SAM bridge can be specified with the alternate\nform by specifying options sam.tcp.host and/or sam.tcp.port\nOptions sam.udp.host and sam.udp.port specify the listening ip\nrange and the port of SAM datagram server. This server is\nonly launched after a client creates the first SAM datagram\nor raw session, after a handshake with SAM version >= 3.0.\n\nThe option loglevel=[DEBUG|WARN|ERROR|CRIT] can be used\nfor tuning the log verbosity.");
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block22: {
            if (this.serverSocket == null) {
                return;
            }
            this.changeState(ClientAppState.RUNNING);
            if (this._mgr != null) {
                this._mgr.register(this);
            }
            I2PAppContext.getGlobalContext().portMapper().register(this._useSSL ? "SAM-SSL" : "SAM", this._listenHost != null ? this._listenHost : "127.0.0.1", this._listenPort);
            while (this.acceptConnections) {
                SocketChannel s = this.serverSocket.accept();
                if (this._log.shouldDebug()) {
                    this._log.debug("New connection from " + s.socket().getInetAddress().toString() + ":" + s.socket().getPort());
                }
                class HelloHandler
                implements Runnable,
                Handler {
                    private final SocketChannel s;
                    private final SAMBridge parent;

                    HelloHandler(SocketChannel s, SAMBridge parent) {
                        this.s = s;
                        this.parent = parent;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        this.parent.register(this);
                        try {
                            SAMHandler handler = SAMHandlerFactory.createSAMHandler(this.s, SAMBridge.this.i2cpProps, this.parent);
                            if (handler == null) {
                                if (SAMBridge.this._log.shouldDebug()) {
                                    SAMBridge.this._log.debug("SAM handler has not been instantiated");
                                }
                                try {
                                    this.s.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                return;
                            }
                            handler.startHandling();
                        }
                        catch (SAMException e) {
                            if (SAMBridge.this._log.shouldError()) {
                                SAMBridge.this._log.error("SAM error: " + e.getMessage(), e);
                            }
                            String reply = "HELLO REPLY RESULT=I2P_ERROR MESSAGE=\"" + e.getMessage() + "\"\n";
                            SAMHandler.writeString(reply, this.s);
                            try {
                                this.s.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        catch (Exception ee) {
                            try {
                                this.s.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            SAMBridge.this._log.log(50, "Unexpected error handling SAM connection", ee);
                        }
                        finally {
                            this.parent.unregister(this);
                        }
                    }

                    @Override
                    public void stopHandling() {
                        try {
                            this.s.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                new I2PAppThread(new HelloHandler(s, this), "SAM HelloHandler").start();
            }
            this.changeState(ClientAppState.STOPPING);
            try {
                if (this._log.shouldDebug()) {
                    this._log.debug("Shutting down, closing server socket");
                }
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException s) {
                // empty catch block
            }
            I2PAppContext.getGlobalContext().portMapper().unregister(this._useSSL ? "SAM-SSL" : "SAM");
            this.stopHandlers();
            this.changeState(ClientAppState.STOPPED);
            break block22;
            catch (Exception e) {
                try {
                    if (this.acceptConnections) {
                        this._log.error("Unexpected error while listening for connections", e);
                    } else {
                        e = null;
                    }
                    this.changeState(ClientAppState.STOPPING, e);
                }
                catch (Throwable throwable) {
                    try {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Shutting down, closing server socket");
                        }
                        if (this.serverSocket != null) {
                            this.serverSocket.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    I2PAppContext.getGlobalContext().portMapper().unregister(this._useSSL ? "SAM-SSL" : "SAM");
                    this.stopHandlers();
                    this.changeState(ClientAppState.STOPPED);
                    throw throwable;
                }
                try {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Shutting down, closing server socket");
                    }
                    if (this.serverSocket != null) {
                        this.serverSocket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                I2PAppContext.getGlobalContext().portMapper().unregister(this._useSSL ? "SAM-SSL" : "SAM");
                this.stopHandlers();
                this.changeState(ClientAppState.STOPPED);
            }
        }
    }

    public void saveConfig() throws IOException {
        DataHelper.storeProps(this.i2cpProps, this._configFile);
    }

    public SAMSecureSessionInterface secureSession() {
        if (this._secureSession == null) {
            boolean attemptauth;
            if (this._log.shouldLog(10)) {
                this._log.debug("SAMBridge.secureSession() called when secureSession is null, creating default I2CP auth");
            }
            if (attemptauth = Boolean.parseBoolean(this.i2cpProps.getProperty(PROP_AUTH))) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("SAMBridge.secureSession() called when authentication is enabled");
                }
                SAMSecureSession secureSession = new SAMSecureSession();
                return secureSession;
            }
        }
        return this._secureSession;
    }

    private static class Options {
        private final String host;
        private final String keyFile;
        private final int port;
        private final Properties opts;
        private final boolean isSSL;
        private final File configFile;

        public Options(String host, int port, boolean isSSL, Properties opts, String keyFile, File configFile) {
            this.host = host;
            this.port = port;
            this.opts = opts;
            this.keyFile = keyFile;
            this.isSSL = isSSL;
            this.configFile = configFile;
        }
    }

    private static class HelpRequestedException
    extends Exception {
        static final long serialVersionUID = 1L;

        private HelpRequestedException() {
        }
    }
}

