/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SHA256Generator;
import net.i2p.crypto.SigType;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.KeyCertificate;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.ByteArrayStream;

public class KeysAndCert
extends DataStructureImpl {
    protected PublicKey _publicKey;
    protected SigningPublicKey _signingKey;
    protected Certificate _certificate;
    private Hash __calculatedHash;
    private byte[] _padding;
    protected int _paddingBlocks;
    private static final int PAD_COMP_LEN = 32;

    public Certificate getCertificate() {
        return this._certificate;
    }

    public void setCertificate(Certificate cert) {
        if (this._certificate != null) {
            throw new IllegalStateException();
        }
        this._certificate = cert;
    }

    public SigType getSigType() {
        if (this._certificate == null) {
            return null;
        }
        if (this._certificate.getCertificateType() == 5) {
            try {
                KeyCertificate kcert = this._certificate.toKeyCertificate();
                return kcert.getSigType();
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        return SigType.DSA_SHA1;
    }

    public EncType getEncType() {
        if (this._certificate == null) {
            return null;
        }
        if (this._certificate.getCertificateType() == 5) {
            try {
                KeyCertificate kcert = this._certificate.toKeyCertificate();
                return kcert.getEncType();
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        return EncType.ELGAMAL_2048;
    }

    public PublicKey getPublicKey() {
        return this._publicKey;
    }

    public void setPublicKey(PublicKey key) {
        if (this._publicKey != null) {
            throw new IllegalStateException();
        }
        this._publicKey = key;
    }

    public SigningPublicKey getSigningPublicKey() {
        return this._signingKey;
    }

    public void setSigningPublicKey(SigningPublicKey key) {
        if (this._signingKey != null) {
            throw new IllegalStateException();
        }
        this._signingKey = key;
    }

    public byte[] getPadding() {
        if (this._paddingBlocks <= 1) {
            return this._padding;
        }
        byte[] rv = new byte[32 * this._paddingBlocks];
        for (int i = 0; i < this._paddingBlocks; ++i) {
            System.arraycopy(this._padding, 0, this._paddingBlocks, i * 32, 32);
        }
        return rv;
    }

    public void setPadding(byte[] padding) {
        if (this._padding != null) {
            throw new IllegalStateException();
        }
        this._padding = padding;
        this.compressPadding();
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._publicKey != null || this._signingKey != null || this._certificate != null) {
            throw new IllegalStateException();
        }
        PublicKey pk = PublicKey.create(in);
        SigningPublicKey spk = SigningPublicKey.create(in);
        Certificate cert = Certificate.create(in);
        if (cert.getCertificateType() == 5) {
            KeyCertificate kcert = cert.toKeyCertificate();
            this._publicKey = pk.toTypedKey(kcert);
            this._signingKey = spk.toTypedKey(kcert);
            byte[] pad1 = pk.getPadding(kcert);
            byte[] pad2 = spk.getPadding(kcert);
            this._padding = KeysAndCert.combinePadding(pad1, pad2);
            this._certificate = kcert;
        } else {
            this._publicKey = pk;
            this._signingKey = spk;
            this._certificate = cert;
        }
    }

    protected static byte[] combinePadding(byte[] pad1, byte[] pad2) {
        if (pad1 == null) {
            return pad2;
        }
        if (pad2 == null) {
            return pad1;
        }
        byte[] rv = new byte[pad1.length + pad2.length];
        System.arraycopy(pad1, 0, rv, 0, pad1.length);
        System.arraycopy(pad2, 0, rv, pad1.length, pad2.length);
        return rv;
    }

    private void compressPadding() {
        this._paddingBlocks = 0;
        if (this._padding == null || (this._padding.length & 0x3F) != 32) {
            return;
        }
        int blks = this._padding.length / 32;
        for (int i = 1; i < blks; ++i) {
            if (DataHelper.eq(this._padding, 0, this._padding, i, 32)) continue;
            return;
        }
        byte[] comp = new byte[32];
        System.arraycopy(this._padding, 0, comp, 0, 32);
        this._padding = comp;
        this._paddingBlocks = blks;
    }

    protected int writePaddingBytes(byte[] target, int off) {
        if (this._padding == null) {
            return off;
        }
        if (this._paddingBlocks > 1) {
            for (int i = 0; i < this._paddingBlocks; ++i) {
                System.arraycopy(this._padding, 0, target, off, this._padding.length);
                off += 32;
            }
        } else {
            System.arraycopy(this._padding, 0, target, off, this._padding.length);
            off += this._padding.length;
        }
        return off;
    }

    @Override
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._certificate == null || this._publicKey == null || this._signingKey == null) {
            throw new DataFormatException("Not enough data to format the router identity");
        }
        this._publicKey.writeBytes(out);
        if (this._padding != null) {
            if (this._paddingBlocks <= 1) {
                out.write(this._padding);
            } else {
                for (int i = 0; i < this._paddingBlocks; ++i) {
                    out.write(this._padding, 0, 32);
                }
            }
        } else if (this._signingKey.length() < SigningPublicKey.KEYSIZE_BYTES || this._publicKey.length() < PublicKey.KEYSIZE_BYTES) {
            throw new DataFormatException("No padding set");
        }
        this._signingKey.writeTruncatedBytes(out);
        this._certificate.writeBytes(out);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof KeysAndCert)) {
            return false;
        }
        KeysAndCert ident = (KeysAndCert)object;
        return DataHelper.eq(this._signingKey, ident._signingKey) && DataHelper.eq(this._publicKey, ident._publicKey) && Arrays.equals(this._padding, ident._padding) && DataHelper.eq(this._certificate, ident._certificate);
    }

    public int hashCode() {
        if (this._signingKey == null) {
            return 0;
        }
        return this._signingKey.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        String cls = this.getClass().getSimpleName();
        buf.append(cls);
        buf.append("\n* Hash: ");
        if (cls.equals("Destination")) {
            buf.append(this.getHash().toBase32());
        } else {
            buf.append(this.getHash().toBase64());
        }
        buf.append("\n* Certificate: ").append(this._certificate);
        if (this._publicKey != null && this._publicKey.getType() != EncType.ELGAMAL_2048 || !cls.equals("Destination")) {
            buf.append("\n* Public Key: ").append(this._publicKey);
        }
        buf.append("\n* Public Signing Key: ").append(this._signingKey);
        if (this._padding != null) {
            int len = this._padding.length;
            if (this._paddingBlocks > 1) {
                len *= this._paddingBlocks;
            }
            buf.append("\n* Padding: ").append(len).append(" bytes");
        }
        return buf.toString();
    }

    @Override
    public Hash calculateHash() {
        return this.getHash();
    }

    public Hash getHash() {
        byte[] identBytes;
        if (this.__calculatedHash != null) {
            return this.__calculatedHash;
        }
        try {
            if (this._certificate == null) {
                throw new IllegalStateException("KAC hash error");
            }
            ByteArrayStream baos = new ByteArrayStream(384 + this._certificate.size());
            this.writeBytes(baos);
            identBytes = baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("KAC hash error", ioe);
        }
        catch (DataFormatException dfe) {
            throw new IllegalStateException("KAC hash error", dfe);
        }
        this.__calculatedHash = SHA256Generator.getInstance().calculateHash(identBytes);
        return this.__calculatedHash;
    }
}

