/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;
import net.i2p.util.ByteArrayStream;

public class HostReplyMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 39;
    private Destination _dest;
    private long _reqID;
    private int _code;
    private SessionId _sessionId;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILURE = 1;
    public static final int RESULT_SECRET_REQUIRED = 2;
    public static final int RESULT_KEY_REQUIRED = 3;
    public static final int RESULT_SECRET_AND_KEY_REQUIRED = 4;
    public static final int RESULT_DECRYPTION_FAILURE = 5;
    private static final long MAX_INT = 0xFFFFFFFFL;

    public HostReplyMessage() {
    }

    public HostReplyMessage(SessionId id, Destination d, long reqID) {
        if (id == null || d == null) {
            throw new IllegalArgumentException();
        }
        if (reqID < 0L || reqID > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this._sessionId = id;
        this._dest = d;
        this._reqID = reqID;
    }

    public HostReplyMessage(SessionId id, int failureCode, long reqID) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (failureCode <= 0 || failureCode > 255) {
            throw new IllegalArgumentException();
        }
        if (reqID < 0L || reqID > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this._sessionId = id;
        this._code = failureCode;
        this._reqID = reqID;
    }

    public SessionId getSessionId() {
        return this._sessionId;
    }

    @Override
    public SessionId sessionId() {
        return this._sessionId;
    }

    public long getReqID() {
        return this._reqID;
    }

    public int getResultCode() {
        return this._code;
    }

    public Destination getDestination() {
        return this._dest;
    }

    @Override
    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            this._reqID = DataHelper.readLong(in, 4);
            this._code = in.read();
            if (this._code < 0) {
                throw new EOFException();
            }
            if (this._code == 0) {
                this._dest = Destination.create(in);
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("bad data", dfe);
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        int len = 7;
        if (this._code == 0) {
            if (this._dest == null) {
                throw new I2CPMessageException("Unable to write out the message as there is not enough data");
            }
            len += this._dest.size();
        }
        ByteArrayStream os = new ByteArrayStream(len);
        try {
            this._sessionId.writeBytes(os);
            DataHelper.writeLong(os, 4, this._reqID);
            os.write((byte)this._code);
            if (this._code == 0) {
                this._dest.writeBytes(os);
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("bad data", dfe);
        }
        return os.toByteArray();
    }

    @Override
    public int getType() {
        return 39;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("HostReplyMessage ");
        buf.append("\n* ").append(this._sessionId);
        buf.append(" ReqID: ").append(this._reqID);
        buf.append(" Result: ").append(this._code);
        if (this._code == 0) {
            buf.append("\n* Destination: ").append(this._dest);
        }
        return buf.toString();
    }
}

