/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;

public class MessagePayloadMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 31;
    private int _sessionId;
    private long _messageId;
    private Payload _payload;

    public MessagePayloadMessage() {
        this._sessionId = -1;
        this._messageId = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessagePayloadMessage(long sessID, long msgID, Payload payload) {
        MessagePayloadMessage messagePayloadMessage = this;
        synchronized (messagePayloadMessage) {
            this._sessionId = (int)sessID;
            this._messageId = msgID;
            this._payload = payload;
        }
    }

    public synchronized long getSessionId() {
        return this._sessionId;
    }

    @Override
    public synchronized SessionId sessionId() {
        return this._sessionId >= 0 ? new SessionId(this._sessionId) : null;
    }

    @Deprecated
    public synchronized void setSessionId(long id) {
        this._sessionId = (int)id;
    }

    public synchronized long getMessageId() {
        return this._messageId;
    }

    @Deprecated
    public synchronized void setMessageId(long id) {
        this._messageId = id;
    }

    public synchronized Payload getPayload() {
        return this._payload;
    }

    @Deprecated
    public synchronized void setPayload(Payload payload) {
        this._payload = payload;
    }

    @Override
    protected synchronized void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = (int)DataHelper.readLong(in, 2);
            this._messageId = DataHelper.readLong(in, 4);
            this._payload = new Payload();
            this._payload.readBytes(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void writeMessage(OutputStream out) throws I2CPMessageException, IOException {
        if (this._sessionId < 0) {
            throw new I2CPMessageException("Unable to write out the message, as the session ID has not been defined");
        }
        if (this._messageId < 0L) {
            throw new I2CPMessageException("Unable to write out the message, as the message ID has not been defined");
        }
        if (this._payload == null) {
            throw new I2CPMessageException("Unable to write out the message, as the payload has not been defined");
        }
        int size = 10 + this._payload.getSize();
        try {
            DataHelper.writeLong(out, 4, size);
            out.write(31);
            DataHelper.writeLong(out, 2, this._sessionId);
            DataHelper.writeLong(out, 4, this._messageId);
            DataHelper.writeLong(out, 4, this._payload.getSize());
            out.write(this._payload.getEncryptedData());
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to write the message length or type", dfe);
        }
    }

    @Override
    public int getType() {
        return 31;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(" MessagePayloadMessage\n*");
        buf.append(" SessionID: ").append(this._sessionId);
        buf.append(" [MsgID ").append(this._messageId);
        buf.append("] [").append(this._payload).append("]");
        return buf.toString();
    }
}

