/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import java.util.Date;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;

class PersistenceHelper {
    private static final String NL = System.getProperty("line.separator");

    PersistenceHelper() {
    }

    public static final void add(StringBuilder buf, boolean addComments, String prefix, String name, String description, double value) {
        if (addComments) {
            buf.append("# ").append(description).append(NL);
        } else {
            buf.append(prefix).append(name).append('=').append(value).append(NL);
        }
    }

    public static final void addDate(StringBuilder buf, boolean addComments, String prefix, String name, String description, long value) {
        if (addComments) {
            String when = value > 0L ? new Date(value).toString() : "Never";
            PersistenceHelper.add(buf, true, prefix, name, description + ' ' + when, value);
        } else {
            PersistenceHelper.add(buf, false, prefix, name, description, value);
        }
    }

    public static final void addTime(StringBuilder buf, boolean addComments, String prefix, String name, String description, long value) {
        if (addComments) {
            String when = DataHelper.formatDuration(value);
            PersistenceHelper.add(buf, true, prefix, name, description + ' ' + when, value);
        } else {
            PersistenceHelper.add(buf, false, prefix, name, description, value);
        }
    }

    public static final void add(StringBuilder buf, boolean addComments, String prefix, String name, String description, long value) {
        if (addComments) {
            buf.append("# ").append(description).append(NL);
        } else {
            buf.append(prefix).append(name).append('=').append(value).append(NL);
        }
    }

    public static final long getLong(Properties props, String prefix, String name) {
        String val = props.getProperty(prefix + name);
        if (val != null) {
            try {
                long rv = Long.parseLong(val);
                return rv >= 0L ? rv : 0L;
            }
            catch (NumberFormatException nfe) {
                Log log = I2PAppContext.getGlobalContext().logManager().getLog(PersistenceHelper.class);
                log.warn("Error formatting " + val, nfe);
            }
        }
        return 0L;
    }

    public static final double getDouble(Properties props, String prefix, String name) {
        String val = props.getProperty(prefix + name);
        if (val != null) {
            try {
                return Double.parseDouble(val);
            }
            catch (NumberFormatException nfe) {
                Log log = I2PAppContext.getGlobalContext().logManager().getLog(PersistenceHelper.class);
                log.warn("Error formatting " + val, nfe);
            }
        }
        return 0.0;
    }

    public static final int getInt(Properties props, String prefix, String name) {
        String val = props.getProperty(prefix + name);
        if (val != null) {
            try {
                int rv = Integer.parseInt(val);
                return rv >= 0 ? rv : 0;
            }
            catch (NumberFormatException nfe) {
                Log log = I2PAppContext.getGlobalContext().logManager().getLog(PersistenceHelper.class);
                log.warn("Error formatting " + val, nfe);
            }
        }
        return 0;
    }
}

