/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import net.i2p.data.DataHelper;
import net.i2p.util.LookaheadInputStream;

public class ResettableGZIPInputStream
extends InflaterInputStream {
    private static final int FOOTER_SIZE = 8;
    private final ExtraByteInputStream _extraByteInputStream;
    private final LookaheadInputStream _lookaheadStream;
    private final CRC32 _crc32;
    private final byte[] _buf1 = new byte[1];
    private boolean _complete;

    public ResettableGZIPInputStream() {
        super(new ExtraByteInputStream(new LookaheadInputStream(8)), new Inflater(true));
        this._extraByteInputStream = (ExtraByteInputStream)this.in;
        this._lookaheadStream = (LookaheadInputStream)this._extraByteInputStream.getInputStream();
        this._crc32 = new CRC32();
    }

    public ResettableGZIPInputStream(InputStream compressedStream) throws IOException {
        this();
        this.initialize(compressedStream);
    }

    public void initialize(InputStream compressedStream) throws IOException {
        this.len = 0;
        this.inf.reset();
        this._complete = false;
        this._crc32.reset();
        this._buf1[0] = 0;
        this._extraByteInputStream.reset();
        this._lookaheadStream.initialize(compressedStream);
        this.verifyHeader();
    }

    @Override
    public int read() throws IOException {
        int read = this.read(this._buf1, 0, 1);
        if (read == -1) {
            return -1;
        }
        return this._buf1[0] & 0xFF;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this._complete) {
            return -1;
        }
        int read = super.read(buf, off, len);
        if (read == -1) {
            this.verifyFooter();
            return -1;
        }
        this._crc32.update(buf, off, read);
        if (this.inf.finished()) {
            this.verifyFooter();
            this.inf.reset();
            this._complete = true;
        }
        return read;
    }

    public long getTotalRead() {
        try {
            return this.inf.getBytesRead();
        }
        catch (RuntimeException e) {
            return 0L;
        }
    }

    public long getTotalExpanded() {
        try {
            return this.inf.getBytesWritten();
        }
        catch (RuntimeException e) {
            return 0L;
        }
    }

    public long getRemaining() {
        try {
            return this.inf.getRemaining();
        }
        catch (RuntimeException e) {
            return 0L;
        }
    }

    public boolean getFinished() {
        try {
            return this.inf.finished();
        }
        catch (RuntimeException e) {
            return true;
        }
    }

    public void destroy() throws IOException {
        this.close();
        super.close();
    }

    @Override
    public void close() throws IOException {
        this.len = 0;
        this.inf.reset();
        this._complete = false;
        this._crc32.reset();
        this._buf1[0] = 0;
        this._extraByteInputStream.close();
    }

    public String toString() {
        return "Read: " + this.getTotalRead() + "; Expanded: " + this.getTotalExpanded() + "; Remaining: " + this.getRemaining() + "; Finished: " + this.getFinished();
    }

    private void verifyFooter() throws IOException {
        byte[] footer = this._lookaheadStream.getFooter();
        long actualSize = this.inf.getTotalOut();
        long expectedSize = DataHelper.fromLongLE(footer, 4, 4);
        if (expectedSize != actualSize) {
            throw new IOException("gunzip expected " + expectedSize + " bytes, got " + actualSize);
        }
        long actualCRC = this._crc32.getValue();
        long expectedCRC = DataHelper.fromLongLE(footer, 0, 4);
        if (expectedCRC != actualCRC) {
            throw new IOException("gunzip CRC fail expected 0x" + Long.toHexString(expectedCRC) + " bytes, got 0x" + Long.toHexString(actualCRC));
        }
    }

    private void verifyHeader() throws IOException {
        int c = this.in.read();
        if (c != 31) {
            throw new IOException("First magic byte was wrong [" + c + "]");
        }
        c = this.in.read();
        if (c != 139) {
            throw new IOException("Second magic byte was wrong [" + c + "]");
        }
        c = this.in.read();
        if (c != 8) {
            throw new IOException("Compression format is INVALID [" + c + "]");
        }
        int flags = this.in.read();
        c = this.in.read();
        if (c == -1) {
            throw new IOException("EOF on MTIME0 [" + c + "]");
        }
        c = this.in.read();
        if (c == -1) {
            throw new IOException("EOF on MTIME1 [" + c + "]");
        }
        c = this.in.read();
        if (c == -1) {
            throw new IOException("EOF on MTIME2 [" + c + "]");
        }
        c = this.in.read();
        if (c == -1) {
            throw new IOException("EOF on MTIME3 [" + c + "]");
        }
        c = this.in.read();
        if (c != 0 && c != 2 && c != 4) {
            throw new IOException("Invalid extended flags [" + c + "]");
        }
        c = this.in.read();
        if (0 != (flags & 0x20)) {
            int _len = 0;
            c = this.in.read();
            if (c == -1) {
                throw new IOException("EOF reading the extra header");
            }
            _len = c;
            c = this.in.read();
            if (c == -1) {
                throw new IOException("EOF reading the extra header");
            }
            _len += c << 8;
            for (int i = 0; i < _len; ++i) {
                c = this.in.read();
                if (c != -1) continue;
                throw new IOException("EOF reading the extra header's body");
            }
        }
        if (0 != (flags & 0x10)) {
            c = this.in.read();
            while (c != 0) {
                if (c == -1) {
                    throw new IOException("EOF reading the name");
                }
                c = this.in.read();
            }
        }
        if (0 != (flags & 8)) {
            c = this.in.read();
            while (c != 0) {
                if (c == -1) {
                    throw new IOException("EOF reading the comment");
                }
                c = this.in.read();
            }
        }
        if (0 != (flags & 0x40)) {
            c = this.in.read();
            if (c == -1) {
                throw new IOException("EOF reading the CRC16");
            }
            c = this.in.read();
            if (c == -1) {
                throw new IOException("EOF reading the CRC16");
            }
        }
    }

    private static class ExtraByteInputStream
    extends FilterInputStream {
        private static final byte DUMMY = 0;
        private boolean _extraSent;

        public ExtraByteInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            if (this._extraSent) {
                return -1;
            }
            int rv = this.in.read();
            if (rv >= 0) {
                return rv;
            }
            this._extraSent = true;
            return 0;
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            if (this._extraSent) {
                return -1;
            }
            int rv = this.in.read(buf, off, len);
            if (rv >= 0) {
                return rv;
            }
            this._extraSent = true;
            buf[off] = 0;
            return 1;
        }

        @Override
        public void close() throws IOException {
            this._extraSent = false;
            this.in.close();
        }

        @Override
        public void reset() {
            this._extraSent = false;
        }

        public InputStream getInputStream() {
            return this.in;
        }
    }
}

