/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.TimeZone;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.stat.Rate;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.VersionComparator;

public abstract class SystemVersion {
    public static final String DAEMON_USER = "i2psvc";
    public static final String GENTOO_USER = "i2p";
    private static final boolean _isWin;
    private static final boolean _isMac;
    private static final boolean _isArm;
    private static final boolean _isX86;
    private static final boolean _isGentoo;
    private static final boolean _isZero;
    private static final boolean _isAndroid;
    private static final boolean _isApache;
    private static final boolean _isGNU;
    private static final boolean _isOpenJDK;
    private static final boolean _is64;
    private static final boolean _hasWrapper;
    private static final boolean _isLinuxService;
    private static final boolean _isWindowsService;
    private static final boolean _isService;
    private static final boolean _isSlow;
    private static final boolean _oneDotSix;
    private static final boolean _oneDotSeven;
    private static final boolean _oneDotEight;
    private static final boolean _oneDotNine;
    private static final boolean _oneDotTen;
    private static final boolean _oneDotEleven;
    private static final boolean _twelve;
    private static final boolean _thirteen;
    private static final boolean _fourteen;
    private static final boolean _fifteen;
    private static final boolean _sixteen;
    private static final boolean _seventeen;
    private static final boolean _eighteen;
    private static final boolean _nineteen;
    private static final boolean _twenty;
    private static final boolean _twentyOne;
    private static final boolean _twentyTwo;
    private static final int _androidSDK;
    public static final String PROP_OVERRIDE_IS_SLOW = "router.overrideIsSlow";
    public static final boolean DEFAULT_OVERRIDE_IS_SLOW = false;

    public static String getOS() {
        if (SystemVersion.isWindows()) {
            return "Windows";
        }
        if (SystemVersion.isMac()) {
            return "Apple";
        }
        if (SystemVersion.isGNU()) {
            return "Linux";
        }
        if (SystemVersion.isLinuxService()) {
            return "Linux (Service)";
        }
        if (SystemVersion.isAndroid()) {
            return "Android";
        }
        return "Linux";
    }

    public static String getArch() {
        if (SystemVersion.is64Bit()) {
            if (SystemVersion.isARM()) {
                return "ARM64";
            }
            if (SystemVersion.isX86()) {
                return "AMD64";
            }
        }
        if (SystemVersion.isARM()) {
            return "ARM";
        }
        if (SystemVersion.isX86()) {
            return "386";
        }
        return "unknown";
    }

    public static boolean isWindows() {
        return _isWin;
    }

    public static boolean isMac() {
        return _isMac;
    }

    public static boolean isAndroid() {
        return _isAndroid;
    }

    public static boolean isApache() {
        return _isApache || _isAndroid;
    }

    public static boolean isGNU() {
        return _isGNU;
    }

    public static boolean isGentoo() {
        return _isGentoo;
    }

    public static boolean isOpenJDK() {
        return _isOpenJDK;
    }

    public static boolean isARM() {
        return _isArm && (SystemVersion.getCores() < 4 || SystemVersion.getCores() == 4 && System.getProperty("os.arch").startsWith("arm"));
    }

    public static boolean isX86() {
        return _isX86;
    }

    public static boolean isZeroVM() {
        return _isZero;
    }

    public static boolean isSlow() {
        return _isSlow || !NativeBigInteger.isNative() || SystemVersion.getCores() < 4 && !SystemVersion.is64Bit() || SystemVersion.getCores() == 1 && SystemVersion.getMaxMemory() < 0x18000000L && !I2PAppContext.getGlobalContext().getBooleanProperty(PROP_OVERRIDE_IS_SLOW);
    }

    public static boolean isJava6() {
        return _oneDotSix;
    }

    public static boolean isJava7() {
        return _oneDotSeven;
    }

    public static boolean isJava8() {
        return _oneDotEight;
    }

    public static boolean isJava9() {
        return _oneDotNine;
    }

    public static boolean isJava10() {
        return _oneDotTen;
    }

    public static boolean isJava11() {
        return _oneDotEleven;
    }

    public static boolean isJava12() {
        return _twelve;
    }

    public static boolean isJava13() {
        return _thirteen;
    }

    public static boolean isJava14() {
        return _fourteen;
    }

    public static boolean isJava15() {
        return _fifteen;
    }

    public static boolean isJava16() {
        return _sixteen;
    }

    public static boolean isJava17() {
        return _seventeen;
    }

    public static boolean isJava18() {
        return _eighteen;
    }

    public static boolean isJava19() {
        return _nineteen;
    }

    public static boolean isJava20() {
        return _twenty;
    }

    public static boolean isJava21() {
        return _twentyOne;
    }

    public static boolean isJava22() {
        return _twentyTwo;
    }

    public static boolean isJava(int minVersion) {
        return SystemVersion.isJava("1." + minVersion);
    }

    public static boolean isJava(String minVersion) {
        String version = System.getProperty("java.version");
        if (!version.startsWith("1.")) {
            version = "1." + version;
        }
        if (!minVersion.startsWith("1.")) {
            minVersion = "1." + minVersion;
        }
        if (_isAndroid) {
            if (minVersion.startsWith("1.6")) {
                return _oneDotSix;
            }
            if (minVersion.startsWith("1.7")) {
                return _oneDotSeven;
            }
            return false;
        }
        return VersionComparator.comp(version, minVersion) >= 0;
    }

    public static boolean is64Bit() {
        return _is64;
    }

    public static boolean isLinuxService() {
        return _isLinuxService;
    }

    public static boolean isWindowsService() {
        return _isWindowsService;
    }

    public static boolean isService() {
        return _isService;
    }

    public static int getAndroidVersion() {
        return _androidSDK;
    }

    public static boolean hasWrapper() {
        return _hasWrapper;
    }

    public static long getMaxMemory() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory >= 0x3FFFFFFFFFFFFFFFL) {
            maxMemory = 0x200000000L;
        }
        return maxMemory;
    }

    public static int getCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static int usableCores() {
        if (_isWin || _isMac) {
            return 1;
        }
        int dividend = 1;
        int divisor = 1;
        if (_isX86) {
            dividend *= 3;
            divisor *= 4;
        }
        return (SystemVersion.getCores() * dividend + divisor / 2) / divisor;
    }

    public static TimeZone getSystemTimeZone() {
        return SystemVersion.getSystemTimeZone(I2PAppContext.getGlobalContext());
    }

    public static TimeZone getSystemTimeZone(I2PAppContext ctx) {
        String systemTimeZone = ctx.getProperty("i2p.systemTimeZone");
        if (systemTimeZone != null) {
            return TimeZone.getTimeZone(systemTimeZone);
        }
        return TimeZone.getDefault();
    }

    public static void main(String[] args) {
        String jvm;
        String string = SystemVersion.isOpenJDK() ? "(OpenJDK)" : (SystemVersion.isZeroVM() ? "(Zero JVM)" : (jvm = SystemVersion.isApache() ? "(Apache)" : ""));
        if (SystemVersion.isJava8()) {
            System.out.println("Java 8 " + jvm);
        } else if (SystemVersion.isJava9()) {
            System.out.println("Java 9 " + jvm);
        } else if (SystemVersion.isJava10()) {
            System.out.println("Java 10 " + jvm);
        } else if (SystemVersion.isJava11()) {
            System.out.println("Java 11 " + jvm);
        } else if (SystemVersion.isJava12()) {
            System.out.println("Java 12 " + jvm);
        } else if (SystemVersion.isJava13()) {
            System.out.println("Java 13 " + jvm);
        } else if (SystemVersion.isJava14()) {
            System.out.println("Java 14 " + jvm);
        } else if (SystemVersion.isJava15()) {
            System.out.println("Java 15 " + jvm);
        } else if (SystemVersion.isJava16()) {
            System.out.println("Java 16 " + jvm);
        } else if (SystemVersion.isJava17()) {
            System.out.println("Java 17 " + jvm);
        } else if (SystemVersion.isJava18()) {
            System.out.println("Java 18 " + jvm);
        } else if (SystemVersion.isJava19()) {
            System.out.println("Java 19 " + jvm);
        } else if (SystemVersion.isJava20()) {
            System.out.println("Java 20 " + jvm);
        } else if (SystemVersion.isJava21()) {
            System.out.println("Java 21 " + jvm);
        } else if (SystemVersion.isJava22()) {
            System.out.println("Java 22 " + jvm);
        }
        System.out.println("Platform: " + SystemVersion.getOS() + (SystemVersion.is64Bit() ? " (64Bit)" : " (32Bit)"));
        System.out.println("Cores / Max memory: " + SystemVersion.getCores() + " / " + SystemVersion.getMaxMemory() / 1024L / 1024L + "KB");
        System.out.println("");
        System.out.println("System Properties:");
        TreeSet<String> keys = new TreeSet<String>(System.getProperties().stringPropertyNames());
        for (String k : keys) {
            String v = System.getProperty(k);
            if (k.equals("line.separator")) {
                if ("\n".equals(v)) {
                    v = "\\n";
                } else if ("\r\n".equals(v)) {
                    v = "\\r\\n";
                }
            } else if (k.contains("user") || k.contains("vendor.url") || k.contains("printer")) continue;
            System.out.println("  " + k + " = " + v);
        }
    }

    public static int getCPULoad() {
        int max;
        DecimalFormat integerFormatter = new DecimalFormat("###,###,##0");
        int cores = SystemVersion.getCores();
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        double cpuLoadAvg = osmxb.getProcessCpuLoad() * 100.0;
        int cpuLoad = (int)cpuLoadAvg;
        if (cpuLoad > (max = 100)) {
            cpuLoad = max;
        }
        return cpuLoad;
    }

    public static int getCPULoadAvg() {
        if (I2PAppContext.getGlobalContext().statManager() == null || I2PAppContext.getGlobalContext().statManager().getRate("router.cpuLoad") == null) {
            return 0;
        }
        int max = 100;
        Rate stat = I2PAppContext.getGlobalContext().statManager().getRate("router.cpuLoad").getRate(60000L);
        long count = 1L + (3L * stat.getCurrentEventCount() + stat.getLastEventCount());
        long loadAvg = count > 1L ? (long)((double)SystemVersion.getCPULoad() + (3.0 * stat.getCurrentTotalValue() + stat.getLastTotalValue()) / (double)count) : (long)SystemVersion.getCPULoad();
        int load = Math.toIntExact(loadAvg);
        if (load > max) {
            load = max;
        }
        return load;
    }

    public static int getSystemLoad() {
        if (I2PAppContext.getGlobalContext().statManager() == null) {
            return 0;
        }
        DecimalFormat integerFormatter = new DecimalFormat("###,###,##0");
        int cores = SystemVersion.getCores();
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        double systemLoadAvg = osmxb.getSystemLoadAverage() / (double)cores * 100.0;
        int sysLoad = (int)systemLoadAvg;
        if (sysLoad < 0) {
            return 0;
        }
        return sysLoad;
    }

    public static int getTunnelBuildSuccess() {
        int percentage;
        if (I2PAppContext.getGlobalContext().statManager() == null) {
            return 0;
        }
        Rate explSuccess = I2PAppContext.getGlobalContext().statManager().getRate("tunnel.buildExploratorySuccess").getRate(600000L);
        Rate explReject = I2PAppContext.getGlobalContext().statManager().getRate("tunnel.buildExploratoryReject").getRate(600000L);
        Rate explExpire = I2PAppContext.getGlobalContext().statManager().getRate("tunnel.buildExploratoryExpire").getRate(600000L);
        Rate clientSuccess = I2PAppContext.getGlobalContext().statManager().getRate("tunnel.buildClientSuccess").getRate(600000L);
        Rate clientReject = I2PAppContext.getGlobalContext().statManager().getRate("tunnel.buildClientReject").getRate(600000L);
        Rate clientExpire = I2PAppContext.getGlobalContext().statManager().getRate("tunnel.buildClientExpire").getRate(600000L);
        int success = (int)explSuccess.getLastEventCount() + (int)clientSuccess.getLastEventCount();
        int reject = (int)explReject.getLastEventCount() + (int)clientReject.getLastEventCount();
        int expire = (int)explExpire.getLastEventCount() + (int)clientExpire.getLastEventCount();
        if (success < 1) {
            success = 1;
        }
        if ((percentage = 100 * success / (success + reject + expire)) == 100 || percentage == 0) {
            return 0;
        }
        return percentage;
    }

    static {
        boolean is64;
        _isWin = System.getProperty("os.name").startsWith("Win");
        _isMac = System.getProperty("os.name").startsWith("Mac");
        _isArm = System.getProperty("os.arch").startsWith("arm") || System.getProperty("os.arch").startsWith("aarch");
        _isX86 = System.getProperty("os.arch").contains("86") || System.getProperty("os.arch").equals("amd64");
        _isGentoo = System.getProperty("os.version").contains("gentoo") || System.getProperty("os.version").contains("hardened");
        _isZero = System.getProperty("java.vm.name").contains("Zero");
        _hasWrapper = System.getProperty("wrapper.version") != null;
        _isWindowsService = _isWin && _hasWrapper && Boolean.parseBoolean(System.getProperty("wrapper.service"));
        boolean bl = is64 = "64".equals(System.getProperty("sun.arch.data.model")) || System.getProperty("os.arch").contains("64");
        if (_isWin && !is64) {
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            is64 = arch != null && arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64");
        }
        _is64 = is64;
        String vendor = System.getProperty("java.vendor");
        _isAndroid = vendor.contains("Android");
        _isApache = vendor.startsWith("Apache");
        _isGNU = vendor.startsWith("GNU Classpath") || vendor.startsWith("Free Software Foundation");
        String runtime = System.getProperty("java.runtime.name");
        _isOpenJDK = runtime != null && runtime.contains("OpenJDK");
        _isLinuxService = !_isWin && !_isMac && !_isAndroid && (DAEMON_USER.equals(System.getProperty("user.name")) || _isGentoo && GENTOO_USER.equals(System.getProperty("user.name")));
        _isService = _isLinuxService || _isWindowsService;
        _isSlow = _isAndroid || _isApache || SystemVersion.isARM() && !_isMac || _isGNU || _isZero || SystemVersion.getMaxMemory() < 0x10000000L;
        int sdk = 0;
        if (_isAndroid) {
            try {
                Class<?> ver = Class.forName("android.os.Build$VERSION", true, ClassLoader.getSystemClassLoader());
                Field field = ver.getField("SDK_INT");
                sdk = field.getInt(null);
            }
            catch (Exception ver) {
                // empty catch block
            }
        }
        _androidSDK = sdk;
        if (_isAndroid) {
            _oneDotSix = _androidSDK >= 9;
            _oneDotSeven = _androidSDK >= 19;
            _oneDotEight = false;
            _oneDotNine = false;
            _oneDotTen = false;
            _oneDotEleven = false;
            _twelve = false;
            _thirteen = false;
            _fourteen = false;
            _fifteen = false;
            _sixteen = false;
            _seventeen = false;
            _eighteen = false;
            _nineteen = false;
            _twenty = false;
            _twentyOne = false;
            _twentyTwo = false;
        } else {
            String version = System.getProperty("java.version");
            if (!version.startsWith("1.")) {
                version = "1." + version;
            }
            _oneDotSix = VersionComparator.comp(version, "1.6") >= 0;
            _oneDotSeven = _oneDotSix && VersionComparator.comp(version, "1.7") >= 0;
            _oneDotEight = _oneDotSeven && VersionComparator.comp(version, "1.8") >= 0;
            _oneDotNine = _oneDotEight && VersionComparator.comp(version, "1.9") >= 0;
            _oneDotTen = _oneDotNine && VersionComparator.comp(version, "1.10") >= 0;
            _oneDotEleven = _oneDotTen && VersionComparator.comp(version, "1.11") >= 0;
            _twelve = _oneDotEleven && VersionComparator.comp(version, "12.0") >= 0;
            _thirteen = _twelve && VersionComparator.comp(version, "13.0") >= 0;
            _fourteen = _thirteen && VersionComparator.comp(version, "14.0") >= 0;
            _fifteen = _fourteen && VersionComparator.comp(version, "15.0") >= 0;
            _sixteen = _fifteen && VersionComparator.comp(version, "16.0") >= 0;
            _seventeen = _sixteen && VersionComparator.comp(version, "17.0") >= 0;
            _eighteen = _seventeen && VersionComparator.comp(version, "18.0") >= 0;
            _nineteen = _eighteen && VersionComparator.comp(version, "19.0") >= 0;
            _twenty = _nineteen && VersionComparator.comp(version, "20.0") >= 0;
            _twentyOne = _twenty && VersionComparator.comp(version, "21.0") >= 0;
            _twentyTwo = _twentyOne && VersionComparator.comp(version, "22.0") >= 0;
        }
    }
}

