/*
 * Decompiled with CFR 0.152.
 */
package io.pack200;

import io.pack200.Attribute;
import io.pack200.Code;
import io.pack200.ConstantPool;
import io.pack200.Package;
import io.pack200.Utils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

class ClassWriter {
    int verbose;
    Package pkg;
    Package.Class cls;
    DataOutputStream out;
    ConstantPool.Index cpIndex;
    ConstantPool.Index bsmIndex;
    ByteArrayOutputStream buf = new ByteArrayOutputStream();
    DataOutputStream bufOut = new DataOutputStream(this.buf);

    ClassWriter(Package.Class cls, OutputStream out) throws IOException {
        this.pkg = cls.getPackage();
        this.cls = cls;
        this.verbose = this.pkg.verbose;
        this.out = new DataOutputStream(new BufferedOutputStream(out));
        this.cpIndex = ConstantPool.makeIndex(cls.toString(), cls.getCPMap());
        this.cpIndex.flattenSigs = true;
        if (cls.hasBootstrapMethods()) {
            this.bsmIndex = ConstantPool.makeIndex(this.cpIndex.debugName + ".BootstrapMethods", cls.getBootstrapMethodMap());
        }
        if (this.verbose > 1) {
            Utils.log.fine("local CP=" + (this.verbose > 2 ? this.cpIndex.dumpString() : this.cpIndex.toString()));
        }
    }

    private void writeShort(int x) throws IOException {
        this.out.writeShort(x);
    }

    private void writeInt(int x) throws IOException {
        this.out.writeInt(x);
    }

    private void writeRef(ConstantPool.Entry e) throws IOException {
        this.writeRef(e, this.cpIndex);
    }

    private void writeRef(ConstantPool.Entry e, ConstantPool.Index cpIndex) throws IOException {
        int i = e == null ? 0 : cpIndex.indexOf(e);
        this.writeShort(i);
    }

    void write() throws IOException {
        boolean ok = false;
        try {
            if (this.verbose > 1) {
                Utils.log.fine("...writing " + this.cls);
            }
            this.writeMagicNumbers();
            this.writeConstantPool();
            this.writeHeader();
            this.writeMembers(false);
            this.writeMembers(true);
            this.writeAttributes(0, this.cls);
            this.out.flush();
            ok = true;
        }
        finally {
            if (!ok) {
                Utils.log.warning("Error on output of " + this.cls);
            }
        }
    }

    void writeMagicNumbers() throws IOException {
        this.writeInt(this.cls.magic);
        this.writeShort(this.cls.version.minor);
        this.writeShort(this.cls.version.major);
    }

    void writeConstantPool() throws IOException {
        ConstantPool.Entry[] cpMap = this.cls.cpMap;
        this.writeShort(cpMap.length);
        block13: for (int i = 0; i < cpMap.length; ++i) {
            ConstantPool.Entry e = cpMap[i];
            assert (e == null == (i == 0 || cpMap[i - 1] != null && cpMap[i - 1].isDoubleWord()));
            if (e == null) continue;
            byte tag = e.getTag();
            if (this.verbose > 2) {
                Utils.log.fine("   CP[" + i + "] = " + e);
            }
            this.out.write(tag);
            switch (tag) {
                case 13: {
                    throw new AssertionError((Object)"CP should have Signatures remapped to Utf8");
                }
                case 1: {
                    this.out.writeUTF(e.stringValue());
                    continue block13;
                }
                case 3: {
                    this.out.writeInt(((ConstantPool.NumberEntry)e).numberValue().intValue());
                    continue block13;
                }
                case 4: {
                    float fval = ((ConstantPool.NumberEntry)e).numberValue().floatValue();
                    this.out.writeInt(Float.floatToRawIntBits(fval));
                    continue block13;
                }
                case 5: {
                    this.out.writeLong(((ConstantPool.NumberEntry)e).numberValue().longValue());
                    continue block13;
                }
                case 6: {
                    double dval = ((ConstantPool.NumberEntry)e).numberValue().doubleValue();
                    this.out.writeLong(Double.doubleToRawLongBits(dval));
                    continue block13;
                }
                case 7: 
                case 8: 
                case 16: {
                    this.writeRef(e.getRef(0));
                    continue block13;
                }
                case 15: {
                    ConstantPool.MethodHandleEntry mhe = (ConstantPool.MethodHandleEntry)e;
                    this.out.writeByte(mhe.refKind);
                    this.writeRef(mhe.getRef(0));
                    continue block13;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.writeRef(e.getRef(0));
                    this.writeRef(e.getRef(1));
                    continue block13;
                }
                case 18: {
                    this.writeRef(e.getRef(0), this.bsmIndex);
                    this.writeRef(e.getRef(1));
                    continue block13;
                }
                case 17: {
                    throw new AssertionError((Object)"CP should have BootstrapMethods moved to side-table");
                }
                default: {
                    throw new IOException("Bad constant pool tag " + tag);
                }
            }
        }
    }

    void writeHeader() throws IOException {
        this.writeShort(this.cls.flags);
        this.writeRef(this.cls.thisClass);
        this.writeRef(this.cls.superClass);
        this.writeShort(this.cls.interfaces.length);
        for (int i = 0; i < this.cls.interfaces.length; ++i) {
            this.writeRef(this.cls.interfaces[i]);
        }
    }

    void writeMembers(boolean doMethods) throws IOException {
        List<Package.Class.Member> mems = !doMethods ? this.cls.getFields() : this.cls.getMethods();
        this.writeShort(mems.size());
        for (Package.Class.Member m : mems) {
            this.writeMember(m, doMethods);
        }
    }

    void writeMember(Package.Class.Member m, boolean doMethod) throws IOException {
        if (this.verbose > 2) {
            Utils.log.fine("writeMember " + m);
        }
        this.writeShort(m.flags);
        this.writeRef(m.getDescriptor().nameRef);
        this.writeRef(m.getDescriptor().typeRef);
        this.writeAttributes(!doMethod ? 1 : 2, m);
    }

    private void reorderBSMandICS(Attribute.Holder h) {
        int icsidx;
        Attribute bsmAttr = h.getAttribute(Package.attrBootstrapMethodsEmpty);
        if (bsmAttr == null) {
            return;
        }
        Attribute icsAttr = h.getAttribute(Package.attrInnerClassesEmpty);
        if (icsAttr == null) {
            return;
        }
        int bsmidx = h.attributes.indexOf(bsmAttr);
        if (bsmidx > (icsidx = h.attributes.indexOf(icsAttr))) {
            h.attributes.remove(bsmAttr);
            h.attributes.add(icsidx, bsmAttr);
        }
    }

    void writeAttributes(int ctype, Attribute.Holder h) throws IOException {
        if (h.attributes == null) {
            this.writeShort(0);
            return;
        }
        if (h instanceof Package.Class) {
            this.reorderBSMandICS(h);
        }
        this.writeShort(h.attributes.size());
        for (Attribute a : h.attributes) {
            a.finishRefs(this.cpIndex);
            this.writeRef(a.getNameRef());
            if (a.layout() == Package.attrCodeEmpty || a.layout() == Package.attrBootstrapMethodsEmpty || a.layout() == Package.attrInnerClassesEmpty) {
                DataOutputStream savedOut = this.out;
                assert (this.out != this.bufOut);
                this.buf.reset();
                this.out = this.bufOut;
                if ("Code".equals(a.name())) {
                    Package.Class.Method m = (Package.Class.Method)h;
                    this.writeCode(m.code);
                } else if ("BootstrapMethods".equals(a.name())) {
                    assert (h == this.cls);
                    this.writeBootstrapMethods(this.cls);
                } else if ("InnerClasses".equals(a.name())) {
                    assert (h == this.cls);
                    this.writeInnerClasses(this.cls);
                } else {
                    throw new AssertionError();
                }
                this.out = savedOut;
                if (this.verbose > 2) {
                    Utils.log.fine("Attribute " + a.name() + " [" + this.buf.size() + "]");
                }
                this.writeInt(this.buf.size());
                this.buf.writeTo(this.out);
                continue;
            }
            if (this.verbose > 2) {
                Utils.log.fine("Attribute " + a.name() + " [" + a.size() + "]");
            }
            this.writeInt(a.size());
            this.out.write(a.bytes());
        }
    }

    void writeCode(Code code) throws IOException {
        code.finishRefs(this.cpIndex);
        this.writeShort(code.max_stack);
        this.writeShort(code.max_locals);
        this.writeInt(code.bytes.length);
        this.out.write(code.bytes);
        int nh = code.getHandlerCount();
        this.writeShort(nh);
        for (int i = 0; i < nh; ++i) {
            this.writeShort(code.handler_start[i]);
            this.writeShort(code.handler_end[i]);
            this.writeShort(code.handler_catch[i]);
            this.writeRef(code.handler_class[i]);
        }
        this.writeAttributes(3, code);
    }

    void writeBootstrapMethods(Package.Class cls) throws IOException {
        List<ConstantPool.BootstrapMethodEntry> bsms = cls.getBootstrapMethods();
        this.writeShort(bsms.size());
        for (ConstantPool.BootstrapMethodEntry e : bsms) {
            this.writeRef(e.bsmRef);
            this.writeShort(e.argRefs.length);
            for (ConstantPool.Entry argRef : e.argRefs) {
                this.writeRef(argRef);
            }
        }
    }

    void writeInnerClasses(Package.Class cls) throws IOException {
        List<Package.InnerClass> ics = cls.getInnerClasses();
        this.writeShort(ics.size());
        for (Package.InnerClass ic : ics) {
            this.writeRef(ic.thisClass);
            this.writeRef(ic.outerClass);
            this.writeRef(ic.name);
            this.writeShort(ic.flags);
        }
    }
}

