/*
 * Decompiled with CFR 0.152.
 */
package io.pack200;

import io.pack200.Utils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

abstract class ConstantPool {
    protected static final Entry[] noRefs = new Entry[0];
    protected static final ClassEntry[] noClassRefs = new ClassEntry[0];
    static final byte[] TAGS_IN_ORDER = new byte[]{1, 3, 4, 5, 6, 8, 7, 13, 12, 9, 10, 11, 15, 16, 17, 18};
    static final byte[] TAG_ORDER = new byte[19];
    static final byte[] NUMBER_TAGS;
    static final byte[] EXTRA_TAGS;
    static final byte[] LOADABLE_VALUE_TAGS;
    static final byte[] ANY_MEMBER_TAGS;
    static final byte[] FIELD_SPECIFIC_TAGS;

    private ConstantPool() {
    }

    static int verbose() {
        return Utils.currentPropMap().getInteger("io.pack200.verbose");
    }

    public static synchronized Utf8Entry getUtf8Entry(String value) {
        Map<String, Utf8Entry> utf8Entries = Utils.getTLGlobals().getUtf8Entries();
        Utf8Entry e = utf8Entries.get(value);
        if (e == null) {
            e = new Utf8Entry(value);
            utf8Entries.put(e.stringValue(), e);
        }
        return e;
    }

    public static ClassEntry getClassEntry(String name) {
        Map<String, ClassEntry> classEntries = Utils.getTLGlobals().getClassEntries();
        ClassEntry e = classEntries.get(name);
        if (e == null) {
            e = new ClassEntry(ConstantPool.getUtf8Entry(name));
            assert (name.equals(e.stringValue()));
            classEntries.put(e.stringValue(), e);
        }
        return e;
    }

    public static LiteralEntry getLiteralEntry(Comparable<?> value) {
        Map<Object, LiteralEntry> literalEntries = Utils.getTLGlobals().getLiteralEntries();
        LiteralEntry e = literalEntries.get(value);
        if (e == null) {
            e = value instanceof String ? new StringEntry(ConstantPool.getUtf8Entry((String)((Object)value))) : new NumberEntry((Number)((Object)value));
            literalEntries.put(value, e);
        }
        return e;
    }

    public static StringEntry getStringEntry(String value) {
        return (StringEntry)ConstantPool.getLiteralEntry(value);
    }

    public static SignatureEntry getSignatureEntry(String type) {
        Map<String, SignatureEntry> signatureEntries = Utils.getTLGlobals().getSignatureEntries();
        SignatureEntry e = signatureEntries.get(type);
        if (e == null) {
            e = new SignatureEntry(type);
            assert (e.stringValue().equals(type));
            signatureEntries.put(type, e);
        }
        return e;
    }

    public static SignatureEntry getSignatureEntry(Utf8Entry formRef, ClassEntry[] classRefs) {
        return ConstantPool.getSignatureEntry(SignatureEntry.stringValueOf(formRef, classRefs));
    }

    public static DescriptorEntry getDescriptorEntry(Utf8Entry nameRef, SignatureEntry typeRef) {
        String key;
        Map<String, DescriptorEntry> descriptorEntries = Utils.getTLGlobals().getDescriptorEntries();
        DescriptorEntry e = descriptorEntries.get(key = DescriptorEntry.stringValueOf(nameRef, typeRef));
        if (e == null) {
            e = new DescriptorEntry(nameRef, typeRef);
            assert (e.stringValue().equals(key)) : e.stringValue() + " != " + key;
            descriptorEntries.put(key, e);
        }
        return e;
    }

    public static DescriptorEntry getDescriptorEntry(Utf8Entry nameRef, Utf8Entry typeRef) {
        return ConstantPool.getDescriptorEntry(nameRef, ConstantPool.getSignatureEntry(typeRef.stringValue()));
    }

    public static MemberEntry getMemberEntry(byte tag, ClassEntry classRef, DescriptorEntry descRef) {
        String key;
        Map<String, MemberEntry> memberEntries = Utils.getTLGlobals().getMemberEntries();
        MemberEntry e = memberEntries.get(key = MemberEntry.stringValueOf(tag, classRef, descRef));
        if (e == null) {
            e = new MemberEntry(tag, classRef, descRef);
            assert (e.stringValue().equals(key)) : e.stringValue() + " != " + key;
            memberEntries.put(key, e);
        }
        return e;
    }

    public static MethodHandleEntry getMethodHandleEntry(byte refKind, MemberEntry memRef) {
        String key;
        Map<String, MethodHandleEntry> methodHandleEntries = Utils.getTLGlobals().getMethodHandleEntries();
        MethodHandleEntry e = methodHandleEntries.get(key = MethodHandleEntry.stringValueOf(refKind, memRef));
        if (e == null) {
            e = new MethodHandleEntry(refKind, memRef);
            assert (e.stringValue().equals(key));
            methodHandleEntries.put(key, e);
        }
        return e;
    }

    public static MethodTypeEntry getMethodTypeEntry(SignatureEntry sigRef) {
        String key;
        Map<String, MethodTypeEntry> methodTypeEntries = Utils.getTLGlobals().getMethodTypeEntries();
        MethodTypeEntry e = methodTypeEntries.get(key = sigRef.stringValue());
        if (e == null) {
            e = new MethodTypeEntry(sigRef);
            assert (e.stringValue().equals(key));
            methodTypeEntries.put(key, e);
        }
        return e;
    }

    public static MethodTypeEntry getMethodTypeEntry(Utf8Entry typeRef) {
        return ConstantPool.getMethodTypeEntry(ConstantPool.getSignatureEntry(typeRef.stringValue()));
    }

    public static InvokeDynamicEntry getInvokeDynamicEntry(BootstrapMethodEntry bssRef, DescriptorEntry descRef) {
        String key;
        Map<String, InvokeDynamicEntry> invokeDynamicEntries = Utils.getTLGlobals().getInvokeDynamicEntries();
        InvokeDynamicEntry e = invokeDynamicEntries.get(key = InvokeDynamicEntry.stringValueOf(bssRef, descRef));
        if (e == null) {
            e = new InvokeDynamicEntry(bssRef, descRef);
            assert (e.stringValue().equals(key));
            invokeDynamicEntries.put(key, e);
        }
        return e;
    }

    public static BootstrapMethodEntry getBootstrapMethodEntry(MethodHandleEntry bsmRef, Entry[] argRefs) {
        String key;
        Map<String, BootstrapMethodEntry> bootstrapMethodEntries = Utils.getTLGlobals().getBootstrapMethodEntries();
        BootstrapMethodEntry e = bootstrapMethodEntries.get(key = BootstrapMethodEntry.stringValueOf(bsmRef, argRefs));
        if (e == null) {
            e = new BootstrapMethodEntry(bsmRef, argRefs);
            assert (e.stringValue().equals(key));
            bootstrapMethodEntries.put(key, e);
        }
        return e;
    }

    static boolean isMemberTag(byte tag) {
        switch (tag) {
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    static byte numberTagOf(Number value) {
        if (value instanceof Integer) {
            return 3;
        }
        if (value instanceof Float) {
            return 4;
        }
        if (value instanceof Long) {
            return 5;
        }
        if (value instanceof Double) {
            return 6;
        }
        throw new RuntimeException("bad literal value " + value);
    }

    static boolean isRefKind(byte refKind) {
        return 1 <= refKind && refKind <= 9;
    }

    static String qualifiedStringValue(Entry e1, Entry e2) {
        return ConstantPool.qualifiedStringValue(e1.stringValue(), e2.stringValue());
    }

    static String qualifiedStringValue(String s1, String s234) {
        assert (s1.indexOf(46) < 0);
        return s1 + "." + s234;
    }

    static int compareSignatures(String s1, String s2) {
        return ConstantPool.compareSignatures(s1, s2, null, null);
    }

    static int compareSignatures(String s1, String s2, String[] p1, String[] p2) {
        int length;
        int S1_COMES_FIRST = -1;
        boolean S2_COMES_FIRST = true;
        char c1 = s1.charAt(0);
        char c2 = s2.charAt(0);
        if (c1 != '(' && c2 == '(') {
            return -1;
        }
        if (c2 != '(' && c1 == '(') {
            return 1;
        }
        if (p1 == null) {
            p1 = ConstantPool.structureSignature(s1);
        }
        if (p2 == null) {
            p2 = ConstantPool.structureSignature(s2);
        }
        if (p1.length != p2.length) {
            return p1.length - p2.length;
        }
        int i = length = p1.length;
        while (--i >= 0) {
            int res = p1[i].compareTo(p2[i]);
            if (res == 0) continue;
            return res;
        }
        assert (s1.equals(s2));
        return 0;
    }

    static int countClassParts(Utf8Entry formRef) {
        int num = 0;
        String s = formRef.stringValue();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != 'L') continue;
            ++num;
        }
        return num;
    }

    static String flattenSignature(String[] parts) {
        String form = parts[0];
        if (parts.length == 1) {
            return form;
        }
        int len = form.length();
        for (int i = 1; i < parts.length; ++i) {
            len += parts[i].length();
        }
        char[] sig = new char[len];
        int j = 0;
        int k = 1;
        for (int i = 0; i < form.length(); ++i) {
            char ch = form.charAt(i);
            sig[j++] = ch;
            if (ch != 'L') continue;
            String cls = parts[k++];
            cls.getChars(0, cls.length(), sig, j);
            j += cls.length();
        }
        assert (j == len);
        assert (k == parts.length);
        return new String(sig);
    }

    private static int skipTo(char semi, String sig, int i) {
        return (i = sig.indexOf(semi, i)) >= 0 ? i : sig.length();
    }

    static String[] structureSignature(String sig) {
        int firstl = sig.indexOf(76);
        if (firstl < 0) {
            String[] parts = new String[]{sig};
            return parts;
        }
        char[] form = null;
        String[] parts = null;
        for (int pass = 0; pass <= 1; ++pass) {
            int formPtr = 0;
            int partPtr = 1;
            int nextsemi = 0;
            int nextangl = 0;
            int lastj = 0;
            int i = firstl + 1;
            while (i > 0) {
                int j;
                if (nextsemi < i) {
                    nextsemi = ConstantPool.skipTo(';', sig, i);
                }
                if (nextangl < i) {
                    nextangl = ConstantPool.skipTo('<', sig, i);
                }
                int n = j = nextsemi < nextangl ? nextsemi : nextangl;
                if (pass != 0) {
                    sig.getChars(lastj, i, form, formPtr);
                    parts[partPtr] = sig.substring(i, j);
                }
                formPtr += i - lastj;
                ++partPtr;
                lastj = j;
                i = sig.indexOf(76, j) + 1;
            }
            if (pass != 0) {
                sig.getChars(lastj, sig.length(), form, formPtr);
                break;
            }
            form = new char[formPtr += sig.length() - lastj];
            parts = new String[partPtr];
        }
        parts[0] = new String(form);
        return parts;
    }

    public static Index makeIndex(String debugName, Entry[] cpMap) {
        return new Index(debugName, cpMap);
    }

    public static Index makeIndex(String debugName, Collection<Entry> cpMapList) {
        return new Index(debugName, cpMapList);
    }

    public static void sort(Index ix) {
        ix.clearIndex();
        Arrays.sort(ix.cpMap);
        if (ConstantPool.verbose() > 2) {
            System.out.println("sorted " + ix.dumpString());
        }
    }

    public static Index[] partition(Index ix, int[] keys) {
        List<Entry> part;
        int key;
        ArrayList<ArrayList<Entry>> parts = new ArrayList<ArrayList<Entry>>();
        Entry[] cpMap = ix.cpMap;
        assert (keys.length == cpMap.length);
        for (int i = 0; i < keys.length; ++i) {
            key = keys[i];
            if (key < 0) continue;
            while (key >= parts.size()) {
                parts.add(null);
            }
            part = (ArrayList<Entry>)parts.get(key);
            if (part == null) {
                part = new ArrayList<Entry>();
                parts.set(key, (ArrayList<Entry>)part);
            }
            part.add(cpMap[i]);
        }
        Index[] indexes = new Index[parts.size()];
        for (key = 0; key < indexes.length; ++key) {
            part = (List)parts.get(key);
            if (part == null) continue;
            indexes[key] = new Index(ix.debugName + "/part#" + key, part);
            assert (indexes[key].indexOf((Entry)part.get(0)) == 0);
        }
        return indexes;
    }

    public static Index[] partitionByTag(Index ix) {
        Entry[] cpMap = ix.cpMap;
        int[] keys = new int[cpMap.length];
        for (int i = 0; i < keys.length; ++i) {
            Entry e = cpMap[i];
            keys[i] = e == null ? -1 : (int)e.tag;
        }
        Index[] byTag = ConstantPool.partition(ix, keys);
        for (int tag = 0; tag < byTag.length; ++tag) {
            if (byTag[tag] == null) continue;
            byTag[tag].debugName = ConstantPool.tagName(tag);
        }
        if (byTag.length < 19) {
            Index[] longer = new Index[19];
            System.arraycopy(byTag, 0, longer, 0, byTag.length);
            byTag = longer;
        }
        return byTag;
    }

    public static void completeReferencesIn(Set<Entry> cpRefs, boolean flattenSigs) {
        ConstantPool.completeReferencesIn(cpRefs, flattenSigs, null);
    }

    public static void completeReferencesIn(Set<Entry> cpRefs, boolean flattenSigs, List<BootstrapMethodEntry> bsms) {
        cpRefs.remove(null);
        ListIterator<Entry> work = new ArrayList<Entry>(cpRefs).listIterator(cpRefs.size());
        while (work.hasPrevious()) {
            Entry re;
            Entry e = work.previous();
            work.remove();
            assert (e != null);
            if (flattenSigs && e.tag == 13) {
                SignatureEntry se = (SignatureEntry)e;
                Utf8Entry ue = se.asUtf8Entry();
                cpRefs.remove(se);
                cpRefs.add(ue);
                e = ue;
            }
            if (bsms != null && e.tag == 17) {
                BootstrapMethodEntry bsm = (BootstrapMethodEntry)e;
                cpRefs.remove(bsm);
                if (!bsms.contains(bsm)) {
                    bsms.add(bsm);
                }
            }
            int i = 0;
            while ((re = e.getRef(i)) != null) {
                if (cpRefs.add(re)) {
                    work.add(re);
                }
                ++i;
            }
        }
    }

    static double percent(int num, int den) {
        return (double)((int)(10000.0 * (double)num / (double)den + 0.5)) / 100.0;
    }

    public static String tagName(int tag) {
        switch (tag) {
            case 1: {
                return "Utf8";
            }
            case 3: {
                return "Integer";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Long";
            }
            case 6: {
                return "Double";
            }
            case 7: {
                return "Class";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "Fieldref";
            }
            case 10: {
                return "Methodref";
            }
            case 11: {
                return "InterfaceMethodref";
            }
            case 12: {
                return "NameandType";
            }
            case 15: {
                return "MethodHandle";
            }
            case 16: {
                return "MethodType";
            }
            case 18: {
                return "InvokeDynamic";
            }
            case 50: {
                return "**All";
            }
            case 0: {
                return "**None";
            }
            case 51: {
                return "**LoadableValue";
            }
            case 52: {
                return "**AnyMember";
            }
            case 53: {
                return "*FieldSpecific";
            }
            case 13: {
                return "*Signature";
            }
            case 17: {
                return "*BootstrapMethod";
            }
        }
        return "tag#" + tag;
    }

    public static String refKindName(int refKind) {
        switch (refKind) {
            case 1: {
                return "getField";
            }
            case 2: {
                return "getStatic";
            }
            case 3: {
                return "putField";
            }
            case 4: {
                return "putStatic";
            }
            case 5: {
                return "invokeVirtual";
            }
            case 6: {
                return "invokeStatic";
            }
            case 7: {
                return "invokeSpecial";
            }
            case 8: {
                return "newInvokeSpecial";
            }
            case 9: {
                return "invokeInterface";
            }
        }
        return "refKind#" + refKind;
    }

    private static boolean verifyTagOrder(byte[] tags) {
        int prev = -1;
        for (byte tag : tags) {
            int next = TAG_ORDER[tag];
            assert (next > 0) : "tag not found: " + tag;
            assert (TAGS_IN_ORDER[next - 1] == tag) : "tag repeated: " + tag + " => " + next + " => " + TAGS_IN_ORDER[next - 1];
            assert (prev < next) : "tags not in order: " + Arrays.toString(tags) + " at " + tag;
            prev = next;
        }
        return true;
    }

    static {
        for (int i = 0; i < TAGS_IN_ORDER.length; ++i) {
            ConstantPool.TAG_ORDER[ConstantPool.TAGS_IN_ORDER[i]] = (byte)(i + 1);
        }
        NUMBER_TAGS = new byte[]{3, 4, 5, 6};
        EXTRA_TAGS = new byte[]{15, 16, 17, 18};
        LOADABLE_VALUE_TAGS = new byte[]{3, 4, 5, 6, 8, 7, 15, 16};
        ANY_MEMBER_TAGS = new byte[]{9, 10, 11};
        FIELD_SPECIFIC_TAGS = new byte[]{3, 4, 5, 6, 8};
        assert (ConstantPool.verifyTagOrder(TAGS_IN_ORDER) && ConstantPool.verifyTagOrder(NUMBER_TAGS) && ConstantPool.verifyTagOrder(EXTRA_TAGS) && ConstantPool.verifyTagOrder(LOADABLE_VALUE_TAGS) && ConstantPool.verifyTagOrder(ANY_MEMBER_TAGS) && ConstantPool.verifyTagOrder(FIELD_SPECIFIC_TAGS));
    }

    public static class IndexGroup {
        private Index[] indexByTag = new Index[19];
        private Index[] indexByTagGroup;
        private int[] untypedFirstIndexByTag;
        private int totalSizeQQ;
        private Index[][] indexByTagAndClass;

        private Index makeTagGroupIndex(byte tagGroupTag, byte[] tagsInGroup) {
            if (this.indexByTagGroup == null) {
                this.indexByTagGroup = new Index[4];
            }
            int which = tagGroupTag - 50;
            assert (this.indexByTagGroup[which] == null);
            int fillp = 0;
            Entry[] cpMap = null;
            for (int pass = 1; pass <= 2; ++pass) {
                this.untypedIndexOf(null);
                for (byte tag : tagsInGroup) {
                    int ixLen;
                    Index ix = this.indexByTag[tag];
                    if (ix == null || (ixLen = ix.cpMap.length) == 0) continue;
                    assert (tagGroupTag != 50 ? fillp < this.untypedFirstIndexByTag[tag] : fillp == this.untypedFirstIndexByTag[tag]);
                    if (cpMap != null) {
                        assert (cpMap[fillp] == null);
                        assert (cpMap[fillp + ixLen - 1] == null);
                        System.arraycopy(ix.cpMap, 0, cpMap, fillp, ixLen);
                    }
                    fillp += ixLen;
                }
                if (cpMap != null) continue;
                assert (pass == 1);
                cpMap = new Entry[fillp];
                fillp = 0;
            }
            this.indexByTagGroup[which] = new Index(ConstantPool.tagName(tagGroupTag), cpMap);
            return this.indexByTagGroup[which];
        }

        public int untypedIndexOf(Entry e) {
            if (this.untypedFirstIndexByTag == null) {
                this.untypedFirstIndexByTag = new int[20];
                int fillp = 0;
                for (int i = 0; i < TAGS_IN_ORDER.length; ++i) {
                    byte tag = TAGS_IN_ORDER[i];
                    Index ix = this.indexByTag[tag];
                    if (ix == null) continue;
                    int ixLen = ix.cpMap.length;
                    this.untypedFirstIndexByTag[tag] = fillp;
                    fillp += ixLen;
                }
                this.untypedFirstIndexByTag[19] = fillp;
            }
            if (e == null) {
                return -1;
            }
            byte tag = e.tag;
            Index ix = this.indexByTag[tag];
            if (ix == null) {
                return -1;
            }
            int idx = ix.findIndexOf(e);
            if (idx >= 0) {
                idx += this.untypedFirstIndexByTag[tag];
            }
            return idx;
        }

        public void initIndexByTag(byte tag, Index ix) {
            assert (this.indexByTag[tag] == null);
            Entry[] cpMap = ix.cpMap;
            for (int i = 0; i < cpMap.length; ++i) {
                assert (cpMap[i].tag == tag);
            }
            if (tag == 1) assert (cpMap.length == 0 || cpMap[0].stringValue().isEmpty());
            this.indexByTag[tag] = ix;
            this.untypedFirstIndexByTag = null;
            this.indexByTagGroup = null;
            if (this.indexByTagAndClass != null) {
                this.indexByTagAndClass[tag] = null;
            }
        }

        public Index getIndexByTag(byte tag) {
            if (tag >= 50) {
                return this.getIndexByTagGroup(tag);
            }
            Index ix = this.indexByTag[tag];
            if (ix == null) {
                this.indexByTag[tag] = ix = new Index(ConstantPool.tagName(tag), new Entry[0]);
            }
            return ix;
        }

        private Index getIndexByTagGroup(byte tag) {
            Index ix;
            if (this.indexByTagGroup != null && (ix = this.indexByTagGroup[tag - 50]) != null) {
                return ix;
            }
            switch (tag) {
                case 50: {
                    return this.makeTagGroupIndex((byte)50, TAGS_IN_ORDER);
                }
                case 51: {
                    return this.makeTagGroupIndex((byte)51, LOADABLE_VALUE_TAGS);
                }
                case 52: {
                    return this.makeTagGroupIndex((byte)52, ANY_MEMBER_TAGS);
                }
                case 53: {
                    return null;
                }
            }
            throw new AssertionError((Object)("bad tag group " + tag));
        }

        public Index getMemberIndex(byte tag, ClassEntry classRef) {
            if (classRef == null) {
                throw new RuntimeException("missing class reference for " + ConstantPool.tagName(tag));
            }
            if (this.indexByTagAndClass == null) {
                this.indexByTagAndClass = new Index[19][];
            }
            Index allClasses = this.getIndexByTag((byte)7);
            Index[] perClassIndexes = this.indexByTagAndClass[tag];
            if (perClassIndexes == null) {
                int i;
                Index allMembers = this.getIndexByTag(tag);
                int[] whichClasses = new int[allMembers.size()];
                for (i = 0; i < whichClasses.length; ++i) {
                    int whichClass;
                    MemberEntry e = (MemberEntry)allMembers.get(i);
                    whichClasses[i] = whichClass = allClasses.indexOf(e.classRef);
                }
                perClassIndexes = ConstantPool.partition(allMembers, whichClasses);
                for (i = 0; i < perClassIndexes.length; ++i) {
                    assert (perClassIndexes[i] == null || perClassIndexes[i].assertIsSorted());
                }
                this.indexByTagAndClass[tag] = perClassIndexes;
            }
            int whichClass = allClasses.indexOf(classRef);
            return perClassIndexes[whichClass];
        }

        public int getOverloadingIndex(MemberEntry methodRef) {
            Index ix = this.getMemberIndex(methodRef.tag, methodRef.classRef);
            Utf8Entry nameRef = methodRef.descRef.nameRef;
            int ord = 0;
            for (int i = 0; i < ix.cpMap.length; ++i) {
                MemberEntry e = (MemberEntry)ix.cpMap[i];
                if (e.equals(methodRef)) {
                    return ord;
                }
                if (!e.descRef.nameRef.equals(nameRef)) continue;
                ++ord;
            }
            throw new RuntimeException("should not reach here");
        }

        public MemberEntry getOverloadingForIndex(byte tag, ClassEntry classRef, String name, int which) {
            assert (name.equals(name.intern()));
            Index ix = this.getMemberIndex(tag, classRef);
            int ord = 0;
            for (int i = 0; i < ix.cpMap.length; ++i) {
                MemberEntry e = (MemberEntry)ix.cpMap[i];
                if (!e.descRef.nameRef.stringValue().equals(name)) continue;
                if (ord == which) {
                    return e;
                }
                ++ord;
            }
            throw new RuntimeException("should not reach here");
        }

        public boolean haveNumbers() {
            for (byte tag : NUMBER_TAGS) {
                if (this.getIndexByTag(tag).size() <= 0) continue;
                return true;
            }
            return false;
        }

        public boolean haveExtraTags() {
            for (byte tag : EXTRA_TAGS) {
                if (this.getIndexByTag(tag).size() <= 0) continue;
                return true;
            }
            return false;
        }
    }

    public static final class Index
    extends AbstractList<Entry> {
        protected String debugName;
        protected Entry[] cpMap;
        protected boolean flattenSigs;
        protected Entry[] indexKey;
        protected int[] indexValue;

        protected Entry[] getMap() {
            return this.cpMap;
        }

        protected Index(String debugName) {
            this.debugName = debugName;
        }

        protected Index(String debugName, Entry[] cpMap) {
            this(debugName);
            this.setMap(cpMap);
        }

        protected void setMap(Entry[] cpMap) {
            this.clearIndex();
            this.cpMap = cpMap;
        }

        protected Index(String debugName, Collection<Entry> cpMapList) {
            this(debugName);
            this.setMap(cpMapList);
        }

        protected void setMap(Collection<Entry> cpMapList) {
            this.cpMap = new Entry[cpMapList.size()];
            cpMapList.toArray(this.cpMap);
            this.setMap(this.cpMap);
        }

        @Override
        public int size() {
            return this.cpMap.length;
        }

        @Override
        public Entry get(int i) {
            return this.cpMap[i];
        }

        public Entry getEntry(int i) {
            return this.cpMap[i];
        }

        private int findIndexOf(Entry e) {
            int probe;
            if (this.indexKey == null) {
                this.initializeIndex();
            }
            if (this.indexKey[probe = this.findIndexLocation(e)] != e) {
                if (this.flattenSigs && e.tag == 13) {
                    SignatureEntry se = (SignatureEntry)e;
                    return this.findIndexOf(se.asUtf8Entry());
                }
                return -1;
            }
            int index = this.indexValue[probe];
            assert (e.equals(this.cpMap[index]));
            return index;
        }

        public boolean contains(Entry e) {
            return this.findIndexOf(e) >= 0;
        }

        public int indexOf(Entry e) {
            int index = this.findIndexOf(e);
            if (index < 0 && ConstantPool.verbose() > 0) {
                System.out.println("not found: " + e);
                System.out.println("       in: " + this.dumpString());
                Thread.dumpStack();
            }
            assert (index >= 0);
            return index;
        }

        public int lastIndexOf(Entry e) {
            return this.indexOf(e);
        }

        public boolean assertIsSorted() {
            for (int i = 1; i < this.cpMap.length; ++i) {
                if (this.cpMap[i - 1].compareTo(this.cpMap[i]) <= 0) continue;
                System.out.println("Not sorted at " + (i - 1) + "/" + i + ": " + this.dumpString());
                return false;
            }
            return true;
        }

        protected void clearIndex() {
            this.indexKey = null;
            this.indexValue = null;
        }

        private int findIndexLocation(Entry e) {
            int size = this.indexKey.length;
            int hash = e.hashCode();
            int probe = hash & size - 1;
            int stride = (hash >>> 8 | 1) & size - 1;
            Entry e1;
            while ((e1 = this.indexKey[probe]) != e && e1 != null) {
                if ((probe += stride) < size) continue;
                probe -= size;
            }
            return probe;
        }

        private void initializeIndex() {
            int hsize;
            if (ConstantPool.verbose() > 2) {
                System.out.println("initialize Index " + this.debugName + " [" + this.size() + "]");
            }
            int hsize0 = (int)((double)(this.cpMap.length + 10) * 1.5);
            for (hsize = 1; hsize < hsize0; hsize <<= 1) {
            }
            this.indexKey = new Entry[hsize];
            this.indexValue = new int[hsize];
            for (int i = 0; i < this.cpMap.length; ++i) {
                Entry e = this.cpMap[i];
                if (e == null) continue;
                int probe = this.findIndexLocation(e);
                assert (this.indexKey[probe] == null);
                this.indexKey[probe] = e;
                this.indexValue[probe] = i;
            }
        }

        public Entry[] toArray(Entry[] a) {
            int sz = this.size();
            if (a.length < sz) {
                return super.toArray(a);
            }
            System.arraycopy(this.cpMap, 0, a, 0, sz);
            if (a.length > sz) {
                a[sz] = null;
            }
            return a;
        }

        public Entry[] toArray() {
            return this.toArray(new Entry[this.size()]);
        }

        public Object clone() {
            return new Index(this.debugName, (Entry[])this.cpMap.clone());
        }

        @Override
        public String toString() {
            return "Index " + this.debugName + " [" + this.size() + "]";
        }

        public String dumpString() {
            String s = this.toString();
            s = s + " {\n";
            for (int i = 0; i < this.cpMap.length; ++i) {
                s = s + "    " + i + ": " + this.cpMap[i] + "\n";
            }
            s = s + "}";
            return s;
        }
    }

    public static class BootstrapMethodEntry
    extends Entry {
        final MethodHandleEntry bsmRef;
        final Entry[] argRefs;

        @Override
        public Entry getRef(int i) {
            if (i == 0) {
                return this.bsmRef;
            }
            if (i - 1 < this.argRefs.length) {
                return this.argRefs[i - 1];
            }
            return null;
        }

        @Override
        protected int computeValueHash() {
            int hc2 = this.bsmRef.hashCode();
            return Arrays.hashCode(this.argRefs) + (hc2 << 8) ^ hc2;
        }

        BootstrapMethodEntry(MethodHandleEntry bsmRef, Entry[] argRefs) {
            super((byte)17);
            this.bsmRef = bsmRef;
            this.argRefs = (Entry[])argRefs.clone();
            this.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || o.getClass() != BootstrapMethodEntry.class) {
                return false;
            }
            BootstrapMethodEntry that = (BootstrapMethodEntry)o;
            return this.bsmRef.eq(that.bsmRef) && Arrays.equals(this.argRefs, that.argRefs);
        }

        @Override
        public int compareTo(Object o) {
            int x = this.superCompareTo(o);
            if (x == 0) {
                BootstrapMethodEntry that = (BootstrapMethodEntry)o;
                if (Utils.SORT_BSS_BSM_MAJOR) {
                    x = this.bsmRef.compareTo(that.bsmRef);
                }
                if (x == 0) {
                    x = BootstrapMethodEntry.compareArgArrays(this.argRefs, that.argRefs);
                }
                if (x == 0) {
                    x = this.bsmRef.compareTo(that.bsmRef);
                }
            }
            return x;
        }

        @Override
        public String stringValue() {
            return BootstrapMethodEntry.stringValueOf(this.bsmRef, this.argRefs);
        }

        static String stringValueOf(MethodHandleEntry bsmRef, Entry[] argRefs) {
            StringBuilder sb = new StringBuilder(bsmRef.stringValue());
            int nextSep = 60;
            boolean didOne = false;
            for (Entry argRef : argRefs) {
                sb.append((char)nextSep).append(argRef.stringValue());
                nextSep = 59;
            }
            if (nextSep == 60) {
                sb.append((char)nextSep);
            }
            sb.append('>');
            return sb.toString();
        }

        static int compareArgArrays(Entry[] a1, Entry[] a2) {
            int x = a1.length - a2.length;
            if (x != 0) {
                return x;
            }
            for (int i = 0; i < a1.length && (x = a1[i].compareTo(a2[i])) == 0; ++i) {
            }
            return x;
        }
    }

    public static class InvokeDynamicEntry
    extends Entry {
        final BootstrapMethodEntry bssRef;
        final DescriptorEntry descRef;

        @Override
        public Entry getRef(int i) {
            if (i == 0) {
                return this.bssRef;
            }
            if (i == 1) {
                return this.descRef;
            }
            return null;
        }

        @Override
        protected int computeValueHash() {
            int hc2 = this.descRef.hashCode();
            return this.bssRef.hashCode() + (hc2 << 8) ^ hc2;
        }

        InvokeDynamicEntry(BootstrapMethodEntry bssRef, DescriptorEntry descRef) {
            super((byte)18);
            this.bssRef = bssRef;
            this.descRef = descRef;
            this.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || o.getClass() != InvokeDynamicEntry.class) {
                return false;
            }
            InvokeDynamicEntry that = (InvokeDynamicEntry)o;
            return this.bssRef.eq(that.bssRef) && this.descRef.eq(that.descRef);
        }

        @Override
        public int compareTo(Object o) {
            int x = this.superCompareTo(o);
            if (x == 0) {
                InvokeDynamicEntry that = (InvokeDynamicEntry)o;
                if (Utils.SORT_INDY_BSS_MAJOR) {
                    x = this.bssRef.compareTo(that.bssRef);
                }
                if (x == 0) {
                    x = this.descRef.compareTo(that.descRef);
                }
                if (x == 0) {
                    x = this.bssRef.compareTo(that.bssRef);
                }
            }
            return x;
        }

        @Override
        public String stringValue() {
            return InvokeDynamicEntry.stringValueOf(this.bssRef, this.descRef);
        }

        static String stringValueOf(BootstrapMethodEntry bssRef, DescriptorEntry descRef) {
            return "Indy:" + bssRef.stringValue() + "." + descRef.stringValue();
        }
    }

    public static class MethodTypeEntry
    extends Entry {
        final SignatureEntry typeRef;

        @Override
        public Entry getRef(int i) {
            return i == 0 ? this.typeRef : null;
        }

        @Override
        protected int computeValueHash() {
            return this.typeRef.hashCode() + this.tag;
        }

        MethodTypeEntry(SignatureEntry typeRef) {
            super((byte)16);
            this.typeRef = typeRef;
            this.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || o.getClass() != MethodTypeEntry.class) {
                return false;
            }
            MethodTypeEntry that = (MethodTypeEntry)o;
            return this.typeRef.eq(that.typeRef);
        }

        @Override
        public int compareTo(Object o) {
            int x = this.superCompareTo(o);
            if (x == 0) {
                MethodTypeEntry that = (MethodTypeEntry)o;
                x = this.typeRef.compareTo(that.typeRef);
            }
            return x;
        }

        @Override
        public String stringValue() {
            return this.typeRef.stringValue();
        }
    }

    public static class MethodHandleEntry
    extends Entry {
        final int refKind;
        final MemberEntry memRef;

        @Override
        public Entry getRef(int i) {
            return i == 0 ? this.memRef : null;
        }

        @Override
        protected int computeValueHash() {
            int hc2 = this.refKind;
            return this.memRef.hashCode() + (hc2 << 8) ^ hc2;
        }

        MethodHandleEntry(byte refKind, MemberEntry memRef) {
            super((byte)15);
            assert (ConstantPool.isRefKind(refKind));
            this.refKind = refKind;
            this.memRef = memRef;
            this.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || o.getClass() != MethodHandleEntry.class) {
                return false;
            }
            MethodHandleEntry that = (MethodHandleEntry)o;
            return this.refKind == that.refKind && this.memRef.eq(that.memRef);
        }

        @Override
        public int compareTo(Object o) {
            int x = this.superCompareTo(o);
            if (x == 0) {
                MethodHandleEntry that = (MethodHandleEntry)o;
                if (Utils.SORT_HANDLES_KIND_MAJOR) {
                    x = this.refKind - that.refKind;
                }
                if (x == 0) {
                    x = this.memRef.compareTo(that.memRef);
                }
                if (x == 0) {
                    x = this.refKind - that.refKind;
                }
            }
            return x;
        }

        public static String stringValueOf(int refKind, MemberEntry memRef) {
            return ConstantPool.refKindName(refKind) + ":" + memRef.stringValue();
        }

        @Override
        public String stringValue() {
            return MethodHandleEntry.stringValueOf(this.refKind, this.memRef);
        }
    }

    public static class SignatureEntry
    extends Entry {
        final Utf8Entry formRef;
        final ClassEntry[] classRefs;
        String value;
        Utf8Entry asUtf8Entry;

        @Override
        public Entry getRef(int i) {
            if (i == 0) {
                return this.formRef;
            }
            return i - 1 < this.classRefs.length ? this.classRefs[i - 1] : null;
        }

        SignatureEntry(String value) {
            super((byte)13);
            this.value = value = value.intern();
            String[] parts = ConstantPool.structureSignature(value);
            this.formRef = ConstantPool.getUtf8Entry(parts[0]);
            this.classRefs = new ClassEntry[parts.length - 1];
            for (int i = 1; i < parts.length; ++i) {
                this.classRefs[i - 1] = ConstantPool.getClassEntry(parts[i]);
            }
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            this.stringValue();
            return this.value.hashCode() + this.tag;
        }

        public Utf8Entry asUtf8Entry() {
            if (this.asUtf8Entry == null) {
                this.asUtf8Entry = ConstantPool.getUtf8Entry(this.stringValue());
            }
            return this.asUtf8Entry;
        }

        @Override
        public boolean equals(Object o) {
            return o != null && o.getClass() == SignatureEntry.class && ((SignatureEntry)o).value.equals(this.value);
        }

        @Override
        public int compareTo(Object o) {
            int x = this.superCompareTo(o);
            if (x == 0) {
                SignatureEntry that = (SignatureEntry)o;
                x = ConstantPool.compareSignatures(this.value, that.value);
            }
            return x;
        }

        @Override
        public String stringValue() {
            if (this.value == null) {
                this.value = SignatureEntry.stringValueOf(this.formRef, this.classRefs);
            }
            return this.value;
        }

        static String stringValueOf(Utf8Entry formRef, ClassEntry[] classRefs) {
            String[] parts = new String[1 + classRefs.length];
            parts[0] = formRef.stringValue();
            for (int i = 1; i < parts.length; ++i) {
                parts[i] = classRefs[i - 1].stringValue();
            }
            return ConstantPool.flattenSignature(parts).intern();
        }

        public int computeSize(boolean countDoublesTwice) {
            String form = this.formRef.stringValue();
            int min = 0;
            int max = 1;
            if (this.isMethod()) {
                min = 1;
                max = form.indexOf(41);
            }
            int size = 0;
            block5: for (int i = min; i < max; ++i) {
                switch (form.charAt(i)) {
                    case 'D': 
                    case 'J': {
                        if (!countDoublesTwice) break;
                        ++size;
                        break;
                    }
                    case '[': {
                        while (form.charAt(i) == '[') {
                            ++i;
                        }
                        break;
                    }
                    case ';': {
                        continue block5;
                    }
                    default: {
                        assert (0 <= "BSCIJFDZLV([".indexOf(form.charAt(i)));
                        break;
                    }
                }
                ++size;
            }
            return size;
        }

        public boolean isMethod() {
            return this.formRef.stringValue().charAt(0) == '(';
        }

        public byte getLiteralTag() {
            switch (this.formRef.stringValue().charAt(0)) {
                case 'I': {
                    return 3;
                }
                case 'J': {
                    return 5;
                }
                case 'F': {
                    return 4;
                }
                case 'D': {
                    return 6;
                }
                case 'B': 
                case 'C': 
                case 'S': 
                case 'Z': {
                    return 3;
                }
                case 'L': {
                    return 8;
                }
            }
            assert (false);
            return 0;
        }

        public String prettyString() {
            int i;
            String s;
            if (this.isMethod()) {
                s = this.formRef.stringValue();
                s = s.substring(0, 1 + s.indexOf(41));
            } else {
                s = "/" + this.formRef.stringValue();
            }
            while ((i = s.indexOf(59)) >= 0) {
                s = s.substring(0, i) + s.substring(i + 1);
            }
            return s;
        }
    }

    public static class MemberEntry
    extends Entry {
        final ClassEntry classRef;
        final DescriptorEntry descRef;

        @Override
        public Entry getRef(int i) {
            if (i == 0) {
                return this.classRef;
            }
            if (i == 1) {
                return this.descRef;
            }
            return null;
        }

        @Override
        protected int computeValueHash() {
            int hc2 = this.descRef.hashCode();
            return this.classRef.hashCode() + (hc2 << 8) ^ hc2;
        }

        MemberEntry(byte tag, ClassEntry classRef, DescriptorEntry descRef) {
            super(tag);
            assert (ConstantPool.isMemberTag(tag));
            this.classRef = classRef;
            this.descRef = descRef;
            this.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || o.getClass() != MemberEntry.class) {
                return false;
            }
            MemberEntry that = (MemberEntry)o;
            return this.classRef.eq(that.classRef) && this.descRef.eq(that.descRef);
        }

        @Override
        public int compareTo(Object o) {
            int x = this.superCompareTo(o);
            if (x == 0) {
                MemberEntry that = (MemberEntry)o;
                if (Utils.SORT_MEMBERS_DESCR_MAJOR) {
                    x = this.descRef.compareTo(that.descRef);
                }
                if (x == 0) {
                    x = this.classRef.compareTo(that.classRef);
                }
                if (x == 0) {
                    x = this.descRef.compareTo(that.descRef);
                }
            }
            return x;
        }

        @Override
        public String stringValue() {
            return MemberEntry.stringValueOf(this.tag, this.classRef, this.descRef);
        }

        static String stringValueOf(byte tag, ClassEntry classRef, DescriptorEntry descRef) {
            String pfx;
            assert (ConstantPool.isMemberTag(tag));
            switch (tag) {
                case 9: {
                    pfx = "Field:";
                    break;
                }
                case 10: {
                    pfx = "Method:";
                    break;
                }
                case 11: {
                    pfx = "IMethod:";
                    break;
                }
                default: {
                    pfx = tag + "???";
                }
            }
            return pfx + ConstantPool.qualifiedStringValue(classRef, descRef);
        }

        public boolean isMethod() {
            return this.descRef.isMethod();
        }
    }

    public static class DescriptorEntry
    extends Entry {
        final Utf8Entry nameRef;
        final SignatureEntry typeRef;

        @Override
        public Entry getRef(int i) {
            if (i == 0) {
                return this.nameRef;
            }
            if (i == 1) {
                return this.typeRef;
            }
            return null;
        }

        DescriptorEntry(Entry nameRef, Entry typeRef) {
            super((byte)12);
            if (typeRef instanceof Utf8Entry) {
                typeRef = ConstantPool.getSignatureEntry(typeRef.stringValue());
            }
            this.nameRef = (Utf8Entry)nameRef;
            this.typeRef = (SignatureEntry)typeRef;
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            int hc2 = this.typeRef.hashCode();
            return this.nameRef.hashCode() + (hc2 << 8) ^ hc2;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || o.getClass() != DescriptorEntry.class) {
                return false;
            }
            DescriptorEntry that = (DescriptorEntry)o;
            return this.nameRef.eq(that.nameRef) && this.typeRef.eq(that.typeRef);
        }

        @Override
        public int compareTo(Object o) {
            int x = this.superCompareTo(o);
            if (x == 0) {
                DescriptorEntry that = (DescriptorEntry)o;
                x = this.typeRef.compareTo(that.typeRef);
                if (x == 0) {
                    x = this.nameRef.compareTo(that.nameRef);
                }
            }
            return x;
        }

        @Override
        public String stringValue() {
            return DescriptorEntry.stringValueOf(this.nameRef, this.typeRef);
        }

        static String stringValueOf(Entry nameRef, Entry typeRef) {
            return ConstantPool.qualifiedStringValue(typeRef, nameRef);
        }

        public String prettyString() {
            return this.nameRef.stringValue() + this.typeRef.prettyString();
        }

        public boolean isMethod() {
            return this.typeRef.isMethod();
        }

        public byte getLiteralTag() {
            return this.typeRef.getLiteralTag();
        }
    }

    public static class ClassEntry
    extends Entry {
        final Utf8Entry ref;

        @Override
        public Entry getRef(int i) {
            return i == 0 ? this.ref : null;
        }

        @Override
        protected int computeValueHash() {
            return this.ref.hashCode() + this.tag;
        }

        ClassEntry(Entry ref) {
            super((byte)7);
            this.ref = (Utf8Entry)ref;
            this.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o != null && o.getClass() == ClassEntry.class && ((ClassEntry)o).ref.eq(this.ref);
        }

        @Override
        public int compareTo(Object o) {
            int x = this.superCompareTo(o);
            if (x == 0) {
                x = this.ref.compareTo(((ClassEntry)o).ref);
            }
            return x;
        }

        @Override
        public String stringValue() {
            return this.ref.stringValue();
        }
    }

    public static class StringEntry
    extends LiteralEntry {
        final Utf8Entry ref;

        @Override
        public Entry getRef(int i) {
            return i == 0 ? this.ref : null;
        }

        StringEntry(Entry ref) {
            super((byte)8);
            this.ref = (Utf8Entry)ref;
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            return this.ref.hashCode() + this.tag;
        }

        @Override
        public boolean equals(Object o) {
            return o != null && o.getClass() == StringEntry.class && ((StringEntry)o).ref.eq(this.ref);
        }

        @Override
        public int compareTo(Object o) {
            int x = this.superCompareTo(o);
            if (x == 0) {
                x = this.ref.compareTo(((StringEntry)o).ref);
            }
            return x;
        }

        @Override
        public Comparable<?> literalValue() {
            return this.ref.stringValue();
        }

        @Override
        public String stringValue() {
            return this.ref.stringValue();
        }
    }

    public static class NumberEntry
    extends LiteralEntry {
        final Number value;

        NumberEntry(Number value) {
            super(ConstantPool.numberTagOf(value));
            this.value = value;
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o != null && o.getClass() == NumberEntry.class && ((NumberEntry)o).value.equals(this.value);
        }

        @Override
        public int compareTo(Object o) {
            int x = this.superCompareTo(o);
            if (x == 0) {
                Comparable compValue = (Comparable)((Object)this.value);
                x = compValue.compareTo(((NumberEntry)o).value);
            }
            return x;
        }

        public Number numberValue() {
            return this.value;
        }

        @Override
        public Comparable<?> literalValue() {
            return (Comparable)((Object)this.value);
        }

        @Override
        public String stringValue() {
            return this.value.toString();
        }
    }

    public static abstract class LiteralEntry
    extends Entry {
        protected LiteralEntry(byte tag) {
            super(tag);
        }

        public abstract Comparable<?> literalValue();
    }

    public static class Utf8Entry
    extends Entry {
        final String value;

        Utf8Entry(String value) {
            super((byte)1);
            this.value = value.intern();
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o != null && o.getClass() == Utf8Entry.class && ((Utf8Entry)o).value.equals(this.value);
        }

        @Override
        public int compareTo(Object o) {
            int x = this.superCompareTo(o);
            if (x == 0) {
                x = this.value.compareTo(((Utf8Entry)o).value);
            }
            return x;
        }

        @Override
        public String stringValue() {
            return this.value;
        }
    }

    public static abstract class Entry
    implements Comparable<Object> {
        protected final byte tag;
        protected int valueHash;

        protected Entry(byte tag) {
            this.tag = tag;
        }

        public final byte getTag() {
            return this.tag;
        }

        public final boolean tagEquals(int tag) {
            return this.getTag() == tag;
        }

        public Entry getRef(int i) {
            return null;
        }

        public boolean eq(Entry that) {
            assert (that != null);
            return this == that || this.equals(that);
        }

        public abstract boolean equals(Object var1);

        public final int hashCode() {
            if (this.valueHash == 0) {
                this.valueHash = this.computeValueHash();
                if (this.valueHash == 0) {
                    this.valueHash = 1;
                }
            }
            return this.valueHash;
        }

        protected abstract int computeValueHash();

        @Override
        public abstract int compareTo(Object var1);

        protected int superCompareTo(Object o) {
            Entry that = (Entry)o;
            if (this.tag != that.tag) {
                return TAG_ORDER[this.tag] - TAG_ORDER[that.tag];
            }
            return 0;
        }

        public final boolean isDoubleWord() {
            return this.tag == 6 || this.tag == 5;
        }

        public final boolean tagMatches(int matchTag) {
            byte[] allowedTags;
            if (this.tag == matchTag) {
                return true;
            }
            switch (matchTag) {
                case 50: {
                    return true;
                }
                case 13: {
                    return this.tag == 1;
                }
                case 51: {
                    allowedTags = LOADABLE_VALUE_TAGS;
                    break;
                }
                case 52: {
                    allowedTags = ANY_MEMBER_TAGS;
                    break;
                }
                case 53: {
                    allowedTags = FIELD_SPECIFIC_TAGS;
                    break;
                }
                default: {
                    return false;
                }
            }
            for (byte b : allowedTags) {
                if (b != this.tag) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            String valuePrint = this.stringValue();
            if (ConstantPool.verbose() > 4) {
                if (this.valueHash != 0) {
                    valuePrint = valuePrint + " hash=" + this.valueHash;
                }
                valuePrint = valuePrint + " id=" + System.identityHashCode(this);
            }
            return ConstantPool.tagName(this.tag) + "=" + valuePrint;
        }

        public abstract String stringValue();
    }
}

