/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.rrd4j.graph.ImageWorker;
import org.rrd4j.graph.RrdGraphDef;

class BufferedImageWorker
extends ImageWorker {
    private BufferedImage img;
    private int imgWidth;
    private int imgHeight;
    private AffineTransform initialAffineTransform;
    private final ImageWriter writer;
    private final ImageWriteParam iwp;

    public static Builder getBuilder() {
        return new Builder();
    }

    private BufferedImageWorker(Builder builder) {
        this.imgHeight = builder.height;
        this.imgWidth = builder.width;
        this.writer = builder.writer;
        this.iwp = builder.imageWriteParam;
        this.resize(this.imgWidth, this.imgHeight);
    }

    BufferedImageWorker(int width, int height) {
        this.imgHeight = height;
        this.imgWidth = width;
        this.writer = ImageIO.getImageWritersByFormatName("png").next();
        this.iwp = this.writer.getDefaultWriteParam();
        this.resize(this.imgWidth, this.imgHeight);
    }

    @Override
    void resize(int width, int height) {
        this.imgWidth = width;
        this.imgHeight = height;
        this.img = new BufferedImage(width, height, 2);
        Graphics2D g2d = this.img.createGraphics();
        this.setG2d(g2d);
        this.initialAffineTransform = g2d.getTransform();
        this.setAntiAliasing(false);
        this.setTextAntiAliasing(false);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    @Override
    protected void reset(Graphics2D g2d) {
        g2d.setTransform(this.initialAffineTransform);
        g2d.setClip(0, 0, this.imgWidth, this.imgHeight);
    }

    @Override
    void makeImage(OutputStream stream) throws IOException {
        BufferedImage outputImage = this.img;
        ImageWriterSpi imgProvider = this.writer.getOriginatingProvider();
        this.img.coerceData(false);
        if (!imgProvider.canEncodeImage(outputImage) || "image/jpeg".equalsIgnoreCase(imgProvider.getMIMETypes()[0])) {
            int w = this.img.getWidth();
            int h = this.img.getHeight();
            outputImage = new BufferedImage(w, h, 1);
            outputImage.getGraphics().drawImage(this.img, 0, 0, w, h, null);
            if (!imgProvider.canEncodeImage(outputImage)) {
                throw new IllegalArgumentException("Invalid image type");
            }
        }
        if (!imgProvider.canEncodeImage(outputImage)) {
            throw new IllegalArgumentException("Invalid image type");
        }
        try (ImageOutputStream imageStream = ImageIO.createImageOutputStream(stream);){
            this.writer.setOutput(imageStream);
            this.writer.write(null, new IIOImage(outputImage, null, null), this.iwp);
            imageStream.flush();
        }
        catch (IOException e) {
            this.writer.abort();
            throw e;
        }
        finally {
            this.writer.dispose();
        }
    }

    static class Builder {
        private int width = 1;
        private int height = 1;
        private RrdGraphDef gdef;
        private ImageWriter writer;
        private ImageWriteParam imageWriteParam;

        Builder() {
        }

        BufferedImageWorker build() {
            return new BufferedImageWorker(this);
        }

        private ImageWriteParam getImageParams() {
            ImageWriteParam iwp = this.writer.getDefaultWriteParam();
            ImageWriterSpi imgProvider = this.writer.getOriginatingProvider();
            if (!imgProvider.isFormatLossless()) {
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality(this.gdef.imageQuality);
            }
            if (iwp.canWriteProgressive()) {
                iwp.setProgressiveMode(this.gdef.interlaced ? 1 : 0);
            }
            return iwp;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder setGdef(RrdGraphDef gdef) {
            this.gdef = gdef;
            if (this.writer == null) {
                this.writer = ImageIO.getImageWritersByFormatName(gdef.imageFormat).next();
            }
            if (this.imageWriteParam == null) {
                this.imageWriteParam = this.getImageParams();
            }
            return this;
        }

        public Builder setWriter(ImageWriter writer) {
            this.writer = writer;
            if (this.imageWriteParam == null) {
                this.imageWriteParam = this.getImageParams();
            }
            return this;
        }

        public Builder setImageWriteParam(ImageWriteParam imageWriteParam) {
            this.imageWriteParam = imageWriteParam;
            return this;
        }
    }
}

