/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import java.io.UnsupportedEncodingException;

public final class BufferTools {
    protected static final String defaultCharsetName = "ISO-8859-1";

    private BufferTools() {
    }

    public static String byteBufferToStringIgnoringEncodingIssues(byte[] bytes, int offset, int length) {
        try {
            return BufferTools.byteBufferToString(bytes, offset, length, defaultCharsetName);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String byteBufferToString(byte[] bytes, int offset, int length) throws UnsupportedEncodingException {
        return BufferTools.byteBufferToString(bytes, offset, length, defaultCharsetName);
    }

    public static String byteBufferToString(byte[] bytes, int offset, int length, String charsetName) throws UnsupportedEncodingException {
        if (length < 1) {
            return "";
        }
        return new String(bytes, offset, length, charsetName);
    }

    public static byte[] stringToByteBufferIgnoringEncodingIssues(String s, int offset, int length) {
        try {
            return BufferTools.stringToByteBuffer(s, offset, length);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] stringToByteBuffer(String s, int offset, int length) throws UnsupportedEncodingException {
        return BufferTools.stringToByteBuffer(s, offset, length, defaultCharsetName);
    }

    public static byte[] stringToByteBuffer(String s, int offset, int length, String charsetName) throws UnsupportedEncodingException {
        String stringToCopy = s.substring(offset, offset + length);
        return stringToCopy.getBytes(charsetName);
    }

    public static void stringIntoByteBuffer(String s, int offset, int length, byte[] bytes, int destOffset) throws UnsupportedEncodingException {
        BufferTools.stringIntoByteBuffer(s, offset, length, bytes, destOffset, defaultCharsetName);
    }

    public static void stringIntoByteBuffer(String s, int offset, int length, byte[] bytes, int destOffset, String charsetName) throws UnsupportedEncodingException {
        String stringToCopy = s.substring(offset, offset + length);
        byte[] srcBytes = stringToCopy.getBytes(charsetName);
        if (srcBytes.length > 0) {
            System.arraycopy(srcBytes, 0, bytes, destOffset, srcBytes.length);
        }
    }

    public static String trimStringRight(String s) {
        char endChar;
        int endPosition;
        for (endPosition = s.length() - 1; endPosition >= 0 && (endChar = s.charAt(endPosition)) <= ' '; --endPosition) {
        }
        if (endPosition == s.length() - 1) {
            return s;
        }
        if (endPosition < 0) {
            return "";
        }
        return s.substring(0, endPosition + 1);
    }

    public static String padStringRight(String s, int length, char padWith) {
        if (s.length() >= length) {
            return s;
        }
        StringBuilder stringBuffer = new StringBuilder(s);
        while (stringBuffer.length() < length) {
            stringBuffer.append(padWith);
        }
        return stringBuffer.toString();
    }

    public static boolean checkBit(byte b, int bitPosition) {
        return (b & 1 << bitPosition) != 0;
    }

    public static byte setBit(byte b, int bitPosition, boolean value) {
        byte newByte = value ? (byte)(b | 1 << bitPosition) : (byte)(b & ~(1 << bitPosition));
        return newByte;
    }

    public static int shiftByte(byte c, int places) {
        int i = c & 0xFF;
        if (places < 0) {
            return i << -places;
        }
        if (places > 0) {
            return i >> places;
        }
        return i;
    }

    public static int unpackInteger(byte b1, byte b2, byte b3, byte b4) {
        int value = b4 & 0xFF;
        value += BufferTools.shiftByte(b3, -8);
        value += BufferTools.shiftByte(b2, -16);
        return value += BufferTools.shiftByte(b1, -24);
    }

    public static byte[] packInteger(int i) {
        byte[] bytes = new byte[4];
        bytes[3] = (byte)(i & 0xFF);
        bytes[2] = (byte)(i >> 8 & 0xFF);
        bytes[1] = (byte)(i >> 16 & 0xFF);
        bytes[0] = (byte)(i >> 24 & 0xFF);
        return bytes;
    }

    public static int unpackSynchsafeInteger(byte b1, byte b2, byte b3, byte b4) {
        int value = b4 & 0x7F;
        value += BufferTools.shiftByte((byte)(b3 & 0x7F), -7);
        value += BufferTools.shiftByte((byte)(b2 & 0x7F), -14);
        return value += BufferTools.shiftByte((byte)(b1 & 0x7F), -21);
    }

    public static byte[] packSynchsafeInteger(int i) {
        byte[] bytes = new byte[4];
        BufferTools.packSynchsafeInteger(i, bytes, 0);
        return bytes;
    }

    public static void packSynchsafeInteger(int i, byte[] bytes, int offset) {
        bytes[offset + 3] = (byte)(i & 0x7F);
        bytes[offset + 2] = (byte)(i >> 7 & 0x7F);
        bytes[offset + 1] = (byte)(i >> 14 & 0x7F);
        bytes[offset + 0] = (byte)(i >> 21 & 0x7F);
    }

    public static byte[] copyBuffer(byte[] bytes, int offset, int length) {
        byte[] copy = new byte[length];
        if (length > 0) {
            System.arraycopy(bytes, offset, copy, 0, length);
        }
        return copy;
    }

    public static void copyIntoByteBuffer(byte[] bytes, int offset, int length, byte[] destBuffer, int destOffset) {
        if (length > 0) {
            System.arraycopy(bytes, offset, destBuffer, destOffset, length);
        }
    }

    public static int sizeUnsynchronisationWouldAdd(byte[] bytes) {
        int count = 0;
        for (int i = 0; i < bytes.length - 1; ++i) {
            if (bytes[i] != -1 || (bytes[i + 1] & 0xFFFFFFE0) != -32 && bytes[i + 1] != 0) continue;
            ++count;
        }
        if (bytes.length > 0 && bytes[bytes.length - 1] == -1) {
            ++count;
        }
        return count;
    }

    public static byte[] unsynchroniseBuffer(byte[] bytes) {
        int count = BufferTools.sizeUnsynchronisationWouldAdd(bytes);
        if (count == 0) {
            return bytes;
        }
        byte[] newBuffer = new byte[bytes.length + count];
        int j = 0;
        for (int i = 0; i < bytes.length - 1; ++i) {
            newBuffer[j++] = bytes[i];
            if (bytes[i] != -1 || (bytes[i + 1] & 0xFFFFFFE0) != -32 && bytes[i + 1] != 0) continue;
            newBuffer[j++] = 0;
        }
        newBuffer[j++] = bytes[bytes.length - 1];
        if (bytes[bytes.length - 1] == -1) {
            newBuffer[j++] = 0;
        }
        return newBuffer;
    }

    public static int sizeSynchronisationWouldSubtract(byte[] bytes) {
        int count = 0;
        for (int i = 0; i < bytes.length - 2; ++i) {
            if (bytes[i] != -1 || bytes[i + 1] != 0 || (bytes[i + 2] & 0xFFFFFFE0) != -32 && bytes[i + 2] != 0) continue;
            ++count;
        }
        if (bytes.length > 1 && bytes[bytes.length - 2] == -1 && bytes[bytes.length - 1] == 0) {
            ++count;
        }
        return count;
    }

    public static byte[] synchroniseBuffer(byte[] bytes) {
        int count = BufferTools.sizeSynchronisationWouldSubtract(bytes);
        if (count == 0) {
            return bytes;
        }
        byte[] newBuffer = new byte[bytes.length - count];
        int i = 0;
        for (int j = 0; j < newBuffer.length - 1; ++j) {
            newBuffer[j] = bytes[i];
            if (bytes[i] == -1 && bytes[i + 1] == 0 && ((bytes[i + 2] & 0xFFFFFFE0) == -32 || bytes[i + 2] == 0)) {
                ++i;
            }
            ++i;
        }
        newBuffer[newBuffer.length - 1] = bytes[i];
        return newBuffer;
    }

    public static String substitute(String s, String replaceThis, String withThis) {
        if (replaceThis.length() < 1 || !s.contains(replaceThis)) {
            return s;
        }
        StringBuilder newString = new StringBuilder();
        int lastPosition = 0;
        int position = 0;
        while ((position = s.indexOf(replaceThis, position)) >= 0) {
            if (position > lastPosition) {
                newString.append(s.substring(lastPosition, position));
            }
            if (withThis != null) {
                newString.append(withThis);
            }
            lastPosition = position + replaceThis.length();
            ++position;
        }
        if (lastPosition < s.length()) {
            newString.append(s.substring(lastPosition));
        }
        return newString.toString();
    }

    public static String asciiOnly(String s) {
        StringBuilder newString = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch < ' ' || ch > '~') {
                newString.append('?');
                continue;
            }
            newString.append(ch);
        }
        return newString.toString();
    }

    public static int indexOfTerminator(byte[] bytes) {
        return BufferTools.indexOfTerminator(bytes, 0);
    }

    public static int indexOfTerminator(byte[] bytes, int fromIndex) {
        return BufferTools.indexOfTerminator(bytes, 0, 1);
    }

    public static int indexOfTerminator(byte[] bytes, int fromIndex, int terminatorLength) {
        int marker = -1;
        for (int i = fromIndex; i <= bytes.length - terminatorLength; ++i) {
            int matched;
            if ((i - fromIndex) % terminatorLength != 0) continue;
            for (matched = 0; matched < terminatorLength && bytes[i + matched] == 0; ++matched) {
            }
            if (matched != terminatorLength) continue;
            marker = i;
            break;
        }
        return marker;
    }

    public static int indexOfTerminatorForEncoding(byte[] bytes, int fromIndex, int encoding) {
        int terminatorLength = encoding == 1 || encoding == 2 ? 2 : 1;
        return BufferTools.indexOfTerminator(bytes, fromIndex, terminatorLength);
    }
}

