/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.EncodedText;
import com.mpatric.mp3agic.ID3v2PictureFrameData;
import com.mpatric.mp3agic.InvalidDataException;
import java.io.UnsupportedEncodingException;

public class ID3v2ObseletePictureFrameData
extends ID3v2PictureFrameData {
    public ID3v2ObseletePictureFrameData(boolean unsynchronisation) {
        super(unsynchronisation);
    }

    public ID3v2ObseletePictureFrameData(boolean unsynchronisation, String mimeType, byte pictureType, EncodedText description, byte[] imageData) {
        super(unsynchronisation, mimeType, pictureType, description, imageData);
    }

    public ID3v2ObseletePictureFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation, bytes);
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        String filetype;
        try {
            filetype = BufferTools.byteBufferToString(bytes, 1, 3);
        }
        catch (UnsupportedEncodingException e) {
            filetype = "unknown";
        }
        this.mimeType = "image/" + filetype.toLowerCase();
        this.pictureType = bytes[4];
        int marker = BufferTools.indexOfTerminatorForEncoding(bytes, 5, bytes[0]);
        if (marker >= 0) {
            this.description = new EncodedText(bytes[0], BufferTools.copyBuffer(bytes, 5, marker - 5));
            marker += this.description.getTerminator().length;
        } else {
            this.description = new EncodedText(bytes[0], "");
            marker = 1;
        }
        this.imageData = BufferTools.copyBuffer(bytes, marker, bytes.length - marker);
    }
}

