/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.AbstractID3v2Tag;
import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.ID3v22Tag;
import com.mpatric.mp3agic.ID3v23Tag;
import com.mpatric.mp3agic.ID3v24Tag;
import com.mpatric.mp3agic.InvalidDataException;
import com.mpatric.mp3agic.NoSuchTagException;
import com.mpatric.mp3agic.UnsupportedTagException;

public final class ID3v2TagFactory {
    private ID3v2TagFactory() {
    }

    public static AbstractID3v2Tag createTag(byte[] bytes) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        ID3v2TagFactory.sanityCheckTag(bytes);
        byte majorVersion = bytes[3];
        switch (majorVersion) {
            case 2: {
                return ID3v2TagFactory.createID3v22Tag(bytes);
            }
            case 3: {
                return new ID3v23Tag(bytes);
            }
            case 4: {
                return new ID3v24Tag(bytes);
            }
        }
        throw new UnsupportedTagException("Tag version not supported");
    }

    private static AbstractID3v2Tag createID3v22Tag(byte[] bytes) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        ID3v22Tag tag = new ID3v22Tag(bytes);
        if (tag.getFrameSets().isEmpty()) {
            tag = new ID3v22Tag(bytes, true);
        }
        return tag;
    }

    public static void sanityCheckTag(byte[] bytes) throws NoSuchTagException, UnsupportedTagException {
        if (bytes.length < 10) {
            throw new NoSuchTagException("Buffer too short");
        }
        if (!"ID3".equals(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, 0, "ID3".length()))) {
            throw new NoSuchTagException();
        }
        byte majorVersion = bytes[3];
        if (majorVersion != 2 && majorVersion != 3 && majorVersion != 4) {
            byte minorVersion = bytes[4];
            throw new UnsupportedTagException("Unsupported version 2." + majorVersion + "." + minorVersion);
        }
    }
}

