/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.AbstractID3v2FrameData;
import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.EncodedText;
import com.mpatric.mp3agic.InvalidDataException;
import java.io.UnsupportedEncodingException;

public class ID3v2UrlFrameData
extends AbstractID3v2FrameData {
    protected String url;
    protected EncodedText description;

    public ID3v2UrlFrameData(boolean unsynchronisation) {
        super(unsynchronisation);
    }

    public ID3v2UrlFrameData(boolean unsynchronisation, EncodedText description, String url) {
        super(unsynchronisation);
        this.description = description;
        this.url = url;
    }

    public ID3v2UrlFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation);
        this.synchroniseAndUnpackFrameData(bytes);
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        int marker = BufferTools.indexOfTerminatorForEncoding(bytes, 1, bytes[0]);
        if (marker >= 0) {
            this.description = new EncodedText(bytes[0], BufferTools.copyBuffer(bytes, 1, marker - 1));
            marker += this.description.getTerminator().length;
        } else {
            this.description = new EncodedText(bytes[0], "");
            marker = 1;
        }
        try {
            this.url = BufferTools.byteBufferToString(bytes, marker, bytes.length - marker);
        }
        catch (UnsupportedEncodingException e) {
            this.url = "";
        }
    }

    @Override
    protected byte[] packFrameData() {
        byte[] bytes = new byte[this.getLength()];
        bytes[0] = this.description != null ? this.description.getTextEncoding() : (byte)0;
        int marker = 1;
        if (this.description != null) {
            byte[] descriptionBytes = this.description.toBytes(true, true);
            BufferTools.copyIntoByteBuffer(descriptionBytes, 0, descriptionBytes.length, bytes, marker);
            marker += descriptionBytes.length;
        } else {
            bytes[marker++] = 0;
        }
        if (this.url != null && this.url.length() > 0) {
            try {
                BufferTools.stringIntoByteBuffer(this.url, 0, this.url.length(), bytes, marker);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return bytes;
    }

    @Override
    protected int getLength() {
        int length = 1;
        length = this.description != null ? (length += this.description.toBytes(true, true).length) : ++length;
        if (this.url != null) {
            length += this.url.length();
        }
        return length;
    }

    public EncodedText getDescription() {
        return this.description;
    }

    public void setDescription(EncodedText description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ID3v2UrlFrameData other = (ID3v2UrlFrameData)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

